/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.math.WmiFractionModel;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathActionAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathActionModel;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathMultiscriptModel;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorModel;
import com.maplesoft.mathdoc.model.math.WmiMathPaddedModel;
import com.maplesoft.mathdoc.model.math.WmiMathPhantomModel;
import com.maplesoft.mathdoc.model.math.WmiMathSpaceModel;
import com.maplesoft.mathdoc.model.math.WmiMathStyleModel;
import com.maplesoft.mathdoc.model.math.WmiMathTableModel;
import com.maplesoft.mathdoc.model.math.WmiMathTextModel;
import com.maplesoft.mathdoc.model.math.WmiMathWrapperModel;
import com.maplesoft.mathdoc.model.math.WmiOverModel;
import com.maplesoft.mathdoc.model.math.WmiRootModel;
import com.maplesoft.mathdoc.model.math.WmiSubSupModel;
import com.maplesoft.mathdoc.model.math.WmiSubscriptModel;
import com.maplesoft.mathdoc.model.math.WmiSuperscriptModel;
import com.maplesoft.mathdoc.model.math.WmiThreeArgumentMathModel;
import com.maplesoft.mathdoc.model.math.WmiTwoArgumentMathModel;
import com.maplesoft.mathdoc.model.math.WmiUnderModel;
import com.maplesoft.mathdoc.model.math.WmiUnderOverModel;
import com.maplesoft.util.WmiMathEntityNameMapper;

public class WmiMathModelUtil {
    public static boolean requiresMRow(WmiCompositeModel pmodel) {
        return pmodel instanceof WmiTwoArgumentMathModel || pmodel instanceof WmiThreeArgumentMathModel || pmodel instanceof WmiRootModel.WmiSquareRootModel || pmodel instanceof WmiRootModel || pmodel instanceof WmiMathMultiscriptModel || pmodel instanceof WmiMathTableModel.WmiMathTableDataModel;
    }

    public static boolean isSpaceLike(WmiMathModel model) {
        boolean isSpaceLike = false;
        if (model instanceof WmiMathSpaceModel) {
            isSpaceLike = true;
        } else if (model instanceof WmiMathTextModel) {
            try {
                isSpaceLike = true;
                WmiMathTextModel textModel = (WmiMathTextModel)model;
                String contents = textModel.getTokenContents();
                String[] tokens = contents.split("&;");
                int i = 0;
                while (i < tokens.length) {
                    if (!tokens[i].trim().equals("") && !WmiMathEntityNameMapper.isNonMarkingEntity(tokens[i])) {
                        isSpaceLike = false;
                    }
                    ++i;
                }
            }
            catch (WmiNoReadAccessException e) {
                WmiErrorLog.log(e);
            }
        } else if (model instanceof WmiMathWrapperModel || model instanceof WmiMathStyleModel || model instanceof WmiMathPaddedModel || model instanceof WmiMathPhantomModel || model instanceof WmiInlineMathModel) {
            try {
                WmiCompositeModel parent = (WmiCompositeModel)((Object)model);
                int i = 0;
                while (i < parent.getChildCount()) {
                    isSpaceLike = true;
                    WmiMathModel child = (WmiMathModel)parent.getChild(i);
                    if (!WmiModelUtil.isEmptyIdentifierModel(child) && !WmiMathModelUtil.isSpaceLike(child)) {
                        isSpaceLike = false;
                        break;
                    }
                    ++i;
                }
            }
            catch (WmiNoReadAccessException e) {
                WmiErrorLog.log(e);
            }
        } else if (model instanceof WmiMathActionModel) {
            try {
                WmiMathActionModel action = (WmiMathActionModel)model;
                WmiMathActionAttributeSet attrs = (WmiMathActionAttributeSet)action.getAttributes();
                int selection = 0;
                if (attrs.getAttribute("selection") != null) {
                    selection = Integer.parseInt(attrs.getAttribute("selection").toString()) - 1;
                }
                if (action.getChildCount() >= selection) {
                    isSpaceLike = WmiMathModelUtil.isSpaceLike((WmiMathModel)action.getChild(selection));
                }
            }
            catch (WmiNoReadAccessException e) {
                WmiErrorLog.log(e);
            }
            catch (NumberFormatException e) {
                WmiErrorLog.log(e);
            }
        }
        return isSpaceLike;
    }

    public static boolean isEmbellishedOperator(WmiMathModel model) {
        boolean isEmbellishedOp = false;
        if (model instanceof WmiMathOperatorModel) {
            isEmbellishedOp = true;
        } else if (model instanceof WmiSubscriptModel || model instanceof WmiSuperscriptModel || model instanceof WmiSubSupModel || model instanceof WmiUnderModel || model instanceof WmiOverModel || model instanceof WmiUnderOverModel || model instanceof WmiMathMultiscriptModel || model instanceof WmiFractionModel) {
            try {
                WmiCompositeModel parent = (WmiCompositeModel)((Object)model);
                int childCounter = 0;
                WmiMathModel child = (WmiMathModel)parent.getChild(childCounter);
                while (WmiModelUtil.isEmptyIdentifierModel(child)) {
                    child = (WmiMathModel)parent.getChild(++childCounter);
                }
                if (WmiMathModelUtil.isEmbellishedOperator((WmiMathModel)parent.getChild(childCounter))) {
                    isEmbellishedOp = true;
                }
            }
            catch (WmiNoReadAccessException e) {
                WmiErrorLog.log(e);
            }
        } else if (model instanceof WmiMathWrapperModel || model instanceof WmiMathStyleModel || model instanceof WmiMathPhantomModel || model instanceof WmiInlineMathModel) {
            WmiCompositeModel parent = (WmiCompositeModel)((Object)model);
            int embellishedOpCount = 0;
            boolean hasSpaceLikeChildren = true;
            try {
                int i = 0;
                while (i < parent.getChildCount()) {
                    WmiMathModel child = (WmiMathModel)parent.getChild(i);
                    if (!WmiModelUtil.isEmptyIdentifierModel(child)) {
                        if (WmiMathModelUtil.isEmbellishedOperator(child)) {
                            ++embellishedOpCount;
                        } else if (!WmiMathModelUtil.isSpaceLike(child)) {
                            hasSpaceLikeChildren = false;
                        }
                    }
                    ++i;
                }
            }
            catch (WmiNoReadAccessException e) {
                WmiErrorLog.log(e);
            }
            isEmbellishedOp = embellishedOpCount == 1 && hasSpaceLikeChildren;
        } else if (model instanceof WmiMathActionModel) {
            try {
                WmiMathActionModel action = (WmiMathActionModel)model;
                WmiMathActionAttributeSet attrs = (WmiMathActionAttributeSet)action.getAttributes();
                int selection = 0;
                if (attrs.getAttribute("selection") != null) {
                    selection = Integer.parseInt(attrs.getAttribute("selection").toString()) - 1;
                }
                if (action.getChildCount() >= selection) {
                    isEmbellishedOp = WmiMathModelUtil.isEmbellishedOperator((WmiMathModel)action.getChild(selection));
                }
            }
            catch (WmiNoReadAccessException e) {
                WmiErrorLog.log(e);
            }
            catch (NumberFormatException e) {
                WmiErrorLog.log(e);
            }
        }
        return isEmbellishedOp;
    }

    public static WmiMathOperatorModel getEmbellishedOperator(WmiModel model) {
        WmiMathOperatorModel operatorModel = null;
        if (model instanceof WmiMathOperatorModel) {
            operatorModel = (WmiMathOperatorModel)model;
        } else if (model instanceof WmiSubscriptModel || model instanceof WmiSuperscriptModel || model instanceof WmiSubSupModel || model instanceof WmiUnderModel || model instanceof WmiOverModel || model instanceof WmiUnderOverModel || model instanceof WmiMathMultiscriptModel || model instanceof WmiFractionModel) {
            try {
                WmiCompositeModel parent = (WmiCompositeModel)model;
                int childCounter = 0;
                WmiMathModel child = (WmiMathModel)parent.getChild(childCounter);
                while (WmiModelUtil.isEmptyIdentifierModel(child)) {
                    child = (WmiMathModel)parent.getChild(++childCounter);
                }
                operatorModel = WmiMathModelUtil.getEmbellishedOperator((WmiMathModel)parent.getChild(childCounter));
            }
            catch (WmiNoReadAccessException e) {
                WmiErrorLog.log(e);
            }
        } else if (model instanceof WmiMathWrapperModel || model instanceof WmiMathStyleModel || model instanceof WmiMathPhantomModel || model instanceof WmiInlineMathModel) {
            WmiCompositeModel parent = (WmiCompositeModel)model;
            int embellishedOpCount = 0;
            boolean hasSpaceLikeChildren = true;
            try {
                int i = 0;
                while (i < parent.getChildCount()) {
                    WmiMathModel child = (WmiMathModel)parent.getChild(i);
                    if (!WmiModelUtil.isEmptyIdentifierModel(child)) {
                        if (WmiMathModelUtil.getEmbellishedOperator(child) != null) {
                            operatorModel = WmiMathModelUtil.getEmbellishedOperator(child);
                            ++embellishedOpCount;
                        } else if (!WmiMathModelUtil.isSpaceLike(child)) {
                            hasSpaceLikeChildren = false;
                        }
                    }
                    ++i;
                }
            }
            catch (WmiNoReadAccessException e) {
                WmiErrorLog.log(e);
            }
            if (embellishedOpCount != 1 || !hasSpaceLikeChildren) {
                operatorModel = null;
            }
        } else if (model instanceof WmiMathActionModel) {
            try {
                WmiMathActionModel action = (WmiMathActionModel)model;
                WmiMathActionAttributeSet attrs = (WmiMathActionAttributeSet)action.getAttributes();
                int selection = 0;
                if (attrs.getAttribute("selection") != null) {
                    selection = Integer.parseInt(attrs.getAttribute("selection").toString()) - 1;
                }
                if (action.getChildCount() >= selection) {
                    operatorModel = WmiMathModelUtil.getEmbellishedOperator((WmiMathModel)action.getChild(selection));
                }
            }
            catch (WmiNoReadAccessException e) {
                WmiErrorLog.log(e);
            }
            catch (NumberFormatException e) {
                WmiErrorLog.log(e);
            }
        }
        return operatorModel;
    }
}

