/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractArrayAttributeSet;
import com.maplesoft.mathdoc.model.WmiAbstractArrayCompositeMathModel;
import com.maplesoft.mathdoc.model.WmiAttributeKey;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiFontAttributeSource;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiStringAttributeKey;
import com.maplesoft.mathdoc.model.math.WmiDimensionUnit;
import com.maplesoft.mathdoc.model.math.WmiImpliedSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import java.util.HashMap;

public class WmiMathPaddedModel
extends WmiAbstractArrayCompositeMathModel
implements WmiMathModel,
WmiFontAttributeSource {
    public static final String WIDTH = "width";
    public static final String LSPACE = "lspace";
    public static final String HEIGHT = "height";
    public static final String DEPTH = "depth";
    private static final WmiImpliedSemantics IMPLIED_SEMANTICS = new WmiImpliedSemantics();
    private WmiMathSemantics semantics = null;

    public WmiMathPaddedModel(WmiMathDocumentModel doc) {
        super(doc);
        try {
            this.setAttributes(this.createCompatibleAttributeSet());
        }
        catch (WmiNoWriteAccessException wae) {
            WmiErrorLog.log(wae);
        }
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    public WmiMathPaddedModel(WmiMathDocumentModel doc, WmiModel[] children) throws WmiInvalidModelInitializationException {
        super(doc, children);
        try {
            this.setAttributes(this.createCompatibleAttributeSet());
        }
        catch (WmiNoWriteAccessException wae) {
            WmiErrorLog.log(wae);
        }
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    public WmiMathPaddedModel(WmiMathDocumentModel doc, WmiModel child) throws WmiInvalidModelInitializationException {
        super(doc, new WmiModel[]{child});
        try {
            this.setAttributes(this.createCompatibleAttributeSet());
        }
        catch (WmiNoWriteAccessException wae) {
            WmiErrorLog.log(wae);
        }
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    private WmiMathPaddedModel(WmiMathDocumentModel doc, WmiModel model, WmiMathPaddedAttributeSet attrs) {
        super(doc);
        this.children = new WmiModel[]{model};
        this.length = 1;
        this.attributes = attrs;
    }

    @Override
    public WmiModelTag getTag() {
        return WmiModelTag.MATH_PADDED;
    }

    @Override
    public boolean isVisible() throws WmiNoReadAccessException {
        boolean visible = true;
        WmiMathDocumentModel doc = this.getDocument();
        if (doc != null) {
            visible = !doc.isHidden(this);
        }
        return visible;
    }

    @Override
    public Dag toDag() throws WmiNoReadAccessException {
        return this.semantics != null ? this.semantics.toDag(this) : null;
    }

    @Override
    public void setSemantics(WmiMathSemantics semantics) {
        this.semantics = semantics;
    }

    @Override
    public WmiMathSemantics getSemantics() {
        return this.semantics;
    }

    @Override
    public void setAttributes(WmiAttributeSet set) throws WmiNoWriteAccessException {
        if (set instanceof WmiMathPaddedAttributeSet) {
            super.setAttributes(set);
        } else {
            WmiErrorLog.log(new Exception("Invalid attribute set"));
        }
    }

    @Override
    protected WmiAttributeSet createCompatibleAttributeSet() {
        return new WmiMathPaddedAttributeSet();
    }

    @Override
    public String getNamedFontStyle() throws WmiNoReadAccessException {
        Object nameObj;
        String name = null;
        WmiAttributeSet attrs = this.getAttributesForRead();
        if (attrs != null && (nameObj = attrs.getAttribute("font_style_name")) != null) {
            name = nameObj.toString();
        }
        return name;
    }

    @Override
    public void updateFontStyle(String name) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiFontAttributeSet defSet = new WmiFontAttributeSet();
        defSet.setNamedFontStyle(name, this.getDocument());
        this.addAttributes(defSet);
    }

    @Override
    public boolean useScriptSize(WmiModel child) {
        return false;
    }

    public static class WmiMathPaddedAttributeSet
    extends WmiFontAttributeSet {
        public static final String[] ATTRIBUTES = new String[]{"width", "lspace", "height", "depth"};
        private static final WmiMathSpaceDimensionUnit DEFAULT_HEIGHT = WmiMathSpaceDimensionUnit.createDimension("+0ex", "", null);
        private static final WmiMathSpaceDimensionUnit DEFAULT_WIDTH = WmiMathSpaceDimensionUnit.createDimension("+0em", "", null);
        private static final WmiMathSpaceDimensionUnit DEFAULT_DEPTH = WmiMathSpaceDimensionUnit.createDimension("+0ex", "", null);
        private static final WmiMathSpaceDimensionUnit DEFAULT_LSPACE = WmiMathSpaceDimensionUnit.createDimension("+0em", "", null);
        public static final WmiAttributeKey[] PADDED_KEYS = new WmiAttributeKey[]{new HeightKey(), new WidthKey(), new DepthKey(), new LSpaceKey()};
        public static final WmiAttributeKey[] EXTENDED_KEYS = WmiAbstractArrayAttributeSet.createExtendedKeySet(WmiFontAttributeSet.ATTRIBUTE_KEYS, PADDED_KEYS);
        private static HashMap keyMap = null;
        private static HashMap cache = new HashMap();
        private WmiMathSpaceDimensionUnit height = DEFAULT_HEIGHT;
        private WmiMathSpaceDimensionUnit width = DEFAULT_WIDTH;
        private WmiMathSpaceDimensionUnit depth = DEFAULT_DEPTH;
        private WmiMathSpaceDimensionUnit lspace = DEFAULT_LSPACE;

        public WmiMathPaddedAttributeSet() {
        }

        public WmiMathPaddedAttributeSet(WmiMathPaddedAttributeSet source) {
            super(source);
            this.width = source.width;
            this.height = source.height;
            this.depth = source.depth;
            this.lspace = source.lspace;
        }

        @Override
        public WmiAttributeSet copyAttributes() {
            return new WmiMathPaddedAttributeSet(this);
        }

        @Override
        public void addAttributes(WmiAttributeSet set) {
            super.addAttributes(set);
            if (set instanceof WmiMathPaddedAttributeSet) {
                WmiMathPaddedAttributeSet source = (WmiMathPaddedAttributeSet)set;
                this.width = source.width;
                this.height = source.height;
                this.depth = source.depth;
                this.lspace = source.lspace;
            }
        }

        public WmiMathSpaceDimensionUnit getWidth() {
            return this.width;
        }

        public WmiMathSpaceDimensionUnit getHeight() {
            return this.height;
        }

        public WmiMathSpaceDimensionUnit getDepth() {
            return this.depth;
        }

        public WmiMathSpaceDimensionUnit getLSpace() {
            return this.lspace;
        }

        @Override
        public boolean equals(Object obj) {
            boolean equals = false;
            if (this == obj) {
                equals = true;
            } else if (super.equals(obj) && obj instanceof WmiMathPaddedAttributeSet) {
                WmiMathPaddedAttributeSet ref = (WmiMathPaddedAttributeSet)obj;
                equals &= this.lspace.equals(ref.lspace);
                equals &= this.height.equals(ref.height);
                equals &= this.width.equals(ref.width);
                equals &= this.depth.equals(ref.depth);
            }
            return equals;
        }

        @Override
        public int hashCode() {
            int code = super.hashCode();
            code ^= this.lspace.hashCode();
            code ^= this.height.hashCode();
            code ^= this.width.hashCode();
            return code ^= this.depth.hashCode();
        }

        @Override
        protected HashMap getKeyMap() {
            return keyMap;
        }

        @Override
        public WmiAttributeKey[] getKeys() {
            return EXTENDED_KEYS;
        }

        @Override
        protected void setKeyMap(HashMap map) {
            keyMap = map;
        }

        @Override
        public HashMap getCache() {
            return cache;
        }

        public static class DepthKey
        extends DimensionKey {
            public DepthKey() {
                super(WmiMathPaddedModel.DEPTH, DEFAULT_DEPTH);
            }

            @Override
            public WmiDimensionUnit getDimension(WmiMathPaddedAttributeSet set) {
                return set.depth;
            }

            @Override
            public void setDimension(WmiMathPaddedAttributeSet set, WmiDimensionUnit value) {
                set.depth = (WmiMathSpaceDimensionUnit)value;
            }
        }

        public static abstract class DimensionKey
        extends WmiStringAttributeKey {
            private WmiMathSpaceDimensionUnit defaultDimension;

            public DimensionKey(String name, WmiMathSpaceDimensionUnit defaultValue) {
                super(name, null);
                this.defaultDimension = defaultValue;
            }

            @Override
            public String getStringValue(WmiAttributeSet set) {
                Object value = this.getValue(set);
                return value != null ? value.toString() : null;
            }

            @Override
            public void setStringValue(WmiAttributeSet set, String value) {
                this.setValue(set, value);
            }

            @Override
            public Object getValue(WmiAttributeSet set) {
                return this.getDimension((WmiMathPaddedAttributeSet)set);
            }

            @Override
            public void setValue(WmiAttributeSet set, Object value) {
                WmiDimensionUnit unit = null;
                if (value instanceof WmiDimensionUnit) {
                    unit = (WmiDimensionUnit)value;
                } else {
                    String s = value.toString();
                    String v = value.toString();
                    String dimension = "";
                    if (s.indexOf(" ") > -1) {
                        int spaceIndex = s.indexOf(" ");
                        dimension = s.substring(spaceIndex + 1);
                        v = s.substring(0, spaceIndex);
                    }
                    unit = WmiMathSpaceDimensionUnit.createDimension(v, dimension, this.defaultDimension);
                }
                this.setDimension((WmiMathPaddedAttributeSet)set, unit);
            }

            public abstract WmiDimensionUnit getDimension(WmiMathPaddedAttributeSet var1);

            public abstract void setDimension(WmiMathPaddedAttributeSet var1, WmiDimensionUnit var2);
        }

        public static class HeightKey
        extends DimensionKey {
            public HeightKey() {
                super(WmiMathPaddedModel.HEIGHT, DEFAULT_HEIGHT);
            }

            @Override
            public WmiDimensionUnit getDimension(WmiMathPaddedAttributeSet set) {
                return set.height;
            }

            @Override
            public void setDimension(WmiMathPaddedAttributeSet set, WmiDimensionUnit value) {
                set.height = (WmiMathSpaceDimensionUnit)value;
            }
        }

        public static class LSpaceKey
        extends DimensionKey {
            public LSpaceKey() {
                super(WmiMathPaddedModel.LSPACE, DEFAULT_LSPACE);
            }

            @Override
            public WmiDimensionUnit getDimension(WmiMathPaddedAttributeSet set) {
                return set.lspace;
            }

            @Override
            public void setDimension(WmiMathPaddedAttributeSet set, WmiDimensionUnit value) {
                set.lspace = (WmiMathSpaceDimensionUnit)value;
            }
        }

        public static class WidthKey
        extends DimensionKey {
            public WidthKey() {
                super(WmiMathPaddedModel.WIDTH, DEFAULT_WIDTH);
            }

            @Override
            public WmiDimensionUnit getDimension(WmiMathPaddedAttributeSet set) {
                return set.width;
            }

            @Override
            public void setDimension(WmiMathPaddedAttributeSet set, WmiDimensionUnit value) {
                set.width = (WmiMathSpaceDimensionUnit)value;
            }
        }
    }

    public static class WmiMathSpaceDimensionUnit
    extends WmiDimensionUnit {
        protected String dimension = "";
        protected int sign = 0;

        protected WmiMathSpaceDimensionUnit(WmiDimensionUnit dimUnit, String dimension, int sign) {
            super(dimUnit.getUnitsValue(), dimUnit.getUnit(), dimUnit.getDefaultUnit());
            this.dimension = dimension;
            this.sign = sign;
        }

        public String getDimension() {
            return this.dimension;
        }

        public int getSign() {
            return this.sign;
        }

        public static WmiMathSpaceDimensionUnit createDimension(String specification, String dimension, WmiDimensionUnit defaultUnit) {
            int sign = 0;
            if (specification.startsWith("+")) {
                sign = 1;
                specification = specification.substring(1);
            } else if (specification.startsWith("-")) {
                sign = -1;
                specification = specification.substring(1);
            }
            defaultUnit = WmiDimensionUnit.createDimension(specification, null);
            WmiDimensionUnit dim = WmiDimensionUnit.createDimension(specification, defaultUnit);
            return new WmiMathSpaceDimensionUnit(dim, dimension, sign);
        }
    }
}

