/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractArrayAttributeSet;
import com.maplesoft.mathdoc.model.WmiAttributeKey;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiEnumeratedAttributeKey;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiStringAttributeKey;
import com.maplesoft.mathdoc.model.WmiValidForTypeMK;
import com.maplesoft.mathdoc.model.math.WmiAbstractMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiDimensionUnit;
import com.maplesoft.mathdoc.model.math.WmiImpliedSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import java.util.HashMap;

public class WmiMathSpaceModel
extends WmiAbstractMathTokenModel
implements WmiMathModel,
WmiValidForTypeMK {
    private WmiMathSemantics semantics;
    private static final WmiImpliedSemantics IMPLIED_SEMANTICS = new WmiImpliedSemantics();
    public static final String WIDTH = "width";
    public static final String HEIGHT = "height";
    public static final String DEPTH = "depth";
    public static final String LINEBREAK = "linebreak";
    public static final String LINEBREAK_AUTO = "auto";
    public static final String LINEBREAK_NEWLINE = "newline";
    public static final String LINEBREAK_INDENTING_NEWLINE = "indentingnewline";
    public static final String LINEBREAK_INCREASE_INDENT_NEWLINE = "increaseindentnewline";
    public static final String LINEBREAK_DECREASE_INDENT_NEWLINE = "decreaseindentnewline";
    public static final String LINEBREAK_FIRSTPROC_NEWLINE = "firstprocnewline";
    public static final String LINEBREAK_NO_BREAK = "nobreak";
    public static final String LINEBREAK_GOOD_BREAK = "goodbreak";
    public static final String LINEBREAK_BAD_BREAK = "badbreak";

    public WmiMathSpaceModel(WmiMathDocumentModel doc) {
        super(doc);
        try {
            this.setAttributes(this.createCompatibleAttributeSet());
        }
        catch (WmiNoWriteAccessException wae) {
            WmiErrorLog.log(wae);
        }
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    public WmiMathSpaceModel(WmiMathDocumentModel doc, String contents) {
        super(doc, contents);
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    public WmiMathSpaceModel(WmiMathDocumentModel doc, String contents, WmiAttributeSet attributes) {
        super(doc, contents);
        try {
            this.setAttributes(attributes);
        }
        catch (WmiNoWriteAccessException wae) {
            WmiErrorLog.log(wae);
        }
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    @Override
    public WmiModelTag getTag() {
        return WmiModelTag.MATH_SPACE;
    }

    @Override
    public Dag toDag() throws WmiNoReadAccessException {
        Dag dag = this.semantics != null ? this.semantics.toDag(this) : null;
        return dag;
    }

    @Override
    public void setSemantics(WmiMathSemantics semantics) {
        this.semantics = semantics;
    }

    @Override
    public WmiMathSemantics getSemantics() {
        return this.semantics;
    }

    @Override
    public void setAttributes(WmiAttributeSet set) throws WmiNoWriteAccessException {
        if (set instanceof WmiMathSpaceAttributeSet) {
            super.setAttributes(set);
        } else {
            WmiErrorLog.log(new Exception("Invalid attribute set"));
        }
    }

    @Override
    protected WmiAttributeSet createCompatibleAttributeSet() {
        return new WmiMathSpaceAttributeSet();
    }

    @Override
    public boolean forceSave(Object key, Object value) {
        return false;
    }

    @Override
    public boolean useScriptSize(WmiModel child) {
        return false;
    }

    @Override
    public Dag getTypeMk() {
        return null;
    }

    @Override
    public boolean suppliesOwnTypeMK() {
        return false;
    }

    @Override
    public boolean isCrossBoundarySubselectable() {
        return false;
    }

    public static class WmiMathSpaceAttributeSet
    extends WmiMathAttributeSet {
        public static final String[] ATTRIBUTES = new String[]{"height", "width", "depth", "linebreak"};
        private static final WmiDimensionUnit DEFAULT_HEIGHT = WmiDimensionUnit.createDimension("0ex", null);
        private static final WmiDimensionUnit DEFAULT_WIDTH = WmiDimensionUnit.createDimension("0em", null);
        private static final WmiDimensionUnit DEFAULT_DEPTH = WmiDimensionUnit.createDimension("0ex", null);
        public static final int DEFAULT_LINEBREAK = 0;
        public static final String[] LINEBREAK_OPTIONS = new String[]{"auto", "nobreak", "newline", "indentingnewline", "goodbreak", "badbreak", "increaseindentnewline", "decreaseindentnewline", "firstprocnewline"};
        public static final WmiAttributeKey[] SPACE_KEYS = new WmiAttributeKey[]{new HeightKey(), new WidthKey(), new DepthKey(), new LinebreakKey()};
        public static final WmiAttributeKey[] EXTENDED_KEYS = WmiAbstractArrayAttributeSet.createExtendedKeySet(WmiFontAttributeSet.ATTRIBUTE_KEYS, SPACE_KEYS);
        private static HashMap keyMap = null;
        private static HashMap cache = new HashMap();
        private WmiDimensionUnit height = DEFAULT_HEIGHT;
        private WmiDimensionUnit width = DEFAULT_WIDTH;
        private WmiDimensionUnit depth = DEFAULT_DEPTH;
        private int linebreak = 0;

        public WmiMathSpaceAttributeSet() {
        }

        public WmiMathSpaceAttributeSet(WmiMathSpaceAttributeSet source) {
            super(source);
            this.width = source.width;
            this.height = source.height;
            this.depth = source.depth;
            this.linebreak = source.linebreak;
        }

        @Override
        public void addAttributes(WmiAttributeSet set) {
            super.addAttributes(set);
            if (set instanceof WmiMathSpaceAttributeSet) {
                WmiMathSpaceAttributeSet source = (WmiMathSpaceAttributeSet)set;
                this.width = source.width;
                this.height = source.height;
                this.depth = source.depth;
                this.linebreak = source.linebreak;
            }
        }

        public String getLinebreak() {
            return LINEBREAK_OPTIONS[this.linebreak];
        }

        public WmiDimensionUnit getWidth() {
            return this.width == null ? DEFAULT_WIDTH : this.width;
        }

        public WmiDimensionUnit getHeight() {
            return this.height == null ? DEFAULT_HEIGHT : this.height;
        }

        public WmiDimensionUnit getDepth() {
            return this.depth == null ? DEFAULT_DEPTH : this.depth;
        }

        @Override
        public WmiAttributeSet copyAttributes() {
            return new WmiMathSpaceAttributeSet(this);
        }

        @Override
        public boolean equals(Object obj) {
            boolean equals = false;
            if (this == obj) {
                equals = true;
            } else if (super.equals(obj) && obj instanceof WmiMathSpaceAttributeSet) {
                WmiMathSpaceAttributeSet ref = (WmiMathSpaceAttributeSet)obj;
                equals = ref.linebreak == this.linebreak;
                equals &= this.height.equals(ref.height);
                equals &= this.width.equals(ref.width);
                equals &= this.depth.equals(ref.depth);
            }
            return equals;
        }

        @Override
        public int hashCode() {
            int code = super.hashCode();
            code ^= this.linebreak;
            code ^= this.height.hashCode();
            code ^= this.width.hashCode();
            return code ^= this.depth.hashCode();
        }

        @Override
        protected HashMap getKeyMap() {
            return keyMap;
        }

        @Override
        public WmiAttributeKey[] getKeys() {
            return EXTENDED_KEYS;
        }

        @Override
        protected void setKeyMap(HashMap map) {
            keyMap = map;
        }

        @Override
        public HashMap getCache() {
            return cache;
        }

        public static class DepthKey
        extends DimensionKey {
            public DepthKey() {
                super(WmiMathSpaceModel.DEPTH, DEFAULT_DEPTH);
            }

            @Override
            public WmiDimensionUnit getDimension(WmiMathSpaceAttributeSet set) {
                return set.depth;
            }

            @Override
            public void setDimension(WmiMathSpaceAttributeSet set, WmiDimensionUnit value) {
                set.depth = value;
            }
        }

        public static abstract class DimensionKey
        extends WmiStringAttributeKey {
            private WmiDimensionUnit defaultDimension;

            public DimensionKey(String name, WmiDimensionUnit defaultValue) {
                super(name, null);
                this.defaultDimension = defaultValue;
            }

            @Override
            public String getStringValue(WmiAttributeSet set) {
                Object value = this.getValue(set);
                return value != null ? value.toString() : null;
            }

            @Override
            public void setStringValue(WmiAttributeSet set, String value) {
                this.setValue(set, value);
            }

            @Override
            public Object getValue(WmiAttributeSet set) {
                return this.getDimension((WmiMathSpaceAttributeSet)set);
            }

            @Override
            public void setValue(WmiAttributeSet set, Object value) {
                WmiDimensionUnit unit = null;
                unit = value instanceof WmiDimensionUnit ? (WmiDimensionUnit)value : WmiDimensionUnit.createDimension(value.toString(), this.defaultDimension);
                this.setDimension((WmiMathSpaceAttributeSet)set, unit);
            }

            public abstract WmiDimensionUnit getDimension(WmiMathSpaceAttributeSet var1);

            public abstract void setDimension(WmiMathSpaceAttributeSet var1, WmiDimensionUnit var2);
        }

        public static class HeightKey
        extends DimensionKey {
            public HeightKey() {
                super(WmiMathSpaceModel.HEIGHT, DEFAULT_HEIGHT);
            }

            @Override
            public WmiDimensionUnit getDimension(WmiMathSpaceAttributeSet set) {
                return set.height;
            }

            @Override
            public void setDimension(WmiMathSpaceAttributeSet set, WmiDimensionUnit value) {
                set.height = value;
            }
        }

        public static class LinebreakKey
        extends WmiEnumeratedAttributeKey {
            protected LinebreakKey() {
                super(WmiMathSpaceModel.LINEBREAK, LINEBREAK_OPTIONS, 0);
            }

            @Override
            public int getIntValue(WmiAttributeSet set) {
                return ((WmiMathSpaceAttributeSet)set).linebreak;
            }

            @Override
            public void setIntValue(WmiAttributeSet set, int value) {
                ((WmiMathSpaceAttributeSet)set).linebreak = value;
            }
        }

        public static class WidthKey
        extends DimensionKey {
            public WidthKey() {
                super(WmiMathSpaceModel.WIDTH, DEFAULT_WIDTH);
            }

            @Override
            public WmiDimensionUnit getDimension(WmiMathSpaceAttributeSet set) {
                return set.width;
            }

            @Override
            public void setDimension(WmiMathSpaceAttributeSet set, WmiDimensionUnit value) {
                set.width = value;
            }
        }
    }
}

