/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractArrayAttributeSet;
import com.maplesoft.mathdoc.model.WmiAbstractArrayCompositeMathModel;
import com.maplesoft.mathdoc.model.WmiAttributeKey;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiBooleanAttributeKey;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiDeleteHandler;
import com.maplesoft.mathdoc.model.WmiDeleteManager;
import com.maplesoft.mathdoc.model.WmiDeletePlaceholderModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiFontAttributeSource;
import com.maplesoft.mathdoc.model.WmiIntAttributeKey;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.WmiStringAttributeKey;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.math.WmiIdentifierModel;
import com.maplesoft.mathdoc.model.math.WmiImpliedSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import java.util.HashMap;

public class WmiMathTableModel
extends WmiAbstractArrayCompositeMathModel
implements WmiMathModel,
WmiFontAttributeSource {
    private WmiMathSemantics semantics;
    protected WmiDeleteHandler deleteHandler = null;
    private boolean containsLabeledRow = false;
    private boolean containsAlignmentElement = false;
    private static final WmiImpliedSemantics IMPLIED_SEMANTICS = new WmiImpliedSemantics();

    public WmiMathTableModel(WmiMathDocumentModel doc) {
        super(doc);
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    public WmiMathTableModel(WmiMathDocumentModel doc, WmiModel[] rows) throws WmiInvalidModelInitializationException {
        super(doc, rows);
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    @Override
    public void update(String undoName) throws WmiNoUpdateAccessException {
        super.update(undoName);
        this.containsLabeledRow = this.findLabeledRow();
        this.containsAlignmentElement = this.findAlignmentElement();
    }

    @Override
    public WmiModelTag getTag() {
        return WmiModelTag.MATH_TABLE;
    }

    @Override
    public boolean isVisible() throws WmiNoReadAccessException {
        boolean visible = true;
        WmiMathDocumentModel doc = this.getDocument();
        if (doc != null) {
            visible = !doc.isHidden(this);
        }
        return visible;
    }

    @Override
    public Dag toDag() throws WmiNoReadAccessException {
        return null;
    }

    @Override
    public void setSemantics(WmiMathSemantics semantics) {
        this.semantics = semantics;
    }

    @Override
    public WmiMathSemantics getSemantics() {
        return this.semantics;
    }

    @Override
    public void setAttributes(WmiAttributeSet set) throws WmiNoWriteAccessException {
        if (set instanceof WmiMathTableAttributeSet) {
            super.setAttributes(set);
        } else {
            WmiErrorLog.log(new Exception("Invalid attribute set"));
        }
    }

    @Override
    protected WmiAttributeSet createCompatibleAttributeSet() {
        return new WmiMathTableAttributeSet();
    }

    @Override
    public boolean isSubselectable() {
        return false;
    }

    @Override
    public boolean useScriptSize(WmiModel child) throws WmiNoReadAccessException {
        return false;
    }

    @Override
    public String getNamedFontStyle() throws WmiNoReadAccessException {
        Object nameObj;
        String name = null;
        WmiAttributeSet attrs = this.getAttributesForRead();
        if (attrs != null && (nameObj = attrs.getAttribute("font_style_name")) != null) {
            name = nameObj.toString();
        }
        return name;
    }

    @Override
    public void updateFontStyle(String name) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiFontAttributeSet defSet = new WmiFontAttributeSet();
        defSet.setNamedFontStyle(name, this.getDocument());
        this.addAttributes(defSet);
    }

    @Override
    public boolean isCrossBoundarySubselectable() {
        return false;
    }

    @Override
    public WmiDeleteHandler getDeleteHandler() {
        if (this.deleteHandler == null) {
            this.deleteHandler = new WmiMathTableDeleteHandler(this);
        }
        return this.deleteHandler;
    }

    private boolean findLabeledRow() {
        boolean labeledRow = false;
        try {
            int i = 0;
            while (i < this.getChildCount()) {
                WmiModel child = this.getChild(i);
                if (child instanceof WmiMathTableLabeledRowModel) {
                    labeledRow = true;
                }
                ++i;
            }
        }
        catch (WmiNoReadAccessException nrae) {
            WmiErrorLog.log(nrae);
        }
        return labeledRow;
    }

    public boolean containsLabeledRow() {
        return this.containsLabeledRow;
    }

    private boolean findAlignmentElement() {
        WmiModelTag[] alignmentTags = new WmiModelTag[]{WmiModelTag.MATH_ALIGN_GROUP, WmiModelTag.MATH_ALIGN_MARK};
        WmiModel alignmentModel = null;
        try {
            alignmentModel = WmiModelUtil.findFirstDescendantOfTag((WmiModel)this, alignmentTags);
        }
        catch (WmiNoReadAccessException e) {
            WmiErrorLog.log(e);
        }
        return alignmentModel != null;
    }

    public boolean containsAlignmentElement() {
        return this.containsAlignmentElement;
    }

    public static class WmiMathTableAttributeSet
    extends WmiFontAttributeSet {
        public static final String ALIGN = "align";
        public static final String ROW_ALIGN = "rowalign";
        public static final String COLUMN_ALIGN = "columnalign";
        public static final String GROUP_ALIGN = "groupalign";
        public static final String ALIGNMENT_SCOPE = "alignmentscope";
        public static final String COLUMN_WIDTH = "columnwidth";
        public static final String WIDTH = "width";
        public static final String ROW_SPACING = "rowspacing";
        public static final String COLUMN_SPACING = "columnspacing";
        public static final String ROW_LINES = "rowlines";
        public static final String COLUMN_LINES = "columnlines";
        public static final String FRAME = "frame";
        public static final String FRAME_SPACING = "framespacing";
        public static final String EQUAL_ROWS = "equalrows";
        public static final String EQUAL_COLUMNS = "equalcolumns";
        public static final String DISPLAY_STYLE = "displaystyle";
        public static final String SIDE = "side";
        public static final String MIN_LABEL_SPACING = "minlabelspacing";
        private static HashMap keymap = null;
        private static HashMap cache = new HashMap();
        public static final String[] ATTRIBUTES = new String[]{"align", "rowalign", "columnalign", "groupalign", "alignmentscope", "columnwidth", "width", "rowspacing", "columnspacing", "rowlines", "columnlines", "frame", "framespacing", "equalrows", "equalcolumns", "displaystyle", "side", "minlabelspacing"};
        protected String alignVal = null;
        protected String rowalign = null;
        protected String columnalign = null;
        protected String groupalign = null;
        protected String alignmentscope = null;
        protected String columnwidth = null;
        protected String widthVal = null;
        protected String rowspacing = null;
        protected String columnspacing = null;
        protected String rowlines = null;
        protected String columnlines = null;
        protected String frameVal = null;
        protected String framespacing = null;
        protected Boolean equalrows = null;
        protected Boolean equalcolumns = null;
        protected Boolean displaystyle = null;
        protected String sideVal = null;
        protected String minlabelspacing = null;
        public static final WmiAttributeKey[] TABLE_KEYS = new WmiAttributeKey[]{new AlignKey(), new RowAlignKey(), new ColumnAlignKey(), new GroupAlignKey(), new AlignmentScopeKey(), new ColumnWidthKey(), new WidthKey(), new RowSpacingKey(), new ColumnSpacingKey(), new RowLinesKey(), new ColumnLinesKey(), new FrameKey(), new FrameSpacingKey(), new EqualRowsKey(), new EqualColumnsKey(), new DisplayStyleKey(), new SideKey(), new MinLabelSpacingKey()};
        public static final WmiAttributeKey[] EXTENDED_KEYS_TABLE = WmiAbstractArrayAttributeSet.createExtendedKeySet(WmiFontAttributeSet.ATTRIBUTE_KEYS, TABLE_KEYS);

        public WmiMathTableAttributeSet() {
        }

        public WmiMathTableAttributeSet(WmiMathTableAttributeSet source) {
            this.alignVal = source.alignVal;
            this.rowalign = source.rowalign;
            this.columnalign = source.columnalign;
            this.groupalign = source.groupalign;
            this.alignmentscope = source.alignmentscope;
            this.columnwidth = source.columnwidth;
            this.widthVal = source.widthVal;
            this.rowspacing = source.rowspacing;
            this.columnspacing = source.columnspacing;
            this.rowlines = source.rowlines;
            this.columnlines = source.columnlines;
            this.frameVal = source.frameVal;
            this.framespacing = source.framespacing;
            this.equalrows = source.equalrows;
            this.equalcolumns = source.equalcolumns;
            this.displaystyle = source.displaystyle;
            this.sideVal = source.sideVal;
            this.minlabelspacing = source.minlabelspacing;
        }

        @Override
        public WmiAttributeSet copyAttributes() {
            return new WmiMathTableAttributeSet(this);
        }

        @Override
        public void addAttributes(WmiAttributeSet set) {
            super.addAttributes(set);
            if (set instanceof WmiMathTableAttributeSet) {
                WmiMathTableAttributeSet source = (WmiMathTableAttributeSet)set;
                this.alignVal = source.alignVal;
                this.rowalign = source.rowalign;
                this.columnalign = source.columnalign;
                this.groupalign = source.groupalign;
                this.alignmentscope = source.alignmentscope;
                this.columnwidth = source.columnwidth;
                this.widthVal = source.widthVal;
                this.rowspacing = source.rowspacing;
                this.columnspacing = source.columnspacing;
                this.rowlines = source.rowlines;
                this.columnlines = source.columnlines;
                this.frameVal = source.frameVal;
                this.framespacing = source.framespacing;
                this.equalrows = source.equalrows;
                this.equalcolumns = source.equalcolumns;
                this.displaystyle = source.displaystyle;
                this.sideVal = source.sideVal;
                this.minlabelspacing = source.minlabelspacing;
            }
        }

        @Override
        public WmiAttributeKey[] getKeys() {
            return EXTENDED_KEYS_TABLE;
        }

        @Override
        public HashMap getCache() {
            return cache;
        }

        @Override
        protected HashMap getKeyMap() {
            return keymap;
        }

        @Override
        protected void setKeyMap(HashMap map) {
            keymap = map;
        }

        public String getAlign() {
            return this.alignVal;
        }

        public String getRowAlign() {
            return this.rowalign;
        }

        public String getColumnAlign() {
            return this.columnalign;
        }

        public String getGroupAlign() {
            return this.groupalign;
        }

        public String getAlignmentScope() {
            return this.alignmentscope;
        }

        public String getColumnWidth() {
            return this.columnwidth;
        }

        public String getWidth() {
            return this.widthVal;
        }

        public String getRowSpacing() {
            return this.rowspacing;
        }

        public String getColumnSpacing() {
            return this.columnspacing;
        }

        public String getRowLines() {
            return this.rowlines;
        }

        public String getColumnLines() {
            return this.columnlines;
        }

        public String getFrame() {
            return this.frameVal;
        }

        public String getFrameSpacing() {
            return this.framespacing;
        }

        public boolean getEqualRows() {
            return this.equalrows != null ? this.equalrows : false;
        }

        public boolean getEqualColumns() {
            return this.equalcolumns != null ? this.equalcolumns : false;
        }

        public boolean getDisplayStyle() {
            return this.displaystyle != null ? this.displaystyle : false;
        }

        public String getSide() {
            return this.sideVal != null ? this.sideVal : "";
        }

        public String getMinLabelSpacing() {
            return this.minlabelspacing;
        }

        public static class AlignKey
        extends WmiStringAttributeKey {
            public AlignKey() {
                super(WmiMathTableAttributeSet.ALIGN, "axis");
            }

            @Override
            public String getStringValue(WmiAttributeSet set) {
                return ((WmiMathTableAttributeSet)set).alignVal != null ? ((WmiMathTableAttributeSet)set).alignVal : this.getDefaultValue();
            }

            @Override
            public void setStringValue(WmiAttributeSet set, String value) {
                ((WmiMathTableAttributeSet)set).alignVal = value;
            }
        }

        public static class AlignmentScopeKey
        extends WmiStringAttributeKey {
            public AlignmentScopeKey() {
                super(WmiMathTableAttributeSet.ALIGNMENT_SCOPE, "true");
            }

            @Override
            public String getStringValue(WmiAttributeSet set) {
                return ((WmiMathTableAttributeSet)set).alignmentscope != null ? ((WmiMathTableAttributeSet)set).alignmentscope : this.getDefaultValue();
            }

            @Override
            public void setStringValue(WmiAttributeSet set, String value) {
                ((WmiMathTableAttributeSet)set).alignmentscope = value;
            }
        }

        public static class ColumnAlignKey
        extends WmiStringAttributeKey {
            public ColumnAlignKey() {
                super(WmiMathTableAttributeSet.COLUMN_ALIGN, "center");
            }

            public ColumnAlignKey(String key, String defaultValue) {
                super(key, defaultValue);
            }

            @Override
            public String getStringValue(WmiAttributeSet set) {
                return ((WmiMathTableAttributeSet)set).columnalign != null ? ((WmiMathTableAttributeSet)set).columnalign : this.getDefaultValue();
            }

            @Override
            public void setStringValue(WmiAttributeSet set, String value) {
                ((WmiMathTableAttributeSet)set).columnalign = value;
            }
        }

        public static class ColumnLinesKey
        extends WmiStringAttributeKey {
            public ColumnLinesKey() {
                super(WmiMathTableAttributeSet.COLUMN_LINES, "none");
            }

            @Override
            public String getStringValue(WmiAttributeSet set) {
                return ((WmiMathTableAttributeSet)set).columnlines != null ? ((WmiMathTableAttributeSet)set).columnlines : this.getDefaultValue();
            }

            @Override
            public void setStringValue(WmiAttributeSet set, String value) {
                ((WmiMathTableAttributeSet)set).columnlines = value;
            }
        }

        public static class ColumnSpacingKey
        extends WmiStringAttributeKey {
            public ColumnSpacingKey() {
                super(WmiMathTableAttributeSet.COLUMN_SPACING, "0.8em");
            }

            @Override
            public String getStringValue(WmiAttributeSet set) {
                return ((WmiMathTableAttributeSet)set).columnspacing != null ? ((WmiMathTableAttributeSet)set).columnspacing : this.getDefaultValue();
            }

            @Override
            public void setStringValue(WmiAttributeSet set, String value) {
                ((WmiMathTableAttributeSet)set).columnspacing = value;
            }
        }

        public static class ColumnWidthKey
        extends WmiStringAttributeKey {
            public ColumnWidthKey() {
                super(WmiMathTableAttributeSet.COLUMN_WIDTH, "auto");
            }

            @Override
            public String getStringValue(WmiAttributeSet set) {
                return ((WmiMathTableAttributeSet)set).columnwidth != null ? ((WmiMathTableAttributeSet)set).columnwidth : this.getDefaultValue();
            }

            @Override
            public void setStringValue(WmiAttributeSet set, String value) {
                ((WmiMathTableAttributeSet)set).columnwidth = value;
            }
        }

        public static class DisplayStyleKey
        extends WmiBooleanAttributeKey {
            public DisplayStyleKey() {
                super(WmiMathTableAttributeSet.DISPLAY_STYLE, false);
            }

            @Override
            public boolean getBooleanValue(WmiAttributeSet set) {
                return ((WmiMathTableAttributeSet)set).displaystyle != null ? ((WmiMathTableAttributeSet)set).displaystyle.booleanValue() : this.getDefaultValue();
            }

            @Override
            public void setBooleanValue(WmiAttributeSet set, boolean value) {
                ((WmiMathTableAttributeSet)set).displaystyle = new Boolean(value);
            }
        }

        public static class EqualColumnsKey
        extends WmiBooleanAttributeKey {
            public EqualColumnsKey() {
                super(WmiMathTableAttributeSet.EQUAL_COLUMNS, false);
            }

            @Override
            public boolean getBooleanValue(WmiAttributeSet set) {
                return ((WmiMathTableAttributeSet)set).equalcolumns != null ? ((WmiMathTableAttributeSet)set).equalcolumns.booleanValue() : this.getDefaultValue();
            }

            @Override
            public void setBooleanValue(WmiAttributeSet set, boolean value) {
                ((WmiMathTableAttributeSet)set).equalcolumns = new Boolean(value);
            }
        }

        public static class EqualRowsKey
        extends WmiBooleanAttributeKey {
            public EqualRowsKey() {
                super(WmiMathTableAttributeSet.EQUAL_ROWS, false);
            }

            @Override
            public boolean getBooleanValue(WmiAttributeSet set) {
                return ((WmiMathTableAttributeSet)set).equalrows != null ? ((WmiMathTableAttributeSet)set).equalrows.booleanValue() : this.getDefaultValue();
            }

            @Override
            public void setBooleanValue(WmiAttributeSet set, boolean value) {
                ((WmiMathTableAttributeSet)set).equalrows = new Boolean(value);
            }
        }

        public static class FrameKey
        extends WmiStringAttributeKey {
            public FrameKey() {
                super(WmiMathTableAttributeSet.FRAME, "none");
            }

            @Override
            public String getStringValue(WmiAttributeSet set) {
                return ((WmiMathTableAttributeSet)set).frameVal != null ? ((WmiMathTableAttributeSet)set).frameVal : this.getDefaultValue();
            }

            @Override
            public void setStringValue(WmiAttributeSet set, String value) {
                ((WmiMathTableAttributeSet)set).frameVal = value;
            }
        }

        public static class FrameSpacingKey
        extends WmiStringAttributeKey {
            public FrameSpacingKey() {
                super(WmiMathTableAttributeSet.FRAME_SPACING, "0.4em 0.5ex");
            }

            @Override
            public String getStringValue(WmiAttributeSet set) {
                return ((WmiMathTableAttributeSet)set).framespacing != null ? ((WmiMathTableAttributeSet)set).framespacing : this.getDefaultValue();
            }

            @Override
            public void setStringValue(WmiAttributeSet set, String value) {
                ((WmiMathTableAttributeSet)set).framespacing = value;
            }
        }

        public static class GroupAlignKey
        extends WmiStringAttributeKey {
            public GroupAlignKey() {
                super(WmiMathTableAttributeSet.GROUP_ALIGN, "{left}");
            }

            public GroupAlignKey(String key, String defaultValue) {
                super(key, defaultValue);
            }

            @Override
            public String getStringValue(WmiAttributeSet set) {
                return ((WmiMathTableAttributeSet)set).groupalign != null ? ((WmiMathTableAttributeSet)set).groupalign : this.getDefaultValue();
            }

            @Override
            public void setStringValue(WmiAttributeSet set, String value) {
                ((WmiMathTableAttributeSet)set).groupalign = value;
            }
        }

        public static class MinLabelSpacingKey
        extends WmiStringAttributeKey {
            public MinLabelSpacingKey() {
                super(WmiMathTableAttributeSet.MIN_LABEL_SPACING, "0.8em");
            }

            @Override
            public String getStringValue(WmiAttributeSet set) {
                return ((WmiMathTableAttributeSet)set).minlabelspacing != null ? ((WmiMathTableAttributeSet)set).minlabelspacing : this.getDefaultValue();
            }

            @Override
            public void setStringValue(WmiAttributeSet set, String value) {
                ((WmiMathTableAttributeSet)set).minlabelspacing = value;
            }
        }

        public static class RowAlignKey
        extends WmiStringAttributeKey {
            public RowAlignKey() {
                super(WmiMathTableAttributeSet.ROW_ALIGN, "baseline");
            }

            public RowAlignKey(String key, String defaultValue) {
                super(key, defaultValue);
            }

            @Override
            public String getStringValue(WmiAttributeSet set) {
                return ((WmiMathTableAttributeSet)set).rowalign != null ? ((WmiMathTableAttributeSet)set).rowalign : this.getDefaultValue();
            }

            @Override
            public void setStringValue(WmiAttributeSet set, String value) {
                ((WmiMathTableAttributeSet)set).rowalign = value;
            }
        }

        public static class RowLinesKey
        extends WmiStringAttributeKey {
            public RowLinesKey() {
                super(WmiMathTableAttributeSet.ROW_LINES, "none");
            }

            @Override
            public String getStringValue(WmiAttributeSet set) {
                return ((WmiMathTableAttributeSet)set).rowlines != null ? ((WmiMathTableAttributeSet)set).rowlines : this.getDefaultValue();
            }

            @Override
            public void setStringValue(WmiAttributeSet set, String value) {
                ((WmiMathTableAttributeSet)set).rowlines = value;
            }
        }

        public static class RowSpacingKey
        extends WmiStringAttributeKey {
            public RowSpacingKey() {
                super(WmiMathTableAttributeSet.ROW_SPACING, "1.0ex");
            }

            @Override
            public String getStringValue(WmiAttributeSet set) {
                return ((WmiMathTableAttributeSet)set).rowspacing != null ? ((WmiMathTableAttributeSet)set).rowspacing : this.getDefaultValue();
            }

            @Override
            public void setStringValue(WmiAttributeSet set, String value) {
                ((WmiMathTableAttributeSet)set).rowspacing = value;
            }
        }

        public static class SideKey
        extends WmiStringAttributeKey {
            public SideKey() {
                super(WmiMathTableAttributeSet.SIDE, "right");
            }

            @Override
            public String getStringValue(WmiAttributeSet set) {
                return ((WmiMathTableAttributeSet)set).sideVal != null ? ((WmiMathTableAttributeSet)set).sideVal : this.getDefaultValue();
            }

            @Override
            public void setStringValue(WmiAttributeSet set, String value) {
                ((WmiMathTableAttributeSet)set).sideVal = value;
            }
        }

        public static class WidthKey
        extends WmiStringAttributeKey {
            public WidthKey() {
                super(WmiMathTableAttributeSet.WIDTH, "auto");
            }

            @Override
            public String getStringValue(WmiAttributeSet set) {
                return ((WmiMathTableAttributeSet)set).widthVal != null ? ((WmiMathTableAttributeSet)set).widthVal : this.getDefaultValue();
            }

            @Override
            public void setStringValue(WmiAttributeSet set, String value) {
                ((WmiMathTableAttributeSet)set).widthVal = value;
            }
        }
    }

    public static class WmiMathTableDataModel
    extends WmiAbstractArrayCompositeMathModel
    implements WmiMathModel {
        private WmiMathSemantics semantics;
        protected WmiDeleteHandler deleteHandler = null;

        public WmiMathTableDataModel(WmiMathDocumentModel doc) {
            super(doc);
        }

        public WmiMathTableDataModel(WmiMathDocumentModel doc, WmiModel arg) {
            super(doc);
            try {
                this.appendChild(arg);
            }
            catch (WmiNoWriteAccessException e) {
                WmiErrorLog.log(e);
            }
        }

        @Override
        public WmiModelTag getTag() {
            return WmiModelTag.MATH_TABLE_CELL;
        }

        @Override
        protected WmiAttributeSet createCompatibleAttributeSet() {
            return new WmiMathTableDataAttributeSet();
        }

        @Override
        public boolean isVisible() throws WmiNoReadAccessException {
            boolean visible = true;
            WmiMathDocumentModel doc = this.getDocument();
            if (doc != null) {
                visible = !doc.isHidden(this);
            }
            return visible;
        }

        @Override
        public Dag toDag() throws WmiNoReadAccessException {
            return this.semantics != null ? this.semantics.toDag(this) : null;
        }

        @Override
        public void setSemantics(WmiMathSemantics semantics) {
            this.semantics = semantics;
        }

        @Override
        public WmiMathSemantics getSemantics() {
            return this.semantics;
        }

        public boolean isInEmptyRow() throws WmiNoReadAccessException {
            boolean emptyRow = true;
            WmiCompositeModel row = this.getParent();
            int rowSize = row.getChildCount();
            int i = 0;
            while (i < rowSize && emptyRow) {
                WmiMathTableDataModel cell = (WmiMathTableDataModel)row.getChild(i);
                if (cell.getChildCount() > 0) {
                    WmiModel child = cell.getChild(0);
                    emptyRow = child instanceof WmiTextModel && ((WmiTextModel)child).getLength() == 0 || child instanceof WmiCompositeModel && ((WmiCompositeModel)child).getChildCount() == 0;
                }
                ++i;
            }
            return rowSize == 0 || emptyRow;
        }

        public boolean isInEmptyColumn() throws WmiNoReadAccessException {
            boolean emptyColumn = true;
            WmiCompositeModel row = this.getParent();
            int indexInRow = row.indexOf(this);
            WmiCompositeModel table = row.getParent();
            int columnCount = table.getChildCount();
            int i = 0;
            while (i < columnCount && emptyColumn) {
                WmiMathTableDataModel cell;
                WmiMathTableRowModel checkRow;
                if (table.getChild(i) instanceof WmiMathTableRowModel && (checkRow = (WmiMathTableRowModel)table.getChild(i)).getChild(indexInRow) instanceof WmiMathTableDataModel && (cell = (WmiMathTableDataModel)checkRow.getChild(indexInRow)).getChildCount() > 0) {
                    WmiModel child = cell.getChild(0);
                    emptyColumn = child instanceof WmiTextModel && ((WmiTextModel)child).getLength() == 0 || child instanceof WmiCompositeModel && ((WmiCompositeModel)child).getChildCount() == 0;
                }
                ++i;
            }
            return columnCount == 0 || emptyColumn;
        }

        @Override
        public WmiDeleteHandler getDeleteHandler() {
            if (this.deleteHandler == null) {
                this.deleteHandler = new WmiMathTableDataDeleteHandler(this);
            }
            return this.deleteHandler;
        }

        @Override
        public boolean useScriptSize(WmiModel child) throws WmiNoReadAccessException {
            return false;
        }

        public static class WmiMathTableDataAttributeSet
        extends WmiMathTableAttributeSet {
            private static HashMap keymap = null;
            private static HashMap cache = new HashMap();
            public static final String ROW_SPAN = "rowspan";
            public static final String COLUMN_SPAN = "columnspan";
            public static final String[] ATTRIBUTES = new String[]{"rowalign", "columnalign", "groupalign", "rowspan", "columnspan"};
            public static final WmiAttributeKey[] DATA_KEYS = new WmiAttributeKey[]{new RowAlignKey(), new ColumnAlignKey(), new GroupAlignKey(), new RowSpanKey(), new ColumnSpanKey()};
            public static final WmiAttributeKey[] EXTENDED_KEYS_TABLE_DATA = WmiAbstractArrayAttributeSet.createExtendedKeySet(WmiFontAttributeSet.ATTRIBUTE_KEYS, DATA_KEYS);
            protected Integer rowspan = null;
            protected Integer columnspan = null;

            public WmiMathTableDataAttributeSet() {
            }

            public WmiMathTableDataAttributeSet(WmiMathTableDataAttributeSet source) {
                this.rowalign = source.rowalign;
                this.columnalign = source.columnalign;
                this.groupalign = source.groupalign;
                this.rowspan = source.rowspan;
                this.columnspan = source.columnspan;
            }

            @Override
            public WmiAttributeSet copyAttributes() {
                return new WmiMathTableDataAttributeSet(this);
            }

            @Override
            public WmiAttributeKey[] getKeys() {
                return EXTENDED_KEYS_TABLE_DATA;
            }

            @Override
            public HashMap getCache() {
                return cache;
            }

            @Override
            protected HashMap getKeyMap() {
                return keymap;
            }

            @Override
            protected void setKeyMap(HashMap map) {
                keymap = map;
            }

            public Integer getRowSpan() {
                return this.rowspan;
            }

            public Integer getColumnSpan() {
                return this.columnspan;
            }

            public static class ColumnAlignKey
            extends WmiMathTableAttributeSet.ColumnAlignKey {
                public ColumnAlignKey() {
                    super("columnalign", "");
                }
            }

            public static class ColumnSpanKey
            extends WmiIntAttributeKey {
                public ColumnSpanKey() {
                    super(WmiMathTableDataAttributeSet.COLUMN_SPAN, 1);
                }

                @Override
                public int getIntValue(WmiAttributeSet set) {
                    return ((WmiMathTableDataAttributeSet)set).columnspan != null ? ((WmiMathTableDataAttributeSet)set).columnspan.intValue() : this.getDefaultValue();
                }

                @Override
                public void setIntValue(WmiAttributeSet set, int value) {
                    ((WmiMathTableDataAttributeSet)set).columnspan = new Integer(value);
                }
            }

            public static class GroupAlignKey
            extends WmiMathTableAttributeSet.GroupAlignKey {
                public GroupAlignKey() {
                    super("groupalign", "");
                }
            }

            public static class RowAlignKey
            extends WmiMathTableAttributeSet.RowAlignKey {
                public RowAlignKey() {
                    super("rowalign", "");
                }
            }

            public static class RowSpanKey
            extends WmiIntAttributeKey {
                public RowSpanKey() {
                    super(WmiMathTableDataAttributeSet.ROW_SPAN, 1);
                }

                @Override
                public int getIntValue(WmiAttributeSet set) {
                    return ((WmiMathTableDataAttributeSet)set).rowspan != null ? ((WmiMathTableDataAttributeSet)set).rowspan.intValue() : this.getDefaultValue();
                }

                @Override
                public void setIntValue(WmiAttributeSet set, int value) {
                    ((WmiMathTableDataAttributeSet)set).rowspan = new Integer(value);
                }
            }
        }

        public class WmiMathTableDataDeleteHandler
        implements WmiDeleteHandler {
            WmiMathTableDataModel model;

            WmiMathTableDataDeleteHandler(WmiMathTableDataModel arg) {
                this.model = arg;
            }

            @Override
            public void processDelete(WmiDeleteManager manager) throws WmiNoWriteAccessException, WmiNoReadAccessException, WmiModelIndexOutOfBoundsException {
                WmiMathTableModel table;
                WmiMathTableRowModel myParent;
                int deleteIndex = WmiModelUtil.getFirstDeletePlaceHolderPosition(this.model);
                if (deleteIndex > -1) {
                    WmiModel deleted = ((WmiDeletePlaceholderModel)WmiMathTableDataModel.this.getChild(0)).getReplacedModel();
                    WmiFontAttributeSet attribs = deleted.getAttributes() instanceof WmiFontAttributeSet ? (WmiFontAttributeSet)deleted.getAttributes() : new WmiMathAttributeSet();
                    WmiIdentifierModel emptyIdent = new WmiIdentifierModel(WmiMathTableDataModel.this.getDocument(), "", "", attribs, false);
                    WmiMathTableDataModel.this.replaceChild(emptyIdent, 0);
                    if (manager.getModelToReposition() == null) {
                        manager.setModelToReposition(new WmiModelPosition(emptyIdent, 0));
                    }
                }
                if (this.model.isInEmptyColumn()) {
                    myParent = (WmiMathTableRowModel)this.model.getParent();
                    int indexOfDataInRow = myParent.indexOf(this.model);
                    table = (WmiMathTableModel)myParent.getParent();
                    if (myParent.getChildCount() > 1 && indexOfDataInRow > 0) {
                        int i = 0;
                        while (i < table.getChildCount()) {
                            WmiMathTableRowModel rowModel = (WmiMathTableRowModel)table.getChild(i);
                            rowModel.removeChild(indexOfDataInRow);
                            ++i;
                        }
                        if (myParent.getChild(indexOfDataInRow) != null) {
                            manager.setModelToReposition(new WmiModelPosition(myParent.getChild(indexOfDataInRow), 0));
                        } else if (myParent.getChild(0) != null) {
                            manager.setModelToReposition(new WmiModelPosition(myParent.getChild(0), 0));
                        }
                    }
                }
                if (this.model.isInEmptyRow()) {
                    myParent = (WmiMathTableRowModel)WmiMathTableDataModel.this.getParent();
                    int indexOfDataInRow = myParent.indexOf(this.model);
                    table = (WmiMathTableModel)myParent.getParent();
                    int index = table.indexOf(myParent);
                    WmiDeletePlaceholderModel rowPlaceHolder = new WmiDeletePlaceholderModel(myParent);
                    table.replaceChild(rowPlaceHolder, index);
                    manager.mark(table);
                    WmiMathTableRowModel repositionRow = myParent;
                    if (table.getChild(index + 1) != null) {
                        repositionRow = (WmiMathTableRowModel)table.getChild(index + 1);
                    } else if (table.getChild(index - 1) != null) {
                        repositionRow = (WmiMathTableRowModel)table.getChild(index - 1);
                    }
                    if (repositionRow.getChild(indexOfDataInRow) != null) {
                        manager.setModelToReposition(new WmiModelPosition(repositionRow.getChild(indexOfDataInRow), 0));
                    } else if (repositionRow.getChild(0) != null) {
                        manager.setModelToReposition(new WmiModelPosition(repositionRow.getChild(0), 0));
                    }
                }
            }

            @Override
            public boolean forceDeleteHandling() {
                return false;
            }
        }
    }

    public class WmiMathTableDeleteHandler
    implements WmiDeleteHandler {
        WmiMathTableModel model;

        WmiMathTableDeleteHandler(WmiMathTableModel arg) {
            this.model = arg;
        }

        @Override
        public void processDelete(WmiDeleteManager manager) throws WmiNoWriteAccessException, WmiNoReadAccessException, WmiModelIndexOutOfBoundsException {
            while (WmiModelUtil.getDeletedChildCount(this.model) > 0) {
                int deleteIndex = WmiModelUtil.getFirstDeletePlaceHolderPosition(this.model);
                WmiModel deleted = ((WmiDeletePlaceholderModel)WmiMathTableModel.this.getChild(deleteIndex)).getReplacedModel();
                if (deleted instanceof WmiMathTableRowModel) {
                    this.model.removeChild(deleteIndex);
                }
                if (manager.getModelToReposition() != null) continue;
                if (this.model.getChild(deleteIndex) != null) {
                    manager.setModelToReposition(new WmiModelPosition(this.model.getChild(deleteIndex), 0));
                    continue;
                }
                manager.setModelToReposition(new WmiModelPosition(this.model.getChild(0), 0));
            }
        }

        @Override
        public boolean forceDeleteHandling() {
            return false;
        }
    }

    public static class WmiMathTableLabeledRowModel
    extends WmiMathTableRowModel {
        public WmiMathTableLabeledRowModel(WmiMathDocumentModel doc) {
            super(doc);
        }

        public WmiMathTableLabeledRowModel(WmiMathDocumentModel doc, WmiModel[] children) throws WmiInvalidModelInitializationException {
            super(doc, children);
        }

        public WmiMathTableLabeledRowModel(WmiMathDocumentModel doc, WmiModel arg) {
            super(doc, arg);
        }

        @Override
        public WmiModelTag getTag() {
            return WmiModelTag.MATH_TABLE_LABELED_ROW;
        }
    }

    public static class WmiMathTableRowModel
    extends WmiAbstractArrayCompositeMathModel
    implements WmiMathModel {
        private WmiMathSemantics semantics;
        protected WmiDeleteHandler deleteHandler = null;

        public WmiMathTableRowModel(WmiMathDocumentModel doc) {
            super(doc);
        }

        public WmiMathTableRowModel(WmiMathDocumentModel doc, WmiModel[] children) throws WmiInvalidModelInitializationException {
            super(doc, children);
        }

        public WmiMathTableRowModel(WmiMathDocumentModel doc, WmiModel arg) {
            super(doc);
            try {
                this.appendChild(arg);
            }
            catch (WmiNoWriteAccessException e) {
                WmiErrorLog.log(e);
            }
        }

        @Override
        public WmiModelTag getTag() {
            return WmiModelTag.MATH_TABLE_ROW;
        }

        @Override
        public boolean isVisible() throws WmiNoReadAccessException {
            boolean visible = true;
            WmiMathDocumentModel doc = this.getDocument();
            if (doc != null) {
                visible = !doc.isHidden(this);
            }
            return visible;
        }

        @Override
        public Dag toDag() throws WmiNoReadAccessException {
            return this.semantics != null ? this.semantics.toDag(this) : null;
        }

        @Override
        public void setSemantics(WmiMathSemantics semantics) {
            this.semantics = semantics;
        }

        @Override
        public WmiMathSemantics getSemantics() {
            return this.semantics;
        }

        @Override
        protected WmiAttributeSet createCompatibleAttributeSet() {
            return new WmiMathTableRowAttributeSet();
        }

        @Override
        public WmiDeleteHandler getDeleteHandler() {
            if (this.deleteHandler == null) {
                this.deleteHandler = new WmiMathTableRowDeleteHandler(this);
            }
            return this.deleteHandler;
        }

        @Override
        public boolean useScriptSize(WmiModel child) throws WmiNoReadAccessException {
            return false;
        }

        public static class WmiMathTableRowAttributeSet
        extends WmiMathTableAttributeSet {
            private static HashMap keymap = null;
            private static HashMap cache = new HashMap();
            public static final String[] ATTRIBUTES = new String[]{"rowalign", "columnalign", "groupalign"};
            public static final WmiAttributeKey[] ROW_KEYS = new WmiAttributeKey[]{new RowAlignKey(), new ColumnAlignKey(), new GroupAlignKey()};
            public static final WmiAttributeKey[] EXTENDED_KEYS_TABLE_ROW = WmiAbstractArrayAttributeSet.createExtendedKeySet(WmiFontAttributeSet.ATTRIBUTE_KEYS, ROW_KEYS);

            public WmiMathTableRowAttributeSet() {
            }

            public WmiMathTableRowAttributeSet(WmiMathTableRowAttributeSet source) {
                this.rowalign = source.rowalign;
                this.columnalign = source.columnalign;
                this.groupalign = source.groupalign;
            }

            @Override
            public WmiAttributeSet copyAttributes() {
                return new WmiMathTableRowAttributeSet(this);
            }

            @Override
            public WmiAttributeKey[] getKeys() {
                return EXTENDED_KEYS_TABLE_ROW;
            }

            @Override
            public HashMap getCache() {
                return cache;
            }

            @Override
            protected HashMap getKeyMap() {
                return keymap;
            }

            @Override
            protected void setKeyMap(HashMap map) {
                keymap = map;
            }

            public static class ColumnAlignKey
            extends WmiMathTableAttributeSet.ColumnAlignKey {
                public ColumnAlignKey() {
                    super("columnalign", "");
                }
            }

            public static class GroupAlignKey
            extends WmiMathTableAttributeSet.GroupAlignKey {
                public GroupAlignKey() {
                    super("groupalign", "");
                }
            }

            public static class RowAlignKey
            extends WmiMathTableAttributeSet.RowAlignKey {
                public RowAlignKey() {
                    super("rowalign", "");
                }
            }
        }

        public class WmiMathTableRowDeleteHandler
        implements WmiDeleteHandler {
            WmiMathTableRowModel model;

            WmiMathTableRowDeleteHandler(WmiMathTableRowModel arg) {
                this.model = arg;
            }

            @Override
            public void processDelete(WmiDeleteManager manager) throws WmiNoWriteAccessException, WmiNoReadAccessException, WmiModelIndexOutOfBoundsException {
                while (WmiModelUtil.getDeletedChildCount(this.model) > 0) {
                    int deleteIndex = WmiModelUtil.getFirstDeletePlaceHolderPosition(this.model);
                    WmiModel deleted = ((WmiDeletePlaceholderModel)WmiMathTableRowModel.this.getChild(deleteIndex)).getReplacedModel();
                    WmiMathTableRowModel.this.replaceChild(deleted, deleteIndex);
                    if (!(deleted instanceof WmiMathTableDataModel)) continue;
                    WmiMathTableDataModel dataElement = (WmiMathTableDataModel)deleted;
                    WmiModel child = dataElement.getChild(0);
                    WmiDeletePlaceholderModel childPlaceHolder = new WmiDeletePlaceholderModel(child);
                    dataElement.replaceChild(childPlaceHolder, 0);
                    manager.mark(dataElement);
                }
            }

            @Override
            public boolean forceDeleteHandling() {
                return false;
            }
        }
    }
}

