/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.math.WmiAbstractMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiImpliedSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.util.WmiMathEntityNameMapper;

public class WmiMathTextModel
extends WmiAbstractMathTokenModel
implements WmiMathModel {
    private WmiMathSemantics semantics = null;
    private static final WmiImpliedSemantics IMPLIED_SEMANTICS = new WmiImpliedSemantics();

    public WmiMathTextModel(WmiMathDocumentModel doc, String contents, WmiMathContext context) {
        this(doc, contents, contents, context);
    }

    public WmiMathTextModel(WmiMathDocumentModel doc, String contents, WmiAttributeSet attrs) {
        super(doc, contents, attrs);
    }

    public WmiMathTextModel(WmiMathDocumentModel doc, String contents, String semanticsLabel, WmiMathContext context) {
        super(doc, semanticsLabel, (WmiAttributeSet)new WmiMathAttributeSet());
        WmiFontAttributeSet defSet = new WmiFontAttributeSet();
        try {
            defSet.addAttributes(context.getStyle());
            this.addAttributes(defSet);
        }
        catch (WmiNoWriteAccessException e) {
            WmiErrorLog.log(e);
        }
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    public static String getNonMarkingEntity(String name) {
        if (!name.equals("")) {
            if (WmiMathEntityNameMapper.isNonMarkingEntity(name.substring(1, name.length() - 1))) {
                return name.substring(1, name.length() - 1);
            }
            return "";
        }
        return "";
    }

    @Override
    public Dag toDag() throws WmiNoReadAccessException {
        return this.semantics == null ? null : this.semantics.toDag(this);
    }

    @Override
    public WmiModelTag getTag() {
        return WmiModelTag.MATH_TEXT;
    }

    @Override
    public boolean useScriptSize(WmiModel child) {
        return false;
    }

    @Override
    public void setSemantics(WmiMathSemantics semantics) {
        this.semantics = semantics;
    }

    @Override
    public WmiMathSemantics getSemantics() {
        return this.semantics;
    }

    @Override
    protected WmiTextModel createSubModel(int offset) throws WmiNoReadAccessException {
        return new WmiMathTextModel(this.getDocument(), this.getText().substring(offset), this.getText().substring(offset), new WmiMathContext((WmiFontAttributeSet)this.getAttributes()));
    }
}

