/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractArrayCompositeMathModel;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiFontAttributeSource;
import com.maplesoft.mathdoc.model.WmiMathDocumentHierarchyValidator;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.math.WmiAssignedSemantics;
import com.maplesoft.mathdoc.model.math.WmiIdentifierModel;
import com.maplesoft.mathdoc.model.math.WmiImpliedSemantics;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathFencedModel;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import java.io.IOException;
import java.util.HashMap;

public class WmiMathWrapperModel
extends WmiAbstractArrayCompositeMathModel
implements WmiMathModel,
WmiFontAttributeSource {
    private static final int MATH_CHILD_INDEX = 0;
    public static final int DISPLAY_DAG_CHILD_INDEX = 0;
    public static final int SEMANTIC_DAG_CHILD_INDEX = 1;
    public static final int DISPLAY_DAG_PART = 0;
    public static final int SEMANTIC_DAG_PART = 1;
    public static final String TYPESET_PACKAGE = "Typesetting";
    private static final int FUNCTION_NAME_INDEX = 0;
    private static final String MODULE_NAME_ATTR = "modulename";
    private static final String EMPTY_DOTM_CLASSIC = "%#%?G";
    protected static HashMap styleMapper = new HashMap();
    private WmiMathSemantics semantics = null;
    private String dotm = null;
    private String displayDotM = null;
    private boolean replacingLabel = false;

    public WmiMathWrapperModel(WmiMathDocumentModel doc) {
        super(doc);
    }

    public static boolean identifyTypesettingOutputDag(Dag dag) {
        boolean isTypeset = false;
        if (dag.getType() == 29 && dag.getLength() == 2) {
            Dag tdDag = dag.getChild(0);
            isTypeset = WmiMathWrapperModel.isTypesettingDag(tdDag) || DagUtil.isGarbage(tdDag);
        }
        return isTypeset;
    }

    public static boolean isTypesettingDag(Dag dag) {
        boolean isTypeset = false;
        if (dag != null) {
            Dag testDag = dag;
            if (dag.getType() == 29 && dag.getLength() == 1) {
                testDag = dag.getChild(0);
            }
            if (testDag.getType() == 18) {
                Dag nameDag = testDag.getChild(0);
                Dag typesetAttr = DagUtil.searchForAttribute(nameDag, MODULE_NAME_ATTR);
                isTypeset = typesetAttr != null && typesetAttr.getData().equals(TYPESET_PACKAGE);
            }
        }
        return isTypeset;
    }

    public static Dag[] getTypesettingDagComponents(Dag dag) {
        Dag[] parts = new Dag[]{dag, dag};
        if (WmiMathWrapperModel.identifyTypesettingOutputDag(dag)) {
            Dag tdDag = dag.getChild(0);
            Dag tsDag = dag.getChild(1);
            if (tdDag.getType() == 18) {
                parts[0] = tdDag;
                if (DagUtil.isOneElementList(tsDag)) {
                    parts[1] = tsDag.getChild(0);
                } else {
                    parts[1] = tsDag;
                    if (tsDag != null && tsDag.getType() == 30) {
                        tsDag.setType(29);
                    }
                }
            } else if (DagUtil.isGarbage(tdDag)) {
                parts[0] = tsDag;
                parts[1] = tsDag;
                if (DagUtil.isOneElementList(tsDag)) {
                    parts[1] = tsDag.getChild(0);
                    parts[0] = parts[1];
                }
            }
        }
        return parts;
    }

    public WmiMathWrapperModel createInputMath() throws WmiNoReadAccessException {
        WmiMathWrapperModel model = null;
        try {
            model = (WmiMathWrapperModel)this.clone();
            WmiAttributeSet set = model.getAttributes();
            set.addAttribute("font_style_name", "2D Math");
            model.attributes = set;
        }
        catch (CloneNotSupportedException e) {
            WmiErrorLog.log(e);
        }
        return model;
    }

    private void recreateChildren(Dag dag, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        this.recreateChildren(dag, dag, context);
    }

    private void recreateChildren(Dag displayDag, Dag semanticDag, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathModel child;
        Dag renderDag;
        try {
            this.removeChildren(0, this.getChildCount());
        }
        catch (WmiModelIndexOutOfBoundsException boundsE) {
            WmiErrorLog.log(boundsE);
        }
        Dag dag = renderDag = DagUtil.isGarbage(displayDag) || DagUtil.isMVerbatim(displayDag) ? semanticDag : displayDag;
        if (!renderDag.isNormalized()) {
            renderDag = DagBuilder.normalize(renderDag);
        }
        if ((child = WmiMathFactory.createMathModel(this.getDocument(), renderDag, context)) == null && displayDag != semanticDag) {
            child = WmiMathFactory.createMathModel(this.getDocument(), semanticDag, context);
        }
        if (child != null) {
            this.appendChild(child);
            if (child.getSemantics() != null) {
                if (!WmiMathWrapperModel.isTypesettingDag(semanticDag)) {
                    WmiAssignedSemantics newSemantics = new WmiAssignedSemantics(semanticDag, 0, semanticDag != displayDag);
                    child.setSemantics(newSemantics);
                }
            } else {
                WmiAssignedSemantics newSemantics = new WmiAssignedSemantics(semanticDag, 0, semanticDag != displayDag);
                child.setSemantics(newSemantics);
            }
        }
    }

    public void createMathChildren(String dotM) throws IOException, WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathContext context = new WmiMathContext((WmiFontAttributeSet)this.getAttributes());
        this.createMathChildren(dotM, context);
    }

    public void createMathChildren(String dotM, WmiMathContext context) throws IOException, WmiNoReadAccessException, WmiNoWriteAccessException {
        Dag semanticDag = DagBuilder.createDag(dotM.getBytes());
        semanticDag = DagBuilder.normalize(semanticDag);
        Dag displayDag = this.displayDotM != null ? DagBuilder.createDag(this.displayDotM.getBytes()) : null;
        Dag dag = null;
        Dag tdDag = null;
        Dag tsDag = null;
        if (displayDag != null) {
            tsDag = semanticDag;
            dag = tdDag = displayDag;
        } else {
            tsDag = null;
            tdDag = null;
            dag = semanticDag;
        }
        if (tdDag == null && WmiMathWrapperModel.identifyTypesettingOutputDag(dag)) {
            tdDag = dag.getChild(0);
            tsDag = dag.getChild(1);
            if (DagUtil.isOneElementList(tsDag)) {
                tsDag = tsDag.getChild(0);
            }
        }
        if (tsDag != null && tdDag != null) {
            this.recreateChildren(tdDag, tsDag, context);
        } else {
            this.recreateChildren(dag, dag, context);
        }
        if (context.hasRecoverableErrorOccured()) {
            throw context.getRecoverableError();
        }
    }

    public void createMathChildren(Dag dag, WmiFontAttributeSet fontAttr) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        this.createMathChildren(dag, new WmiMathContext(fontAttr));
    }

    public void createMathChildren(Dag renderDag, Dag semanticDag, WmiFontAttributeSet fontAttr) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        this.createMathChildren(renderDag, semanticDag, new WmiMathContext(fontAttr));
    }

    public void createMathChildren(Dag displayDag, Dag semanticDag, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        this.recreateChildren(displayDag, semanticDag, context);
    }

    public void createMathChildren(Dag dag, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        this.createMathChildren(dag, dag, context);
    }

    public Dag getNonSemanticDag() throws WmiNoReadAccessException {
        return this.toDag(false);
    }

    public Dag getDag() throws WmiNoReadAccessException {
        return this.toDag();
    }

    public void storeDotm(String dotm) {
        this.dotm = dotm;
    }

    public String getDotM() throws WmiNoReadAccessException {
        Dag dag;
        String dotM = this.dotm;
        if (dotM == null && this.getChild(0) instanceof WmiMathModel && (dag = ((WmiMathModel)this.getChild(0)).toDag()) != null) {
            dotM = DagBuilder.createDotm(dag);
        }
        return dotM;
    }

    public String getDotMClassic() throws WmiNoReadAccessException {
        String dotM = null;
        boolean forceUpdate = false;
        if (this.isEmptyMath()) {
            dotM = EMPTY_DOTM_CLASSIC;
        } else {
            Dag dag = WmiImpliedSemantics.getDag(this, false, true);
            if (WmiMathWrapperModel.isTypesettingDag(dag) && this.getChild(0) instanceof WmiMathModel) {
                dag = ((WmiMathModel)this.getChild(0)).toDag();
            }
            if (dag != null) {
                dag = DagUtil.getDisplayDataFromPrintslash(dag);
            }
            if (dag != null && DagUtil.isList(dag) && dag.getLength() == 2 && WmiMathWrapperModel.isTypesettingDag(dag.getChild(0))) {
                dag = dag.getChild(1);
                forceUpdate = true;
            }
            if (dag != null) {
                dotM = DagBuilder.createDotm(dag);
            }
        }
        if (!forceUpdate && this.dotm != null) {
            dotM = this.dotm;
        }
        return dotM;
    }

    public String getSaveDotM() throws WmiNoReadAccessException {
        String dotM = null;
        Dag dag = this.getSaveDag();
        if (dag != null) {
            dotM = DagBuilder.createDotm(dag);
        }
        return dotM;
    }

    public Dag getSaveDag() throws WmiNoReadAccessException {
        Dag dag = null;
        if (this.getChild(0) instanceof WmiMathModel) {
            Dag displayDag;
            WmiMathModel mathChild = (WmiMathModel)this.getChild(0);
            dag = displayDag = WmiImpliedSemantics.getDag(mathChild, false, true);
            Dag semanticDag = null;
            WmiMathSemantics childSemantics = mathChild.getSemantics();
            if (childSemantics instanceof WmiAssignedSemantics) {
                semanticDag = childSemantics.toDag(mathChild);
            } else if (this.getSemantics() instanceof WmiAssignedSemantics) {
                semanticDag = this.getSemantics().toDag(this);
            } else if (childSemantics != null && !(childSemantics instanceof WmiImpliedSemantics)) {
                semanticDag = childSemantics.toDag(mathChild);
            } else if (this.getSemantics() != null && !(this.getSemantics() instanceof WmiImpliedSemantics)) {
                semanticDag = this.getSemantics().toDag(this);
            }
            if (semanticDag != null) {
                dag = semanticDag;
            } else {
                String value;
                dag = displayDag;
                WmiModelTag tag = mathChild.getTag();
                if (tag == WmiModelTag.MATH_ROW && ((WmiCompositeModel)((Object)mathChild)).getChildCount() == 1) {
                    mathChild = (WmiMathModel)((WmiCompositeModel)((Object)mathChild)).getChild(0);
                    tag = mathChild.getTag();
                }
                if (tag == WmiModelTag.MATH_IDENTIFIER && (value = ((WmiTextModel)((Object)mathChild)).getText()).length() == 0) {
                    dag = Dag.createDag(8, null, "", false);
                }
            }
        } else {
            dag = this.toDag();
        }
        return dag;
    }

    public Dag getSaveDisplayDag() throws WmiNoReadAccessException {
        Dag displayDag = null;
        if (this.getChild(0) instanceof WmiMathModel) {
            WmiMathModel mathChild = (WmiMathModel)this.getChild(0);
            displayDag = WmiImpliedSemantics.getDag(mathChild, false, true);
        }
        return displayDag;
    }

    public String getSaveDisplayDotM() throws WmiNoReadAccessException {
        Dag dag;
        String dotM;
        String string = dotM = this.getDocument().isMutableModel(this) ? null : this.displayDotM;
        if (dotM == null && (dag = this.getSaveDisplayDag()) != null) {
            dotM = DagBuilder.createDotm(dag);
        }
        return dotM;
    }

    public void setDisplayDotM(String dotM) {
        this.displayDotM = dotM;
    }

    public String getAutoSimplifiedInput() throws WmiNoReadAccessException {
        String input = null;
        Dag dag = this.toDag();
        boolean collapse = false;
        if (dag != null) {
            int i;
            int length;
            if ((dag = DagUtil.getSemanticDataFromPrintslash(dag)) != null && dag.getType() == 46 && (length = dag.getLength()) % 2 == 0) {
                collapse = true;
                i = 1;
                while (i < length) {
                    Dag child = dag.getChild(i);
                    if (!DagUtil.isOne(child) && !DagUtil.isMinusOne(child)) {
                        collapse = false;
                        break;
                    }
                    i += 2;
                }
            }
            if (collapse) {
                StringBuffer sb = new StringBuffer();
                i = 0;
                while (i < this.length) {
                    sb.append(DagBuilder.lPrint(dag.getChild(i)));
                    Dag terminator = dag.getChild(i + 1);
                    if (DagUtil.isOne(terminator)) {
                        sb.append(";");
                    } else {
                        sb.append(":");
                    }
                    i += 2;
                }
                input = sb.toString();
            } else {
                input = DagBuilder.lPrint(dag);
            }
        }
        return input;
    }

    @Override
    public String getNamedFontStyle() throws WmiNoReadAccessException {
        Object nameObj;
        String name = null;
        WmiAttributeSet attrs = this.getAttributesForRead();
        if (attrs != null && (nameObj = attrs.getAttribute("font_style_name")) != null) {
            name = nameObj.toString();
        }
        return name;
    }

    @Override
    public void updateFontStyle(String name) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiFontAttributeSet defSet = new WmiFontAttributeSet();
        defSet.setNamedFontStyle(name, this.getDocument());
        this.addAttributes(defSet);
    }

    @Override
    public WmiMathSemantics getSemantics() {
        return this.semantics;
    }

    @Override
    public void setSemantics(WmiMathSemantics semantics) {
        if (semantics == null || semantics instanceof WmiImpliedSemantics || semantics instanceof WmiAssignedSemantics) {
            this.semantics = semantics;
        }
    }

    @Override
    public Dag toDag() throws WmiNoReadAccessException {
        return this.toDag(true);
    }

    public Dag toDag(boolean useAssignedSemanticsIfPossible) throws WmiNoReadAccessException {
        Dag dag = null;
        if (this.semantics instanceof WmiAssignedSemantics && useAssignedSemanticsIfPossible) {
            dag = this.semantics.toDag(this);
        } else {
            String dotMString;
            boolean gotDagFromMathChild = false;
            if (this.getChild(0) instanceof WmiMathModel) {
                WmiMathModel mathChild = (WmiMathModel)this.getChild(0);
                WmiMathSemantics childSemantics = mathChild.getSemantics();
                if (childSemantics instanceof WmiAssignedSemantics) {
                    dag = childSemantics.toDag(mathChild);
                } else {
                    dag = ((WmiMathModel)this.getChild(0)).toDag();
                    gotDagFromMathChild = true;
                }
            }
            String string = dotMString = gotDagFromMathChild ? this.dotm : this.getDotM();
            if (dag == null) {
                if (dotMString != null) {
                    try {
                        dag = DagBuilder.createDag(dotMString.getBytes());
                    }
                    catch (IOException ioE) {
                        WmiErrorLog.log(ioE);
                    }
                } else {
                    WmiImpliedSemantics semantics = new WmiImpliedSemantics();
                    dag = semantics.toDag(this);
                }
            }
        }
        return dag;
    }

    @Override
    public boolean useScriptSize(WmiModel child) {
        return false;
    }

    public void setReplacingLabel(boolean state) {
        this.replacingLabel = state;
    }

    public boolean isReplacingLabel() {
        return this.replacingLabel;
    }

    @Override
    protected WmiAttributeSet createCompatibleAttributeSet() {
        return new WmiFontAttributeSet();
    }

    @Override
    public WmiModelTag getTag() {
        return WmiModelTag.MATH;
    }

    @Override
    public boolean isVisible() throws WmiNoReadAccessException {
        boolean visible = true;
        WmiMathDocumentModel doc = this.getDocument();
        if (doc != null) {
            visible = !doc.isHidden(this);
        }
        return visible;
    }

    public static final WmiMathWrapperModel insert2DMath(WmiModel targetModel, int targetOffset, WmiMathDocumentModel doc) throws WmiModelIndexOutOfBoundsException, WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiAttributeSet attrs = targetModel.getAttributes();
        return WmiMathWrapperModel.insert2DMath(targetModel, targetOffset, doc, attrs);
    }

    public static final WmiMathWrapperModel insert2DMath(WmiModel targetModel, int targetOffset, WmiMathDocumentModel doc, WmiAttributeSet attrs) throws WmiModelIndexOutOfBoundsException, WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiFontAttributeSet mappedAttrs = WmiMathWrapperModel.mapStyleFromAttributes(doc, attrs);
        WmiMathModel placeHolderStructure = WmiMathWrapperModel.createDefaultEmptyStructure(doc, mappedAttrs);
        return WmiMathWrapperModel.insert2DMath(targetModel, targetOffset, doc, placeHolderStructure, mappedAttrs);
    }

    public static final WmiMathWrapperModel insert2DMath(WmiModel targetModel, int targetOffset, WmiMathDocumentModel doc, WmiMathModel insertedModel, WmiAttributeSet attrs) throws WmiModelIndexOutOfBoundsException, WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathWrapperModel mathWrapper = new WmiMathWrapperModel(doc);
        if (attrs != null) {
            mathWrapper.addAttributes(attrs);
        }
        mathWrapper.appendChild(insertedModel);
        WmiFontAttributeSet newTextRunAttributes = WmiMathWrapperModel.createAttributesForNewTextRuns(targetModel, doc);
        WmiMathDocumentHierarchyValidator validator = doc.getModelHierarchyValidator();
        WmiModel targetParent = targetModel instanceof WmiCompositeModel ? targetModel : targetModel.getParent();
        while (targetParent != null && !validator.isValid(targetParent.getTag(), mathWrapper.getTag())) {
            targetModel = targetParent;
            targetParent = targetParent.getParent();
        }
        WmiCompositeModel parentModel = WmiModelUtil.findAncestorOfClass(targetModel, WmiCompositeModel.class);
        if (targetModel instanceof WmiTextModel) {
            WmiTextModel textModel = (WmiTextModel)targetModel;
            WmiMathWrapperModel.insertIntoText(textModel, targetOffset, parentModel, doc, mathWrapper, newTextRunAttributes);
        } else {
            if (parentModel == null && targetModel instanceof WmiCompositeModel) {
                parentModel = (WmiCompositeModel)targetModel;
            }
            if (parentModel != null) {
                WmiCompositeModel composite = parentModel;
                int modelIndex = targetModel == parentModel ? 0 : composite.indexOf(targetModel);
                composite.addChild(mathWrapper, modelIndex);
            }
        }
        return mathWrapper;
    }

    private static final void insertIntoText(WmiTextModel textModel, int targetOffset, WmiModel parentModel, WmiMathDocumentModel doc, WmiMathWrapperModel mathWrapper, WmiFontAttributeSet textAttrs) throws WmiModelIndexOutOfBoundsException, WmiNoReadAccessException, WmiNoWriteAccessException {
        int modelLength = textModel.getLength();
        WmiCompositeModel composite = (WmiCompositeModel)parentModel;
        int finalInsertPosition = composite.indexOf(textModel);
        if (modelLength > 0) {
            if (modelLength > 1 && targetOffset > 0 && targetOffset < modelLength) {
                WmiTextModel splitModel = textModel.splitModel(targetOffset);
                if (splitModel != textModel) {
                    finalInsertPosition = composite.indexOf(splitModel);
                }
            } else if (targetOffset == modelLength) {
                ++finalInsertPosition;
            }
            if (targetOffset == 0 && modelLength > 0) {
                composite.addChild(new WmiTextModel(doc, "", textAttrs), finalInsertPosition);
                ++finalInsertPosition;
            }
            composite.addChild(mathWrapper, finalInsertPosition);
        } else {
            composite.replaceChild(mathWrapper, finalInsertPosition);
        }
    }

    private static final WmiFontAttributeSet createAttributesForNewTextRuns(WmiModel targetModel, WmiMathDocumentModel doc) throws WmiNoReadAccessException {
        WmiAttributeSet surroundingAttributes = targetModel.getAttributes();
        WmiFontAttributeSet newTextRunAttributes = null;
        if (surroundingAttributes instanceof WmiFontAttributeSet) {
            newTextRunAttributes = (WmiFontAttributeSet)surroundingAttributes;
        } else {
            String styleName = (String)surroundingAttributes.getAttribute("font_style_name");
            if (styleName != null) {
                newTextRunAttributes = doc.getFontStyle(styleName);
            }
        }
        return newTextRunAttributes;
    }

    public static WmiMathModel createPlaceHolder(WmiMathDocumentModel doc, WmiMathContext context) {
        WmiIdentifierModel newIdModel = new WmiIdentifierModel(doc, "", "", context, false);
        return newIdModel;
    }

    public static WmiMathModel createPlaceHolder(WmiMathDocumentModel doc, WmiAttributeSet attrs) {
        return WmiMathWrapperModel.createPlaceHolder(doc, WmiMathWrapperModel.createContext(attrs));
    }

    public static WmiMathContext createContext(WmiAttributeSet attrs) {
        WmiMathContext context = null;
        if (attrs instanceof WmiFontAttributeSet) {
            context = new WmiMathContext((WmiFontAttributeSet)attrs);
        } else {
            WmiFontAttributeSet fontr = new WmiFontAttributeSet();
            fontr.addAttributes(attrs);
            context = new WmiMathContext(fontr);
        }
        return context;
    }

    public static final WmiMathModel createDefaultEmptyStructure(WmiMathDocumentModel doc, WmiAttributeSet attrs) throws WmiNoWriteAccessException {
        WmiInlineMathModel newRow = new WmiInlineMathModel(doc);
        WmiMathContext context = WmiMathWrapperModel.createContext(attrs);
        WmiMathModel newIdModel = WmiMathWrapperModel.createPlaceHolder(doc, context);
        newRow.appendChild(newIdModel);
        return newRow;
    }

    public static final WmiMathWrapperModel createEmptyMathWrapper(WmiMathDocumentModel doc, WmiAttributeSet attrs) throws WmiNoWriteAccessException {
        WmiMathWrapperModel wrapper = new WmiMathWrapperModel(doc);
        wrapper.setAttributes(attrs);
        wrapper.appendChild(WmiMathWrapperModel.createDefaultEmptyStructure(doc, attrs));
        return wrapper;
    }

    public boolean isEmptyMath() throws WmiNoReadAccessException {
        boolean structureEmpty = false;
        WmiModel model = this;
        while (model instanceof WmiCompositeModel && !(model instanceof WmiMathFencedModel) && ((WmiCompositeModel)model).getChildCount() < 2) {
            WmiCompositeModel composite = model;
            if (composite.getChildCount() == 1) {
                model = composite.getChild(0);
                if (!(model instanceof WmiTextModel)) continue;
                structureEmpty = ((WmiTextModel)model).getLength() == 0;
                break;
            }
            structureEmpty = true;
            break;
        }
        return structureEmpty;
    }

    public boolean isPlaceHolder() throws WmiNoReadAccessException {
        boolean isPlaceHolder = false;
        WmiModel model = this;
        while (model instanceof WmiCompositeModel && ((WmiCompositeModel)model).getChildCount() == 1) {
            WmiCompositeModel composite = model;
            if (!((model = composite.getChild(0)) instanceof WmiIdentifierModel)) continue;
            boolean bl = isPlaceHolder = ((WmiIdentifierModel)model).getTokenContents().length() == 0;
        }
        return isPlaceHolder;
    }

    public static final void addStyleMapping(String sourceName, String targetName) {
        styleMapper.put(sourceName, targetName);
    }

    public static final WmiFontAttributeSet mapStyleFromAttributes(WmiMathDocumentModel doc, WmiAttributeSet sourceAttrs) throws WmiNoReadAccessException {
        WmiFontAttributeSet newAttributes = sourceAttrs instanceof WmiFontAttributeSet ? (WmiFontAttributeSet)sourceAttrs : null;
        String styleName = (String)sourceAttrs.getAttribute("font_style_name");
        if ((styleName = WmiMathWrapperModel.mapStyleName(styleName)) != null) {
            newAttributes = doc.getFontStyle(styleName);
        }
        return newAttributes;
    }

    public static final String mapStyleName(String name) {
        String returned = (String)styleMapper.get(name);
        returned = returned == null ? name : returned;
        return returned;
    }

    @Override
    public int kerningPoints() throws WmiNoReadAccessException {
        WmiFontAttributeSet fontattr = WmiMathWrapperModel.mapStyleFromAttributes(this.getDocument(), this.getAttributes());
        int kP = 0;
        if (fontattr != null) {
            double d = (double)fontattr.getSize() * 0.3;
            kP = (int)d;
        }
        return kP;
    }

    public void discardSemantics() throws WmiNoReadAccessException, WmiNoWriteAccessException {
        this.removeSemantics(this);
    }

    private void removeSemantics(WmiMathModel model) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        this.removeSemantics(model, false);
    }

    public void removeSemantics(WmiMathModel model, boolean forceReset) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        boolean continueTraversal = true;
        boolean summaryRTable = false;
        if (model.getTag() == WmiModelTag.MATH_ACTION) {
            WmiAttributeSet attrs = model.getAttributesForRead();
            summaryRTable = attrs.getAttribute("rtableid") != null;
            Object actionType = attrs.getAttribute("actiontype");
            if (summaryRTable && !(summaryRTable = "browsertable".equals(actionType))) {
                attrs = model.getAttributes();
                attrs.addAttribute("rtableid", null);
                model.setAttributes(attrs);
            }
        }
        if (forceReset && !summaryRTable) {
            model.setSemantics(null);
        } else {
            WmiMathSemantics semantics = model.getSemantics();
            if (summaryRTable) {
                continueTraversal = false;
            } else if (semantics instanceof WmiAssignedSemantics) {
                ((WmiAssignedSemantics)semantics).markStale();
            } else {
                model.setSemantics(null);
            }
        }
        if (continueTraversal && model instanceof WmiCompositeModel) {
            WmiCompositeModel comp = (WmiCompositeModel)((Object)model);
            int itlen = comp.getChildCount();
            int i = 0;
            while (i < itlen) {
                WmiModel child = comp.getChild(i);
                if (child instanceof WmiMathModel) {
                    this.removeSemantics((WmiMathModel)child, forceReset);
                }
                ++i;
            }
        }
    }

    @Override
    public boolean isCrossBoundarySubselectable() {
        return false;
    }
}

