/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagUtil;
import java.math.BigDecimal;

public class WmiNumericFormatter {
    private static final int MAX_EXPANDED_DIGITS = 100000;
    private String dot = ".";
    private String displaydot;
    private String defaultdisplaydot;
    private String comma = ",";
    private String displaycomma;
    private String defaultdisplaycomma;
    private float[][] colors = new float[][]{{0.0f, 0.0f, 0.0f}, {1.0f, 1.0f, 1.0f}, {1.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 1.0f}, {1.0f, 1.0f, 0.0f}, {1.0f, 0.0f, 1.0f}, {0.0f, 1.0f, 1.0f}};

    public WmiNumericFormatter() {
        this(".", ",");
    }

    public WmiNumericFormatter(String dot, String comma) {
        this.defaultdisplaydot = dot;
        this.defaultdisplaycomma = comma;
        this.displaydot = this.defaultdisplaydot;
        this.displaycomma = this.defaultdisplaycomma;
    }

    /*
     * Unable to fully structure code
     */
    public WmiFormattedNumeric format(Dag n, String fmt) {
        this.displaydot = this.defaultdisplaydot;
        this.displaycomma = this.defaultdisplaycomma;
        N = this.splitNumeric(n);
        if ((fmt = this.getFormatter(n, fmt, N)).length() != 0) ** GOTO lbl9
        return null;
        while ((i = fmt.indexOf("]")) != -1) {
            this.processSpecial(N, fmt.substring(1, i));
            fmt = fmt.substring(i + 1);
lbl9:
            // 2 sources

            if (fmt.length() > 0 && fmt.charAt(0) == '[') continue;
        }
        fmt = this.expandFormattingString(fmt);
        if (N.isRational()) {
            i = WmiNumericFormatter.indexOf(fmt, this.dot);
            digits = 0;
            if (i != -1) {
                digits = this.countDecimals(fmt, i + 1);
            }
            N = N.approximateRational(digits);
        }
        if ((s = this.scale(fmt)) != 0) {
            N.setExponent(N.getIntegerExponent() + s);
        }
        i = WmiNumericFormatter.indexOf(fmt, this.dot);
        rstart = i + 1;
        hasdot = true;
        if (i == -1) {
            hasdot = false;
            rstart = i = fmt.length();
        }
        N.setForceDot(hasdot);
        j = WmiNumericFormatter.indexOf(fmt, "E+");
        if (j == -1) {
            j = WmiNumericFormatter.indexOf(fmt, "E-");
        }
        if (j == -1) {
            j = WmiNumericFormatter.indexOf(fmt, "e+");
        }
        if (j == -1) {
            j = WmiNumericFormatter.indexOf(fmt, "e-");
        }
        if (j == -1) {
            N.normalize(0);
        } else {
            if (i > j) {
                i = j;
            }
            rstart = j;
            nleft = this.countLeftDigits(fmt, i - 1);
            if (nleft == 0 && !hasdot) {
                nleft = 1;
            }
            N.normalizeMultiples(nleft);
        }
        if (!hasdot) {
            N.roundToDecimals(0);
            this.formatRight(fmt, N, rstart);
        } else {
            dd = this.countDecimals(fmt, i + 1);
            N.roundToDecimals(dd);
            this.formatRight(fmt, N, i + 1);
        }
        this.formatLeft(fmt, N, i - 1);
        return N;
    }

    private String expandFormattingString(String fmt) {
        StringBuffer sb = new StringBuffer();
        sb.append(fmt.charAt(0));
        int k = 1;
        while (k < fmt.length()) {
            int i = fmt.indexOf("{", k);
            if (i == -1) {
                sb.append(fmt.substring(k));
                break;
            }
            sb.append(fmt.substring(k, i));
            int j = fmt.indexOf("}", i + 1);
            if (j == -1) break;
            char d = fmt.charAt(i - 1);
            String ns = fmt.substring(i + 1, j);
            try {
                int n = Integer.valueOf(ns) - 1;
                if (n <= 0 || n > 100000) break;
                int q = 0;
                while (q < n) {
                    sb.append(d);
                    ++q;
                }
            }
            catch (NumberFormatException x) {
                break;
            }
            k = j + 1;
        }
        return sb.toString();
    }

    private int countLeftDigits(String fmt, int i) {
        boolean inquote = false;
        int n = 0;
        while (i >= 0) {
            char c = fmt.charAt(i);
            if (c == '\"') {
                inquote = !inquote;
                --i;
                continue;
            }
            if (!(inquote || c != '#' && c != '0' && c != '?')) {
                ++n;
            }
            --i;
        }
        return n;
    }

    private int countDecimals(String fmt, int i) {
        boolean inquote = false;
        int n = 0;
        while (i < fmt.length()) {
            char c = fmt.charAt(i);
            if (c == '\"') {
                inquote = !inquote;
                ++i;
                continue;
            }
            if (!inquote) {
                if (c == 'E' && i < fmt.length() - 2) {
                    char t1 = fmt.charAt(i + 1);
                    char t2 = fmt.charAt(i + 2);
                    if (!(t1 != '+' && t1 != '-' || t2 != '#' && t2 != '0' && t2 != '?')) {
                        int j = WmiNumericFormatter.indexOf(fmt, "E", i + 2);
                        if (j == -1) break;
                        i = j + 1;
                        continue;
                    }
                }
                if (c == '#' || c == '0' || c == '?') {
                    ++n;
                }
            }
            ++i;
        }
        return n;
    }

    private void formatRight(String fmt, WmiFormattedNumeric N, int i) {
        StringBuffer sb = new StringBuffer();
        String rm = N.getPostMantissa();
        int k = 0;
        boolean inquote = false;
        while (i < fmt.length()) {
            char c = fmt.charAt(i);
            if (c == '\"') {
                inquote = !inquote;
                ++i;
                continue;
            }
            if (!inquote) {
                if (c == '#' || c == '0' || c == '?') {
                    if (k < rm.length()) {
                        sb.append(rm.charAt(k));
                        ++k;
                    } else if (c == '0') {
                        sb.append("0");
                    } else if (c == '?') {
                        sb.append(" ");
                    }
                } else if (c != this.comma.charAt(0)) {
                    if (c == '_') {
                        sb.append(" ");
                        ++i;
                    } else if (c == '[') {
                        int j = fmt.indexOf(93, i);
                        if (j != -1) {
                            this.processSpecial(N, fmt.substring(i + 1, j));
                            i = j;
                        }
                    } else if (c == 'E') {
                        if (i < fmt.length() - 2) {
                            char t1 = fmt.charAt(i + 1);
                            char t2 = fmt.charAt(i + 2);
                            if (!(t1 != '+' && t1 != '-' || t2 != '#' && t2 != '0' && t2 != '?')) {
                                i = this.formatExponent(fmt, N, i + 1);
                                continue;
                            }
                        }
                        sb.append(c);
                    } else {
                        sb.append(c);
                    }
                }
            } else {
                sb.append(c);
            }
            ++i;
        }
        N.setPostMantissa(sb.toString());
    }

    private int formatExponent(String fmt, WmiFormattedNumeric N, int i) {
        N.forceExponentSign(fmt.charAt(i++) == '+');
        int j = WmiNumericFormatter.indexOf(fmt, "E", i);
        if (j == -1) {
            j = fmt.length();
        }
        this.formatExponent(fmt.substring(i, j), N);
        return j;
    }

    private void formatExponent(String fmt, WmiFormattedNumeric N) {
        StringBuffer sb = new StringBuffer();
        String digits = "" + N.getIntegerExponent();
        this.formatLeft(fmt, sb, digits, fmt.length() - 1, N);
        N.setExponentString(sb.reverse().toString());
    }

    private void processSpecial(WmiFormattedNumeric N, String s) {
        if ((s = s.toLowerCase()).equals("red")) {
            N.setRGBColor(this.colors[2]);
        } else if (s.equals("black")) {
            N.setRGBColor(this.colors[0]);
        } else if (s.equals("blue")) {
            N.setRGBColor(this.colors[4]);
        } else if (s.equals("cyan")) {
            N.setRGBColor(this.colors[7]);
        } else if (s.equals("green")) {
            N.setRGBColor(this.colors[3]);
        } else if (s.equals("magenta")) {
            N.setRGBColor(this.colors[6]);
        } else if (s.equals("white")) {
            N.setRGBColor(this.colors[1]);
        } else if (s.equals("yellow")) {
            N.setRGBColor(this.colors[5]);
        } else if (s.startsWith("color")) {
            int color = 0;
            try {
                Integer.valueOf(s.substring(5)).intValue();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (color > 7 || color < 0) {
                color = 0;
            }
            N.setRGBColor(this.colors[color]);
        } else if (s.startsWith("sep")) {
            if (s.length() > 3) {
                this.displaydot = "" + s.charAt(3);
            }
            if (s.length() > 4) {
                this.displaycomma = "" + s.charAt(4);
            }
        } else if (!(s.startsWith("=") || s.startsWith(">") || s.startsWith("<"))) {
            throw new Error("number format not supported: " + s);
        }
    }

    private int scale(String fmt) {
        int s = 0;
        boolean inquote = false;
        int i = 0;
        while (i < fmt.length()) {
            char c = fmt.charAt(i);
            if (c == '\"') {
                inquote = !inquote;
                ++i;
                continue;
            }
            if (!inquote) {
                if (c == this.comma.charAt(0)) {
                    if (i == fmt.length() - 1) {
                        s -= 3;
                    } else {
                        char tt = fmt.charAt(i + 1);
                        if (tt != '#' && tt != '0' && tt != '?') {
                            s -= 3;
                        }
                    }
                } else if (c == '%') {
                    s += 2;
                }
            }
            ++i;
        }
        return s;
    }

    private boolean hasSeparatingComma(String fmt, int i) {
        boolean inquote = false;
        while (i >= 0) {
            char c = fmt.charAt(i);
            if (c == '\"') {
                inquote = !inquote;
                --i;
                continue;
            }
            if (!inquote && c == this.comma.charAt(0) && i < fmt.length() - 1) {
                char tt = fmt.charAt(i + 1);
                if (tt == '#' || tt == '0' || tt == '?') {
                    return true;
                }
                --i;
                continue;
            }
            --i;
        }
        return false;
    }

    private boolean hasMoreFormatDigits(String fmt, int i) {
        --i;
        while (i >= 0) {
            char c = fmt.charAt(i);
            if (c == '#' || c == '0' || c == '?') {
                return true;
            }
            --i;
        }
        return false;
    }

    private boolean hasMoreZeroFormatDigits(String fmt, int i) {
        --i;
        while (i >= 0) {
            char c = fmt.charAt(i);
            if (c == '0') {
                return true;
            }
            --i;
        }
        return false;
    }

    private void formatLeft(String fmt, WmiFormattedNumeric N, int i) {
        StringBuffer sb = new StringBuffer();
        String lm = N.getPreMantissa();
        this.formatLeft(fmt, sb, lm, i, N);
        N.setPreMantissa(sb.reverse().toString());
    }

    private void formatLeft(String fmt, StringBuffer sb, String digits, int i, WmiFormattedNumeric N) {
        String lm = digits;
        int k = lm.length() - 1;
        boolean markthousands = this.hasSeparatingComma(fmt, i);
        int tcount = 0;
        boolean inquote = false;
        boolean hasdigit = false;
        while (i >= 0) {
            if (i > 0 && fmt.charAt(i - 1) == '_') {
                if (hasdigit && !this.hasMoreFormatDigits(fmt, i)) {
                    while (k >= 0) {
                        sb.append(lm.charAt(k));
                        if (markthousands && k > 0 && ++tcount == 3) {
                            sb.append(this.displaycomma);
                            tcount = 0;
                        }
                        --k;
                    }
                }
                sb.append(" ");
                i -= 2;
                continue;
            }
            char c = fmt.charAt(i);
            if (c == '\"') {
                inquote = !inquote;
                --i;
                continue;
            }
            if (!inquote) {
                if (c == '#' || c == '0' || c == '?') {
                    hasdigit = true;
                    if (k >= 0) {
                        sb.append(lm.charAt(k));
                        if (markthousands && (k > 0 || this.hasMoreZeroFormatDigits(fmt, i)) && ++tcount == 3) {
                            sb.append(this.displaycomma);
                            tcount = 0;
                        }
                        --k;
                    } else if (c == '0') {
                        sb.append("0");
                        if (markthousands && this.hasMoreFormatDigits(fmt, i) && ++tcount == 3) {
                            sb.append(this.displaycomma);
                            tcount = 0;
                        }
                    } else if (c == '?') {
                        sb.append(" ");
                        if (++tcount == 3) {
                            tcount = 0;
                        }
                    }
                } else if (c != this.comma.charAt(0)) {
                    if (c == ']') {
                        int j = i - 1;
                        while (j >= 0 && fmt.charAt(j) != '[') {
                            --j;
                        }
                        if (j != -1) {
                            this.processSpecial(N, fmt.substring(j + 1, i));
                            i = j;
                        }
                    } else {
                        if (hasdigit && !this.hasMoreFormatDigits(fmt, i)) {
                            while (k >= 0) {
                                sb.append(lm.charAt(k));
                                if (markthousands && k > 0 && ++tcount == 3) {
                                    sb.append(this.displaycomma);
                                    tcount = 0;
                                }
                                --k;
                            }
                        }
                        sb.append(c);
                    }
                }
            } else {
                if (hasdigit && !this.hasMoreFormatDigits(fmt, i)) {
                    while (k >= 0) {
                        sb.append(lm.charAt(k));
                        if (markthousands && k > 0 && ++tcount == 3) {
                            sb.append(this.displaycomma);
                            tcount = 0;
                        }
                        --k;
                    }
                }
                sb.append(c);
            }
            --i;
        }
        if (hasdigit) {
            while (k >= 0) {
                sb.append(lm.charAt(k));
                if (markthousands && k > 0 && ++tcount == 3) {
                    sb.append(this.displaycomma);
                    tcount = 0;
                }
                --k;
            }
        }
    }

    public WmiFormattedNumeric splitNumeric(Dag n) {
        if (DagUtil.isFloatZero(n) || DagUtil.isZero(n)) {
            WmiFormattedNumeric zero = new WmiFormattedNumeric("0", 0);
            zero.setZero(true);
            return zero;
        }
        if (DagUtil.isFloat(n)) {
            Dag md = n.getChild(0);
            if (DagUtil.isFloatInfinity(n)) {
                WmiFormattedNumeric infty = new WmiFormattedNumeric(true, false);
                if (DagUtil.isNegative(n)) {
                    infty.setSign(-1);
                }
                return infty;
            }
            if (DagUtil.isNameNamed(n.getChild(1), "undefined")) {
                return new WmiFormattedNumeric(false, true);
            }
            String m = md.getData();
            if (m.equals("0")) {
                WmiFormattedNumeric zero = new WmiFormattedNumeric("0", 0);
                zero.setZero(true);
                return zero;
            }
            if (DagUtil.isNegInt(md)) {
                m = "-" + m;
            }
            int e = DagUtil.parseInt(n.getChild(1));
            return new WmiFormattedNumeric(m, e);
        }
        if (DagUtil.isPosInt(n)) {
            return new WmiFormattedNumeric(n.getData(), 0);
        }
        if (DagUtil.isNegInt(n)) {
            return new WmiFormattedNumeric("-" + n.getData(), 0);
        }
        if (DagUtil.isSum(n)) {
            if (DagUtil.isNameNamed(n.getChild(0), "infinity")) {
                WmiFormattedNumeric infty = new WmiFormattedNumeric(true, false);
                if (DagUtil.isNegative(n.getChild(1))) {
                    infty.setSign(-1);
                }
                return infty;
            }
            return new WmiFormattedNumeric(DagBuilder.lPrint(n), 0);
        }
        if (DagUtil.isNameNamed(n, "infinity")) {
            return new WmiFormattedNumeric(true, false);
        }
        if (DagUtil.isNameNamed(n, "undefined")) {
            return new WmiFormattedNumeric(false, true);
        }
        if (DagUtil.isRational(n)) {
            return new WmiFormattedNumeric(n);
        }
        throw new Error("unexpected DAG: " + n);
    }

    public String getFormatter(Dag n, String fmt) {
        return this.getFormatter(n, fmt, null);
    }

    private String getFormatter(Dag n, String fmt, WmiFormattedNumeric N) {
        if (this.hasConditional(fmt)) {
            return this.getConditionalFormatter(n, fmt);
        }
        fmt = DagUtil.isZero(n) || DagUtil.isFloatZero(n) ? this.getZeroFormatter(fmt) : (DagUtil.isNegative(n) ? this.getNegativeFormatter(fmt, N) : this.getPositiveFormatter(fmt));
        return fmt;
    }

    private boolean hasConditional(String fmt) {
        int i = WmiNumericFormatter.indexOf(fmt, "[");
        while (i != -1) {
            char c;
            if (i < fmt.length() - 1 && ((c = fmt.charAt(i + 1)) == '=' || c == '<' || c == '>')) {
                return true;
            }
            i = WmiNumericFormatter.indexOf(fmt, "[", i + 1);
        }
        return false;
    }

    private String getConditionalFormatter(Dag n, String fmt) {
        int[] r;
        int i = 0;
        while ((r = this.getNextFormatter(fmt, i)) != null) {
            String f = fmt.substring(r[0], r[1]);
            i = r[1] + 1;
            String[] c = this.getCondition(f);
            if (c != null && !this.meetsCondition(n, c)) continue;
            return f;
        }
        return "";
    }

    private int[] getNextFormatter(String fmt, int i) {
        if (i >= fmt.length()) {
            return null;
        }
        int j = WmiNumericFormatter.indexOf(fmt, ";", i);
        if (j == -1) {
            j = fmt.length();
        }
        return new int[]{i, j};
    }

    private String[] getCondition(String fmt) {
        int i = WmiNumericFormatter.indexOf(fmt, "[");
        if (i == -1) {
            return null;
        }
        int j = WmiNumericFormatter.indexOf(fmt, "]", i);
        if (j == -1) {
            return null;
        }
        String s = fmt.substring(i + 1, j);
        if (s.length() < 2) {
            return null;
        }
        char c = s.charAt(0);
        if (c != '=' && c != '<' && c != '>') {
            return null;
        }
        String op = "" + (char)c;
        String num = null;
        char c1 = s.charAt(1);
        if (c1 == '=' || c1 == '>') {
            op = String.valueOf(op) + (char)c1;
            num = s.substring(2);
        } else {
            num = s.substring(1);
        }
        return new String[]{op, num.trim()};
    }

    private boolean meetsCondition(Dag n, String[] c) {
        double num = Double.valueOf(c[1]);
        return this.meetsCondition(n, c[0], num);
    }

    private boolean meetsCondition(Dag n, String op, double num) {
        int s = this.compare(n, num);
        if (op.equals("=")) {
            return s == 0;
        }
        if (op.equals(">")) {
            return s == 1;
        }
        if (op.equals("<")) {
            return s == -1;
        }
        if (op.equals(">=")) {
            return s == 0 || s == 1;
        }
        if (op.equals("<=")) {
            return s == 0 || s == -1;
        }
        if (op.equals("<>")) {
            return s != 0;
        }
        return false;
    }

    private int compare(Dag n, double num) {
        String ns = DagBuilder.lPrint(n);
        if (ns.equals("undefined")) {
            return 2;
        }
        if (ns.equals("infinity")) {
            return 1;
        }
        if (ns.equals("-infinity")) {
            return -1;
        }
        BigDecimal N = new BigDecimal(ns);
        return N.compareTo(new BigDecimal(num));
    }

    private String getZeroFormatter(String fmt) {
        int i = WmiNumericFormatter.indexOf(fmt, ";");
        if (i == -1) {
            return fmt;
        }
        int j = WmiNumericFormatter.indexOf(fmt, ";", i + 1);
        if (j == -1) {
            return fmt.substring(0, i);
        }
        return fmt.substring(j + 1);
    }

    private String getNegativeFormatter(String fmt, WmiFormattedNumeric N) {
        int i = WmiNumericFormatter.indexOf(fmt, ";");
        if (i == -1) {
            return fmt;
        }
        int j = WmiNumericFormatter.indexOf(fmt, ";", i + 1);
        if (j == i + 1) {
            return this.getPositiveFormatter(fmt);
        }
        if (N != null) {
            N.setSign(1);
        }
        if (j == -1) {
            return fmt.substring(i + 1);
        }
        return fmt.substring(i + 1, j);
    }

    private String getPositiveFormatter(String fmt) {
        int i = WmiNumericFormatter.indexOf(fmt, ";");
        if (i == -1) {
            return fmt;
        }
        return fmt.substring(0, i);
    }

    private static int indexOf(String s, String c) {
        return WmiNumericFormatter.indexOf(s, c, 0);
    }

    private static int indexOf(String s, String c, int p0) {
        boolean inquote = false;
        char c0 = c.charAt(0);
        int l = c.length();
        int i = p0;
        while (i < s.length()) {
            char ci = s.charAt(i);
            if (ci == '\"') {
                inquote = !inquote;
            } else if (!inquote && ci == c0) {
                if (l == 1) {
                    return i;
                }
                if (i + l <= s.length() && s.substring(i, i + l).equals(c)) {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    public class WmiFormattedNumeric {
        private String premantissa;
        private String postmantissa;
        private int exponent;
        private String xstring;
        private boolean forcedot;
        private boolean isnegative;
        private boolean iszero;
        private float[] color;
        private boolean forcexsign;
        private boolean isinfinity = false;
        private boolean isundefined = false;
        private Dag rational;
        private boolean signforced;

        public WmiFormattedNumeric(boolean infinity, boolean nan) {
            if (nan) {
                this.isundefined = true;
            } else if (infinity) {
                this.isinfinity = true;
            }
            this.premantissa = "";
            this.exponent = 0;
        }

        public void setZero(boolean b) {
            this.iszero = b;
        }

        public WmiFormattedNumeric(String m, int e) {
            int i;
            this.premantissa = m;
            if (!WmiNumericFormatter.this.displaydot.equals(WmiNumericFormatter.this.dot) && (i = m.indexOf(WmiNumericFormatter.this.dot)) != -1) {
                this.premantissa = String.valueOf(m.substring(0, i - 1)) + WmiNumericFormatter.this.displaydot + m.substring(i + 1);
            }
            this.exponent = e;
            this.isnegative = false;
            if (this.premantissa != null && this.premantissa.length() > 0 && this.premantissa.charAt(0) == '-') {
                this.isnegative = true;
                this.premantissa = this.premantissa.substring(1);
            }
            if (this.premantissa.equals("0")) {
                this.premantissa = "";
            }
        }

        public WmiFormattedNumeric(Dag n) {
            this.rational = n;
        }

        public boolean isRational() {
            return this.rational != null;
        }

        public WmiFormattedNumeric approximateRational(int digits) {
            BigDecimal numer = new BigDecimal(DagBuilder.lPrint(this.rational.getChild(0)));
            BigDecimal denom = new BigDecimal(DagBuilder.lPrint(this.rational.getChild(1)));
            BigDecimal v = numer.divide(denom, digits += denom.unscaledValue().bitLength() / 3, 6);
            WmiFormattedNumeric r = new WmiFormattedNumeric(v.unscaledValue().toString(), -v.scale());
            if (this.signforced) {
                r.isnegative = this.isnegative;
            }
            r.color = this.color;
            return r;
        }

        public void setExponentString(String x) {
            this.xstring = x;
        }

        public void forceExponentSign(boolean b) {
            this.forcexsign = b;
        }

        public void setRGBColor(float[] fs) {
            this.color = fs;
        }

        public float[] getRGBColor() {
            return this.color;
        }

        public String getPostMantissa() {
            return this.postmantissa;
        }

        public void setPostMantissa(String m) {
            this.postmantissa = m;
        }

        public String getPreMantissa() {
            return this.premantissa;
        }

        public void setPreMantissa(String m) {
            this.premantissa = m;
        }

        public int getSign() {
            if (this.iszero) {
                return 0;
            }
            if (this.isnegative) {
                return -1;
            }
            return 1;
        }

        public void setSign(int i) {
            this.signforced = true;
            this.isnegative = i == -1;
        }

        public void setForceDot(boolean d) {
            this.forcedot = d;
        }

        public int getIntegerExponent() {
            if (this.iszero) {
                return 0;
            }
            return this.exponent;
        }

        public void setExponent(int exponent) {
            this.exponent = exponent;
        }

        public String getMantissa() {
            String m = this.premantissa;
            if (this.postmantissa != null && this.postmantissa.length() > 0) {
                m = String.valueOf(m) + WmiNumericFormatter.this.displaydot + this.postmantissa;
            }
            return m;
        }

        public String getExponent() {
            if (this.xstring != null && this.iszero) {
                this.xstring = "0";
            }
            if (this.forcexsign && this.xstring.charAt(0) != '-') {
                return "+" + this.xstring;
            }
            return this.xstring;
        }

        public void trim() {
            String m = this.postmantissa;
            int i = m.length() - 1;
            while (i >= 0 && m.charAt(i) == '0') {
                --i;
            }
            this.postmantissa = this.postmantissa.substring(0, i + 1);
        }

        public void roundToDecimals(int i) {
            int d;
            if (this.postmantissa == null || this.postmantissa.length() <= i) {
                return;
            }
            boolean carry = false;
            int n = i;
            while ((d = this.postmantissa.charAt(i) - 48) >= 5) {
                int tst2;
                if (d > 5) {
                    carry = true;
                    break;
                }
                if (++i < this.postmantissa.length()) continue;
                if (n > 0) {
                    i = n - 1;
                    int tst = this.postmantissa.charAt(i) - 48;
                    if (tst / 2 * 2 == tst) break;
                    carry = true;
                    break;
                }
                if (this.premantissa == null || this.premantissa.length() == 0 || (tst2 = this.premantissa.charAt(i = this.premantissa.length() - 1) - 48) / 2 * 2 == tst2) break;
                carry = true;
                break;
            }
            this.postmantissa = this.postmantissa.substring(0, n);
            if (carry) {
                if (n > 0) {
                    int l = this.postmantissa.length();
                    this.postmantissa = this.increment(this.postmantissa);
                    if (this.postmantissa.length() > l) {
                        this.postmantissa = this.postmantissa.substring(1);
                        this.premantissa = this.increment(this.premantissa);
                    }
                } else {
                    this.premantissa = this.increment(this.premantissa);
                }
            }
            this.trim();
        }

        private String increment(String s) {
            if (s == null || s.length() == 0) {
                return "1";
            }
            int i = s.length() - 1;
            StringBuffer sb = new StringBuffer();
            int carry = 1;
            while (i >= 0) {
                int d = s.charAt(i) - 48;
                if ((d += carry) == 10) {
                    sb.append("0");
                    carry = 1;
                } else {
                    sb.append((char)(48 + d));
                    carry = 0;
                }
                --i;
            }
            if (carry == 1) {
                sb.append("1");
            }
            sb.reverse();
            return sb.toString();
        }

        public String getDigits() {
            String m = this.premantissa;
            if (this.postmantissa != null && this.postmantissa.length() > 0) {
                m = String.valueOf(m) + WmiNumericFormatter.this.displaydot + this.postmantissa;
            } else if (this.forcedot) {
                m = String.valueOf(m) + WmiNumericFormatter.this.displaydot;
            }
            return m;
        }

        public void setMantissa(String mantissa) {
            int i = mantissa.indexOf(WmiNumericFormatter.this.displaydot);
            if (i == -1) {
                this.premantissa = mantissa;
                this.postmantissa = null;
            } else {
                this.premantissa = mantissa.substring(0, i);
                this.postmantissa = mantissa.substring(i + 1);
            }
        }

        public void normalize(int x) {
            String mv;
            StringBuffer zeros;
            int q;
            String m;
            if (x == this.exponent) {
                if (this.premantissa == null || this.premantissa.equals("0")) {
                    this.premantissa = "";
                }
                if (this.postmantissa == null) {
                    this.postmantissa = "";
                }
                return;
            }
            int d = this.exponent - x;
            if (d < 0) {
                m = this.premantissa;
                if (m.equals("0")) {
                    m = "";
                }
                if ((q = (d = -d) - m.length()) < 0) {
                    q = 0;
                }
                zeros = new StringBuffer(q);
                int i = 0;
                while (i < q) {
                    zeros.append("0");
                    ++i;
                }
                m = String.valueOf(zeros.toString()) + m;
                mv = m.substring(m.length() - d, m.length());
                this.postmantissa = this.postmantissa != null ? String.valueOf(mv) + this.postmantissa : mv;
                this.premantissa = m.substring(0, m.length() - d);
                if (this.premantissa.equals("0")) {
                    this.premantissa = "";
                }
                if (this.postmantissa == null) {
                    this.postmantissa = "";
                }
            } else {
                if (this.postmantissa == null) {
                    this.postmantissa = "";
                }
                if ((q = d - (m = this.postmantissa).length()) < 0) {
                    q = 0;
                }
                zeros = new StringBuffer(q);
                int i = 0;
                while (i < q) {
                    zeros.append("0");
                    ++i;
                }
                m = String.valueOf(m) + zeros.toString();
                mv = m.substring(0, d);
                this.premantissa = this.premantissa != null ? String.valueOf(this.premantissa) + mv : mv;
                this.postmantissa = m.substring(d);
            }
            this.exponent = x;
            int k = this.postmantissa.length();
            while (k > 0 && this.postmantissa.charAt(k - 1) == '0') {
                --k;
            }
            this.postmantissa = this.postmantissa.substring(0, k);
        }

        private int rem(int a, int m) {
            if (a >= 0) {
                return a % m;
            }
            int r = -a % m;
            if ((r = m - r) >= m) {
                r -= m;
            }
            return r;
        }

        public void normalizeMultiples(int nleft) {
            if (this.iszero) {
                this.normalize(0);
                return;
            }
            int n = this.leftDigits() - 1;
            if (nleft == 0) {
                this.normalize(n + 1);
            } else {
                int l = this.rem(n, nleft);
                this.normalize(n - l);
            }
        }

        public int leftDigits() {
            String m = this.premantissa;
            if (m.equals("0")) {
                m = "";
            }
            int n = m.length() + this.exponent;
            return n;
        }

        public String toString() {
            if (this.isinfinity) {
                if (this.getSign() < 0) {
                    return "-infinity";
                }
                return "infinity";
            }
            if (this.isundefined) {
                return "undefined";
            }
            String r = this.getDigits();
            String x = "" + this.exponent;
            if (this.xstring != null) {
                r = String.valueOf(r) + "E";
                if (this.forcexsign && this.xstring.length() > 0 && this.xstring.charAt(0) != '-' && this.xstring.charAt(0) != '+') {
                    r = String.valueOf(r) + "+";
                }
                r = String.valueOf(r) + this.xstring;
            } else {
                if (this.exponent < 0) {
                    x = "(" + x + ")";
                }
                if (this.exponent != 0) {
                    r = String.valueOf(r) + "*10^" + x;
                }
            }
            if (this.isnegative) {
                r = "-" + r;
            }
            return r;
        }
    }
}

