/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagConstants;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.math.WmiFractionModel;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathModelBuilder;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiNumericModel;
import com.maplesoft.mathdoc.model.math.WmiPrecedenceRules;
import com.maplesoft.mathdoc.model.math.WmiSemanticDagUtil;

public class WmiProductBuilder
implements WmiMathModelBuilder,
WmiMathSemantics {
    public static final String EXPLICIT_MULTIPLICATION_OPERATOR = "&sdot;";
    public static final String PROC_MULTIPLICATION_OPERATOR = "*";
    public static final String IMPLICIT_MULTIPLICATION_OPERATOR = "&InvisibleTimes;";
    private static final String LINEBREAK_CONTEXT_NAME = "product";
    private static final WmiMathSemantics RATIONAL_SEMANTICS = new WmiRationalProductSemantics();

    @Override
    public WmiMathModel createModel(Dag dag, WmiMathDocumentModel docModel, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiInlineMathModel inline;
        int start;
        WmiMathModel model = null;
        WmiMathModel denominator = null;
        int size = dag.getLength();
        int numeratorTerms = 0;
        int denominatorTerms = 0;
        int i = start = dag.getChild(0).getType() == 3 ? 2 : 0;
        while (i < size) {
            Dag power = dag.getChild(i + 1);
            if (power.equals(DagConstants.MINUS_ONE)) {
                ++denominatorTerms;
            } else {
                ++numeratorTerms;
            }
            i += 2;
        }
        boolean mergeLeadingRational = false;
        if (start > 0 && numeratorTerms == 0 && denominatorTerms > 0) {
            mergeLeadingRational = true;
            ++numeratorTerms;
            ++denominatorTerms;
        }
        int narraysize = numeratorTerms > 0 ? numeratorTerms * 2 - 1 : 0;
        int darraysize = denominatorTerms > 0 ? denominatorTerms * 2 - 1 : 0;
        WmiModel[] numeratorKids = new WmiMathModel[narraysize];
        WmiModel[] denominatorKids = new WmiMathModel[darraysize];
        int numeratorPrecedence = 3;
        int denominatorPrecedence = 3;
        int ncount = 0;
        int dcount = 0;
        int precedence = 0;
        if (mergeLeadingRational) {
            Dag rational = dag.getChild(0);
            Dag num = rational.getChild(0);
            Dag den = rational.getChild(1);
            precedence = DagBuilder.getPrecedence(num);
            if (precedence > numeratorPrecedence) {
                numeratorPrecedence = precedence;
            }
            if ((precedence = DagBuilder.getPrecedence(den)) > denominatorPrecedence) {
                denominatorPrecedence = precedence;
            }
            this.addTerm(num, (WmiMathModel[])numeratorKids, docModel, context, 0, false);
            ++ncount;
            this.addTerm(den, (WmiMathModel[])denominatorKids, docModel, context, 0, false);
            ++dcount;
        }
        i = start;
        while (i < size) {
            Dag base = dag.getChild(i);
            Dag power = dag.getChild(i + 1);
            precedence = DagBuilder.getPrecedence(base);
            if (power.equals(DagConstants.MINUS_ONE)) {
                if (precedence > denominatorPrecedence) {
                    denominatorPrecedence = precedence;
                }
                this.addTerm(base, (WmiMathModel[])denominatorKids, docModel, context, dcount, denominatorTerms > 1);
                dcount += dcount == 0 ? 1 : 2;
            } else {
                if (precedence > numeratorPrecedence) {
                    numeratorPrecedence = precedence;
                }
                this.addTerm(base, (WmiMathModel[])numeratorKids, docModel, context, ncount, numeratorTerms > 1);
                ncount += ncount == 0 ? 1 : 2;
            }
            i += 2;
        }
        if (ncount > 1) {
            numeratorPrecedence = 4;
        }
        if (dcount > 1) {
            denominatorPrecedence = 4;
        }
        if (dcount > 0) {
            WmiMathModel top = null;
            try {
                denominator = new WmiInlineMathModel(docModel, denominatorKids);
                denominator.setSemantics(this);
            }
            catch (WmiInvalidModelInitializationException e) {
                WmiErrorLog.log(e);
            }
            if (ncount > 0) {
                top = new WmiInlineMathModel(docModel);
                try {
                    top = new WmiInlineMathModel(docModel, numeratorKids);
                }
                catch (WmiInvalidModelInitializationException e) {
                    WmiErrorLog.log(e);
                }
                top.setSemantics(this);
            } else {
                top = WmiMathFactory.createMathNumericToken(docModel, "1", context);
            }
            if (context.useProcRules()) {
                if (numeratorPrecedence > 4) {
                    top = WmiMathFactory.addBrackets(top, context);
                }
                if (denominatorPrecedence >= 4) {
                    denominator = WmiMathFactory.addBrackets(denominator, context);
                }
            }
            if (context.useProcRules()) {
                model = WmiNumericModel.WmiRationalBuilder.createInlineFraction(docModel, top, denominator, context);
                model.setSemantics(RATIONAL_SEMANTICS);
            } else {
                model = new WmiFractionModel(docModel, top, denominator, context);
                model.setSemantics(RATIONAL_SEMANTICS);
            }
        } else {
            try {
                inline = new WmiInlineMathModel(docModel, numeratorKids);
                inline.setSemantics(this);
                if (numeratorPrecedence > 4) {
                    model = WmiMathFactory.addBrackets(inline, context);
                    model.setSemantics(this);
                } else {
                    model = inline;
                }
            }
            catch (WmiInvalidModelInitializationException e) {
                WmiErrorLog.log(e);
            }
        }
        if (start != 0 && !mergeLeadingRational) {
            inline = null;
            WmiMathModel rational = WmiMathFactory.createMath(docModel, dag.getChild(0), context);
            WmiModel[] farry = new WmiMathModel[]{rational, context.useProcRules() ? WmiMathFactory.createMathOperatorToken(docModel, PROC_MULTIPLICATION_OPERATOR, context) : (rational.getTag() == WmiModelTag.MATH_NUMERIC && model.getTag() == WmiModelTag.MATH_NUMERIC ? WmiMathFactory.createMathOperatorToken(docModel, EXPLICIT_MULTIPLICATION_OPERATOR, context) : WmiMathFactory.createMathOperatorToken(docModel, IMPLICIT_MULTIPLICATION_OPERATOR, context)), model};
            try {
                inline = new WmiInlineMathModel(docModel, farry);
            }
            catch (WmiInvalidModelInitializationException e) {
                WmiErrorLog.log(e);
            }
            model = inline;
            model.setSemantics(this);
        }
        if (context.shouldSubExpressionLabel(model, dag)) {
            model = context.createSubexpressionLabel(model, dag);
        }
        return model;
    }

    private Dag getTestDag(WmiMathModel model) throws WmiNoReadAccessException {
        Dag testDag = model.toDag();
        if (DagUtil.isProd(testDag) && testDag.getLength() == 2) {
            testDag = testDag.getChild(0);
        }
        return testDag;
    }

    public void addTerm(Dag term, WmiMathModel[] modelkids, WmiMathDocumentModel docModel, WmiMathContext context, int position, boolean addBrackets) throws WmiNoWriteAccessException, WmiNoReadAccessException {
        if (position > 0) {
            WmiMathModel child = WmiMathFactory.createMath(docModel, term, context);
            if (addBrackets && WmiPrecedenceRules.areBracketsRequired(term, 4, 0)) {
                child = WmiMathFactory.addBrackets(child, context);
            }
            modelkids[position + 1] = child;
            modelkids[position] = context.useProcRules() ? WmiMathFactory.createMathOperatorToken(docModel, PROC_MULTIPLICATION_OPERATOR, context) : (this.isNumeric(modelkids[position + 1]) ? WmiMathFactory.createMathOperatorToken(docModel, EXPLICIT_MULTIPLICATION_OPERATOR, context) : WmiMathFactory.createMathOperatorToken(docModel, IMPLICIT_MULTIPLICATION_OPERATOR, context));
        } else {
            WmiMathModel child = WmiMathFactory.createMath(docModel, term, context);
            if (addBrackets) {
                int precedence = DagBuilder.getPrecedence(term);
                if (WmiPrecedenceRules.areBracketsRequired(term, 4, 0)) {
                    child = WmiMathFactory.addBrackets(child, context);
                }
            }
            modelkids[position] = child;
        }
    }

    private boolean isNumeric(WmiMathModel m) {
        if (m.getTag() != WmiModelTag.MATH_NUMERIC) {
            return false;
        }
        WmiMathSemantics s = m.getSemantics();
        if (s == null) {
            return true;
        }
        return !(s instanceof WmiNumericModel.WmiComplexBuilder);
    }

    @Override
    public Dag toDag(WmiMathModel model) throws WmiNoReadAccessException {
        Dag dag = null;
        WmiCompositeModel composite = (WmiCompositeModel)((Object)model);
        int size = composite.getChildCount() - WmiModelUtil.getNumEmptyIdentifiers(composite);
        if (size % 2 == 1) {
            int dagLength = size + 1;
            Dag[] children = new Dag[dagLength];
            int i = 0;
            int n = 0;
            while (i < dagLength) {
                WmiMathModel child = (WmiMathModel)composite.getChild(i);
                if (WmiModelUtil.isEmptyIdentifierModel(child)) {
                    --i;
                } else {
                    children[n] = child != null ? child.toDag() : null;
                    children[n + 1] = DagConstants.ONE;
                    n += 2;
                }
                i += 2;
            }
            WmiSemanticDagUtil.fillNullDags(children);
            dag = Dag.createDag(14, children, null, false);
        }
        return dag;
    }

    private static class WmiRationalProductSemantics
    implements WmiMathSemantics {
        private WmiRationalProductSemantics() {
        }

        @Override
        public Dag toDag(WmiMathModel model) throws WmiNoReadAccessException {
            WmiCompositeModel composite = (WmiCompositeModel)((Object)model);
            WmiMathModel numerator = (WmiMathModel)composite.getChild(0);
            WmiMathModel denominator = (WmiMathModel)composite.getChild(1);
            Dag[] children = new Dag[]{numerator.toDag(), DagConstants.ONE, denominator.toDag(), DagConstants.MINUS_ONE};
            WmiSemanticDagUtil.fillNullDags(children);
            return Dag.createDag(14, children, null, false);
        }
    }
}

