/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.math.WmiImpliedSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathModel;

public class WmiSemanticDagUtil {
    public static final Dag ABS_FUNC_NAME = Dag.createDag(8, null, "abs", false);
    public static final Dag COMPOSITION_FUNC_NAME = Dag.createDag(8, null, "@@", false);
    public static final Dag CONJUGATE_FUNC_NAME = Dag.createDag(8, null, "conjugate", false);
    public static final Dag DIFF_FUNC_NAME = Dag.createDag(8, null, "diff", false);
    public static final Dag DOLLAR_SIGN_FUNC_NAME = Dag.createDag(8, null, "$", false);
    public static final Dag EVAL_FUNC_NAME = Dag.createDag(8, null, "eval", false);
    public static final Dag EXP_FUNC_NAME = Dag.createDag(8, null, "exp", false);
    public static final Dag FACTORIAL_FUNC_NAME = Dag.createDag(8, null, "factorial", false);
    public static final Dag PRODUCT_FUNC_NAME = Dag.createDag(8, null, "product", false);
    public static final Dag SUM_FUNC_NAME = Dag.createDag(8, null, "sum", false);
    public static final Dag INTEGRAL_FUNC_NAME = Dag.createDag(8, null, "int", false);
    public static final Dag LIMIT_FUNC_NAME = Dag.createDag(8, null, "limit", false);
    public static final Dag PIECEWISE_FUNC_NAME = Dag.createDag(8, null, "PIECEWISE", false);
    public static final Dag MATRIX_FUNC_NAME = Dag.createDag(8, null, "MATRIX", false);
    public static final Dag VECTOR_FUNC_NAME = Dag.createDag(8, null, "VECTOR", false);
    public static final Dag RTABLE_FUNC_NAME = Dag.createDag(8, null, "RTABLE", false);
    public static final Dag UNIT_FUNC_NAME = Dag.createDag(8, null, "Unit", false);
    public static final Dag CURL_FUNC_NAME = Dag.createDag(8, null, "Curl", false);
    public static final Dag GRADIENT_FUNC_NAME = Dag.createDag(8, null, "Gradient", false);
    public static final Dag DIVERGENCE_FUNC_NAME = Dag.createDag(8, null, "Divergence", false);
    public static final Dag SERIES_FUNC_NAME = Dag.createDag(8, null, "_SERIES", false);
    public static final Dag QUESION_MARK_DAG = Dag.createDag(8, null, "?", false);

    private static Dag assembleFunction(Dag fname, Dag arg) {
        Dag[] functionKids = new Dag[]{fname, arg};
        return Dag.createDag(18, functionKids, null, false);
    }

    public static Dag createFunction(Dag fname, Dag[] args) {
        WmiSemanticDagUtil.fillNullDags(args);
        Dag argExpSeq = Dag.createDag(29, args, null, false);
        return WmiSemanticDagUtil.assembleFunction(fname, argExpSeq);
    }

    public static Dag createFunction(Dag fname, Dag arg1) {
        return WmiSemanticDagUtil.createFunction(fname, new Dag[]{arg1});
    }

    public static Dag createFunction(Dag fname, Dag arg1, Dag arg2) {
        return WmiSemanticDagUtil.createFunction(fname, new Dag[]{arg1, arg2});
    }

    public static Dag createFunction(Dag fname, Dag arg1, Dag arg2, Dag arg3) {
        return WmiSemanticDagUtil.createFunction(fname, new Dag[]{arg1, arg2, arg3});
    }

    public static Dag createFunction(Dag fname, Dag arg1, Dag arg2, Dag arg3, Dag arg4) {
        return WmiSemanticDagUtil.createFunction(fname, new Dag[]{arg1, arg2, arg3, arg4});
    }

    public static Dag createList(Dag[] listArgs) {
        WmiSemanticDagUtil.fillNullDags(listArgs);
        return Dag.createDag(30, listArgs, null, false);
    }

    public static Dag createName(String name) {
        return Dag.createDag(8, null, name, false);
    }

    public static Dag createIntpos(String number) {
        return Dag.createDag(2, null, number.trim(), false);
    }

    public static Dag createEquation(Dag identifier, Dag value) {
        Dag[] equationDagKids = new Dag[]{identifier, value};
        WmiSemanticDagUtil.fillNullDags(equationDagKids);
        return Dag.createDag(20, equationDagKids, null, false);
    }

    public static Dag handleNullDag(Dag dag, WmiMathModel model) throws WmiNoReadAccessException {
        if (dag == null) {
            dag = WmiImpliedSemantics.getDag(model, false);
        }
        return dag;
    }

    public static WmiModel getModelSafely(WmiModel model, int position) throws WmiNoReadAccessException {
        WmiModel answer = null;
        if (model != null && model.isComposite()) {
            answer = ((WmiCompositeModel)model).getChild(position);
        }
        return answer;
    }

    public static void fillNullDags(Dag[] dags) {
        if (dags != null) {
            int i = 0;
            while (i < dags.length) {
                if (dags[i] == null) {
                    dags[i] = QUESION_MARK_DAG;
                }
                ++i;
            }
        }
    }
}

