/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractArrayAttributeSet;
import com.maplesoft.mathdoc.model.WmiAttributeKey;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiIntAttributeKey;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.math.WmiImpliedSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiSubSupModel;
import com.maplesoft.mathdoc.model.math.WmiTwoArgumentMathModel;
import java.util.HashMap;

public class WmiSubscriptModel
extends WmiTwoArgumentMathModel {
    private static final WmiImpliedSemantics IMPLIED_SEMANTICS = new WmiImpliedSemantics();

    public WmiSubscriptModel(WmiMathDocumentModel docModel, WmiModel base, WmiModel subscript, WmiMathContext context) throws WmiNoWriteAccessException {
        super(docModel, base, subscript);
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    public WmiSubscriptModel(WmiMathDocumentModel docModel) {
        super(docModel);
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    @Override
    public WmiModelTag getTag() {
        return WmiModelTag.MATH_SUBSCRIPT;
    }

    @Override
    public Dag toDag() throws WmiNoReadAccessException {
        WmiMathSemantics semantics = this.getSemantics();
        return semantics != null ? semantics.toDag(this) : IMPLIED_SEMANTICS.toDag(this);
    }

    @Override
    public void setAttributes(WmiAttributeSet set) throws WmiNoWriteAccessException {
        if (set instanceof WmiSubscriptAttributeSet) {
            super.setAttributes(set);
        } else {
            WmiErrorLog.log(new Exception("Invalid attribute set"));
        }
    }

    @Override
    protected WmiAttributeSet createCompatibleAttributeSet() {
        return new WmiSubscriptAttributeSet();
    }

    @Override
    public boolean isCrossBoundarySubselectable() {
        return false;
    }

    @Override
    public boolean useScriptSize(WmiModel child) throws WmiNoReadAccessException {
        return this.getChildCount() > 0 ? child != this.getChild(0) : false;
    }

    public static class WmiSubscriptAttributeSet
    extends WmiMathAttributeSet {
        public static final String[] ATTRIBUTES = new String[]{"subscriptshift", "placeholder"};
        public static final WmiAttributeKey[] SUB_KEYS = new WmiAttributeKey[]{new SubscriptShiftKey()};
        public static final WmiAttributeKey[] EXTENDED_KEYS_SUBSCRIPT = WmiAbstractArrayAttributeSet.createExtendedKeySet(WmiMathAttributeSet.getMathKeys(), SUB_KEYS);
        private static HashMap keyMap = null;
        private static HashMap cache = new HashMap();
        protected int subscriptShiftProperty = 0;

        public WmiSubscriptAttributeSet() {
        }

        public WmiSubscriptAttributeSet(WmiSubscriptAttributeSet attributes) {
            super(attributes);
            this.subscriptShiftProperty = attributes.subscriptShiftProperty;
        }

        @Override
        public WmiAttributeSet copyAttributes() {
            return new WmiSubscriptAttributeSet(this);
        }

        public int getSubscriptShift() {
            return this.subscriptShiftProperty;
        }

        @Override
        public void addAttributes(WmiAttributeSet set) {
            super.addAttributes(set);
            if (set instanceof WmiSubscriptAttributeSet) {
                WmiSubscriptAttributeSet source = (WmiSubscriptAttributeSet)set;
                this.subscriptShiftProperty = source.subscriptShiftProperty;
            } else if (set instanceof WmiSubSupModel.WmiSubSupAttributeSet) {
                WmiSubSupModel.WmiSubSupAttributeSet source = (WmiSubSupModel.WmiSubSupAttributeSet)set;
                this.subscriptShiftProperty = source.subscriptShiftProperty;
            }
        }

        @Override
        public boolean equals(Object obj) {
            boolean equals = false;
            if (this == obj) {
                equals = true;
            } else if (super.equals(obj) && obj instanceof WmiSubscriptAttributeSet) {
                WmiSubscriptAttributeSet ref = (WmiSubscriptAttributeSet)obj;
                equals = ref.subscriptShiftProperty == this.subscriptShiftProperty;
            }
            return equals;
        }

        @Override
        public int hashCode() {
            int code = super.hashCode();
            return code ^= this.subscriptShiftProperty;
        }

        @Override
        protected HashMap getKeyMap() {
            return keyMap;
        }

        @Override
        public WmiAttributeKey[] getKeys() {
            return EXTENDED_KEYS_SUBSCRIPT;
        }

        @Override
        protected void setKeyMap(HashMap map) {
            keyMap = map;
        }

        @Override
        public HashMap getCache() {
            return cache;
        }

        public static class SubscriptShiftKey
        extends WmiIntAttributeKey {
            public SubscriptShiftKey() {
                super("subscriptshift", 0);
            }

            @Override
            public int getIntValue(WmiAttributeSet set) {
                return set instanceof WmiSubscriptAttributeSet ? ((WmiSubscriptAttributeSet)set).subscriptShiftProperty : 0;
            }

            @Override
            public void setIntValue(WmiAttributeSet set, int value) {
                if (set instanceof WmiSubscriptAttributeSet) {
                    ((WmiSubscriptAttributeSet)set).subscriptShiftProperty = value;
                }
            }
        }
    }
}

