/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagConstants;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.math.WmiAbstractElisionBuilder;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorModel;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiPrecedenceRules;
import com.maplesoft.mathdoc.model.math.WmiSemanticDagUtil;
import java.util.ArrayList;

public class WmiSumBuilder
extends WmiAbstractElisionBuilder
implements WmiMathSemantics {
    public static final String SINGLE_ELIDED_TERM_MARKER = "term";
    public static final String ELIDED_TERM_MARKER = "terms";
    public static final String PLUS_OPERATOR = "+";
    public static final String MINUS_OPERATOR = "&minus;";
    public static final String PROC_MINUS_OPERATOR = " \u2212 ";
    public static final String UNARY_MINUS_OPERATOR = "&uminus0;";
    public static final String PROC_UNARY_MINUS_OPERATOR = "\u2212";
    private static final String LINEBREAK_CONTEXT_NAME = "sum";
    private static final WmiMathSemantics PLUS_SEMANTICS = new PlusSemantics();
    private static final WmiMathSemantics MINUS_SEMANTICS = new MinusSemantics();
    private static final String PLUS_MINUS_OPERATOR_NAME = "&+-";
    private static final String PLUS_MINUS_OPERATOR_SEMANTICS = "&plusmn;";
    private static final String PLUS_MINUS_OPERATOR_CHAR = "\u00b1";

    @Override
    public WmiMathModel createModel(Dag dag, WmiMathDocumentModel docModel, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        int dagLength;
        WmiMathModel model = null;
        int size = dagLength = dag.getLength();
        boolean useElision = this.isElisionRequired(size / 2);
        int elisionSize = 0;
        if (useElision) {
            elisionSize = size / 2 - this.leftSample - this.rightSample;
            size -= elisionSize;
        }
        WmiModel[] children = new WmiMathModel[size];
        int childCount = 0;
        boolean discardSemantics = false;
        if (size == 2) {
            Dag term = dag.getChild(0);
            Dag scale = dag.getChild(1);
            model = WmiMathFactory.createMath(docModel, term, context);
            if (scale.equals(DagConstants.MINUS_ONE)) {
                boolean bracketed = false;
                if (WmiPrecedenceRules.areBracketsRequired(term, 6, 1)) {
                    model = WmiMathFactory.addBrackets(model, context);
                    bracketed = true;
                }
                children[0] = WmiMathFactory.createMathOperatorToken(docModel, context.useProcRules() ? PROC_UNARY_MINUS_OPERATOR : UNARY_MINUS_OPERATOR, context);
                children[1] = model;
                try {
                    model = new WmiInlineMathModel(docModel, children);
                    model.setSemantics(this);
                }
                catch (WmiInvalidModelInitializationException e) {
                    WmiErrorLog.log(e);
                }
            }
        } else {
            int i = 0;
            while (i < dagLength) {
                Dag term = dag.getChild(i);
                Dag scale = dag.getChild(i + 1);
                WmiMathTokenModel addOp = null;
                if (useElision && i == this.leftSample * 2) {
                    children[childCount++] = WmiMathFactory.createMathOperatorToken(docModel, PLUS_OPERATOR, context);
                    children[childCount++] = this.getElisionMarker(docModel, elisionSize, context);
                    i = dagLength - this.rightSample * 2;
                    if (i == dagLength) break;
                }
                if (i == 0) {
                    if (scale.equals(DagConstants.MINUS_ONE)) {
                        addOp = WmiMathFactory.createMathOperatorToken(docModel, context.useProcRules() ? PROC_UNARY_MINUS_OPERATOR : UNARY_MINUS_OPERATOR, context);
                        addOp.setSemantics(MINUS_SEMANTICS);
                    }
                } else if (scale.equals(DagConstants.ONE)) {
                    addOp = WmiMathFactory.createMathOperatorToken(docModel, PLUS_OPERATOR, context);
                    addOp.setSemantics(PLUS_SEMANTICS);
                } else {
                    addOp = WmiMathFactory.createMathOperatorToken(docModel, context.useProcRules() ? PROC_MINUS_OPERATOR : MINUS_OPERATOR, context);
                    addOp.setSemantics(MINUS_SEMANTICS);
                }
                if (term.getType() == 18) {
                    Dag testTerm;
                    String functionName;
                    Dag nameDag = term.getLength() > 1 ? term.getChild(0) : null;
                    String string = functionName = nameDag != null ? nameDag.getData() : null;
                    if (functionName != null && functionName.equals(PLUS_MINUS_OPERATOR_NAME) && (testTerm = term.getChild(1)) != null && testTerm.getType() == 29 && testTerm.getLength() == 1) {
                        term = testTerm.getChild(0);
                        addOp = new WmiMathOperatorModel(docModel, PLUS_MINUS_OPERATOR_CHAR, PLUS_MINUS_OPERATOR_SEMANTICS, context);
                        discardSemantics = true;
                    }
                }
                int precedenceRule = DagUtil.isNegative(scale) ? 1 : 0;
                WmiMathModel termModel = WmiMathFactory.createMath(docModel, term, context);
                boolean bracketed = false;
                if (WmiPrecedenceRules.areBracketsRequired(term, 6, precedenceRule)) {
                    termModel = WmiMathFactory.addBrackets(termModel, context);
                    bracketed = true;
                }
                if (term.getType() == 16 && !bracketed && termModel instanceof WmiCompositeModel && ((WmiCompositeModel)((Object)termModel)).getChild(0) instanceof WmiMathOperatorModel) {
                    addOp = WmiMathFactory.createMathOperatorToken(docModel, MINUS_OPERATOR, context);
                    addOp.setSemantics(MINUS_SEMANTICS);
                    try {
                        ((WmiCompositeModel)((Object)termModel)).removeChild(0);
                    }
                    catch (WmiModelIndexOutOfBoundsException e) {
                        WmiErrorLog.log(e);
                    }
                }
                if (addOp != null) {
                    children[childCount++] = addOp;
                }
                children[childCount++] = termModel;
                i += 2;
            }
            if (childCount < size) {
                WmiMathModel[] compacted = new WmiMathModel[childCount];
                System.arraycopy(children, 0, compacted, 0, childCount);
                children = compacted;
            }
            try {
                model = new WmiInlineMathModel(docModel, children);
                if (!discardSemantics) {
                    model.setSemantics(this);
                }
            }
            catch (WmiInvalidModelInitializationException e) {
                WmiErrorLog.log(e);
            }
        }
        if (context.shouldSubExpressionLabel(model, dag)) {
            model = context.createSubexpressionLabel(model, dag);
        }
        return model;
    }

    @Override
    public Dag toDag(WmiMathModel model) throws WmiNoReadAccessException {
        WmiCompositeModel inline = (WmiCompositeModel)((Object)model);
        int size = inline.getChildCount();
        Dag dag = null;
        if (size > 0) {
            int start = 0;
            WmiMathModel operator = null;
            WmiMathModel first = (WmiMathModel)inline.getChild(0);
            if (first instanceof WmiMathOperatorModel) {
                operator = first;
                start = 1;
            }
            ArrayList<Dag> children = new ArrayList<Dag>();
            int i = start;
            int n = 0;
            while (i < size) {
                WmiMathModel temp = (WmiMathModel)inline.getChild(i);
                if (WmiModelUtil.isEmptyIdentifierModel(temp)) {
                    --i;
                } else {
                    children.add(n, temp.toDag());
                    children.add(n + 1, operator != null ? operator.toDag() : DagConstants.ONE);
                    if (children.get(n + 1) == null) {
                        children.add(n + 1, DagConstants.ONE);
                    }
                    if (i < size - 1) {
                        operator = (WmiMathModel)inline.getChild(i + 1);
                    }
                    n += 2;
                }
                i += 2;
            }
            Dag[] childrenDags = children.toArray(new Dag[0]);
            WmiSemanticDagUtil.fillNullDags(childrenDags);
            dag = Dag.createDag(16, childrenDags, null, false);
        }
        return dag;
    }

    @Override
    protected String getElisionThresholdProperty() {
        return "elisiontermsthreshold";
    }

    @Override
    protected String getElisionAfterProperty() {
        return "elisiontermsafter";
    }

    @Override
    protected String getElisionBeforeProperty() {
        return "elisiontermsbefore";
    }

    @Override
    protected int getDefaultElideThreshold() {
        return 1000;
    }

    @Override
    public String getSingleElisionMarkerText() {
        return SINGLE_ELIDED_TERM_MARKER;
    }

    @Override
    public String getElisionMarkerText() {
        return ELIDED_TERM_MARKER;
    }

    public static boolean isUnaryMinus(WmiMathModel model) throws WmiNoReadAccessException {
        WmiMathOperatorModel opModel;
        String text;
        boolean result = false;
        if (model instanceof WmiMathOperatorModel && (text = (opModel = (WmiMathOperatorModel)model).getText()) != null && text.equals(UNARY_MINUS_OPERATOR)) {
            result = true;
        }
        return result;
    }

    private static class MinusSemantics
    implements WmiMathSemantics {
        @Override
        public Dag toDag(WmiMathModel model) {
            return DagConstants.MINUS_ONE;
        }
    }

    private static class PlusSemantics
    implements WmiMathSemantics {
        private PlusSemantics() {
        }

        @Override
        public Dag toDag(WmiMathModel model) {
            return DagConstants.ONE;
        }
    }
}

