/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractArrayAttributeSet;
import com.maplesoft.mathdoc.model.WmiAttributeKey;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiIntAttributeKey;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.math.WmiImpliedSemantics;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFencedModel;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiSubSupModel;
import com.maplesoft.mathdoc.model.math.WmiTwoArgumentMathModel;
import java.util.HashMap;

public class WmiSuperscriptModel
extends WmiTwoArgumentMathModel {
    private static final WmiImpliedSemantics IMPLIED_SEMANTICS = new WmiImpliedSemantics();

    public WmiSuperscriptModel(WmiMathDocumentModel docModel, WmiModel base, WmiModel superscript, WmiMathContext context) throws WmiNoWriteAccessException {
        super(docModel, base, superscript);
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    public WmiSuperscriptModel(WmiMathDocumentModel docModel, WmiMathModel[] kids, WmiMathContext context) {
        super(docModel);
        this.children = kids;
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    public WmiSuperscriptModel(WmiMathDocumentModel docModel) {
        super(docModel);
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    @Override
    public WmiModelTag getTag() {
        return WmiModelTag.MATH_SUPERSCRIPT;
    }

    @Override
    public Dag toDag() throws WmiNoReadAccessException {
        WmiMathSemantics semantics = this.getSemantics();
        return semantics != null ? semantics.toDag(this) : IMPLIED_SEMANTICS.toDag(this);
    }

    @Override
    public void setAttributes(WmiAttributeSet set) throws WmiNoWriteAccessException {
        if (set instanceof WmiSuperscriptAttributeSet) {
            super.setAttributes(set);
        } else {
            WmiErrorLog.log(new Exception("Invalid attribute set"));
        }
    }

    @Override
    protected WmiAttributeSet createCompatibleAttributeSet() {
        return new WmiSuperscriptAttributeSet();
    }

    @Override
    public boolean isCrossBoundarySubselectable() {
        return false;
    }

    @Override
    public boolean useScriptSize(WmiModel child) throws WmiNoReadAccessException {
        return this.getChildCount() > 0 ? child != this.getChild(0) : false;
    }

    @Override
    public void replaceChildren(WmiModel[] replacement, int first, int span) throws WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        WmiModel[] rep = replacement;
        if (replacement != null && rep.length > 0 && first == 0 && rep[0] instanceof WmiInlineMathModel) {
            WmiInlineMathModel mdl = (WmiInlineMathModel)rep[0];
            try {
                int numChildren = mdl.getChildCount();
                boolean hasSuperscript = false;
                int i = 0;
                while (i < numChildren) {
                    if (mdl.getChild(i) instanceof WmiSuperscriptModel) {
                        WmiTextModel childTextModel;
                        String text;
                        WmiSuperscriptModel child = (WmiSuperscriptModel)mdl.getChild(i);
                        boolean empty = true;
                        if (child.getChild(0) instanceof WmiTextModel && (text = (childTextModel = (WmiTextModel)child.getChild(0)).getAllText().trim()).length() != 0) {
                            empty = false;
                        }
                        if (child.getChild(1) instanceof WmiTextModel && (text = (childTextModel = (WmiTextModel)child.getChild(0)).getAllText().trim()).length() != 0) {
                            empty = false;
                        }
                        hasSuperscript = !empty;
                        break;
                    }
                    ++i;
                }
                if (hasSuperscript) {
                    try {
                        WmiModel[] children = new WmiModel[]{rep[0]};
                        WmiMathContext context = null;
                        context = children[0].getAttributesForRead() instanceof WmiFontAttributeSet ? new WmiMathContext((WmiFontAttributeSet)children[0].getAttributesForRead()) : new WmiMathContext(new WmiMathAttributeSet());
                        rep[0] = new WmiMathFencedModel(this.getDocument(), children, context);
                    }
                    catch (WmiInvalidModelInitializationException imie) {
                        WmiErrorLog.log(imie);
                    }
                }
            }
            catch (WmiNoReadAccessException e) {
                WmiErrorLog.log(e);
            }
        }
        super.replaceChildren(rep, first, span);
    }

    public static class WmiSuperscriptAttributeSet
    extends WmiMathAttributeSet {
        public static final String[] ATTRIBUTES = new String[]{"superscriptshift"};
        public static final WmiAttributeKey[] SUPER_KEYS = new WmiAttributeKey[]{new SuperscriptKey()};
        public static final WmiAttributeKey[] EXTENDED_KEYS_SUPER = WmiAbstractArrayAttributeSet.createExtendedKeySet(WmiMathAttributeSet.getMathKeys(), SUPER_KEYS);
        private static HashMap keyMap = null;
        private static HashMap cache = new HashMap();
        protected int superscriptShiftProperty = 0;

        public WmiSuperscriptAttributeSet() {
        }

        public WmiSuperscriptAttributeSet(WmiSuperscriptAttributeSet attributes) {
            super(attributes);
            this.superscriptShiftProperty = attributes.superscriptShiftProperty;
        }

        @Override
        public WmiAttributeSet copyAttributes() {
            return new WmiSuperscriptAttributeSet(this);
        }

        @Override
        public void addAttributes(WmiAttributeSet set) {
            super.addAttributes(set);
            if (set instanceof WmiSuperscriptAttributeSet) {
                WmiSuperscriptAttributeSet source = (WmiSuperscriptAttributeSet)set;
                this.superscriptShiftProperty = source.superscriptShiftProperty;
            } else if (set instanceof WmiSubSupModel.WmiSubSupAttributeSet) {
                WmiSubSupModel.WmiSubSupAttributeSet source = (WmiSubSupModel.WmiSubSupAttributeSet)set;
                this.superscriptShiftProperty = source.superscriptShiftProperty;
            }
        }

        public int getSuperscriptShift() {
            return this.superscriptShiftProperty;
        }

        @Override
        public boolean equals(Object obj) {
            boolean equals = false;
            if (this == obj) {
                equals = true;
            } else if (super.equals(obj) && obj instanceof WmiSuperscriptAttributeSet) {
                WmiSuperscriptAttributeSet ref = (WmiSuperscriptAttributeSet)obj;
                equals = ref.superscriptShiftProperty == this.superscriptShiftProperty;
            }
            return equals;
        }

        @Override
        public int hashCode() {
            int code = super.hashCode();
            return code ^= this.superscriptShiftProperty;
        }

        @Override
        protected HashMap getKeyMap() {
            return keyMap;
        }

        @Override
        public WmiAttributeKey[] getKeys() {
            return EXTENDED_KEYS_SUPER;
        }

        @Override
        protected void setKeyMap(HashMap map) {
            keyMap = map;
        }

        @Override
        public HashMap getCache() {
            return cache;
        }

        public static class SuperscriptKey
        extends WmiIntAttributeKey {
            protected SuperscriptKey() {
                super("superscriptshift", 0);
            }

            @Override
            public int getIntValue(WmiAttributeSet set) {
                return set instanceof WmiSuperscriptAttributeSet ? ((WmiSuperscriptAttributeSet)set).superscriptShiftProperty : 0;
            }

            @Override
            public void setIntValue(WmiAttributeSet set, int value) {
                if (set instanceof WmiSuperscriptAttributeSet) {
                    ((WmiSuperscriptAttributeSet)set).superscriptShiftProperty = value;
                }
            }
        }
    }
}

