/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractArrayCompositeMathModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathModelBuilder;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiPrecedenceRules;
import com.maplesoft.mathdoc.model.math.WmiSemanticDagUtil;
import com.maplesoft.mathdoc.model.math.WmiSubscriptModel;

public class WmiTablerefBuilder
implements WmiMathModelBuilder,
WmiMathSemantics {
    public static final int BASE_DAG_INDEX = 0;
    public static final int SUBSCRIPT_DAG_INDEX = 1;
    public static final int BASE_MODEL_INDEX = 0;
    public static final int SUBSCRIPT_MODEL_INDEX = 1;
    public static final int MODULE_SUBSCRIPT_MODEL_INDEX = 2;
    public static final String INLINE_TABLEREF_LEFT_BRACKET = "[";
    public static final String INLINE_TABLEREF_RIGHT_BRACKET = "]";
    private static final String LINEBREAK_CONTEXT_NAME = "tableref";

    @Override
    public WmiMathModel createModel(Dag dag, WmiMathDocumentModel docModel, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        Dag baseDag = dag.getChild(0);
        Dag refDag = dag.getChild(1);
        WmiMathModel base = WmiMathFactory.createMath(docModel, baseDag, context);
        if (WmiPrecedenceRules.areBracketsRequired(baseDag, dag, 0)) {
            base = WmiMathFactory.addBrackets(base, context);
        }
        WmiAbstractArrayCompositeMathModel model = null;
        if (context.useProcRules()) {
            model = new WmiInlineMathModel(docModel);
            WmiModel[] children = new WmiMathModel[]{base, WmiMathFactory.createMathOperatorToken(docModel, INLINE_TABLEREF_LEFT_BRACKET, context), WmiMathFactory.createMath(docModel, refDag, context), WmiMathFactory.createMathOperatorToken(docModel, INLINE_TABLEREF_RIGHT_BRACKET, context)};
            try {
                ((WmiInlineMathModel)model).replaceChildren(children, 0, 0);
            }
            catch (WmiModelIndexOutOfBoundsException e) {
                WmiErrorLog.log(e);
            }
        } else {
            WmiMathModel sub = WmiMathFactory.createMath(docModel, refDag, context);
            model = new WmiSubscriptModel(docModel, base, sub, context);
        }
        model.setSemantics(this);
        return model;
    }

    @Override
    public Dag toDag(WmiMathModel model) throws WmiNoReadAccessException {
        Dag dag = null;
        WmiMathModel base = null;
        WmiMathModel subscript = null;
        if (model instanceof WmiSubscriptModel) {
            WmiSubscriptModel msub = (WmiSubscriptModel)model;
            base = (WmiMathModel)msub.getChild(0);
            subscript = (WmiMathModel)msub.getChild(1);
        } else if (model instanceof WmiInlineMathModel) {
            WmiInlineMathModel math = (WmiInlineMathModel)model;
            base = (WmiMathModel)math.getChild(0);
            subscript = (WmiMathModel)math.getChild(2);
        }
        if (base != null && subscript != null) {
            Dag[] children = new Dag[]{base.toDag(), subscript.toDag()};
            WmiSemanticDagUtil.fillNullDags(children);
            dag = Dag.createDag(10, children, null, false);
        }
        return dag;
    }
}

