/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractArrayAttributeSet;
import com.maplesoft.mathdoc.model.WmiAbstractArrayCompositeMathModel;
import com.maplesoft.mathdoc.model.WmiAbstractMathDeleteHandler;
import com.maplesoft.mathdoc.model.WmiAttributeKey;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiBooleanAttributeKey;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiDeleteHandler;
import com.maplesoft.mathdoc.model.WmiDeleteManager;
import com.maplesoft.mathdoc.model.WmiDeletePlaceholderModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.math.WmiImpliedSemantics;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiOverModel;
import com.maplesoft.mathdoc.model.math.WmiThreeArgumentMathModel;
import com.maplesoft.mathdoc.model.math.WmiUnderModel;
import java.util.HashMap;

public class WmiUnderOverModel
extends WmiThreeArgumentMathModel
implements WmiMathModel {
    public static final String ACCENT = "accent";
    public static final String ACCENT_UNDER = "accentunder";
    private static final WmiImpliedSemantics IMPLIED_SEMANTICS = new WmiImpliedSemantics();

    public WmiUnderOverModel(WmiMathDocumentModel docModel, WmiModel center, WmiModel under, WmiModel over, WmiMathContext context) {
        super(docModel, center, under, over, context);
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    @Override
    public WmiModelTag getTag() {
        return WmiModelTag.MATH_UNDER_OVER;
    }

    @Override
    public void setAttributes(WmiAttributeSet set) throws WmiNoWriteAccessException {
        if (set instanceof WmiUnderOverAttributeSet) {
            super.setAttributes(set);
        } else {
            WmiErrorLog.log(new Exception("Invalid attribute set"));
        }
    }

    @Override
    protected WmiAttributeSet createCompatibleAttributeSet() {
        return new WmiUnderOverAttributeSet();
    }

    @Override
    public boolean isCrossBoundarySubselectable() {
        return false;
    }

    @Override
    public boolean useScriptSize(WmiModel child) throws WmiNoReadAccessException {
        return this.getChildCount() > 0 ? child != this.getChild(0) : false;
    }

    @Override
    public WmiDeleteHandler getDeleteHandler() {
        if (this.deleteHandler == null) {
            this.deleteHandler = new WmiUnderOverDeleteHandler(this);
        }
        return this.deleteHandler;
    }

    public static class WmiUnderOverAttributeSet
    extends WmiMathAttributeSet {
        public static final String[] ATTRIBUTES = new String[]{"accent", "accentunder"};
        public static final WmiAttributeKey[] UNDER_OVER_KEYS = new WmiAttributeKey[]{new UnderKey(), new OverKey()};
        public static final WmiAttributeKey[] EXTENDED_KEYS_UNDEROVER = WmiAbstractArrayAttributeSet.createExtendedKeySet(WmiMathAttributeSet.getMathKeys(), UNDER_OVER_KEYS);
        private static final int ACCENT_HASH_BIT = 128;
        private static final int ACCENT_UNDER_HASH_BIT = 32;
        private static HashMap keyMap = null;
        private static HashMap cache = new HashMap();
        protected boolean accentProperty = false;
        protected boolean accentUnderProperty = false;

        public WmiUnderOverAttributeSet() {
        }

        public WmiUnderOverAttributeSet(WmiUnderOverAttributeSet attributes) {
            super(attributes);
            this.accentProperty = attributes.accentProperty;
            this.accentUnderProperty = attributes.accentUnderProperty;
        }

        @Override
        public WmiAttributeSet copyAttributes() {
            return new WmiUnderOverAttributeSet(this);
        }

        @Override
        public void addAttributes(WmiAttributeSet set) {
            super.addAttributes(set);
            if (set instanceof WmiUnderOverAttributeSet) {
                WmiUnderOverAttributeSet source = (WmiUnderOverAttributeSet)set;
                this.accentUnderProperty = source.accentUnderProperty;
                this.accentProperty = source.accentProperty;
            } else if (set instanceof WmiUnderModel.WmiUnderAttributeSet) {
                WmiUnderModel.WmiUnderAttributeSet source = (WmiUnderModel.WmiUnderAttributeSet)set;
                this.accentUnderProperty = source.accentUnderProperty;
            } else if (set instanceof WmiOverModel.WmiOverAttributeSet) {
                WmiOverModel.WmiOverAttributeSet source = (WmiOverModel.WmiOverAttributeSet)set;
                this.accentProperty = source.accentProperty;
            }
        }

        public void modifyPendingForChanges(WmiModel[] targetChildren, WmiUnderOverAttributeSet modifiedAttrs) {
            this.getAccent();
            modifiedAttrs.getAccent();
            this.getAccentUnder();
            modifiedAttrs.getAccentUnder();
        }

        public boolean getAccentUnder() {
            return this.accentUnderProperty;
        }

        public boolean getAccent() {
            return this.accentProperty;
        }

        @Override
        public boolean equals(Object obj) {
            boolean equals = false;
            if (this == obj) {
                equals = true;
            } else if (super.equals(obj) && obj instanceof WmiUnderOverAttributeSet) {
                WmiUnderOverAttributeSet ref = (WmiUnderOverAttributeSet)obj;
                equals = ref.accentProperty == this.accentProperty && ref.accentUnderProperty == this.accentUnderProperty;
            }
            return equals;
        }

        @Override
        public int hashCode() {
            int code = super.hashCode();
            code ^= this.accentProperty ? 128 : 0;
            return code ^= this.accentUnderProperty ? 32 : 0;
        }

        @Override
        protected HashMap getKeyMap() {
            return keyMap;
        }

        @Override
        public WmiAttributeKey[] getKeys() {
            return EXTENDED_KEYS_UNDEROVER;
        }

        @Override
        protected void setKeyMap(HashMap map) {
            keyMap = map;
        }

        @Override
        public HashMap getCache() {
            return cache;
        }

        public static class OverKey
        extends WmiBooleanAttributeKey {
            public OverKey() {
                super(WmiUnderOverModel.ACCENT, false);
            }

            @Override
            public boolean getBooleanValue(WmiAttributeSet set) {
                return ((WmiUnderOverAttributeSet)set).getAccent();
            }

            @Override
            public void setBooleanValue(WmiAttributeSet set, boolean value) {
                ((WmiUnderOverAttributeSet)set).accentProperty = value;
            }
        }

        public static class UnderKey
        extends WmiBooleanAttributeKey {
            public UnderKey() {
                super(WmiUnderOverModel.ACCENT_UNDER, false);
            }

            @Override
            public boolean getBooleanValue(WmiAttributeSet set) {
                return ((WmiUnderOverAttributeSet)set).getAccentUnder();
            }

            @Override
            public void setBooleanValue(WmiAttributeSet set, boolean value) {
                ((WmiUnderOverAttributeSet)set).accentUnderProperty = value;
            }
        }
    }

    public class WmiUnderOverDeleteHandler
    extends WmiAbstractMathDeleteHandler {
        WmiUnderOverDeleteHandler(WmiUnderOverModel arg) {
            this.model = arg;
        }

        @Override
        protected void processRestructure(WmiDeleteManager manager) throws WmiNoWriteAccessException, WmiNoReadAccessException, WmiModelIndexOutOfBoundsException {
            if (WmiModelUtil.getDeletedChildCount(this.model) > 0) {
                WmiAbstractArrayCompositeMathModel restructured = null;
                WmiCompositeModel myParent = WmiUnderOverModel.this.getParent();
                int index = myParent.indexOf(this.model);
                if (WmiUnderOverModel.this.getChild(0) instanceof WmiDeletePlaceholderModel && WmiUnderOverModel.this.getChild(1) instanceof WmiDeletePlaceholderModel) {
                    restructured = new WmiInlineMathModel(WmiUnderOverModel.this.getDocument());
                    ((WmiCompositeModel)restructured).appendChild(WmiUnderOverModel.this.getChild(2));
                } else if (WmiUnderOverModel.this.getChild(0) instanceof WmiDeletePlaceholderModel && WmiUnderOverModel.this.getChild(2) instanceof WmiDeletePlaceholderModel) {
                    restructured = new WmiInlineMathModel(WmiUnderOverModel.this.getDocument());
                    ((WmiCompositeModel)restructured).appendChild(WmiUnderOverModel.this.getChild(1));
                } else if (WmiUnderOverModel.this.getChild(1) instanceof WmiDeletePlaceholderModel && WmiUnderOverModel.this.getChild(2) instanceof WmiDeletePlaceholderModel) {
                    restructured = new WmiInlineMathModel(WmiUnderOverModel.this.getDocument());
                    ((WmiCompositeModel)restructured).appendChild(WmiUnderOverModel.this.getChild(0));
                } else if (WmiUnderOverModel.this.getChild(0) instanceof WmiDeletePlaceholderModel) {
                    restructured = new WmiInlineMathModel(WmiUnderOverModel.this.getDocument());
                    ((WmiCompositeModel)restructured).appendChild(WmiUnderOverModel.this.getChild(1));
                    ((WmiCompositeModel)restructured).appendChild(WmiUnderOverModel.this.getChild(2));
                } else if (WmiUnderOverModel.this.getChild(1) instanceof WmiDeletePlaceholderModel) {
                    restructured = new WmiOverModel(WmiUnderOverModel.this.getDocument(), WmiUnderOverModel.this.getChild(0), WmiUnderOverModel.this.getChild(2), null);
                } else if (WmiUnderOverModel.this.getChild(2) instanceof WmiDeletePlaceholderModel) {
                    restructured = new WmiUnderModel(WmiUnderOverModel.this.getDocument(), WmiUnderOverModel.this.getChild(0), WmiUnderOverModel.this.getChild(1), null);
                }
                myParent.replaceChild(restructured, index);
            }
        }
    }
}

