/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math.specialfunction;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.math.WmiAbstractMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiSemanticDagUtil;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiAbstractSpecialFunctionBuilder;

public class WmiAbsBuilder
extends WmiAbstractSpecialFunctionBuilder {
    private static final int FUNC_DAG_INDEX = 0;
    public static final String LEFT_ABS_OP = "&verbar;";
    public static final String RIGHT_ABS_OP = "&verbar;";
    private static final WmiMathSemantics ABS_SEMANTICS = new WmiAbsSemantics();

    @Override
    public WmiMathModel createSpecialFunctionModel(WmiMathDocumentModel doc, String funcName, Dag argParent, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathModel model = null;
        if (argParent.getLength() == 1) {
            Dag function = argParent.getChild(0);
            model = WmiMathFactory.createMath(doc, function, context);
            model = WmiMathFactory.addBrackets(model, "&verbar;", "&verbar;", context);
            model.setSemantics(ABS_SEMANTICS);
            WmiAttributeSet attrs = model.getAttributes();
            if (attrs instanceof WmiMathAttributeSet) {
                attrs.addAttribute("Typesetting:-msemantics", "abs");
                model.setAttributes(attrs);
            }
        }
        return model;
    }

    public static class WmiAbsSemantics
    implements WmiMathSemantics {
        private static final int ABS_FUNCTION_ARG_INDEX = 1;
        private static final int BAR_ARG_INDEX = 0;

        @Override
        public Dag toDag(WmiMathModel model) throws WmiNoReadAccessException {
            WmiMathModel args;
            WmiAbstractMathTokenModel barToken;
            WmiCompositeModel composite;
            WmiModel firstBar;
            Dag function = null;
            if (model != null && model.isComposite() && (firstBar = (composite = (WmiCompositeModel)((Object)model)).getChild(0)) instanceof WmiAbstractMathTokenModel && "&verbar;".equals((barToken = (WmiAbstractMathTokenModel)firstBar).getSemanticLabel()) && (args = (WmiMathModel)composite.getChild(1)) != null) {
                function = WmiSemanticDagUtil.createFunction(WmiSemanticDagUtil.ABS_FUNC_NAME, args.toDag());
            }
            function = WmiSemanticDagUtil.handleNullDag(function, model);
            return function;
        }
    }
}

