/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math.specialfunction;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractArrayCompositeMathModel;
import com.maplesoft.mathdoc.model.WmiAbstractArrayCompositeModel;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorModel;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathSpaceModel;
import com.maplesoft.mathdoc.model.math.WmiMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiPrecedenceRules;
import com.maplesoft.mathdoc.model.math.WmiSemanticDagUtil;
import com.maplesoft.mathdoc.model.math.WmiUnderModel;
import com.maplesoft.mathdoc.model.math.WmiUnderOverModel;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiAbstractSpecialFunctionBuilder;

public abstract class WmiCentralGlyphBuilder
extends WmiAbstractSpecialFunctionBuilder {
    private static final int FUNCTION_ARGUMENT_DAG_INDEX = 0;
    private static final int EVAL_ARGUMENT_DAG_INDEX = 1;
    private static final int LHS_DAG_INDEX = 0;
    private static final int RHS_DAG_INDEX = 1;
    private static final int FROM_DAG_INDEX = 0;
    private static final int TO_DAG_INDEX = 1;
    public static final boolean INERT = true;
    public static final boolean NONINERT = false;
    private boolean isInert;

    public WmiCentralGlyphBuilder() {
        this(false);
    }

    public WmiCentralGlyphBuilder(boolean state) {
        this.isInert = state;
    }

    @Override
    public WmiMathModel createSpecialFunctionModel(WmiMathDocumentModel doc, String funcName, Dag argParent, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiInlineMathModel model = new WmiInlineMathModel(doc);
        WmiAbstractArrayCompositeModel composite = model;
        WmiMathSpaceModel spacer = new WmiMathSpaceModel(doc);
        spacer.addAttribute("width", "5");
        if (argParent.getLength() == 1) {
            WmiMathModel center = this.buildCentralOperator(doc, context);
            WmiMathModel func = WmiMathFactory.createMath(doc, argParent.getChild(0), context);
            composite.appendChild(center);
            composite.appendChild(spacer);
            composite.appendChild(func);
        } else {
            WmiMathModel underOver = this.buildUnderOver(doc, argParent, context);
            Dag funcDag = argParent.getChild(0);
            WmiMathModel functionModel = WmiMathFactory.createMath(doc, funcDag, context);
            functionModel = this.addBracketsIfRequired(funcDag, functionModel, context);
            composite.appendChild(underOver);
            composite.appendChild(spacer);
            composite.appendChild(functionModel);
        }
        WmiMathSemantics semantics = this.getSemantics();
        if (semantics != null) {
            model.setSemantics(semantics);
        }
        return model;
    }

    private WmiMathModel addBracketsIfRequired(Dag funcDag, WmiMathModel funcModel, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        if (WmiPrecedenceRules.areBracketsRequired(funcDag, this.getPrecedence(), 1)) {
            funcModel = WmiMathFactory.addBrackets(funcModel, context);
        }
        return funcModel;
    }

    protected int getPrecedence() {
        return 20;
    }

    @Override
    public boolean shouldBeUsed(Dag dag, WmiMathContext context) {
        Dag arguments;
        boolean useTemplate = super.shouldBeUsed(dag, context);
        if (useTemplate && (arguments = dag.getChild(1)).getLength() > 0 && arguments.getLength() < 3) {
            if (arguments.getLength() == 1) {
                useTemplate = true;
            } else {
                Dag eval = arguments.getChild(1);
                int evalType = eval.getType();
                if (evalType == 20) {
                    Dag range = eval.getChild(1);
                    if (range.getType() == 35) {
                        useTemplate = range.getChild(0).getType() <= 19 && range.getChild(1).getType() <= 19;
                    }
                } else {
                    useTemplate = evalType == 8;
                }
            }
        }
        return useTemplate;
    }

    protected WmiMathModel buildCentralOperator(WmiMathDocumentModel doc, WmiMathContext context) throws WmiNoWriteAccessException, WmiNoReadAccessException {
        WmiMathTokenModel center = WmiMathFactory.createMathOperatorToken(doc, this.getOperatorString(), context);
        if (this.isInert) {
            this.inertize((WmiMathOperatorModel)center);
        }
        return center;
    }

    protected WmiMathModel buildUnderOver(WmiMathDocumentModel doc, Dag argParent, WmiMathContext context) throws WmiNoWriteAccessException, WmiNoReadAccessException {
        WmiAbstractArrayCompositeMathModel model = null;
        WmiMathModel center = this.buildCentralOperator(doc, context);
        Dag eval = argParent.getChild(1);
        if (eval.getType() == 20) {
            Dag var = eval.getChild(0);
            Dag rhs = eval.getChild(1);
            if (rhs.getType() == 35) {
                WmiMathModel under = this.buildUnder(doc, var, rhs.getChild(0), context);
                WmiMathModel over = WmiMathFactory.createMath(doc, rhs.getChild(1), context);
                model = new WmiUnderOverModel(doc, center, under, over, context);
            } else {
                WmiMathModel under = this.buildUnder(doc, var, rhs, context);
                model = new WmiUnderModel(doc, center, under, context);
            }
        } else if (eval.getType() == 8) {
            WmiMathModel under = WmiMathFactory.createMath(doc, eval, context);
            model = new WmiUnderModel(doc, center, under, context);
        }
        return model;
    }

    public WmiMathModel buildUnder(WmiMathDocumentModel doc, Dag var, Dag from, WmiMathContext context) throws WmiNoWriteAccessException, WmiNoReadAccessException {
        WmiInlineMathModel model = new WmiInlineMathModel(doc);
        WmiAbstractArrayCompositeModel composite = model;
        WmiMathModel varMod = WmiMathFactory.createMath(doc, var, context);
        composite.appendChild(varMod);
        composite.appendChild(WmiMathFactory.createMathOperatorToken(doc, "=", context));
        WmiMathModel fromMod = WmiMathFactory.createMath(doc, from, context);
        composite.appendChild(fromMod);
        return model;
    }

    protected abstract String getOperatorString();

    protected abstract WmiMathSemantics getSemantics();

    private static abstract class LargeOperatorSemantics
    implements WmiMathSemantics {
        private static final int LARGE_OP_OPERATOR_INDEX = 0;
        private static final int LARGE_OP_ARGUMENT_INDEX = 2;
        private static final int OVERUNDER_EQUALITY_INDEX = 1;
        private static final int OVERUNDER_UPPER_RANGE_INDEX = 2;
        private static final int EQUALITY_IDENTIFIER_INDEX = 0;
        private static final int EQUALITY_VALUE_INDEX = 2;
        private static final int UNDER_IDENTIFIER_INDEX = 1;

        private LargeOperatorSemantics() {
        }

        @Override
        public Dag toDag(WmiMathModel model) throws WmiNoReadAccessException {
            Dag function = null;
            if (model != null && model.isComposite()) {
                WmiCompositeModel comp = (WmiCompositeModel)((Object)model);
                int operationOffset = 0;
                WmiMathModel temp = (WmiMathModel)comp.getChild(operationOffset + 0);
                while (temp instanceof WmiMathSpaceModel || WmiModelUtil.isEmptyIdentifierModel(temp)) {
                    temp = (WmiMathModel)comp.getChild(++operationOffset + 0);
                }
                int argumentOffset = operationOffset;
                temp = (WmiMathModel)comp.getChild(argumentOffset + 2);
                while (temp instanceof WmiMathSpaceModel || WmiModelUtil.isEmptyIdentifierModel(temp)) {
                    temp = (WmiMathModel)comp.getChild(++argumentOffset + 2);
                }
                WmiMathModel operatorModel = (WmiMathModel)comp.getChild(0 + operationOffset);
                WmiMathModel argumentModel = (WmiMathModel)comp.getChild(2 + argumentOffset);
                if (operatorModel != null && argumentModel != null) {
                    Dag argumentDag = argumentModel.toDag();
                    Dag rangeOrVarDag = null;
                    WmiModelTag opTag = operatorModel.getTag();
                    if (opTag != WmiModelTag.MATH_OPERATOR) {
                        if (opTag == WmiModelTag.MATH_UNDER) {
                            rangeOrVarDag = this.createVarOrExprDag(operatorModel);
                        } else if (opTag == WmiModelTag.MATH_UNDER_OVER) {
                            rangeOrVarDag = this.createRangeDag(operatorModel);
                        }
                    }
                    Dag functionName = this.getFunctionName();
                    function = rangeOrVarDag != null ? WmiSemanticDagUtil.createFunction(functionName, argumentDag, rangeOrVarDag) : WmiSemanticDagUtil.createFunction(functionName, argumentDag);
                }
            }
            function = WmiSemanticDagUtil.handleNullDag(function, model);
            return function;
        }

        private Dag createVarOrExprDag(WmiMathModel under) throws WmiNoReadAccessException {
            Dag answer = null;
            WmiCompositeModel comp = (WmiCompositeModel)((Object)under);
            WmiMathModel id = (WmiMathModel)comp.getChild(1);
            if (id != null) {
                if (id.isComposite()) {
                    WmiCompositeModel compId = (WmiCompositeModel)((Object)id);
                    WmiMathModel identifier = (WmiMathModel)compId.getChild(0);
                    WmiMathModel expr = (WmiMathModel)compId.getChild(2);
                    if (identifier != null && expr != null) {
                        answer = WmiSemanticDagUtil.createEquation(identifier.toDag(), expr.toDag());
                    }
                } else {
                    answer = id.toDag();
                }
            }
            return answer;
        }

        private Dag createRangeDag(WmiMathModel overUnder) throws WmiNoReadAccessException {
            WmiCompositeModel compOverUnder = (WmiCompositeModel)((Object)overUnder);
            WmiCompositeModel lowerRangeEquation = (WmiCompositeModel)compOverUnder.getChild(1);
            WmiMathModel var = (WmiMathModel)lowerRangeEquation.getChild(0);
            WmiMathModel lowerRange = (WmiMathModel)lowerRangeEquation.getChild(2);
            WmiMathModel upperRange = (WmiMathModel)compOverUnder.getChild(2);
            Dag identifierDag = var.toDag();
            Dag[] rangeDagKids = new Dag[]{lowerRange.toDag(), upperRange.toDag()};
            WmiSemanticDagUtil.fillNullDags(rangeDagKids);
            Dag rangeDag = Dag.createDag(35, rangeDagKids, null, false);
            return WmiSemanticDagUtil.createEquation(identifierDag, rangeDag);
        }

        protected abstract Dag getFunctionName();
    }

    public static class ProductBuilder
    extends WmiCentralGlyphBuilder {
        public static final String PRODUCT_PI_OPERATOR = "&Product;";
        private static final WmiMathSemantics PRODUCT_SEMANTICS = new ProductOperatorSemantics();

        public ProductBuilder() {
        }

        public ProductBuilder(boolean state) {
            super(state);
        }

        @Override
        public String getOperatorString() {
            return PRODUCT_PI_OPERATOR;
        }

        @Override
        protected WmiMathSemantics getSemantics() {
            return PRODUCT_SEMANTICS;
        }

        @Override
        protected int getPrecedence() {
            return 4;
        }
    }

    private static class ProductOperatorSemantics
    extends LargeOperatorSemantics {
        private ProductOperatorSemantics() {
        }

        @Override
        protected Dag getFunctionName() {
            return WmiSemanticDagUtil.PRODUCT_FUNC_NAME;
        }
    }

    public static class SumBuilder
    extends WmiCentralGlyphBuilder {
        public static final String SUM_SIGMA_OPERATOR = "&Sum;";
        private static final WmiMathSemantics SUM_SEMANTICS = new SumOperatorSemantics();

        public SumBuilder() {
        }

        public SumBuilder(boolean state) {
            super(state);
        }

        @Override
        public String getOperatorString() {
            return SUM_SIGMA_OPERATOR;
        }

        @Override
        protected WmiMathSemantics getSemantics() {
            return SUM_SEMANTICS;
        }

        @Override
        protected int getPrecedence() {
            return 6;
        }
    }

    public static class SumOperatorSemantics
    extends LargeOperatorSemantics {
        @Override
        protected Dag getFunctionName() {
            return WmiSemanticDagUtil.SUM_FUNC_NAME;
        }
    }
}

