/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math.specialfunction;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiPrecedenceRules;
import com.maplesoft.mathdoc.model.math.WmiSemanticDagUtil;
import com.maplesoft.mathdoc.model.math.WmiSuperscriptModel;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiAbstractSpecialFunctionBuilder;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiInfixNotationBuilder;

public class WmiCompositionBuilder
extends WmiAbstractSpecialFunctionBuilder {
    private static final int BASE_INDEX = 0;
    private static final int POWER_INDEX = 1;
    private static final WmiMathSemantics COMP_SEMANTICS = new WmiCompositionSemantics();

    @Override
    public WmiMathModel createSpecialFunctionModel(WmiMathDocumentModel doc, String funcName, Dag argParent, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiInvalidModelInitializationException {
        WmiMathModel model = null;
        if (!context.useProcRules()) {
            Dag base = argParent.getChild(0);
            Dag power = argParent.getChild(1);
            WmiMathModel baseModel = WmiMathFactory.createMath(doc, base, context);
            if (WmiPrecedenceRules.areBracketsRequired(base, 1, 0)) {
                baseModel = WmiMathFactory.addBrackets(baseModel, context);
            }
            WmiMathModel powerModel = WmiMathFactory.createMath(doc, power, context);
            powerModel = WmiMathFactory.addBrackets(powerModel, context);
            model = new WmiSuperscriptModel(doc, baseModel, powerModel, context);
            model.setSemantics(COMP_SEMANTICS);
        } else {
            WmiInfixNotationBuilder builder = new WmiInfixNotationBuilder(funcName, 2, 2, 2, false, 1);
            model = builder.createSpecialFunctionModel(doc, funcName, argParent, context);
        }
        return model;
    }

    @Override
    public boolean shouldBeUsed(Dag dag, WmiMathContext context) {
        boolean shouldBeUsed = dag.getLength() > 1 && dag.getChild(1) != null;
        Dag args = dag.getChild(1);
        int argLength = args.getLength();
        return shouldBeUsed && args != null && argLength == 2;
    }

    public static class WmiCompositionSemantics
    implements WmiMathSemantics {
        private static final int COMP_FUNCTION_INDEX = 0;
        private static final int COMP_APPLICATION_INDEX = 1;

        @Override
        public Dag toDag(WmiMathModel model) throws WmiNoReadAccessException {
            Dag function = null;
            if (model != null && model.isComposite()) {
                WmiCompositeModel comp = (WmiCompositeModel)((Object)model);
                WmiMathModel functionName = (WmiMathModel)comp.getChild(0);
                WmiMathModel applications = (WmiMathModel)comp.getChild(1);
                if (functionName != null && applications != null) {
                    function = WmiSemanticDagUtil.createFunction(WmiSemanticDagUtil.COMPOSITION_FUNC_NAME, functionName.toDag(), applications.toDag());
                }
            }
            function = WmiSemanticDagUtil.handleNullDag(function, model);
            return function;
        }
    }
}

