/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math.specialfunction;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.math.WmiFractionModel;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorModel;
import com.maplesoft.mathdoc.model.math.WmiMathPhantomModel;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathSpaceModel;
import com.maplesoft.mathdoc.model.math.WmiMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiPrecedenceRules;
import com.maplesoft.mathdoc.model.math.WmiSemanticDagUtil;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiAbstractSpecialFunctionBuilder;

public class WmiEvalBuilder
extends WmiAbstractSpecialFunctionBuilder {
    private static final int FUNCTION_DAG_INDEX = 0;
    private static final int EVAL_POINT_DAG_INDEX = 1;
    public static final boolean INERT = true;
    public static final boolean NONINERT = false;
    private boolean isInert;
    private static final WmiMathSemantics EVAL_SEMANTICS = new WmiEvalSemantics();

    public WmiEvalBuilder() {
        this(false);
    }

    public WmiEvalBuilder(boolean state) {
        this.isInert = state;
    }

    @Override
    public WmiMathModel createSpecialFunctionModel(WmiMathDocumentModel doc, String funcName, Dag argParent, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiInvalidModelInitializationException {
        WmiInlineMathModel model = null;
        Dag function = argParent.getChild(0);
        Dag eqArg = argParent.getChild(1);
        Dag[] eqns = null;
        if (eqArg.getType() == 36) {
            Dag listContainer = eqArg;
            Dag firstSetChild = eqArg.getChild(0);
            if (firstSetChild != null && firstSetChild.getType() == 29) {
                listContainer = firstSetChild;
            }
            int numChildEqDags = 0;
            int length = listContainer.getLength();
            int i = 0;
            while (i < length) {
                if (listContainer.getChild(i).getType() == 20) {
                    ++numChildEqDags;
                }
                ++i;
            }
            eqns = new Dag[numChildEqDags];
            int index = 0;
            int i2 = 0;
            while (i2 < length) {
                Dag child = listContainer.getChild(i2);
                if (child.getType() == 20) {
                    eqns[index] = child;
                    ++index;
                }
                ++i2;
            }
        } else if (eqArg.getType() == 20) {
            eqns = new Dag[]{eqArg};
        }
        if (eqns != null) {
            int numEqns = eqns.length;
            WmiModel[] vars = new WmiMathModel[numEqns * 2 - 1];
            int i = 0;
            while (i < numEqns - 1) {
                vars[i * 2] = WmiMathFactory.createMath(doc, eqns[i], context);
                vars[i * 2 + 1] = WmiMathFactory.createMathOperatorToken(doc, ",", context);
                ++i;
            }
            vars[vars.length - 1] = WmiMathFactory.createMath(doc, eqns[eqns.length - 1], context);
            WmiInlineMathModel varLine = new WmiInlineMathModel(doc, vars);
            WmiMathModel functionModel = WmiMathFactory.createMath(doc, function, context);
            if (WmiPrecedenceRules.areBracketsRequired(DagBuilder.getPrecedence(function), 3, 0)) {
                functionModel = WmiMathFactory.addBrackets(functionModel, context);
            }
            WmiMathTokenModel evalBar = WmiMathFactory.createMathOperatorToken(doc, "&verbar;", context);
            if (this.isInert) {
                this.inertize((WmiMathOperatorModel)evalBar);
            }
            WmiMathPhantomModel leftSpacer = new WmiMathPhantomModel(doc, varLine);
            leftSpacer.addAttribute("constraints", "height-only");
            WmiFractionModel over = new WmiFractionModel(doc, functionModel, leftSpacer, context);
            over.addAttribute("linethickness", "0");
            functionModel = WmiMathFactory.createMath(doc, function, context);
            if (WmiPrecedenceRules.areBracketsRequired(DagBuilder.getPrecedence(function), 3, 0)) {
                functionModel = WmiMathFactory.addBrackets(functionModel, context);
            }
            WmiMathPhantomModel rightSpacer = new WmiMathPhantomModel(doc, functionModel);
            rightSpacer.addAttribute("constraints", "height-only");
            WmiFractionModel under = new WmiFractionModel(doc, rightSpacer, varLine, context);
            under.addAttribute("linethickness", "0");
            WmiModel[] inlineKids = new WmiMathModel[5];
            inlineKids[0] = over;
            inlineKids[1] = new WmiMathSpaceModel(doc);
            inlineKids[1].addAttribute("width", "0.3 em");
            inlineKids[2] = evalBar;
            inlineKids[3] = new WmiMathSpaceModel(doc);
            inlineKids[3].addAttribute("width", "0.1 em");
            inlineKids[4] = under;
            model = new WmiInlineMathModel(doc, inlineKids);
            model.setSemantics(EVAL_SEMANTICS);
        }
        return model;
    }

    @Override
    public boolean shouldBeUsed(Dag dag, WmiMathContext context) {
        boolean shouldBeUsed = super.shouldBeUsed(dag, context);
        Dag args = dag.getChild(1);
        return shouldBeUsed && args != null && args.getLength() == 2 && (args.getChild(1).getType() == 36 || args.getChild(1).getType() == 20);
    }

    public static class WmiEvalSemantics
    implements WmiMathSemantics {
        private static final int EVAL_ARG_FRAC_INDEX = 0;
        private static final int EVAL_POINT_FRAC_INDEX = 4;
        private static final int ARG_FRAC_ARG_INDEX = 0;
        private static final int POINT_FRAC_POINT_LIST_INDEX = 1;

        @Override
        public Dag toDag(WmiMathModel model) throws WmiNoReadAccessException {
            Dag function = null;
            if (model != null && model.isComposite()) {
                WmiCompositeModel comp = (WmiCompositeModel)((Object)model);
                WmiModel argFrac = comp.getChild(0);
                WmiModel pointFrac = comp.getChild(4);
                if (argFrac != null && argFrac.isComposite() && pointFrac != null && pointFrac.isComposite()) {
                    WmiMathModel arg = (WmiMathModel)((WmiCompositeModel)argFrac).getChild(0);
                    WmiModel pointsModel = ((WmiCompositeModel)pointFrac).getChild(1);
                    if (pointsModel != null && pointsModel.isComposite() && arg != null) {
                        WmiCompositeModel points = (WmiCompositeModel)pointsModel;
                        int evalPoints = points.getChildCount() / 2 + 1;
                        Dag[] evalArgKids = new Dag[2];
                        Dag[] setArgKids = new Dag[evalPoints];
                        evalArgKids[0] = arg.toDag();
                        int j = 0;
                        int i = 0;
                        while (i < points.getChildCount()) {
                            WmiMathModel evalPoint = (WmiMathModel)points.getChild(i);
                            if (evalPoint != null) {
                                setArgKids[j] = evalPoint.toDag();
                            }
                            i += 2;
                            ++j;
                        }
                        Dag expSeq = Dag.createDag(29, setArgKids, null, false);
                        evalArgKids[1] = Dag.createDag(36, new Dag[]{expSeq}, null, false);
                        function = WmiSemanticDagUtil.createFunction(WmiSemanticDagUtil.EVAL_FUNC_NAME, evalArgKids);
                    }
                }
            }
            function = WmiSemanticDagUtil.handleNullDag(function, model);
            return function;
        }
    }
}

