/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math.specialfunction;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagConstants;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiSemanticDagUtil;
import com.maplesoft.mathdoc.model.math.WmiSuperscriptModel;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiAbstractSpecialFunctionBuilder;

public class WmiExpBuilder
extends WmiAbstractSpecialFunctionBuilder {
    private static final int EXP_TERM_INDEX = 0;
    private static final String EXP_OPERATOR = "&ExponentialE;";
    private static final WmiMathSemantics EXP_SEMANTICS = new WmiExpSemantics();

    @Override
    public WmiMathModel createSpecialFunctionModel(WmiMathDocumentModel doc, String funcName, Dag argParent, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        Dag termDag = argParent.getChild(0);
        WmiMathTokenModel eModel = WmiMathFactory.createMathOperatorToken(doc, EXP_OPERATOR, context);
        WmiMathModel model = null;
        if (!DagUtil.isOne(termDag)) {
            WmiMathModel term = WmiMathFactory.createMath(doc, termDag, context);
            model = new WmiSuperscriptModel(doc, eModel, term, context);
        } else {
            model = eModel;
        }
        model.setSemantics(EXP_SEMANTICS);
        return model;
    }

    @Override
    public boolean shouldBeUsed(Dag dag, WmiMathContext context) {
        boolean useTemplate = super.shouldBeUsed(dag, context);
        useTemplate = useTemplate && dag.getChild(1) != null && dag.getChild(1).getLength() == 1 && dag.getChild(1).getChild(0) != null;
        return useTemplate;
    }

    public static class WmiExpSemantics
    implements WmiMathSemantics {
        private static final int EXP_ARG_INDEX = 1;

        @Override
        public Dag toDag(WmiMathModel model) throws WmiNoReadAccessException {
            Dag arg = DagConstants.ONE;
            if (model != null && model.isComposite()) {
                WmiCompositeModel comp = (WmiCompositeModel)((Object)model);
                WmiMathModel expArg = (WmiMathModel)comp.getChild(1);
                arg = expArg.toDag();
            }
            return WmiSemanticDagUtil.createFunction(WmiSemanticDagUtil.EXP_FUNC_NAME, arg);
        }
    }
}

