/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math.specialfunction;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathSpaceModel;
import com.maplesoft.mathdoc.model.math.WmiPrecedenceRules;
import com.maplesoft.mathdoc.model.math.WmiSemanticDagUtil;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiAbstractSpecialFunctionBuilder;
import java.util.ArrayList;

public class WmiInfixNotationBuilder
extends WmiAbstractSpecialFunctionBuilder {
    public static final String INTERSECT_FUNCTION_NAME = "intersect";
    public static final String IN_FUNCTION_NAME = "in";
    public static final String MINUS_FUNCTION_NAME = "minus";
    public static final String UNION_FUNCTION_NAME = "union";
    public static final String SUBSET_FUNCTION_NAME = "subset";
    public static final String EXPR_SEQ_OPERATOR = "$";
    public static final String COMPOSITION_OPERATOR = "@";
    public static final String DOT_PRODUCT_OPERATOR = ".";
    public static final String MOD_OPERATOR = "mod";
    public static final String ELEMENT_OF_OPERATOR = "\u2208";
    public static final String INTERSECT_OPERATOR = "\u2229";
    public static final String UNION_OPERATOR = "\u222a";
    public static final String SUBSET_OPERATOR = "\u2286";
    public static final String SET_MINUS_OPERATOR = "\u2216";
    public static final String PLUS_MINUS_NAME = "&+-";
    public static final String PLUS_MINUS_SEMANTICS = "&plusmn;";
    public static final String PLUS_MINUS_OPERATOR = "\u00b1";
    private int minArgumentSize;
    private int maxArgumentSize;
    private int precedence;
    private String opString;
    private boolean addMSpacePadding;
    private int precedenceRule;

    public WmiInfixNotationBuilder(String op, int minSize, int maxSize, boolean pad) {
        this(op, 2, minSize, maxSize, pad);
    }

    public WmiInfixNotationBuilder(String op, int precedence, int minSize, int maxSize, boolean pad) {
        this.minArgumentSize = minSize;
        this.maxArgumentSize = maxSize;
        this.precedence = precedence;
        this.addMSpacePadding = pad;
        this.opString = op;
        this.precedenceRule = 0;
    }

    public WmiInfixNotationBuilder(String op, int precedence, int minSize, int maxSize, boolean pad, int precedenceRule) {
        this(op, precedence, minSize, maxSize, pad);
        this.precedenceRule = precedenceRule;
    }

    @Override
    public WmiMathModel createSpecialFunctionModel(WmiMathDocumentModel doc, String funcName, Dag argParent, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiInvalidModelInitializationException {
        int argLength = argParent.getLength();
        boolean pad = this.addMSpacePadding;
        int childLength = pad ? (argLength - 1) * 4 + 1 : argLength * 2 - 1;
        WmiModel[] infixKids = new WmiMathModel[childLength];
        Dag firstChild = argParent.getChild(0);
        infixKids[0] = this.createAndBracketChild(doc, firstChild, context);
        int insertIndex = 1;
        int i = 1;
        while (i < argLength) {
            Dag child = argParent.getChild(i);
            if (pad) {
                infixKids[insertIndex] = new WmiMathSpaceModel(doc);
                infixKids[insertIndex++].addAttribute("width", "0.5em");
            }
            infixKids[insertIndex++] = context.useProcRules() ? WmiMathFactory.createMathOperatorToken(doc, funcName, context) : WmiMathFactory.createMathOperatorToken(doc, this.opString, context);
            if (pad) {
                infixKids[insertIndex] = new WmiMathSpaceModel(doc);
                infixKids[insertIndex++].addAttribute("width", "0.5em");
            }
            infixKids[insertIndex++] = this.createAndBracketChild(doc, child, context);
            ++i;
        }
        WmiInlineMathModel model = new WmiInlineMathModel(doc, infixKids);
        model.setSemantics(new WmiInfixNotationSemantics(funcName));
        return model;
    }

    private WmiMathModel createAndBracketChild(WmiMathDocumentModel doc, Dag child, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathModel model = WmiMathFactory.createMath(doc, child, context);
        if (WmiPrecedenceRules.areBracketsRequired(child, this.precedence, this.precedenceRule)) {
            model = WmiMathFactory.addBrackets(model, context);
        }
        return model;
    }

    @Override
    public boolean shouldBeUsed(Dag dag, WmiMathContext context) {
        boolean useTemplate = dag.getLength() > 1 && dag.getChild(1) != null;
        Dag arguments = dag.getChild(1);
        int argLength = arguments.getLength();
        return useTemplate && argLength >= this.minArgumentSize && argLength <= this.maxArgumentSize;
    }

    private class WmiInfixNotationSemantics
    implements WmiMathSemantics {
        private final String functionName;

        public WmiInfixNotationSemantics(String function) {
            this.functionName = function;
        }

        @Override
        public Dag toDag(WmiMathModel model) throws WmiNoReadAccessException {
            Dag function = null;
            if (model != null && model.isComposite()) {
                WmiCompositeModel composite = (WmiCompositeModel)((Object)model);
                ArrayList<Dag> args = new ArrayList<Dag>();
                int i = 0;
                while (i < composite.getChildCount()) {
                    WmiMathModel arg = (WmiMathModel)composite.getChild(i);
                    if (!(arg == null || arg instanceof WmiTextModel && WmiInfixNotationBuilder.this.opString.equals(((WmiTextModel)((Object)arg)).getText()))) {
                        args.add(arg.toDag());
                    }
                    ++i;
                }
                if (args.size() <= WmiInfixNotationBuilder.this.maxArgumentSize && args.size() >= WmiInfixNotationBuilder.this.minArgumentSize) {
                    Dag name = WmiSemanticDagUtil.createName(this.functionName);
                    Dag[] argDags = args.toArray(new Dag[0]);
                    function = WmiSemanticDagUtil.createFunction(name, argDags);
                }
            }
            function = WmiSemanticDagUtil.handleNullDag(function, model);
            return function;
        }
    }
}

