/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math.specialfunction;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorModel;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathSpaceModel;
import com.maplesoft.mathdoc.model.math.WmiMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiPrecedenceRules;
import com.maplesoft.mathdoc.model.math.WmiSemanticDagUtil;
import com.maplesoft.mathdoc.model.math.WmiSuperscriptModel;
import com.maplesoft.mathdoc.model.math.WmiUnderModel;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiAbstractSpecialFunctionBuilder;

public class WmiLimitBuilder
extends WmiAbstractSpecialFunctionBuilder {
    private static final int FUNCTION_INDEX = 0;
    private static final int EQN_INDEX = 1;
    private static final int DIRECTION_INDEX = 2;
    private static final int LHS_INDEX = 0;
    private static final int RHS_INDEX = 1;
    private static final int LIMIT_SIZE = 2;
    private static final int LIMIT_WITH_DIRECTION_SIZE = 3;
    private static final String DIRECTION_RIGHT = "right";
    private static final String DIRECTION_LEFT = "left";
    private static final String DIRECTION_REAL = "real";
    private static final String DIRECTION_COMPLEX = "complex";
    private static final String LIMIT_RIGHT_OPERATOR = "+";
    private static final String LIMIT_LEFT_OPERATOR = "&uminus0;";
    private static final String LIMIT_REAL_OPERATOR = ", real";
    private static final String LIMIT_COMPLEX_OPERATOR = ", complex";
    private static final String LIMIT_ARROW_OPERATOR = "\u2192";
    public static final String LIMIT_OPERATOR = "lim";
    private static final WmiMathSemantics LIMIT_SEMANTICS = new WmiLimitSemantics();
    public static final boolean INERT = true;
    public static final boolean NONINERT = false;
    private boolean isInert;

    public WmiLimitBuilder() {
        this(false);
    }

    public WmiLimitBuilder(boolean state) {
        this.isInert = state;
    }

    @Override
    public WmiMathModel createSpecialFunctionModel(WmiMathDocumentModel doc, String funcName, Dag argParent, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiInvalidModelInitializationException {
        WmiMathModel model = null;
        Dag equationDag = argParent.getChild(1);
        Dag leftHandSide = equationDag.getChild(0);
        Dag rightHandSide = equationDag.getChild(1);
        if (rightHandSide.getType() <= 19) {
            String direction;
            WmiMathModel variableModel = WmiMathFactory.createMath(doc, leftHandSide, context);
            WmiMathModel atModel = WmiMathFactory.createMath(doc, rightHandSide, context);
            WmiMathTokenModel directionModel = null;
            boolean raiseDirectionModel = false;
            if (argParent.getLength() == 3 && (direction = argParent.getChild(2).getData()) != null) {
                if (direction.equalsIgnoreCase(DIRECTION_RIGHT)) {
                    directionModel = WmiMathFactory.createMathOperatorToken(doc, LIMIT_RIGHT_OPERATOR, context);
                    raiseDirectionModel = true;
                } else if (direction.equalsIgnoreCase(DIRECTION_LEFT)) {
                    directionModel = WmiMathFactory.createMathOperatorToken(doc, LIMIT_LEFT_OPERATOR, context);
                    raiseDirectionModel = true;
                } else if (direction.equalsIgnoreCase(DIRECTION_REAL)) {
                    directionModel = WmiMathFactory.createMathOperatorToken(doc, LIMIT_REAL_OPERATOR, context);
                } else if (direction.equalsIgnoreCase(DIRECTION_COMPLEX)) {
                    directionModel = WmiMathFactory.createMathOperatorToken(doc, LIMIT_COMPLEX_OPERATOR, context);
                }
            }
            WmiInlineMathModel underLimit = new WmiInlineMathModel(doc);
            underLimit.appendChild(variableModel);
            underLimit.appendChild(WmiMathFactory.createMathOperatorToken(doc, LIMIT_ARROW_OPERATOR, context));
            if (directionModel == null) {
                underLimit.appendChild(atModel);
            } else if (raiseDirectionModel) {
                WmiMathModel[] kids = new WmiMathModel[]{atModel, directionModel};
                WmiSuperscriptModel script = new WmiSuperscriptModel(doc, kids, context);
                atModel.setParent(script);
                directionModel.setParent(script);
                underLimit.appendChild(script);
            } else {
                underLimit.appendChild(atModel);
                underLimit.appendChild(directionModel);
            }
            WmiMathTokenModel limitTitle = WmiMathFactory.createMathOperatorToken(doc, LIMIT_OPERATOR, context);
            if (this.isInert) {
                this.inertize((WmiMathOperatorModel)limitTitle);
            }
            WmiUnderModel limitModel = new WmiUnderModel(doc, limitTitle, underLimit, context);
            limitModel.addAttribute(WmiUnderModel.WmiUnderAttributeSet.ACCENT_KEY, Boolean.FALSE);
            WmiMathModel functionModel = WmiMathFactory.createMath(doc, argParent.getChild(0), context);
            if (WmiPrecedenceRules.areBracketsRequired(argParent.getChild(0), 4, 1)) {
                functionModel = WmiMathFactory.addBrackets(functionModel, context);
            }
            WmiModel[] rowKids = new WmiMathModel[3];
            rowKids[0] = limitModel;
            rowKids[1] = new WmiMathSpaceModel(doc);
            rowKids[1].addAttribute("width", "0.4em");
            rowKids[2] = functionModel;
            model = new WmiInlineMathModel(doc, rowKids);
        }
        if (model != null) {
            model.setSemantics(LIMIT_SEMANTICS);
        }
        return model;
    }

    @Override
    public boolean shouldBeUsed(Dag dag, WmiMathContext context) {
        boolean shouldBeUsed = super.shouldBeUsed(dag, context);
        Dag args = dag.getChild(1);
        int argLength = args.getLength();
        return shouldBeUsed && args != null && argLength >= 2 && argLength <= 3 && args.getChild(1).getType() == 20;
    }

    private static class WmiLimitSemantics
    implements WmiMathSemantics {
        private static final int UNDER_MODEL_INDEX = 0;
        private static final int FUNCTION_MODEL_INDEX = 2;
        private static final int INLINE_MODEL_INDEX_IN_UNDER_MODEL = 1;
        private static final int VARIABLE_MODEL_INDEX_IN_INLINE_MODEL = 0;
        private static final int POINT_MODEL_INDEX_IN_INLINE_MODEL = 2;
        private static final int OPTION_MODEL_INDEX_IN_INLINE_MODEL = 3;

        private WmiLimitSemantics() {
        }

        @Override
        public Dag toDag(WmiMathModel model) throws WmiNoReadAccessException {
            Dag function = null;
            if (model != null && model.isComposite()) {
                WmiModel inlineModel;
                WmiCompositeModel composite = (WmiCompositeModel)((Object)model);
                WmiMathModel operandModel = (WmiMathModel)composite.getChild(2);
                WmiModel underModel = composite.getChild(0);
                if (underModel != null && underModel.isComposite() && operandModel != null && (inlineModel = ((WmiCompositeModel)underModel).getChild(1)) != null && inlineModel.isComposite()) {
                    WmiCompositeModel inline = (WmiCompositeModel)inlineModel;
                    Dag operand = operandModel.toDag();
                    Dag[] eqnArgs = new Dag[2];
                    WmiMathModel variable = (WmiMathModel)inline.getChild(0);
                    WmiMathModel point = (WmiMathModel)inline.getChild(2);
                    if (variable != null && point != null) {
                        WmiMathOperatorModel optionModel;
                        eqnArgs[0] = variable.toDag();
                        eqnArgs[1] = point.toDag();
                        Dag eqn = Dag.createDag(20, eqnArgs, null, false);
                        if (inline.getChild(3) != null && (optionModel = (WmiMathOperatorModel)inline.getChild(3)) instanceof WmiTextModel) {
                            String text = ((WmiTextModel)optionModel).getText();
                            Dag option = null;
                            if (WmiLimitBuilder.LIMIT_REAL_OPERATOR.equals(text)) {
                                option = Dag.createDag(8, null, WmiLimitBuilder.DIRECTION_REAL, false);
                            }
                            if (WmiLimitBuilder.LIMIT_COMPLEX_OPERATOR.equals(text)) {
                                option = Dag.createDag(8, null, WmiLimitBuilder.DIRECTION_COMPLEX, false);
                            }
                            if (WmiLimitBuilder.LIMIT_RIGHT_OPERATOR.equals(text)) {
                                option = Dag.createDag(8, null, WmiLimitBuilder.DIRECTION_RIGHT, false);
                            }
                            if (WmiLimitBuilder.LIMIT_LEFT_OPERATOR.equals(text)) {
                                option = Dag.createDag(8, null, WmiLimitBuilder.DIRECTION_LEFT, false);
                            }
                            if (option != null) {
                                function = WmiSemanticDagUtil.createFunction(WmiSemanticDagUtil.LIMIT_FUNC_NAME, operand, eqn, option);
                            }
                        }
                        if (function == null) {
                            function = WmiSemanticDagUtil.createFunction(WmiSemanticDagUtil.LIMIT_FUNC_NAME, operand, eqn);
                        }
                    }
                }
            }
            function = WmiSemanticDagUtil.handleNullDag(function, model);
            return function;
        }
    }
}

