/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math.specialfunction;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiPrecedenceRules;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiAbstractSpecialFunctionBuilder;

public class WmiModpBuilder
extends WmiAbstractSpecialFunctionBuilder {
    private static final String CONVERT_IN = "ConvertIn";
    private static final int SUM_INDEX = 0;
    private static final int BASE_INDEX = 1;
    private static final int POWER_INDEX = 2;
    private static final String MODP_OPERATOR = " mod ";

    @Override
    public WmiMathModel createSpecialFunctionModel(WmiMathDocumentModel doc, String funcName, Dag argParent, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiInvalidModelInitializationException {
        WmiInlineMathModel model = null;
        Dag convert = argParent.getChild(0);
        if (convert.getType() == 18 && convert.getChild(0).getData().equals(CONVERT_IN)) {
            Dag poly = convert.getChild(1).getChild(0);
            Dag degree = argParent.getChild(1);
            WmiMathModel polyModel = WmiMathFactory.createMath(doc, poly, context);
            if (WmiPrecedenceRules.areBracketsRequired(DagBuilder.getPrecedence(poly), 6, 1)) {
                polyModel = WmiMathFactory.addBrackets(polyModel, context);
            }
            model = new WmiInlineMathModel(doc);
            model.appendChild(polyModel);
            model.appendChild(WmiMathFactory.createMathOperatorToken(doc, MODP_OPERATOR, context));
            model.appendChild(WmiMathFactory.createMath(doc, degree, context));
        }
        return model;
    }

    @Override
    public boolean shouldBeUsed(Dag dag, WmiMathContext context) {
        boolean shouldBeUsed = super.shouldBeUsed(dag, context);
        Dag args = dag.getChild(1);
        return shouldBeUsed && args != null && args.getLength() >= 2;
    }
}

