/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math.specialfunction;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractArrayCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.math.WmiAssignedSemantics;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathTableModel;
import com.maplesoft.mathdoc.model.math.WmiMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiOverModel;
import com.maplesoft.mathdoc.model.math.WmiSubscriptModel;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiAbstractSpecialFunctionBuilder;

public class WmiTableBuilder
extends WmiAbstractSpecialFunctionBuilder {
    private static final int ROW_INDEX = 0;
    private static final String VECTOR_TABLE = "VECTOR";
    private static final String FIELD_OPTION = "field";
    private static final String BASE_VECTOR = "e";
    private static final String OVER_BAR = "_";

    @Override
    public WmiMathModel createSpecialFunctionModel(WmiMathDocumentModel doc, String funcName, Dag argParent, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathModel theModel = null;
        int argLength = argParent.getLength();
        theModel = funcName.toUpperCase().equals(VECTOR_TABLE) ? this.buildVector(doc, argParent.getChild(0), context) : (argLength == 1 ? WmiTableBuilder.buildMatrix(doc, argParent.getChild(0), context) : this.buildBasisVector(doc, argParent, context));
        return theModel;
    }

    @Override
    public boolean shouldBeUsed(Dag dag, WmiMathContext context) {
        boolean useTemplate = super.shouldBeUsed(dag, context);
        Dag argDag = dag.getChild(1);
        int argLength = argDag.getLength();
        useTemplate = argLength == 1 ? argDag.getChild(0) != null && argDag.getChild(0).getType() == 30 : (argLength == 2 || argLength == 3 ? argDag.getChild(0) != null && argDag.getChild(0).getType() == 30 && argDag.getChild(1) != null && argDag.getChild(1).getType() == 30 : false);
        return useTemplate;
    }

    private WmiMathModel buildVector(WmiMathDocumentModel doc, Dag cols, WmiMathContext context) {
        WmiMathModel container = null;
        int numCols = cols.getLength();
        WmiMathTableModel.WmiMathTableRowModel tableRow = new WmiMathTableModel.WmiMathTableRowModel(doc);
        int i = 0;
        while (i < numCols) {
            boolean numeric = false;
            Dag cellDag = cols.getChild(i);
            WmiMathModel tableItem = null;
            try {
                tableItem = WmiMathFactory.createMath(doc, cellDag, context);
                numeric = numeric && DagUtil.isNumeric(cellDag);
                WmiMathTableModel.WmiMathTableDataModel tableCell = new WmiMathTableModel.WmiMathTableDataModel(doc, tableItem);
                tableRow.appendChild(tableCell);
            }
            catch (WmiNoReadAccessException e) {
                WmiErrorLog.log(e);
            }
            catch (WmiNoWriteAccessException e) {
                WmiErrorLog.log(e);
            }
            ++i;
        }
        try {
            WmiMathTableModel matrix = new WmiMathTableModel(doc);
            matrix.appendChild(tableRow);
            container = WmiMathFactory.addBrackets(matrix, "[", "]", context);
        }
        catch (WmiNoWriteAccessException e) {
            WmiErrorLog.log(e);
        }
        return container;
    }

    private WmiMathModel buildBasisVector(WmiMathDocumentModel doc, Dag dag, WmiMathContext context) throws WmiNoWriteAccessException {
        int termsAdded = 0;
        Dag firstTerm = null;
        boolean firstTermIsSimple = true;
        String firstOp = null;
        WmiInlineMathModel model = new WmiInlineMathModel(doc);
        boolean field = false;
        Dag coeff = dag.getChild(0);
        Dag bases = dag.getChild(1);
        Dag term = null;
        if (dag.getLength() == 3 && dag.getChild(2).getData().equals(FIELD_OPTION)) {
            field = true;
        }
        int i = 0;
        while (i < coeff.getLength()) {
            String theOp = "+";
            term = coeff.getChild(i);
            boolean termIsSimple = false;
            if (term.getType() == 30) {
                if ((term = term.getChild(0)).getType() == 29) {
                    term = term.getChild(0);
                }
                boolean bl = termIsSimple = term.getType() == 16 && term.getLength() <= 2 || term.getType() == 2 || term.getType() == 1;
                if (DagUtil.isOne(term) || DagUtil.isMinusOne(term)) {
                    if (DagUtil.isPosInt(term)) {
                        theOp = "+";
                    } else {
                        theOp = i > 0 ? "&minus;" : "&uminus0;";
                        term = DagUtil.negate(term);
                    }
                } else if (!DagUtil.isZero(term) && termIsSimple) {
                    boolean isNegative = false;
                    if (term.getType() == 16) {
                        isNegative = DagUtil.isNegative(term.getChild(1));
                    } else if (term.getType() == 2 || term.getType() == 1) {
                        isNegative = DagUtil.isNegative(term);
                    }
                    if (isNegative) {
                        if (term.getType() == 2 || term.getType() == 1) {
                            term = DagUtil.negate(term);
                        } else {
                            Dag[] kids = new Dag[]{term.getChild(0), DagUtil.negate(term.getChild(1))};
                            term = Dag.createDag(16, kids, null, false);
                        }
                        theOp = i > 0 ? "&minus;" : "&uminus0;";
                    } else if (DagUtil.isNegative(term)) {
                        theOp = i > 0 ? "&minus;" : "&uminus0;";
                        term = DagUtil.negate(term);
                    }
                }
            }
            if (i == 0) {
                firstTerm = term;
                firstTermIsSimple = termIsSimple;
                firstOp = theOp;
            }
            if (!DagUtil.isZero(term)) {
                if (termsAdded > 0 || theOp != "+") {
                    WmiMathTokenModel theOpModel = WmiMathFactory.createMathOperatorToken(doc, theOp, context);
                    model.appendChild(theOpModel);
                }
                boolean buildInBrackets = !termIsSimple;
                WmiMathModel termModel = this.buildTerm(doc, term, bases.getChild(i), context, field, buildInBrackets);
                model.appendChild(termModel);
                ++termsAdded;
            }
            ++i;
        }
        if (termsAdded == 0) {
            if (firstOp != "+") {
                WmiMathTokenModel theOpModel = WmiMathFactory.createMathOperatorToken(doc, firstOp, context);
                model.appendChild(theOpModel);
            }
            boolean buildInBrackets = !firstTermIsSimple;
            WmiMathModel termModel = this.buildTerm(doc, term, bases.getChild(0), context, field, buildInBrackets);
            model.appendChild(termModel);
        }
        return model;
    }

    private WmiMathModel buildTerm(WmiMathDocumentModel doc, Dag termDag, Dag dag, WmiMathContext context, boolean field, boolean buildInBrackets) {
        WmiInlineMathModel model = new WmiInlineMathModel(doc);
        Dag eDag = DagUtil.createNameDag(BASE_VECTOR);
        Dag nameDag = DagUtil.createNameDag(dag.getData());
        try {
            if (termDag != null && !DagUtil.isOne(termDag)) {
                WmiMathModel term = WmiMathFactory.createMath(doc, termDag, context);
                if (buildInBrackets) {
                    term = WmiMathFactory.addBrackets(term, context);
                }
                model.appendChild(term);
            }
            WmiMathModel coordinate = this.buildCoordinate(doc, eDag, nameDag, context, field);
            model.appendChild(coordinate);
        }
        catch (WmiNoReadAccessException e) {
            WmiErrorLog.log(e);
        }
        catch (WmiNoWriteAccessException e) {
            WmiErrorLog.log(e);
        }
        return model;
    }

    private WmiMathModel buildCoordinate(WmiMathDocumentModel doc, Dag eDag, Dag nameDag, WmiMathContext context, boolean field) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathModel base;
        WmiMathModel e = WmiMathFactory.createMath(doc, eDag, context);
        WmiMathModel sub = WmiMathFactory.createMath(doc, nameDag, context);
        if (!field) {
            base = e;
        } else {
            WmiMathTokenModel over = WmiMathFactory.createMathOperatorToken(doc, OVER_BAR, context);
            base = new WmiOverModel(doc, e, over, context);
        }
        WmiSubscriptModel subscript = new WmiSubscriptModel(doc, base, sub, context);
        return subscript;
    }

    public static WmiMathModel buildMatrix(WmiMathDocumentModel doc, Dag rows, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathModel container = null;
        if (WmiTableBuilder.verifySquareListOfLists(rows)) {
            container = new WmiInlineMathModel(doc);
            WmiAbstractArrayCompositeModel composite = container;
            WmiMathTableModel matrix = new WmiMathTableModel(doc);
            boolean isInteger = true;
            int i = 0;
            while (i < rows.getLength()) {
                WmiMathTableModel.WmiMathTableRowModel tableRow = new WmiMathTableModel.WmiMathTableRowModel(doc);
                Dag rowDag = rows.getChild(i);
                int cols = rowDag.getLength();
                if (cols == 0) {
                    WmiMathModel tableItem = WmiMathFactory.createMath(doc, rowDag, context);
                    isInteger = isInteger && DagUtil.isInt(rowDag);
                    WmiMathTableModel.WmiMathTableDataModel tableCell = new WmiMathTableModel.WmiMathTableDataModel(doc, tableItem);
                    tableRow.appendChild(tableCell);
                } else {
                    int k = 0;
                    while (k < cols) {
                        Dag cellDag = rowDag.getChild(k);
                        WmiMathModel tableItem = WmiMathFactory.createMath(doc, cellDag, context);
                        isInteger = isInteger && DagUtil.isInt(cellDag);
                        tableItem.setSemantics(new WmiAssignedSemantics(cellDag));
                        WmiMathTableModel.WmiMathTableDataModel tableCell = new WmiMathTableModel.WmiMathTableDataModel(doc, tableItem);
                        tableRow.appendChild(tableCell);
                        ++k;
                    }
                }
                matrix.appendChild(tableRow);
                ++i;
            }
            composite.appendChild(matrix);
            if (isInteger) {
                matrix.addAttribute("columnalign", "right");
            }
            container = WmiMathFactory.addBrackets(container, "[", "]", context);
        }
        return container;
    }

    private static boolean verifySquareListOfLists(Dag rows) {
        boolean isListOfLists = true;
        int numRows = rows.getLength();
        int numberOfCols = -1;
        int i = numRows - 1;
        while (i > -1 && isListOfLists) {
            Dag row = rows.getChild(i);
            isListOfLists = row.getType() == 30;
            numberOfCols = numberOfCols < 0 ? row.getLength() : numberOfCols;
            isListOfLists = numberOfCols == row.getLength();
            --i;
        }
        return isListOfLists;
    }
}

