/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math.specialfunction;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiSemanticDagUtil;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiAbstractSpecialFunctionBuilder;

public class WmiUnitBuilder
extends WmiAbstractSpecialFunctionBuilder {
    private static final WmiMathSemantics UNIT_SEMANTICS = new WmiUnitSemantics();

    @Override
    public WmiMathModel createSpecialFunctionModel(WmiMathDocumentModel doc, String funcName, Dag argParent, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiInvalidModelInitializationException {
        WmiMathModel model = null;
        Dag renderUnit = argParent.getChild(0);
        if (DagUtil.isList(renderUnit) && renderUnit.getLength() == 1) {
            renderUnit = renderUnit.getChild(0);
        }
        WmiMathModel units = WmiMathFactory.createMath(doc, renderUnit, context);
        model = WmiMathFactory.addBrackets(units, "&lobrk;", "&robrk;", context);
        model.setSemantics(UNIT_SEMANTICS);
        return model;
    }

    @Override
    public boolean shouldBeUsed(Dag dag, WmiMathContext context) {
        boolean shouldBeUsed = super.shouldBeUsed(dag, context);
        Dag args = dag.getChild(1);
        shouldBeUsed = shouldBeUsed && args != null;
        return shouldBeUsed;
    }

    public static class WmiUnitSemantics
    implements WmiMathSemantics {
        private static final int INDEX_OF_UNIT = 1;

        @Override
        public Dag toDag(WmiMathModel model) throws WmiNoReadAccessException {
            WmiCompositeModel composite;
            WmiMathModel unit;
            Dag function = null;
            if (model != null && model.isComposite() && (unit = (WmiMathModel)(composite = (WmiCompositeModel)((Object)model)).getChild(1)) != null) {
                Dag[] unitDag = new Dag[]{unit.toDag()};
                function = WmiSemanticDagUtil.createFunction(WmiSemanticDagUtil.UNIT_FUNC_NAME, WmiSemanticDagUtil.createList(unitDag));
            }
            function = WmiSemanticDagUtil.handleNullDag(function, model);
            return function;
        }
    }
}

