/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.platform;

import com.maplesoft.mathdoc.platform.WmiRolloverHighlightButtonUI;
import com.maplesoft.util.RuntimePlatform;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.plaf.ButtonUI;

public class WmiPaletteButtonUIFactory {
    public static final int DEFAULT_BUTTON_DIMENSION = 26;
    private static final int DEFAULT_ICON_BUTTON_WIDTH = 50;
    private static final Dimension DEFAULT_BUTTON_SIZE = new Dimension(26, 26);

    public static ButtonUI createUI() {
        if (RuntimePlatform.isMac()) {
            return new MacPaletteButtonUI();
        }
        return new WindowsUnixPaletteButtonUI();
    }

    private static void setDefaultSizes(JComponent c, Dimension d) {
        c.setPreferredSize(d);
        c.setMinimumSize(d);
    }

    private WmiPaletteButtonUIFactory() {
    }

    public static class MacPaletteButtonUI
    extends PaletteButtonUI {
        @Override
        public void paint(Graphics g, JComponent c) {
            super.paint(g, c);
        }
    }

    public static class PaletteButtonUI
    extends WmiRolloverHighlightButtonUI {
        @Override
        public void installUI(JComponent c) {
            Icon icon;
            super.installUI(c);
            final AbstractButton b = (AbstractButton)c;
            b.setRolloverEnabled(true);
            b.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            if (RuntimePlatform.isWindows()) {
                b.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        if ((e.getModifiers() & 0x10) != 0) {
                            ButtonModel model = b.getModel();
                            model.setRollover(false);
                        }
                    }
                });
            }
            if ((icon = b.getIcon()) != null) {
                int width = Math.max(50, icon.getIconWidth());
                int height = icon.getIconHeight();
                Dimension d = new Dimension(width, height);
                WmiPaletteButtonUIFactory.setDefaultSizes(b, d);
            } else {
                WmiPaletteButtonUIFactory.setDefaultSizes(b, DEFAULT_BUTTON_SIZE);
            }
        }

        @Override
        protected void paintText(Graphics g, AbstractButton b, Rectangle textRect, String text) {
            String t = b.getText();
            Font font = b.getFont();
            FontMetrics fm = b.getFontMetrics(font);
            int x = (b.getWidth() - fm.stringWidth(t)) / 2;
            int y = b.getHeight() - fm.getMaxDescent() - 2;
            if (font != null && font.getName().equals("ESSTIXTen")) {
                --y;
            }
            g.drawString(text, x, y);
        }

        @Override
        protected void paintContents(Graphics g, AbstractButton b) {
            Icon icon = b.getIcon();
            if (icon != null) {
                int x = (b.getWidth() - icon.getIconWidth()) / 2;
                int y = (b.getHeight() - icon.getIconHeight()) / 2;
                this.paintIcon(g, b, new Rectangle(x, y, b.getWidth(), b.getHeight()));
            } else {
                Color textColor = null;
                textColor = b.isEnabled() ? b.getForeground() : Color.GRAY;
                g.setColor(textColor);
                this.paintText(g, b, null, b.getText());
            }
        }
    }

    public static class WindowsUnixPaletteButtonUI
    extends PaletteButtonUI {
        @Override
        public void paint(Graphics g, JComponent c) {
            Graphics2D g2 = (Graphics2D)g;
            Object hint = g2.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            super.paint(g, c);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, hint);
        }
    }
}

