/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.platform;

import com.maplesoft.mathdoc.util.WmiResourcePackage;
import com.maplesoft.util.PlatformInfo;
import com.maplesoft.util.RuntimePlatform;
import java.io.File;

public class WmiPlatformFileTools {
    private static final String RESOURCES = "com.maplesoft.mathdoc.platform.resources.Platform";
    private static final String propertiesFile;
    private static final String palettesDir;
    private static int nextUnamedFileIndex;
    private static String untitledFileRootName;

    static {
        StringBuffer sb = new StringBuffer();
        sb.append(PlatformInfo.getUserPath());
        if (RuntimePlatform.isWindows()) {
            propertiesFile = String.valueOf(PlatformInfo.getUserPath()) + "Maple" + "10" + ".ini";
            sb.append("Local Settings\\Application Data\\Maple\\");
            sb.append("10");
            sb.append("\\Palettes\\");
        } else if (RuntimePlatform.isMac()) {
            propertiesFile = String.valueOf(PlatformInfo.getUserPath()) + "Library/Preferences/Maple " + "10" + " Preferences";
            sb.append("Library/Preferences/Maple/");
            sb.append("10");
            sb.append("/Palettes/");
        } else {
            propertiesFile = String.valueOf(PlatformInfo.getUserPath()) + ".maple" + "10" + "rc";
            sb.append(".maple/");
            sb.append("10");
            sb.append("/palettes/");
        }
        palettesDir = sb.toString();
        nextUnamedFileIndex = 0;
        untitledFileRootName = null;
    }

    public static final String getPropertiesFilePath() {
        return propertiesFile;
    }

    public static final String getUserPaletteDir() {
        return palettesDir;
    }

    public static final String getNextUnamedWindowTitle() {
        ++nextUnamedFileIndex;
        if (untitledFileRootName == null) {
            WmiResourcePackage p = WmiResourcePackage.getResourcePackage(RESOURCES);
            untitledFileRootName = p.getStringForKey("Untitled_Doc_Name");
        }
        String winTitle = RuntimePlatform.isMac() ? (nextUnamedFileIndex == 1 ? untitledFileRootName : String.valueOf(untitledFileRootName) + " " + nextUnamedFileIndex) : String.valueOf(untitledFileRootName) + " (" + nextUnamedFileIndex + ")";
        return winTitle;
    }

    public static String getDisplayTitle(File fileSpec) {
        String title = new String("");
        title = RuntimePlatform.isMac() ? fileSpec.getName() : fileSpec.getAbsolutePath();
        return title;
    }
}

