/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.platform;

import com.maplesoft.mathdoc.components.WmiComponentUtil;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class WmiRolloverHighlightButtonUI
extends BasicButtonUI {
    protected static final int PAINT_BACKGROUND = 1;
    protected static final int PAINT_BORDER = 2;

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        c.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        ((AbstractButton)c).setRolloverEnabled(true);
    }

    protected Color getPaintingColor(int which, AbstractButton b) {
        Color c = null;
        ButtonModel model = b.getModel();
        if (which == 1) {
            if (model.isPressed()) {
                c = b.getBackground().darker();
            } else if (model.isSelected()) {
                c = Color.WHITE;
            } else if (model.isRollover()) {
                c = b.getBackground().brighter();
            }
        } else if (which == 2) {
            if (model.isPressed()) {
                c = Color.GRAY;
            } else if (model.isSelected()) {
                c = Color.BLUE;
            } else if (model.isRollover()) {
                c = Color.LIGHT_GRAY;
            }
        }
        return c;
    }

    protected void paintBackground(Graphics g, AbstractButton b) {
        Color backgroundColor = this.getPaintingColor(1, b);
        if (b.isOpaque()) {
            g.setColor(b.getBackground());
            g.fillRect(0, 0, b.getWidth(), b.getHeight());
        }
        if (backgroundColor != null) {
            g.setColor(backgroundColor);
            g.fillRoundRect(0, 0, b.getWidth(), b.getHeight(), 2, 2);
        }
    }

    protected void paintBorder(Graphics g, AbstractButton b) {
        Color borderColor = this.getPaintingColor(2, b);
        if (borderColor != null) {
            g.setColor(borderColor);
            g.drawRoundRect(0, 0, b.getWidth() - 1, b.getHeight() - 1, 4, 4);
        }
    }

    protected void paintContents(Graphics g, AbstractButton b) {
        String text;
        Icon icon = null;
        if (!b.isEnabled()) {
            icon = b.getDisabledIcon();
        }
        if (icon == null) {
            icon = b.getIcon();
        }
        if (icon != null) {
            if (b.getModel().isPressed()) {
                icon.paintIcon(b, g, 3, 2);
            } else {
                icon.paintIcon(b, g, 2, 2);
            }
        }
        if ((text = b.getText()) != null) {
            Rectangle textRect = WmiComponentUtil.centerTextInButton(b);
            FontMetrics fm = g.getFontMetrics();
            if (b.isEnabled() || b.isSelected()) {
                g.setColor(b.getForeground());
            } else {
                g.setColor(Color.GRAY);
            }
            BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, -1, textRect.x + this.getTextShiftOffset(), textRect.y + fm.getAscent() + this.getTextShiftOffset());
        }
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        this.paintBackground(g, b);
        this.paintBorder(g, b);
        this.paintContents(g, b);
    }
}

