/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.platform;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.basic.BasicButtonUI;

public class WmiRoundButtonUIFactory {
    public static ButtonUI createUI() {
        return new RoundButtonUI();
    }

    private WmiRoundButtonUIFactory() {
    }

    private static class RoundButtonUI
    extends BasicButtonUI {
        private RoundButtonUI() {
        }

        @Override
        public void installUI(JComponent c) {
            super.installUI(c);
            Dimension d = this.getPreferredSize(c);
            c.setSize(d);
            c.setMaximumSize(d);
            c.setMinimumSize(d);
            c.setPreferredSize(d);
            c.setOpaque(false);
            ((AbstractButton)c).setRolloverEnabled(true);
        }

        @Override
        public void paint(Graphics g, JComponent c) {
            AbstractButton b = (AbstractButton)c;
            int gap = this.getDefaultTextIconGap(b);
            SizeCalculation size = this.calculateSizes(c);
            Color color = c.getBackground();
            ButtonModel model = b.getModel();
            if (model.isPressed()) {
                color = color.darker();
            } else if (model.isRollover()) {
                color = color.brighter();
            } else if (!model.isEnabled()) {
                color = Color.LIGHT_GRAY;
            }
            Graphics2D g2 = (Graphics2D)g;
            g2.setPaint(new GradientPaint(0.0f, -5.0f, Color.WHITE, 0.0f, size.circleSize, color));
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.fillOval(size.circleXOffset, 0, size.circleSize, size.circleSize);
            g2.setStroke(new BasicStroke(2.0f));
            g2.setPaint(new GradientPaint(0.0f, 0.0f, Color.DARK_GRAY, size.circleSize, size.circleSize, Color.WHITE));
            g2.drawOval(size.circleXOffset, 0, size.circleSize, size.circleSize);
            Icon icon = b.getIcon();
            if (icon != null) {
                icon.paintIcon(c, g2, size.circleXOffset + gap, gap);
            }
            g2.setColor(Color.BLACK);
            g2.drawString(b.getText(), size.labelXOffset, size.circleSize + size.labelHeight + gap);
        }

        @Override
        public Dimension getPreferredSize(JComponent c) {
            SizeCalculation size = this.calculateSizes(c);
            return new Dimension(Math.max(size.circleSize, size.labelWidth), size.circleSize + size.labelHeight + this.getDefaultTextIconGap((AbstractButton)c));
        }

        private SizeCalculation calculateSizes(JComponent c) {
            SizeCalculation size = new SizeCalculation();
            String s = ((AbstractButton)c).getText();
            FontMetrics fm = c.getFontMetrics(c.getFont());
            size.labelWidth = fm.stringWidth(s);
            size.labelHeight = fm.getHeight() + fm.getDescent();
            int circleSize = 32;
            Icon icon = ((AbstractButton)c).getIcon();
            if (icon != null) {
                circleSize = Math.max(icon.getIconWidth(), icon.getIconHeight()) + this.getDefaultTextIconGap((AbstractButton)c);
            }
            size.circleSize = circleSize;
            size.circleXOffset = Math.max(0, (size.labelWidth - size.circleSize) / 2);
            size.labelXOffset = Math.max(0, (size.circleSize - size.labelWidth) / 2);
            return size;
        }

        private static class SizeCalculation {
            public int labelWidth;
            public int labelHeight;
            public int circleSize;
            public int circleXOffset;
            public int labelXOffset;

            private SizeCalculation() {
            }
        }
    }
}

