/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.platform;

import com.maplesoft.mathdoc.components.WmiComponentUtil;
import com.maplesoft.mathdoc.platform.WmiRolloverHighlightButtonUI;
import com.maplesoft.util.RuntimePlatform;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class WmiToolBarButtonUIFactory {
    public static ButtonUI createUI() {
        if (RuntimePlatform.isMac()) {
            return new MacToolBarButtonUI();
        }
        return new WindowsUnixToolBarButtonUI();
    }

    private WmiToolBarButtonUIFactory() {
    }

    public static class MacToolBarButtonUI
    extends BasicButtonUI {
        @Override
        public void installUI(JComponent c) {
            super.installUI(c);
            this.installPressedIcon(c);
            c.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            Font font = c.getFont();
            c.setFont(font.deriveFont(10.0f));
        }

        private void installPressedIcon(JComponent c) {
            AbstractButton b = (AbstractButton)c;
            Icon icon = b.getIcon();
            if (icon instanceof ImageIcon) {
                BufferedImage buffy = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
                Graphics2D g2 = buffy.createGraphics();
                g2.drawImage(((ImageIcon)icon).getImage(), 0, 0, null);
                g2.setComposite(AlphaComposite.getInstance(10, 0.5f));
                g2.setColor(Color.BLACK);
                g2.fillRect(0, 0, buffy.getWidth(), buffy.getHeight());
                g2.dispose();
                b.setPressedIcon(new ImageIcon(buffy));
            }
        }

        @Override
        public void paint(Graphics g, JComponent c) {
            String text;
            AbstractButton b = (AbstractButton)c;
            Icon icon = null;
            ButtonModel model = b.getModel();
            if (model.isSelected()) {
                g.setColor(Color.LIGHT_GRAY);
                g.fillRect(0, 0, b.getWidth(), b.getHeight());
            }
            if (model.isPressed()) {
                icon = b.getPressedIcon();
            } else if (!b.isEnabled()) {
                icon = b.getDisabledIcon();
            }
            if (icon == null) {
                icon = b.getIcon();
            }
            if (icon != null) {
                icon.paintIcon(b, g, 1, 1);
            }
            if ((text = b.getText()) != null) {
                Rectangle textRect = WmiComponentUtil.centerTextInButton(b);
                g.setColor(b.getForeground());
                FontMetrics fm = g.getFontMetrics();
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, -1, textRect.x + this.getTextShiftOffset(), textRect.y + fm.getAscent() + this.getTextShiftOffset());
            }
        }
    }

    public static class WindowsUnixToolBarButtonUI
    extends WmiRolloverHighlightButtonUI {
    }
}

