/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.platform.mac;

import com.maplesoft.mathdoc.components.WmiToolBarButton;
import com.maplesoft.mathdoc.controller.WmiCommand;
import com.maplesoft.mathdoc.controller.WmiCommandProxy;
import com.maplesoft.mathdoc.platform.mac.WmiMacNativeUIProxy;
import com.maplesoft.util.ResourceLoader;
import com.maplesoft.util.StringTools;
import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;

public class WmiMacNativeToolbar
extends WmiMacNativeUIProxy {
    public static final int TOOLBAR_TEXT_ONLY = 1;
    public static final int TOOLBAR_ICON_ONLY = 2;
    public static final int TOOLBAR_TEXT_AND_ICON = 3;
    public static final int TOOLBAR_SMALL_ICONS = 4;
    public static final String TOOLBAR_SPACE_ID = "__space";
    public static final String TOOLBAR_FLEXIBLE_SPACE_ID = "__flex_space";
    public static final String TOOLBAR_CUSTOMIZE_ID = "__customize";
    private String id;
    private String[] items;

    public WmiMacNativeToolbar(String id, Component c, String[] commands, boolean visible, int displayState, ToolbarListener listener) {
        super(c);
        this.id = id;
        this.items = commands;
        this.buildToolbar();
        this.addListener(listener);
    }

    private void buildToolbar() {
        int commandCount = this.items.length;
        String[] localizedNames = new String[commandCount];
        String[] localizedTooltips = new String[commandCount];
        byte[][] imageDataArray = new byte[commandCount][];
        byte[] buffy = new byte[2048];
        int i = 0;
        while (i < commandCount) {
            String commandName = this.items[i];
            if (!commandName.equals("-")) {
                WmiCommandProxy command = WmiCommand.getCommandProxy(commandName);
                if (command == null) {
                    System.err.println("command not found:" + commandName);
                } else {
                    int bytesRead = 0;
                    try {
                        String imageResourceBasename = command.getResource(2);
                        String imageResourcePath = String.valueOf(command.getResourceDirectory()) + '/' + WmiToolBarButton.getIconName(imageResourceBasename, 2, -1, true);
                        InputStream is = ResourceLoader.getResourceAsStream(imageResourcePath);
                        while (is.available() > 0 && bytesRead < buffy.length) {
                            bytesRead += is.read(buffy, bytesRead, is.available());
                        }
                        int cfr_ignored_0 = buffy.length;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    if (bytesRead > 0) {
                        imageDataArray[i] = new byte[bytesRead];
                        System.arraycopy(buffy, 0, imageDataArray[i], 0, bytesRead);
                    }
                    localizedNames[i] = command.getResource(11);
                    if (localizedNames[i] == null) {
                        localizedNames[i] = command.getResource(0);
                    }
                    if (localizedNames[i] != null) {
                        localizedNames[i] = StringTools.removeTilde(localizedNames[i]);
                        if (localizedNames[i].endsWith("...")) {
                            localizedNames[i] = localizedNames[i].substring(0, localizedNames[i].length() - 3);
                        }
                    } else {
                        localizedNames[i] = commandName;
                    }
                    localizedTooltips[i] = command.getResource(1);
                }
            }
            ++i;
        }
        this.createNativeToolbar(this.id, this.items, localizedNames, localizedTooltips, imageDataArray);
    }

    private native void createNativeToolbar(String var1, String[] var2, String[] var3, String[] var4, byte[][] var5);

    private native void addListener(ToolbarListener var1);

    public native void setTooltipsEnabled(boolean var1);

    public native void setEnabled(String var1, boolean var2);

    public native void setDisplayState(int var1);

    public native int getDisplayState();

    public native void setVisible(boolean var1);

    public native boolean isVisible();

    public native void setConfiguration(String[] var1);

    public native String[] getConfiguration();

    public static interface ToolbarListener {
        public void actionPerformed(String var1);
    }
}

