/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.util;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import java.util.Arrays;

public abstract class WmiAncestorPath
implements Cloneable,
Comparable {
    protected static final int DEFAULT_CAPACITY = 10;
    protected static final float GROWTH_FACTOR = 1.5f;
    public static final int SELECT_NONE = 0;
    public static final int SELECT_PARTIAL = 1;
    public static final int SELECT_FULL = 2;
    protected int[] path;
    protected int length = 0;

    protected WmiAncestorPath() {
        this.ensureCapacity(10);
    }

    protected WmiAncestorPath(WmiAncestorPath reference) {
        this.length = reference.length;
        this.path = new int[this.length];
        System.arraycopy(reference.path, 0, this.path, 0, this.length);
    }

    private void ensureCapacity(int size) {
        if (this.path == null) {
            this.path = new int[size];
        } else if (this.path.length < size) {
            int newSize = (int)(1.5f * (float)this.path.length);
            if (newSize < size) {
                newSize = size;
            }
            int[] newPath = new int[newSize];
            System.arraycopy(this.path, 0, newPath, 0, this.path.length);
            this.path = newPath;
        }
    }

    public int depth() {
        return this.length;
    }

    public boolean greaterThan(WmiAncestorPath reference) {
        int diff = this.compareTo(reference);
        if (diff == 0 && this.length > reference.depth()) {
            diff = 1;
        }
        return diff > 0;
    }

    public void next() {
        if (this.length > 0) {
            int n = this.length - 1;
            this.path[n] = this.path[n] + 1;
        }
    }

    public void prev() {
        if (this.length > 0) {
            int n = this.length - 1;
            this.path[n] = this.path[n] - 1;
        }
    }

    public int peek(int level) {
        int value = -1;
        if (level >= 0 && level < this.length) {
            value = this.path[level];
        }
        return value;
    }

    public void poke(int level, int value) {
        if (level >= 0 && level < this.length && value >= 0) {
            this.path[level] = value;
        }
    }

    public int pop() {
        int value = this.top();
        --this.length;
        return value;
    }

    public int top() {
        return this.peek(this.length - 1);
    }

    public void push(int index) {
        this.ensureCapacity(this.length + 1);
        this.path[this.length++] = index;
    }

    public int compareTo(Object o) {
        WmiAncestorPath otherPath = (WmiAncestorPath)o;
        int compareDepth = Math.min(this.length, otherPath.length);
        int diff = 0;
        int d = 0;
        while (d < compareDepth && diff == 0) {
            diff = otherPath.peek(d) < 0 ? (this.peek(d) < 0 ? 0 : -1) : (this.peek(d) < 0 ? 1 : this.peek(d) - otherPath.peek(d));
            ++d;
        }
        return diff;
    }

    public boolean equals(Object obj) {
        boolean isEqual = false;
        if (obj instanceof WmiAncestorPath) {
            WmiAncestorPath pathObj = (WmiAncestorPath)obj;
            isEqual = this.depth() == pathObj.depth() && this.compareTo(obj) == 0;
        }
        return isEqual;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("path:[");
        int i = 0;
        while (i < this.length) {
            sb.append(this.path[i]);
            if (i < this.length - 1) {
                sb.append(",");
            }
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    public static WmiAncestorPath commonPath(WmiAncestorPath firstPath, WmiAncestorPath secondPath) {
        WmiAncestorPath parent;
        block6: {
            parent = null;
            try {
                parent = (WmiAncestorPath)firstPath.clone();
                parent.length = 0;
                Arrays.fill(parent.path, 0);
                if (firstPath == null || secondPath == null) break block6;
                WmiAncestorPath first = (WmiAncestorPath)firstPath.clone();
                WmiAncestorPath second = (WmiAncestorPath)secondPath.clone();
                while (first.depth() > second.depth()) {
                    first.pop();
                }
                while (second.depth() > first.depth()) {
                    second.pop();
                }
                int idx = 0;
                while (idx < first.depth()) {
                    if (first.peek(idx) == second.peek(idx)) {
                        parent.push(first.peek(idx));
                        ++idx;
                        continue;
                    }
                    break;
                }
            }
            catch (CloneNotSupportedException e) {
                WmiErrorLog.log(e);
            }
        }
        return parent;
    }
}

