/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.util;

import com.maplesoft.client.BlockingEvaluation;
import com.maplesoft.client.JavaCallbackListener;
import com.maplesoft.client.KernelAdapter;
import com.maplesoft.client.KernelConnection;
import com.maplesoft.client.KernelConnectionEvent;
import com.maplesoft.client.KernelConnectionListener;
import com.maplesoft.client.KernelEvent;
import com.maplesoft.client.KernelInterfacePropertiesChangeAdapter;
import com.maplesoft.client.KernelProxy;
import com.maplesoft.client.SetGetHandler;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.mathdoc.controller.WmiIndexedViewFactory;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiFormatException;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.exception.WmiParseException;
import com.maplesoft.mathdoc.io.WmiImageUtilities;
import com.maplesoft.mathdoc.io.html.WmiHTMLFormatter;
import com.maplesoft.mathdoc.io.mathml.WmiMathMLImportParser;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiMathMLParagraphModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiParagraphModel;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorModel;
import com.maplesoft.mathdoc.model.math.WmiMathWrapperModel;
import com.maplesoft.mathdoc.util.WmiRawFileWriter;
import com.maplesoft.mathdoc.view.WmiCaret;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiParagraphView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiRenderPath;
import com.maplesoft.util.Base64Encoder;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.util.Arrays;
import javax.media.jai.JAI;

public class WmiMathTools {
    private static final int MIN_BREAK_WIDTH = 96;
    private static WmiMathDocumentView docView;

    private WmiMathTools() {
    }

    public static boolean convertMathMLToGIF(String mathml, int breakWidth, String filename) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiParseException, WmiModelIndexOutOfBoundsException, WmiInvalidModelInitializationException, IOException {
        return WmiMathTools.convertMathMLToGIF(mathml, breakWidth, filename, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean convertMathMLToGIF(String mathml, int breakWidth, String filename, boolean disableStretchyOps) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiParseException, WmiModelIndexOutOfBoundsException, WmiInvalidModelInitializationException, IOException {
        boolean success = true;
        WmiMathDocumentModel docModel = new WmiMathDocumentModel();
        Object dotM = null;
        if (disableStretchyOps) {
            WmiMathOperatorModel.disableStretchyOps = true;
        }
        if (!WmiModelLock.writeLock(docModel, true)) return false;
        try {
            try {
                WmiMathMLImportParser parser = new WmiMathMLImportParser();
                parser.parse(new StringReader(mathml), (WmiCompositeModel)docModel, 0);
                WmiMathMLParagraphModel paragraph = (WmiMathMLParagraphModel)docModel.getChild(0);
                if (paragraph == null) return success;
                WmiModel child = paragraph.getChild(0);
                if (!(child instanceof WmiMathWrapperModel)) return success;
                WmiMathWrapperModel wrapper = (WmiMathWrapperModel)child;
                docView = new WmiMathDocumentView(docModel, new WmiIndexedViewFactory());
                WmiRawFileWriter writer = new WmiRawFileWriter(filename);
                WmiMathToolsFormatter formatter = new WmiMathToolsFormatter(docView, 0, disableStretchyOps);
                if (breakWidth < 96) {
                    breakWidth = 96;
                }
                WmiMathToolsFormatter.setMaxWidth(breakWidth);
                formatter.format(writer, wrapper);
                writer.close();
                return success;
            }
            catch (Exception e) {
                e.printStackTrace();
                success = false;
                WmiModelLock.writeUnlock(docModel);
                if (docView != null) {
                    docView.release();
                }
                WmiCaret.cancelTimer();
            }
            return success;
        }
        finally {
            WmiModelLock.writeUnlock(docModel);
            if (docView != null) {
                docView.release();
            }
            WmiCaret.cancelTimer();
        }
    }

    public static BufferedImage convertMathMLToImage(String mathml, int breakWidth) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiParseException, WmiModelIndexOutOfBoundsException, WmiInvalidModelInitializationException, IOException {
        return WmiMathTools.convertMathMLToImage(mathml, breakWidth, false);
    }

    public static BufferedImage convertMathMLToImage(String mathml, int breakWidth, boolean disableStretchyOps) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiParseException, WmiModelIndexOutOfBoundsException, WmiInvalidModelInitializationException, IOException {
        BufferedImage image = null;
        WmiMathDocumentModel docModel = new WmiMathDocumentModel();
        if (disableStretchyOps) {
            WmiMathOperatorModel.disableStretchyOps = true;
        }
        if (WmiModelLock.writeLock(docModel, true)) {
            try {
                WmiModel child;
                WmiMathMLImportParser parser = new WmiMathMLImportParser();
                parser.parse(new StringReader(mathml), (WmiCompositeModel)docModel, 0);
                WmiMathMLParagraphModel paragraph = (WmiMathMLParagraphModel)docModel.getChild(0);
                if (paragraph != null && (child = paragraph.getChild(0)) instanceof WmiMathWrapperModel) {
                    WmiMathWrapperModel wrapper = (WmiMathWrapperModel)child;
                    docView = new WmiMathDocumentView(docModel, new WmiIndexedViewFactory());
                    WmiMathToolsFormatter formatter = new WmiMathToolsFormatter(docView, 2, disableStretchyOps);
                    if (breakWidth < 96) {
                        breakWidth = 96;
                    }
                    WmiMathToolsFormatter.setMaxWidth(breakWidth);
                    formatter.writeMathModel(wrapper);
                    image = formatter.getImage();
                }
            }
            finally {
                WmiModelLock.writeUnlock(docModel);
            }
        }
        return image;
    }

    public static String convertMathMLToTypeMK(String mathml) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiParseException, WmiModelIndexOutOfBoundsException, WmiInvalidModelInitializationException, IOException {
        String result = "";
        WmiMathDocumentModel docModel = new WmiMathDocumentModel();
        if (WmiModelLock.writeLock(docModel, true)) {
            try {
                WmiModel child;
                WmiMathMLImportParser parser = new WmiMathMLImportParser();
                parser.parse(new StringReader(mathml), (WmiCompositeModel)docModel, 0);
                WmiMathMLParagraphModel paragraph = (WmiMathMLParagraphModel)docModel.getChild(0);
                if (paragraph != null && (child = paragraph.getChild(0)) instanceof WmiMathWrapperModel) {
                    WmiMathWrapperModel wrapper = (WmiMathWrapperModel)child;
                    Dag dag = wrapper.toDag();
                    result = DagBuilder.lPrint(dag);
                }
            }
            finally {
                WmiModelLock.writeUnlock(docModel);
            }
        }
        return result;
    }

    public static boolean convertDotMToGIF(String dotM, int breakWidth, String filename) throws IOException, WmiNoReadAccessException, WmiNoWriteAccessException, WmiInvalidModelInitializationException {
        return WmiMathTools.convertDotMToGIF(dotM, breakWidth, filename, false);
    }

    public static boolean convertDotMToGIF(String dotM, int breakWidth, String filename, boolean disableStretchyOps) throws IOException, WmiNoReadAccessException, WmiNoWriteAccessException, WmiInvalidModelInitializationException {
        boolean success = true;
        WmiMathDocumentModel docModel = new WmiMathDocumentModel();
        WmiMathWrapperModel wrapper = new WmiMathWrapperModel(docModel);
        if (disableStretchyOps) {
            WmiMathOperatorModel.disableStretchyOps = true;
        }
        if (WmiModelLock.writeLock(wrapper, true)) {
            try {
                try {
                    wrapper.createMathChildren(dotM);
                    WmiModel[] modelList = new WmiModel[]{wrapper};
                    WmiParagraphModel paragraph = new WmiParagraphModel(docModel, modelList);
                    docView = new WmiMathDocumentView(docModel, new WmiIndexedViewFactory());
                    WmiRawFileWriter writer = new WmiRawFileWriter(filename);
                    WmiMathToolsFormatter formatter = new WmiMathToolsFormatter(docView, 0, disableStretchyOps);
                    if (breakWidth < 96) {
                        breakWidth = 96;
                    }
                    WmiMathToolsFormatter.setMaxWidth(breakWidth);
                    formatter.format(writer, wrapper);
                    writer.close();
                }
                catch (Exception e) {
                    success = false;
                    WmiModelLock.writeUnlock(wrapper);
                    docView.release();
                    WmiCaret.cancelTimer();
                }
            }
            finally {
                WmiModelLock.writeUnlock(wrapper);
                docView.release();
                WmiCaret.cancelTimer();
            }
        } else {
            success = false;
        }
        return success;
    }

    public static byte[] convertMathToByteArray(String dotM, int breakWidth) throws IOException, WmiNoReadAccessException, WmiNoWriteAccessException, WmiInvalidModelInitializationException {
        return WmiMathTools.convertMathToByteArray(dotM, breakWidth, false);
    }

    public static byte[] convertMathToByteArray(String dotM, int breakWidth, boolean disableStretchyOps) throws IOException, WmiNoReadAccessException, WmiNoWriteAccessException, WmiInvalidModelInitializationException {
        byte[] imageData = null;
        WmiMathDocumentModel docModel = new WmiMathDocumentModel();
        WmiMathWrapperModel wrapper = new WmiMathWrapperModel(docModel);
        if (disableStretchyOps) {
            WmiMathOperatorModel.disableStretchyOps = true;
        }
        if (WmiModelLock.writeLock(wrapper, true)) {
            try {
                try {
                    wrapper.createMathChildren(dotM);
                    docView = new WmiMathDocumentView(docModel, new WmiIndexedViewFactory());
                    ByteArrayOutputStream bStream = new ByteArrayOutputStream();
                    OutputStreamWriter writer = new OutputStreamWriter(bStream);
                    WmiMathToolsFormatter formatter = new WmiMathToolsFormatter(docView, 1, disableStretchyOps);
                    if (breakWidth < 96) {
                        breakWidth = 96;
                    }
                    WmiMathToolsFormatter.setMaxWidth(breakWidth);
                    formatter.format(writer, wrapper);
                    imageData = formatter.getImageData();
                }
                catch (WmiFormatException fe) {
                    WmiErrorLog.log(fe);
                    WmiModelLock.writeUnlock(wrapper);
                    docView.release();
                    WmiCaret.cancelTimer();
                }
            }
            finally {
                WmiModelLock.writeUnlock(wrapper);
                docView.release();
                WmiCaret.cancelTimer();
            }
        } else {
            return null;
        }
        return imageData;
    }

    public static int[] getImageDimensions(String math, int breakWidth) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiParseException, WmiModelIndexOutOfBoundsException, WmiInvalidModelInitializationException, IOException {
        return WmiMathTools.getImageDimensions(math, breakWidth, null, false);
    }

    public static int[] getImageDimensions(String math, WmiMathDocumentModel doc, int breakWidth) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiParseException, WmiModelIndexOutOfBoundsException, WmiInvalidModelInitializationException, IOException {
        return WmiMathTools.getImageDimensions(math, breakWidth, doc, false);
    }

    public static int[] getImageDimensions(String math, int breakWidth, WmiMathDocumentModel doc, boolean disableStretchyOps) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiParseException, WmiModelIndexOutOfBoundsException, WmiInvalidModelInitializationException, IOException {
        int[] dimensions = new int[3];
        WmiMathDocumentModel docModel = doc == null ? new WmiMathDocumentModel() : doc;
        WmiMathWrapperModel wrapper = null;
        if (disableStretchyOps) {
            WmiMathOperatorModel.disableStretchyOps = true;
        }
        if (WmiModelLock.writeLock(docModel, true)) {
            try {
                if (WmiMathTools.isMathML(math)) {
                    WmiModel child;
                    WmiMathMLImportParser parser = new WmiMathMLImportParser();
                    parser.parse(new StringReader(math), (WmiCompositeModel)docModel, 0);
                    WmiMathMLParagraphModel paragraph = (WmiMathMLParagraphModel)docModel.getChild(0);
                    if (paragraph != null && (child = paragraph.getChild(0)) instanceof WmiMathWrapperModel) {
                        wrapper = (WmiMathWrapperModel)child;
                        docView = new WmiMathDocumentView(docModel, new WmiIndexedViewFactory());
                    }
                } else {
                    wrapper = new WmiMathWrapperModel(docModel);
                    wrapper.createMathChildren(math);
                    WmiModel[] modelList = new WmiModel[]{wrapper};
                    WmiParagraphModel paragraph = new WmiParagraphModel(docModel, modelList);
                    docView = new WmiMathDocumentView(docModel, new WmiIndexedViewFactory());
                }
                dimensions = WmiMathTools.getImageDimensions(wrapper, breakWidth, disableStretchyOps);
            }
            finally {
                WmiModelLock.writeUnlock(docModel);
            }
        }
        return dimensions;
    }

    public static int[] getImageDimensions(WmiMathWrapperModel wrapper, int breakWidth, boolean disableStretchyOps) throws WmiNoReadAccessException {
        int[] dimensions = new int[3];
        if (docView != null && wrapper != null) {
            WmiMathToolsFormatter formatter = new WmiMathToolsFormatter(docView, 3, disableStretchyOps);
            if (breakWidth < 96) {
                breakWidth = 96;
            }
            WmiMathToolsFormatter.setMaxWidth(breakWidth);
            try {
                formatter.writeMathModel(wrapper);
                dimensions[0] = formatter.getBaseline();
                dimensions[1] = formatter.getWidth();
                dimensions[2] = formatter.getHeight();
            }
            catch (WmiNoReadAccessException e) {
                WmiErrorLog.log(e);
                Arrays.fill(dimensions, 0);
            }
            catch (IOException e) {
                WmiErrorLog.log(e);
                Arrays.fill(dimensions, 0);
            }
        }
        return dimensions;
    }

    public static String convertMathMLToDotM(String mathml) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiParseException, WmiModelIndexOutOfBoundsException {
        String result = "";
        WmiMathDocumentModel docModel = new WmiMathDocumentModel();
        if (WmiModelLock.writeLock(docModel, true)) {
            try {
                WmiModel child;
                WmiMathMLImportParser parser = new WmiMathMLImportParser();
                parser.parse(new StringReader(mathml), (WmiCompositeModel)docModel, 0);
                WmiMathMLParagraphModel paragraph = (WmiMathMLParagraphModel)docModel.getChild(0);
                if (paragraph != null && (child = paragraph.getChild(0)) instanceof WmiMathWrapperModel) {
                    WmiInlineMathModel mrow = new WmiInlineMathModel(docModel);
                    WmiMathWrapperModel wrapper = (WmiMathWrapperModel)child;
                    int i = 0;
                    while (i < wrapper.getChildCount()) {
                        mrow.appendChild(wrapper.getChild(i));
                        ++i;
                    }
                    wrapper.removeChildren(0, wrapper.getChildCount());
                    wrapper.appendChild(mrow);
                    Dag displayDag = wrapper.toDag();
                    String dotM = DagBuilder.createDotm(displayDag);
                    StringBuffer buff = new StringBuffer();
                    Base64Encoder.encode(dotM, buff);
                    result = buff.toString();
                }
            }
            finally {
                WmiModelLock.writeUnlock(docModel);
            }
        }
        return result;
    }

    private static boolean isMathML(String math) {
        return math.trim().startsWith("<math") && math.trim().endsWith("</math>");
    }

    public static void main(String[] args) {
        try {
            String mathml = "<math><apply><minus/><apply><times/><cn>2</cn><apply><minus/><ci>y</ci><cn>10</cn></apply></apply></apply></math>";
            int breakWidth = 750;
            try {
                boolean success = WmiMathTools.convertMathMLToGIF(mathml, breakWidth, "C:\\test.gif");
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static class WmiMathToolsFormatter
    extends WmiHTMLFormatter {
        private static final int GIF_TARGET = 0;
        private static final int BYTE_ARRAY_TARGET = 1;
        private static final int IMAGE_TARGET = 2;
        private static final int DIMENSIONS_TARGET = 3;
        private static final int HORIZONTAL_PADDING = 3;
        private int target;
        private boolean disableStretchyOps;
        private byte[] imageData = null;
        private BufferedImage image = null;
        private int baseline = 0;
        private int height = 0;
        private int width = 0;

        public WmiMathToolsFormatter(WmiMathDocumentView docView, int target, boolean disableStretchyOps) {
            super(docView);
            this.target = target;
            this.disableStretchyOps = disableStretchyOps;
        }

        @Override
        protected void postFormat() throws IOException {
        }

        @Override
        protected void preFormat() throws IOException, WmiNoReadAccessException {
        }

        public byte[] getImageData() {
            return this.imageData;
        }

        public BufferedImage getImage() {
            return this.image;
        }

        public int getBaseline() {
            return this.baseline;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }

        public static int getMaxWidth() {
            return maxWidth;
        }

        @Override
        protected void formatLinebrokenMathView(WmiParagraphView paragraph, String altText) throws WmiHTMLFormatter.WmiCancelException, WmiNoReadAccessException {
            WmiRenderPath path = new WmiRenderPath(this.docView);
            path.push(-paragraph.getHorizontalOffset(), -paragraph.getVerticalOffset());
            this.exportPositionedView(paragraph, path, altText);
            path.pop();
        }

        @Override
        protected void exportPositionedView(WmiPositionedView view, WmiRenderPath path, String altText) throws WmiHTMLFormatter.WmiCancelException, WmiNoReadAccessException {
            this.image = this.drawViewToImage(view, path, WmiMathToolsFormatter.getMaxWidth());
            this.baseline = view.getBaseline();
            this.height = view.getHeight();
            this.width = view.getWidth();
            if (this.target == 0) {
                this.createImageFile(this.image, altText);
            } else if (this.target == 1) {
                try {
                    ByteArrayOutputStream stream = new ByteArrayOutputStream();
                    JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)stream);
                    encoder.encode(this.image);
                    this.imageData = stream.toByteArray();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }

        public BufferedImage drawViewToImage(WmiPositionedView view, WmiRenderPath path, int maxWidth) throws WmiNoReadAccessException {
            BufferedImage image = null;
            int imageWidth = Math.min(view.getWidth(), maxWidth);
            int origHeight = view.getHeight();
            if (view.getWidth() > maxWidth) {
                origHeight = (int)Math.round((double)origHeight * ((double)view.getWidth() * 1.0 / (double)maxWidth));
            }
            int imageHeight = (int)Math.round((double)origHeight * 1.1);
            image = WmiImageUtilities.createImageObject(imageWidth + 6, imageHeight);
            view.setWidth(imageWidth);
            view.setHeight(imageHeight);
            Graphics2D graphics = image.createGraphics();
            Rectangle rect = new Rectangle(image.getWidth(), image.getHeight());
            WmiMathDocumentView myDoc = view.getDocumentView();
            Color fillColour = myDoc != null ? myDoc.getColor(0) : Color.WHITE;
            graphics.setPaint(fillColour);
            graphics.fill(new Rectangle2D.Double(0.0, 0.0, rect.getWidth(), rect.getHeight()));
            path.setScreenDraw(false);
            path.drawStringsWithGlyphVectors(false);
            graphics.translate(3, (imageHeight - origHeight) / 2);
            view.draw(graphics, path, rect);
            return image;
        }

        @Override
        protected boolean createImageFile(BufferedImage image, String altText) throws WmiHTMLFormatter.WmiCancelException {
            File imgFile = new File(this.getFilename());
            boolean success = WmiImageUtilities.exportToGIF(image, imgFile.getAbsolutePath());
            if (!success) {
                imgFile = this.getNextImageFile(1);
                try {
                    BufferedImage renderImage = image;
                    JAI.create((String)"filestore", (RenderedImage)renderImage, (Object)imgFile.getPath(), (Object)"JPEG");
                    success = true;
                }
                catch (Exception tE) {
                    tE.printStackTrace();
                }
            }
            return success;
        }
    }

    protected static class WmiMathToolsTest
    extends KernelAdapter
    implements KernelConnectionListener {
        private static String[][] testData = new String[][]{{"int(x,x)", "50"}, {"Int(1/x^(2*m+1)/sqrt(x^2+a^2),x)=(2*m)!/(m!)^2*(sqrt(x^2+a^2)/a^2*Sum((-1)^(m-r+1)*r!*(r-1)!/2/(2*r)!/(4*a^2)^(m-r)/x^(2*r),r=1..m)+(-1)^(m+1)/2^(2*m)/a^(2*m+1)*log((sqrt(x^2+a^2)+a)/x))", "400"}, {"Int(1/x^(2*m+1)/sqrt(x^2+a^2),x)=(2*m)!/(m!)^2*(sqrt(x^2+a^2)/a^2*Sum((-1)^(m-r+1)*r!*(r-1)!/2/(2*r)!/(4*a^2)^(m-r)/x^(2*r),r=1..m)+(-1)^(m+1)/2^(2*m)/a^(2*m+1)*log((sqrt(x^2+a^2)+a)/x))", "400"}, {"sqrt(X)=sqrt(c)*abs(x+b/2/c)", "400"}, {"Int(1/(a+b*x+c*x^2)^n/sqrt((a+b*x+c*x^2)),x)=2*(2*c*x+b)*sqrt((a+b*x+c*x^2))/(2*n-1)/(4*a*c-b^2)/(a+b*x+c*x^2)^n+2*(4*c/(4*a*c-b^2))*(n-1)/(2*n-1)*Int(1/(a+b*x+c*x^2)^(n-1)/sqrt((a+b*x+c*x^2)),x)", "400"}, {"Int((a+b*x+c*x^2)^n*sqrt(a+b*x+c*x^2),x)=(2*n+2)!/((n+1)!)^2/(4*(4*c/(4*a*c-b^2)))^(n+1)*((4*c/(4*a*c-b^2))*(2*c*x+b)*sqrt(a+b*x+c*x^2)/c*Sum(r!*(r+1)!*(4*(4*c/(4*a*c-b^2))*(a+b*x+c*x^2))^r/(2*r+2)!,r=0..n) + Int(1/sqrt(a+b*x+c*x^2),x))", "400"}, {"Int(sqrt(x/(a^3-x^3)),x)=2/3*arcsin((x/a)^(3/2))", "400"}, {"Int(x^m*sin(a*x),x)=cos(a*x)*Sum((-1)^(r+1)*m!/(m-2*r)!*x^(m-2*r)/a^(2*r+1),r=0..floor(m/2))+sin(a*x)*Sum((-1)^r*m!/(m-2*r-1)!*x^(m-2*r-1)/a^(2*r+2),r=0..floor((m-1)/2))", "400"}, {"Int(x^m*cos(a*x),x)=sin(a*x)*Sum((-1)^r*m!/(m-2*r)!*x^(m-2*r)/a^(2*r+1),r=0..floor(m/2))+cos(a*x)*Sum((-1)^r*m!/(m-2*r-1)!*x^(m-2*r-1)/a^(2*r+2),r=0..floor((m-1)/2))", "400"}, {"Int(x^n*arccsc(a*x),x)=x^(n+1)/(n+1)*arccsc(a*x)+1/(n+1)*Int(x^n/sqrt(a^2*x^2-1),x)", "400"}, {"Int(1/x^2*log((x+a)/(x-a)),x)=1/x*log((x-a)/(x+a))-1/a*log((x^2-a^2)/x^2)+(2*a^(m+1))/(m+1)*Sum(1/(m-2*r+2)*(x/a)^(m-2*r+2),r=1..floor((m+1)/2))", "400"}, {"Int(1/x^2*log((x+a)/(x-a)),x)=1/x*log((x-a)/(x+a))-1/a*log((x^2-a^2)/x^2)+(2*a^(m+1))/(m+1)*Sum(1/(m-2*r+2)*(x/a)^(m-2*r+2),r=1..floor((m+1)/2))", "400"}, {"Int(log((a+b*x+c*x^2)),x)=(x+b/2/c)*log(a+b*x+c*x^2)-2*x+sqrt(b^2-4*a*c)/c*arctanh((2*c*x+b)/sqrt(b^2-4*a*c))", "400"}, {"Int(1/(a*exp(m*x)+b*exp(-m*x)),x)=1/m/sqrt(a*b)*arctan(exp(m*x)*sqrt(a/b))", "400"}, {"Int(exp(a*x)*(cos(x))^m*(sin(x))^n,x)=exp(a*x)*(cos(x))^(m-1)*(sin(x))^n*(a*cos(x)+(m+n)*sin(x))/((m+n)^2+a^2)-n*a/((m+n)^2+a^2)*Int(exp(a*x)*(cos(x))^(m-1)*(sin(x))^(n-1),x)+(m-1)*(m+n)/((m+n)^2+a^2)*Int(exp(a*x)*(cos(x))^(m-2)*(sin(x))^n,x)", "400"}, {"Int(x^(-p+1)*BesselJ(p,x),x)=-x^(-p+1)*BesselJ(p-1,x)", "400"}, {"Int(x^(m-1)/(1+x^n),x=0..infinity)=Pi/n/sin(m*Pi/n)", "400"}, {"Int(x^a/(m+x^b)^c,x=0..infinity)=m^((a+1-b*c)/b)/b*GAMMA((a+1)/b)*GAMMA(c-(a+1)/b)/GAMMA(c)", "400"}, {"Int((cos(a*x)-cos(b*x))/x,x=0..infinity)=log(abs(b/a))", "400"}, {"Int(1/(1+tan(x)^m),x=0..Pi/2)=Pi/4", "400"}, {"Int(exp(-a*x^2-b/x^2),x=0..infinity)=sqrt(Pi/a)/2*exp(-2*sqrt(a*b))", "400"}};
        private static final int MATHML_SOURCE = 0;
        private static final int DOTM_SOURCE = 1;
        private static final int GIF_TARGET = 0;
        private static final int BYTE_ARRAY_TARGET = 1;
        private static final int IMAGE_TARGET = 2;
        private static final int TYPEMK_TARGET = 3;
        private static final int DIMENSIONS_TARGET = 4;
        private static int outputFileCounter;
        private static String homeDir;
        private int inputFormat = 0;
        private int outputFormat = 0;
        private boolean disableStretchy = false;
        private SetGetHandler setGetHandler = new SetGetHandler(this);
        private KernelConnection kernelConnection = null;
        private int kernelID = -999;

        @Override
        public KernelConnection getConnection() {
            return this.kernelConnection;
        }

        @Override
        public int getKernelID() {
            return this.kernelID;
        }

        public void restart() {
            KernelProxy proxy = KernelProxy.getInstance();
            proxy.evaluate(this.getKernelID(), new KernelAdapter(), "restart;");
        }

        @Override
        public void processConnection(KernelConnectionEvent event) {
            if (event.getKernelState() == 1) {
                KernelProxy proxy = KernelProxy.getInstance();
                proxy.evaluate(this.getKernelID(), this, "gc();");
            }
        }

        @Override
        public void processDisconnection(KernelConnectionEvent event) {
        }

        @Override
        public void setConnection(KernelConnection connection) {
            this.kernelConnection = connection;
            this.kernelConnection.getInterfaceProperties().addChangeListener(new KernelInterfacePropertiesChangeAdapter());
        }

        @Override
        public boolean processError(KernelEvent event) {
            System.out.println(event.getText());
            return true;
        }

        @Override
        public boolean processJava(KernelEvent event) {
            return JavaCallbackListener.processJava(event);
        }

        @Override
        public boolean processChar(KernelEvent event) {
            System.out.println(event.getDag().getChild(0).getData());
            return true;
        }

        @Override
        public boolean processRealMath(KernelEvent event) {
            return false;
        }

        @Override
        public boolean processSet(KernelEvent event) {
            this.setGetHandler.processSetHandler(event);
            return true;
        }

        @Override
        public boolean processGet(KernelEvent event) {
            this.setGetHandler.processGetHandler(event);
            return true;
        }

        public static void main(String[] args) {
            WmiMathToolsTest tester = new WmiMathToolsTest();
            tester.runTests(testData, args[0], args[1], args[2]);
        }

        public WmiMathToolsTest() {
            homeDir = String.valueOf(System.getProperty("user.home")) + System.getProperty("file.separator");
        }

        public void runTests(String[][] testData, String inputFormat, String outputFormat, String disableStretchyOps) {
            String input = inputFormat.substring(inputFormat.indexOf("=") + 1);
            String output = outputFormat.substring(outputFormat.indexOf("=") + 1);
            String disable = disableStretchyOps.substring(disableStretchyOps.indexOf("=") + 1);
            this.inputFormat = input.toLowerCase().equals("mathml") ? 0 : 1;
            this.outputFormat = output.toLowerCase().equals("gif") ? 0 : (output.toLowerCase().equals("bytearray") ? 1 : (output.toLowerCase().equals("image") ? 2 : (output.toLowerCase().equals("typemk") ? 3 : 4)));
            this.disableStretchy = disable.toLowerCase().equals("true");
            KernelProxy proxy = KernelProxy.getInstance();
            proxy.createKernelConnection(this);
            outputFileCounter = 1;
            int i = 0;
            while (i < testData.length) {
                TestCommand command = this.inputFormat == 0 ? new TestCommand("MathML:-ExportPresentation(" + testData[i][0] + ");", proxy.getKernelIDs()[0], this) : new TestCommand(String.valueOf(testData[i][0]) + ";", proxy.getKernelIDs()[0], this);
                command.process();
                String result = command.getLPrintResult();
                result = result.substring(1, result.length() - 1);
                this.processResult(result);
                ++i;
            }
        }

        private void processResult(String result) {
            try {
                int width = Integer.parseInt(testData[outputFileCounter - 1][1]);
                if (this.outputFormat == 0) {
                    if (this.inputFormat == 0) {
                        WmiMathTools.convertMathMLToGIF(result, width, String.valueOf(homeDir) + "MathToolsResult_" + outputFileCounter + ".gif", this.disableStretchy);
                    } else {
                        WmiMathTools.convertDotMToGIF(result, width, String.valueOf(homeDir) + "MathToolsResult_" + outputFileCounter + ".gif", this.disableStretchy);
                    }
                } else if (this.outputFormat == 1) {
                    WmiMathTools.convertMathToByteArray(result, width, this.disableStretchy);
                } else if (this.outputFormat == 2) {
                    BufferedImage image = WmiMathTools.convertMathMLToImage(result, width, this.disableStretchy);
                } else if (this.outputFormat == 3) {
                    System.out.println(WmiMathTools.convertMathMLToTypeMK(result));
                } else if (this.inputFormat == 0 && this.outputFormat == 4) {
                    int[] dimensions = WmiMathTools.getImageDimensions(result, width, null, this.disableStretchy);
                    System.out.println(String.valueOf(dimensions[0]) + ", " + dimensions[1] + ", " + dimensions[2]);
                } else {
                    int[] dimensions = WmiMathTools.getImageDimensions(result, width, null, this.disableStretchy);
                    System.out.println(String.valueOf(dimensions[0]) + ", " + dimensions[1] + ", " + dimensions[2]);
                }
                ++outputFileCounter;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        protected static class TestCommand
        extends BlockingEvaluation {
            String command = null;
            String lprintedResult = null;
            Dag dagResult = null;

            protected TestCommand(String command, int kernelid, WmiMathToolsTest test) {
                super(kernelid, test);
                this.command = command;
            }

            @Override
            public String getCommand() {
                return this.command;
            }

            @Override
            public void update() {
                this.dagResult = (Dag)this.getResult();
                if (this.dagResult != null) {
                    this.lprintedResult = DagBuilder.lPrint(this.dagResult);
                }
            }

            public String getLPrintResult() {
                return this.lprintedResult;
            }

            public Dag getDagResult() {
                return this.dagResult;
            }
        }
    }
}

