/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.util;

public class WmiMutex {
    public static final long FOREVER = Long.MAX_VALUE;
    private Thread owner = null;
    private int lockCount = 0;

    public synchronized boolean acquire(long timeout) throws InterruptedException {
        boolean mutexAcquired = false;
        if (timeout == 0L) {
            mutexAcquired = this.acquireWithoutBlocking();
        } else if (timeout == Long.MAX_VALUE) {
            while (!this.acquireWithoutBlocking()) {
                this.wait(Long.MAX_VALUE);
            }
            mutexAcquired = true;
        } else {
            long expiration = System.currentTimeMillis() + timeout;
            while (!(mutexAcquired = this.acquireWithoutBlocking())) {
                long remaining = expiration - System.currentTimeMillis();
                if (remaining <= 0L) break;
                this.wait(remaining);
            }
        }
        return mutexAcquired;
    }

    public void acquire() throws InterruptedException {
        this.acquire(Long.MAX_VALUE);
    }

    private boolean acquireWithoutBlocking() {
        Thread current = Thread.currentThread();
        if (this.owner == null) {
            this.owner = current;
            this.lockCount = 1;
        } else if (this.owner == current) {
            ++this.lockCount;
        }
        return this.owner == current;
    }

    public synchronized void release() {
        if (this.owner != Thread.currentThread()) {
            throw new OwnershipException();
        }
        if (--this.lockCount <= 0) {
            this.owner = null;
            this.notify();
        }
    }

    public static class OwnershipException
    extends RuntimeException {
        public OwnershipException() {
            super("Attempt by non-owner thread to release a mutex.");
        }

        public OwnershipException(String s) {
            super(s);
        }
    }
}

