/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view;

import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.view.WmiInlineView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiRenderPath;
import com.maplesoft.mathdoc.view.WmiTextView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewPosition;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

public abstract class WmiAbstractInlineWrapperView
extends WmiInlineView {
    protected WmiMathDocumentView doc = null;

    protected WmiAbstractInlineWrapperView(WmiModel model, WmiMathDocumentView docView) {
        super(model, docView);
        this.doc = docView;
    }

    protected void drawDecorator(Graphics g, WmiRenderPath path) {
        g.setColor(this.getDecoratorColor());
        g.drawRect(this.x + path.getHorizontalOffset(), this.y + path.getVerticalOffset(), this.width, this.height);
    }

    public boolean isDecoratorVisible() {
        return true;
    }

    @Override
    public void draw(Graphics g, WmiRenderPath path, Rectangle bounds) {
        super.draw(g, path, bounds);
        if (this.isDecoratorVisible()) {
            Color saveColour = g.getColor();
            this.drawDecorator(g, path);
            g.setColor(saveColour);
        }
    }

    public WmiViewPosition getFinalPosition() throws WmiNoReadAccessException {
        WmiViewPosition answer = null;
        WmiView lastChild = WmiViewUtil.findLastPhysicalDescendantOfTag(this, WmiModelTag.TEXT);
        if (lastChild instanceof WmiTextView) {
            int end = ((WmiTextView)lastChild).getEndOffset() - ((WmiTextView)lastChild).getStartOffset();
            answer = new WmiViewPosition((WmiPositionedView)lastChild, end);
        }
        return answer;
    }

    public boolean stepInto() {
        return false;
    }

    protected abstract Color getDecoratorColor();

    public abstract WmiAbstractInlineWrapperView createViewOfSameClass(WmiModel var1, WmiMathDocumentView var2);
}

