/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiModelPath;
import com.maplesoft.mathdoc.model.WmiModelPathInterval;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import com.maplesoft.mathdoc.model.WmiTextCollector;
import com.maplesoft.mathdoc.view.WmiAccessibleView;
import com.maplesoft.mathdoc.view.WmiCaret;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiGenericView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewPath;
import java.awt.Point;
import java.awt.Rectangle;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleText;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;

public class WmiAccessibleTextComposite
implements AccessibleText {
    protected WmiCompositeView view = null;
    protected AccessibleContext context = null;

    public WmiAccessibleTextComposite(WmiCompositeView parentView) {
        this.view = parentView;
    }

    @Override
    public int getIndexAtPoint(Point p) {
        int offset = 0;
        if (this.view instanceof WmiPositionedView) {
            WmiPositionedView parent = (WmiPositionedView)((Object)this.view);
            WmiPositionedView childView = parent.getNearestChildView(p);
            int i = 0;
            while (i < this.view.getChildCount()) {
                WmiView child = this.view.getChild(i);
                AccessibleContext childContext = child.getAccessibleContext();
                if (child == childView) {
                    p.translate(-childView.getHorizontalOffset(), -childView.getVerticalOffset());
                    AccessibleText childText = childContext.getAccessibleText();
                    offset += childText.getIndexAtPoint(p);
                    break;
                }
                if (childContext instanceof WmiAccessibleView) {
                    offset += ((WmiAccessibleView)((Object)childContext)).getTextLength();
                }
                ++i;
            }
        }
        return offset;
    }

    @Override
    public Rectangle getCharacterBounds(int index) {
        Rectangle result = null;
        int offset = 0;
        int i = 0;
        while (i < this.view.getChildCount() && result == null) {
            WmiView child = this.view.getChild(i);
            AccessibleContext childContext = child.getAccessibleContext();
            if (childContext instanceof WmiAccessibleView) {
                int length = ((WmiAccessibleView)((Object)childContext)).getTextLength();
                if (length > 0 && length + offset >= length) {
                    AccessibleText text = childContext.getAccessibleText();
                    result = text.getCharacterBounds(index - offset);
                } else {
                    offset += length;
                }
            }
            ++i;
        }
        return result;
    }

    @Override
    public int getCharCount() {
        int total = 0;
        if (this.context == null) {
            this.context = this.view.getAccessibleContext();
        }
        if (this.context instanceof WmiAccessibleView) {
            total = ((WmiAccessibleView)((Object)this.context)).getTextLength();
        } else {
            int children = this.view.getChildCount();
            int i = 0;
            while (i < children) {
                AccessibleText text;
                WmiView child = this.view.getChild(i);
                AccessibleContext childContext = child.getAccessibleContext();
                if (childContext != null && (text = childContext.getAccessibleText()) != null) {
                    total += text.getCharCount();
                }
                ++i;
            }
        }
        return total;
    }

    @Override
    public int getCaretPosition() {
        WmiViewPath caretPath;
        WmiViewPath viewPath;
        WmiViewPath common;
        WmiCaret caret;
        int position = 0;
        WmiMathDocumentView docView = this.view.getDocumentView();
        if (docView != null && (caret = docView.getCaret()) != null && (common = WmiViewPath.commonParent(viewPath = new WmiViewPath(this.view), caretPath = caret.getViewPath())).compareTo(viewPath) == 0) {
            position = caret.getOffset();
        }
        return position;
    }

    @Override
    public String getAtIndex(int part, int index) {
        String result = null;
        int children = this.view.getChildCount();
        int offset = 0;
        int i = 0;
        while (i < children && result == null) {
            WmiView child = this.view.getChild(i);
            AccessibleContext childContext = child.getAccessibleContext();
            if (childContext instanceof WmiAccessibleView && (!(childContext instanceof WmiGenericView.WmiAccessibleGenericView) || ((WmiGenericView.WmiAccessibleGenericView)childContext).isPhysicalView())) {
                int length = ((WmiAccessibleView)((Object)childContext)).getTextLength();
                if (length > 0 && length + offset >= index) {
                    AccessibleText text = childContext.getAccessibleText();
                    result = text.getAtIndex(part, index - offset);
                } else {
                    offset += length;
                }
            }
            ++i;
        }
        return result;
    }

    @Override
    public String getAfterIndex(int part, int index) {
        return this.getAtIndex(part, index + 1);
    }

    @Override
    public String getBeforeIndex(int part, int index) {
        return this.getAtIndex(part, index - 1);
    }

    @Override
    public AttributeSet getCharacterAttribute(int i) {
        return new SimpleAttributeSet();
    }

    @Override
    public int getSelectionStart() {
        return 0;
    }

    @Override
    public int getSelectionEnd() {
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getSelectedText() {
        String selected = null;
        WmiMathDocumentView doc = this.view.getDocumentView();
        WmiSelection selection = doc.getSelection();
        if (selection == null) return selected;
        WmiMathDocumentModel docModel = (WmiMathDocumentModel)doc.getModel();
        WmiViewPath beginPath = selection.getSelectionStartPath();
        WmiViewPath endPath = selection.getSelectionEndPath();
        if (beginPath == null || endPath == null) return selected;
        boolean locked = WmiModelLock.readLock(docModel, true);
        try {
            try {
                WmiModelPosition startPos = beginPath.createModelPosition(doc);
                WmiModelPosition endPos = endPath.createModelPosition(doc);
                WmiModelPathInterval span = new WmiModelPathInterval(new WmiModelPath(startPos), new WmiModelPath(endPos));
                WmiTextCollector collector = new WmiTextCollector(startPos, endPos);
                span.walkInterval(docModel, collector);
                selected = collector.getCollectedText();
                return selected;
            }
            catch (WmiNoReadAccessException e) {
                WmiErrorLog.log(e);
                if (!locked) return selected;
                WmiModelLock.readUnlock(docModel);
                return selected;
            }
            catch (WmiInvalidModelInitializationException e) {
                WmiErrorLog.log(e);
                if (!locked) return selected;
                WmiModelLock.readUnlock(docModel);
                return selected;
            }
        }
        finally {
            if (locked) {
                WmiModelLock.readUnlock(docModel);
            }
        }
    }
}

