/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view;

import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.view.WmiHighlightPainter;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewPath;
import com.maplesoft.mathdoc.view.WmiViewPathInterval;
import java.util.HashSet;
import java.util.Iterator;

public class WmiAggregateSelection
implements WmiSelection {
    private WmiMathDocumentView docView = null;
    private HashSet views = new HashSet();
    private HashSet selections = new HashSet();

    public WmiAggregateSelection(WmiMathDocumentView docView) {
        this.docView = docView;
    }

    @Override
    public int contains(WmiView view) {
        int status = 0;
        if (this.views.contains(view)) {
            status = 2;
        } else {
            block4: for (WmiSelection selection : this.selections) {
                switch (selection.contains(view)) {
                    case 2: {
                        status = 2;
                        break block4;
                    }
                    case 1: {
                        status = 1;
                    }
                    default: {
                        continue block4;
                    }
                }
            }
        }
        return status;
    }

    @Override
    public boolean contains(WmiView view, int offset) {
        return false;
    }

    @Override
    public int contains(WmiViewPath path) {
        int status = 0;
        for (WmiSelection sel : this.selections) {
            switch (sel.contains(path)) {
                case 2: {
                    return 2;
                }
                case 1: {
                    status = 1;
                    break;
                }
            }
        }
        if (status == 0) {
            Iterator it = this.views.iterator();
            WmiViewPathInterval interval = new WmiViewPathInterval(this.docView, path, path);
            while (it.hasNext()) {
                WmiView view = (WmiView)it.next();
                switch (interval.contains(view)) {
                    case 1: 
                    case 2: {
                        return 1;
                    }
                }
            }
        }
        return status;
    }

    @Override
    public boolean hideCaret() {
        return true;
    }

    @Override
    public WmiViewPath getSelectionStartPath() {
        return null;
    }

    @Override
    public WmiViewPath getSelectionEndPath() {
        return null;
    }

    @Override
    public boolean isCompoundSelection() {
        return true;
    }

    protected void deleteView(WmiView view) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiModel model = view.getModel();
        WmiCompositeModel parent = model.getParent();
        try {
            parent.removeChild(model);
        }
        catch (WmiModelIndexOutOfBoundsException mioobe) {
            mioobe.printStackTrace();
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public void deleteSelection() {
        Iterator it = this.getViewIterator();
        try {
            try {
                WmiModelLock.writeLock(this.docView.getModel(), true);
                while (it.hasNext()) {
                    WmiView view = (WmiView)it.next();
                    this.deleteView(view);
                }
                this.docView.resetSelectionOnUpdate();
                this.docView.getModel().update("Delete Selection");
            }
            catch (WmiNoReadAccessException nrae) {
                nrae.printStackTrace();
                WmiModelLock.writeUnlock(this.docView.getModel());
            }
            catch (WmiNoWriteAccessException nwae) {
                nwae.printStackTrace();
                WmiModelLock.writeUnlock(this.docView.getModel());
            }
            catch (WmiNoUpdateAccessException nuae) {
                nuae.printStackTrace();
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                WmiModelLock.writeUnlock(this.docView.getModel());
            }
        }
        finally {
            WmiModelLock.writeUnlock(this.docView.getModel());
        }
    }

    @Override
    public void replaceSelection(String contents) {
    }

    @Override
    public void resync() {
    }

    @Override
    public boolean isReadOnly() throws WmiNoReadAccessException {
        return false;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public void updateSelection(WmiViewPath path) {
    }

    public void add(WmiView view) {
        this.views.add(view);
        this.docView.getContextManager().setContextForDocument(this.docView);
    }

    public void add(WmiSelection sel) {
        if (sel instanceof WmiAggregateSelection) {
            this.views.addAll(((WmiAggregateSelection)sel).views);
            this.selections.addAll(((WmiAggregateSelection)sel).selections);
        } else {
            this.selections.add(sel);
        }
    }

    public void remove(WmiView view) {
        this.views.remove(view);
        this.docView.getContextManager().setContextForDocument(this.docView);
    }

    public void clear() {
        this.views.clear();
        this.selections.clear();
    }

    public int getViewCount() {
        return this.views.size();
    }

    public Iterator getViewIterator() {
        return this.views.iterator();
    }

    public Iterator getSelectionIterator() {
        return this.selections.iterator();
    }

    @Override
    public WmiHighlightPainter getSelectionHighlighter() {
        return null;
    }

    @Override
    public void repaintDirtyRegions() {
    }

    @Override
    public boolean getModelInterval(WmiModel[] models, int[] offsets) {
        return false;
    }

    @Override
    public WmiMathDocumentView getSourceDocument() {
        return this.docView;
    }
}

