/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view;

import com.maplesoft.mathdoc.controller.WmiDocumentScroller;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import com.maplesoft.mathdoc.view.WmiContainerView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewPath;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import com.maplesoft.util.RuntimePlatform;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public abstract class WmiBoundsMarker
implements WmiPositionMarker {
    protected WmiMathDocumentView docView;
    private WmiPositionedView positionedView = null;
    protected int left = 0;
    protected int top = 0;
    protected int height = 0;
    protected int width = 0;
    private boolean visible = false;

    protected WmiBoundsMarker(WmiMathDocumentView view) {
        this.docView = view;
    }

    public void drawBounds(Graphics g, int xPos, int yPos, int xSize, int ySize) {
        g.drawRect(xPos, yPos, xSize - 1, ySize - 1);
    }

    public void updateView(WmiPositionedView view) {
        this.positionedView = view;
        this.height = this.positionedView.getHeight();
        this.width = this.positionedView.getWidth();
        Point pt = WmiViewUtil.getAbsoluteOffset(this.positionedView);
        this.left = pt.x;
        this.top = pt.y;
        this.docView.notifyMarkerPositionChanged();
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle(this.left, this.top, this.width, this.height);
    }

    @Override
    public WmiModelPosition getModelPosition() {
        WmiModelPosition position = null;
        if (this.positionedView != null) {
            WmiModel model = this.positionedView.getModel();
            position = new WmiModelPosition(model, this.getOffset());
        }
        return position;
    }

    @Override
    public WmiViewPath getViewPath() {
        WmiViewPath path = null;
        if (this.visible && this.positionedView != null) {
            path = new WmiViewPath(this.positionedView);
        }
        return path;
    }

    @Override
    public void hide() {
        this.visible = false;
        if (this.positionedView instanceof WmiContainerView) {
            ((WmiContainerView)((Object)this.positionedView)).setFocus(false);
        }
        this.docView.setFocusedView(null);
        this.docView.repaint(new Rectangle(this.left, this.top, this.width + 1, this.height + 1));
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public boolean isReadOnly() throws WmiNoReadAccessException {
        WmiMathDocumentModel docModel;
        WmiModel model;
        boolean readonly = false;
        if (this.positionedView != null && (model = this.positionedView.getModel()) != null && (docModel = model.getDocument()) != null) {
            readonly = !docModel.isMutableModel(model);
        }
        return readonly;
    }

    @Override
    public void paint(Graphics g) {
        if (this.visible && this.positionedView != null && this.positionedView.getModel() != null) {
            Point pt = WmiViewUtil.getAbsoluteOffset(this.positionedView);
            this.left = pt.x;
            this.top = pt.y;
            Color saveColour = g.getColor();
            Color drawColour = RuntimePlatform.isMac() ? Color.GRAY : this.docView.getColor(4);
            g.setColor(drawColour);
            this.drawBounds(g, this.left, this.top, this.width, this.height);
            g.setColor(saveColour);
        }
    }

    @Override
    public void scrollVisible() {
        WmiDocumentScroller.scrollVisible(this.docView, this.getBounds());
    }

    @Override
    public void scrollToTop() {
        WmiDocumentScroller.scrollToTop(this.docView, this.getBounds());
    }

    @Override
    public void show() {
        this.visible = true;
        if (this.positionedView != null) {
            this.docView.setFocusedView(this.positionedView);
        }
    }

    @Override
    public WmiPositionedView getView() {
        return this.positionedView;
    }

    @Override
    public int getOffset() {
        return 0;
    }

    @Override
    public void resync() throws WmiNoReadAccessException {
        WmiView temp;
        WmiModel model;
        if (this.positionedView != null && (model = this.positionedView.getModel()) != null && (temp = WmiViewUtil.modelToView(this.positionedView.getDocumentView(), model, 0)) instanceof WmiPositionedView) {
            this.positionedView = (WmiPositionedView)temp;
        }
        this.show();
    }

    @Override
    public void updateMarkerPosition(WmiModel model, int offset) throws WmiNoReadAccessException {
    }
}

