/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view;

import com.maplesoft.mathdoc.components.WmiContextManager;
import com.maplesoft.mathdoc.controller.WmiClipboardManager;
import com.maplesoft.mathdoc.controller.WmiDocumentType;
import com.maplesoft.mathdoc.controller.WmiIndexedViewFactory;
import com.maplesoft.mathdoc.controller.WmiInputMethodRequestHandler;
import com.maplesoft.mathdoc.controller.WmiMathDocumentKeyListener;
import com.maplesoft.mathdoc.controller.WmiMathDocumentMouseListener;
import com.maplesoft.mathdoc.controller.WmiViewFactory;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.font.WmiFontMetrics;
import com.maplesoft.mathdoc.font.WmiFontResolver;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiInputLock;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiModelPath;
import com.maplesoft.mathdoc.model.WmiModelPathInterval;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.WmiParagraphModel;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.math.WmiMathFencedModel;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathSpaceModel;
import com.maplesoft.mathdoc.view.WmiAdaptiveLayoutView;
import com.maplesoft.mathdoc.view.WmiAggregateSelection;
import com.maplesoft.mathdoc.view.WmiCaret;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiDefaultPositionUpdateHandler;
import com.maplesoft.mathdoc.view.WmiEightPointResizer;
import com.maplesoft.mathdoc.view.WmiHighlightPainter;
import com.maplesoft.mathdoc.view.WmiLayoutDecorator;
import com.maplesoft.mathdoc.view.WmiParagraphView;
import com.maplesoft.mathdoc.view.WmiPositionInView;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiPositionUpdateHandler;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiRenderPath;
import com.maplesoft.mathdoc.view.WmiRowView;
import com.maplesoft.mathdoc.view.WmiScrollableContainerView;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiSelectionChangeListener;
import com.maplesoft.mathdoc.view.WmiSelectionHighlighter;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewPath;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import com.maplesoft.mathdoc.view.math.WmiMathCaret;
import com.maplesoft.util.RuntimePlatform;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.dnd.Autoscroll;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.im.InputMethodRequests;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class WmiMathDocumentView
extends JComponent
implements WmiCompositeView,
WmiPositionedView,
WmiScrollableContainerView,
InputMethodListener,
FocusListener,
Scrollable,
Autoscroll {
    protected static final int DEFAULT_INDENT = 5;
    public static final int BACKGROUND_COLOR_INDEX = 0;
    public static final int FOREGROUND_COLOR_INDEX = 1;
    public static final int CARET_COLOR_INDEX = 2;
    public static final int SELECTION_FOREGROUND_COLOR_INDEX = 3;
    public static final int SELECTION_BACKGROUND_COLOR_INDEX = 4;
    public static final int COLOR_INDEX_TABLE_SIZE = 5;
    public static final String RESOURCE_PREFIX = "TextPane";
    public static final int DEFAULT_BREAK_WIDTH = 400;
    protected static final int DEFAULT_WIDTH = 500;
    protected static final int DEFAULT_HEIGHT = 400;
    public static final Insets SCROLL_INSETS = new Insets(8, 8, 8, 8);
    public static final int SCROLL_INCREMENT = 15;
    public static final WmiDocumentType DOCUMENT_TYPE_DEFAULT = new WmiDocumentType();
    public static final String COMPONENT_VIEW_PROPERTY = "__WmiView__";
    public static final String COMPONENT_OFFSET_PROPERTY = "__WmiViewOffset__";
    public static final int LAYOUT_DELAY_TIMEOUT = 10;
    public static final Point CONTAINER_OFFSET = new Point(0, 0);
    protected WmiRowView rootView;
    private WmiMathDocumentModel model;
    private WmiViewFactory factory;
    protected int breakWidth = 400;
    protected int zoom = 133;
    protected int pendingBreakWidth = 400;
    private WmiPositionMarker marker;
    protected WmiMathDocumentMouseListener documentMouseListener = null;
    protected WmiMathDocumentKeyListener documentKeyListener = null;
    protected WmiView focusView = null;
    private WmiSelection currentSelection = null;
    private Color[] colorTable = null;
    protected WmiInputMethodRequestHandler inputHandler = null;
    private boolean isScrolling = false;
    private boolean pendingSelectionReset = false;
    private WmiModelPath pendingModelPath = null;
    private WmiPositionUpdateHandler pendingPositionHandler = null;
    private ArrayList positionHandlers = null;
    private Dimension docSize = null;
    private WmiLayoutDecorator layoutDecorator = null;
    private List highlightPainters = null;
    private int lastHorizontalPosition = 0;
    protected WmiContextManager contextManager = null;
    protected WmiClipboardManager clipboardManager = null;
    protected boolean isLayoutEnabled = true;
    protected boolean isRepaintEnabled = true;
    protected boolean isPainting = false;
    protected boolean isInLayout = false;
    protected Point pendingScrollPosition = null;
    protected ArrayList selectionChangeListeners = new ArrayList();
    private BufferedImage renderImage = null;
    private static WmiMathDocumentView activeDocumentView = null;
    private WmiScrollableContainerView activeContainerView = null;
    private Object activeContainerAccessLock = new Object();
    private boolean skipAutoexecWarning = false;

    public WmiMathDocumentView() {
        this(null, null);
    }

    public WmiMathDocumentView(WmiMathDocumentModel _model, WmiViewFactory _factory) {
        this.model = _model != null ? _model : new WmiMathDocumentModel();
        this.factory = _factory != null ? _factory : new WmiIndexedViewFactory();
        this.model.addModelListener(this.factory);
        this.rootView = this.createRootView(this.model, this.getDebugName());
        this.rootView.setParentView(this);
        this.factory.setRootView(this);
        this.marker = new WmiCaret(this);
        this.positionHandlers = new ArrayList();
        this.highlightPainters = new LinkedList();
        this.getClipboardManager();
        this.setFocusTraversalKeys(0, new TreeSet());
        this.setFocusTraversalKeys(1, new TreeSet());
        this.initializeColorTable();
        this.setLayout(null);
        this.setOpaque(true);
        this.registerTestKeys();
    }

    public void setContextManager(WmiContextManager ctxMgr) {
        this.contextManager = ctxMgr;
    }

    public WmiContextManager getContextManager() {
        return this.contextManager;
    }

    public void enableLayout(boolean state) {
        this.isLayoutEnabled = state;
    }

    public void enableRepaint(boolean state) {
        this.isRepaintEnabled = true;
    }

    public WmiDocumentType getDocumentType() {
        return DOCUMENT_TYPE_DEFAULT;
    }

    @Override
    public boolean isDocumentView() {
        return true;
    }

    @Override
    public void appendView(WmiView view) {
        if (this.rootView != null) {
            this.rootView.appendView(view);
        }
    }

    @Override
    public WmiView getChild(int position) {
        WmiView child = null;
        if (this.rootView != null) {
            child = this.rootView.getChild(position);
        }
        return child;
    }

    @Override
    public int getChildCount() {
        return this.rootView != null ? this.rootView.getChildCount() : 0;
    }

    @Override
    public void replaceChild(WmiView view, int position) {
    }

    @Override
    public void removeChild(int index) {
    }

    @Override
    public int indexOf(WmiView child) {
        return this.rootView != null ? this.rootView.indexOf(child) : -1;
    }

    @Override
    public WmiModel getModel() {
        return this.model;
    }

    public WmiInputLock getInputLock() {
        return this.model.getInputLock();
    }

    @Override
    public void updateView() throws WmiNoReadAccessException {
        if (this.rootView != null) {
            int newZoom = this.getZoom();
            if (!this.isPrintView()) {
                float zoomScale = WmiFontResolver.DPI_SCALE_FACTOR;
                newZoom = Math.round(zoomScale * (float)newZoom);
            }
            if (newZoom != this.zoom) {
                this.zoom = newZoom;
                this.invalidateAll(this.rootView);
            }
            this.rootView.verifyReadLock();
            this.rootView.updateView();
        }
    }

    protected int getZoom() throws WmiNoReadAccessException {
        return ((WmiMathDocumentModel)this.getModel()).getZoomFactor();
    }

    @Override
    public void markValid(int flag) {
        if (this.rootView != null) {
            this.rootView.markValid(flag);
        }
    }

    @Override
    public void markInvalid(int flag) {
        if (this.rootView != null) {
            this.rootView.markInvalid(flag);
        }
    }

    @Override
    public void release() {
        this.removeMouseListener(this.documentMouseListener);
        this.removeMouseMotionListener(this.documentMouseListener);
        this.removeKeyListener(this.documentKeyListener);
        this.removeInputMethodListener(this.inputHandler);
        if (this.model instanceof WmiMathDocumentModel) {
            this.model.removeModelListener(this.factory);
        }
        this.documentMouseListener = null;
        this.documentKeyListener = null;
        this.inputHandler = null;
        FocusListener[] focus = this.getFocusListeners();
        int i = 0;
        while (i < focus.length) {
            this.removeFocusListener(focus[i]);
            ++i;
        }
        this.setPositionMarker(null);
        this.setSelection(null);
        this.rootView.release();
        this.rootView.setParentView(null);
        this.rootView = null;
        if (this.factory != null) {
            this.factory.releaseFactory();
            this.factory = null;
        }
        this.removeLayoutDecorator();
        this.resetKeyboardActions();
        if (this.clipboardManager != null) {
            this.clipboardManager.release();
            this.clipboardManager = null;
        }
        this.removeAll();
        if (this.positionHandlers != null) {
            this.positionHandlers.clear();
        }
        this.model = null;
        this.pendingModelPath = null;
        this.pendingPositionHandler = null;
        this.renderImage = null;
    }

    @Override
    public boolean isLayoutValid() {
        return this.rootView.isLayoutValid();
    }

    @Override
    public boolean isContentValid() {
        return this.rootView.isContentValid();
    }

    @Override
    public void invalidate(int flag) {
        if (this.rootView != null) {
            this.rootView.invalidate(flag);
        }
    }

    @Override
    public void invalidate() {
    }

    public void invalidateAll(WmiView root) throws WmiNoReadAccessException {
        if (root != null) {
            root.invalidate(1);
            if (root instanceof WmiCompositeView) {
                WmiCompositeView parent = (WmiCompositeView)root;
                int c = 0;
                while (c < parent.getChildCount()) {
                    this.invalidateAll(parent.getChild(c));
                    ++c;
                }
            }
        }
    }

    protected void updateBreakWidth() {
        this.calculatePendingBreakWidth();
        if (this.pendingBreakWidth != this.breakWidth) {
            boolean locked = false;
            try {
                try {
                    locked = WmiModelLock.readLock(this.model, false);
                    if (locked) {
                        this.breakWidth = this.pendingBreakWidth;
                        this.revalidateLayout();
                        this.layoutView();
                    }
                }
                catch (WmiNoReadAccessException e) {
                    WmiErrorLog.log(e);
                    if (locked) {
                        WmiModelLock.readUnlock(this.model);
                    }
                }
            }
            finally {
                if (locked) {
                    WmiModelLock.readUnlock(this.model);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutView() {
        if (this.rootView == null || !this.isLayoutEnabled) {
            return;
        }
        boolean syncMarker = false;
        boolean locked = false;
        this.isInLayout = true;
        try {
            try {
                if (!WmiModelLock.ownsWriteLock(this.getModel())) {
                    locked = WmiModelLock.readLock(this.getModel(), true);
                }
                this.calculatePendingBreakWidth();
                if (this.pendingBreakWidth != this.breakWidth) {
                    syncMarker = true;
                    this.breakWidth = this.pendingBreakWidth;
                    this.revalidateLayout();
                }
                if (!SwingUtilities.isEventDispatchThread()) {
                    while (this.isPainting) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
                Object e = this.getTreeLock();
                synchronized (e) {
                    JViewport port;
                    Container parent = this.getParent();
                    JViewport jViewport = port = parent instanceof JViewport ? (JViewport)parent : null;
                    if (port != null) {
                        port.setScrollMode(0);
                    }
                    int oldWidth = this.rootView.getWidth();
                    int oldHeight = this.rootView.getHeight();
                    this.rootView.layoutView();
                    if (this.rootView.getHeight() < oldHeight) {
                        syncMarker = true;
                        this.repaint(0, this.rootView.getHeight() - 1, Math.max(oldWidth, this.rootView.getWidth() + 1), oldHeight - this.rootView.getHeight() + 2);
                    }
                    if (this.rootView.getWidth() != oldWidth) {
                        syncMarker = true;
                        if (this.currentSelection != null) {
                            this.currentSelection.resync();
                        }
                        this.repaint();
                    }
                    if (syncMarker && this.marker != null) {
                        this.marker.resync();
                    }
                    int leftIndent = this.getRootViewLeftIndent();
                    int drawWidth = Math.max(this.rootView.width, this.breakWidth) + 2 * leftIndent;
                    Dimension d = new Dimension(drawWidth, this.rootView.height);
                    this.rootView.x = leftIndent;
                    Rectangle visibleRegion = this.getVisibleRegion();
                    if (visibleRegion != null) {
                        d.height = Math.max(d.height, visibleRegion.height);
                        d.width = Math.max(d.width, visibleRegion.width);
                    }
                    if (this.docSize == null || this.docSize.height != d.height || this.docSize.width != d.width) {
                        this.docSize = d;
                        this.setSize(d);
                        if (this.docSize.width != d.width) {
                            this.repaint();
                        } else if (d.height > this.docSize.height) {
                            this.repaint(0, this.docSize.height - 1, d.width + 1, d.height - this.docSize.height + 2);
                        }
                    }
                    this.rootView.paintDirty();
                    this.layoutComponents();
                    if (port != null && this.pendingScrollPosition != null) {
                        SwingUtilities.invokeLater(new DelayedScroll((JViewport)parent, this.pendingScrollPosition));
                        this.pendingScrollPosition = null;
                    }
                    if (this.layoutDecorator != null && this.layoutDecorator.isVisible()) {
                        this.layoutDecorator.layoutView();
                        this.layoutDecorator.repaint();
                    }
                    this.isInLayout = false;
                }
            }
            catch (WmiNoReadAccessException e) {
                WmiErrorLog.log(e);
                if (locked) {
                    WmiModelLock.readUnlock(this.getModel());
                }
            }
        }
        finally {
            if (locked) {
                WmiModelLock.readUnlock(this.getModel());
            }
        }
    }

    protected void layoutComponents() {
        int i = 0;
        while (i < this.getComponentCount()) {
            Object potentialView;
            Component child = this.getComponent(i);
            if (child instanceof JComponent && (potentialView = ((JComponent)child).getClientProperty(COMPONENT_VIEW_PROPERTY)) instanceof WmiPositionedView) {
                WmiPositionedView view = (WmiPositionedView)potentialView;
                Point p = WmiViewUtil.getAbsoluteOffset(view);
                Point offset = (Point)((JComponent)child).getClientProperty(COMPONENT_OFFSET_PROPERTY);
                if (offset != null) {
                    p.x += offset.x;
                    p.y += offset.y;
                }
                child.setLocation(p);
            }
            ++i;
        }
    }

    protected int getRootViewLeftIndent() {
        return 5;
    }

    @Override
    public void paintDirty() {
        if (this.rootView != null) {
            this.rootView.paintDirty();
        }
    }

    @Override
    public void checkRepaint() {
        if (this.rootView != null) {
            this.rootView.checkRepaint();
        }
    }

    @Override
    public void resetPaintFlags() {
        if (this.rootView != null) {
            this.rootView.resetPaintFlags();
        }
    }

    @Override
    public void forceRepaint() {
        if (this.rootView != null) {
            this.rootView.forceRepaint();
        }
    }

    @Override
    public boolean getCheckRepaint() {
        return this.rootView != null ? this.rootView.getCheckRepaint() : false;
    }

    @Override
    public boolean getForceRepaint() {
        return this.rootView != null ? this.rootView.getForceRepaint() : false;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    @Override
    public String debugPrint(int indent) throws WmiNoReadAccessException {
        return this.rootView != null ? this.rootView.debugPrint(indent) : "";
    }

    @Override
    public String getDebugName() {
        return "Document";
    }

    @Override
    public WmiCompositeView getParentView() {
        return null;
    }

    @Override
    public void setParentView(WmiCompositeView parent) {
        throw new UnsupportedOperationException();
    }

    public void setInputInhibit(boolean inhibit) {
        if (this.documentMouseListener != null) {
            this.documentMouseListener.setDispatchInhibit(inhibit);
        }
    }

    @Override
    public Insets getAutoscrollInsets() {
        Rectangle r = this.getVisibleRegion();
        return r != null ? new Insets(r.y + WmiMathDocumentView.SCROLL_INSETS.top, r.x + WmiMathDocumentView.SCROLL_INSETS.left, r.y + r.height - WmiMathDocumentView.SCROLL_INSETS.bottom, r.x + r.width - WmiMathDocumentView.SCROLL_INSETS.right) : null;
    }

    @Override
    public void autoscroll(Point location) {
        Rectangle r = this.getVisibleRegion();
        int dy = 0;
        if (r != null) {
            if (location.y < r.y + WmiMathDocumentView.SCROLL_INSETS.top) {
                dy = -15;
            } else if (location.y > r.y + r.height - WmiMathDocumentView.SCROLL_INSETS.bottom) {
                dy = 15;
            }
            if (dy != 0) {
                int limit;
                r.y += dy;
                if (r.y < 0) {
                    r.y = 0;
                }
                int n = limit = this.rootView != null ? this.rootView.getHeight() : this.getHeight();
                if ((limit -= r.height) < 0) {
                    limit = 0;
                }
                if (r.y > limit) {
                    r.y = limit;
                }
                this.setScrollPosition(r.x, r.y);
            }
        }
    }

    public WmiClipboardManager getClipboardManager() {
        if (this.clipboardManager == null) {
            this.clipboardManager = new WmiClipboardManager(this);
        }
        return this.clipboardManager;
    }

    @Override
    public void setPositionMarker(int offset) {
        if (this.rootView != null) {
            this.rootView.setPositionMarker(offset);
        }
    }

    @Override
    public int getBaseline() {
        int baseline = 0;
        if (this.rootView != null) {
            baseline = this.rootView.getBaseline();
        }
        return baseline;
    }

    @Override
    public void setBaseline(int baseline) {
        if (this.rootView != null) {
            this.rootView.setBaseline(baseline);
        }
    }

    @Override
    public void setHorizontalOffset(int x) {
        if (this.rootView != null) {
            this.rootView.setHorizontalOffset(x);
        }
    }

    @Override
    public void setVerticalOffset(int y) {
        if (this.rootView != null) {
            this.rootView.setVerticalOffset(y);
        }
    }

    @Override
    public int getHorizontalOffset() {
        int offset = 0;
        if (this.rootView != null) {
            offset = this.rootView.getHorizontalOffset();
        }
        return offset;
    }

    @Override
    public int getVerticalOffset() {
        int offset = 0;
        if (this.rootView != null) {
            offset = this.rootView.getVerticalOffset();
        }
        return offset;
    }

    @Override
    public WmiPositionedView getChildView(Point pt) {
        WmiPositionedView view = null;
        if (this.rootView != null) {
            view = this.rootView.getChildView(pt);
        }
        return view;
    }

    @Override
    public boolean getIntersectingChildViews(Shape shape, WmiAggregateSelection selection, int selectionOp) {
        return false;
    }

    @Override
    public WmiPositionedView getViewForNavigation(int location, Point pt) {
        return this.getNearestChildView(pt);
    }

    @Override
    public WmiPositionedView getNearestChildView(Point pt) {
        WmiPositionedView view = null;
        if (this.rootView != null) {
            view = this.rootView.getNearestChildView(pt);
        }
        return view;
    }

    @Override
    public void setHeight(int height) {
        if (this.rootView != null) {
            this.rootView.setHeight(height);
        }
        if (this.layoutDecorator != null) {
            this.layoutDecorator.setHeight(height);
        }
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        if (this.layoutDecorator != null) {
            this.layoutDecorator.setHeight(height);
        }
    }

    @Override
    public void setWidth(int width) {
        if (this.rootView != null) {
            this.rootView.setWidth(width);
        }
    }

    public boolean isBelowDocument(int y) {
        if (this.rootView != null) {
            return y > this.rootView.getHeight();
        }
        return false;
    }

    @Override
    public WmiMathDocumentView getDocumentView() {
        return this;
    }

    @Override
    public void draw(Graphics g, WmiRenderPath path, Rectangle bounds) {
        boolean backstoreEnable;
        Graphics2D imageg = null;
        Graphics drawg = g;
        boolean bl = backstoreEnable = this.getSelection() == null;
        if (backstoreEnable && (this.renderImage == null || this.renderImage.getWidth() < bounds.width || this.renderImage.getHeight() < bounds.height)) {
            GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice device = env.getDefaultScreenDevice();
            GraphicsConfiguration config = device.getDefaultConfiguration();
            this.renderImage = config.createCompatibleImage(bounds.width, bounds.height);
        }
        if (this.renderImage != null && backstoreEnable) {
            imageg = this.renderImage.createGraphics();
            ((Graphics)imageg).translate(-bounds.x, -bounds.y);
            drawg = imageg;
        }
        if (this.rootView != null && bounds != null) {
            int x = bounds.x;
            int y = bounds.y;
            int width = bounds.width;
            int height = bounds.height;
            if (RuntimePlatform.isMac()) {
                path.drawStringsWithGlyphVectors(false);
            }
            Color saveColor = g.getColor();
            Rectangle clip = g.getClipBounds();
            if (this.isOpaque()) {
                drawg.setColor(this.getColor(0));
                if (clip != null) {
                    x = Math.max(bounds.x, clip.x);
                    y = Math.max(bounds.y, clip.y);
                    width = Math.min(bounds.x + bounds.width, clip.x + clip.width) - x;
                    height = Math.min(bounds.y + bounds.height, clip.y + clip.height) - y;
                }
                if (width > 0 && height > 0) {
                    drawg.fillRect(x, y, width, height);
                }
            }
            WmiSelection selection = this.getSelection();
            WmiHighlightPainter highlighter = null;
            boolean paintSelectionHighlighter = false;
            if (selection != null && (highlighter = selection.getSelectionHighlighter()) != null) {
                boolean documentIsActiveContainer = this.activeContainer() == this;
                boolean selectionEnclosesActiveContainer = documentIsActiveContainer ? false : this.selectionIncludesContainer(this.activeContainer());
                boolean bl2 = paintSelectionHighlighter = documentIsActiveContainer || selectionEnclosesActiveContainer;
            }
            if (paintSelectionHighlighter && highlighter.getDrawingLayer() == 0) {
                this.paintSelectionHighlightInContext(drawg);
            }
            drawg.setColor(saveColor);
            if (this.isInLayout) {
                if (clip != null) {
                    this.repaint(clip);
                } else {
                    this.repaint();
                }
            } else {
                if (clip != null) {
                    drawg.clipRect(clip.x, clip.y, clip.width, clip.height);
                }
                this.rootView.draw(drawg, path, bounds);
            }
            if (paintSelectionHighlighter && highlighter.getDrawingLayer() == 1) {
                this.paintSelectionHighlightInContext(drawg);
            }
            drawg.setClip(null);
            if (this.highlightPainters != null) {
                for (WmiHighlightPainter p : this.highlightPainters) {
                    p.paint(drawg);
                }
            }
            drawg.setClip(clip);
            if (imageg != null) {
                imageg.dispose();
                g.drawImage(this.renderImage, x, y, x + width, y + height, x - bounds.x, y - bounds.y, x - bounds.x + width, y - bounds.y + height, Color.WHITE, null);
            }
        }
    }

    public WmiCompositeModel getDeleteBoundary(WmiCompositeModel parent) throws WmiNoReadAccessException {
        return null;
    }

    @Override
    public void doLayout() {
    }

    public void notifyMousePressed(MouseEvent e) {
    }

    @Override
    public Point getContainerOffset() {
        return CONTAINER_OFFSET;
    }

    @Override
    public boolean mergeFragmentsOnUpdate() {
        return false;
    }

    public void addHighlightPainter(WmiHighlightPainter p) {
        if (!this.highlightPainters.contains(p)) {
            this.highlightPainters.add(p);
        }
    }

    public void removeHighlightPainter(WmiHighlightPainter p) {
        if (this.highlightPainters != null) {
            this.highlightPainters.remove(p);
        }
    }

    @Override
    public void inputMethodTextChanged(InputMethodEvent event) {
    }

    @Override
    public void caretPositionChanged(InputMethodEvent event) {
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.marker != null) {
            this.marker.show();
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (this.marker != null) {
            JRootPane oppRoot;
            JRootPane myRoot;
            Component opp;
            boolean hideMarker = true;
            if (!(this.marker instanceof WmiCaret) && (opp = e.getOppositeComponent()) instanceof JComponent && (myRoot = this.getRootPane()) == (oppRoot = ((JComponent)opp).getRootPane())) {
                hideMarker = false;
            }
            if (hideMarker) {
                this.marker.hide();
            }
            if (this.marker instanceof WmiEightPointResizer) {
                this.getMouseListener().setDragViewToReceiveMove(false);
            }
        }
    }

    public WmiParagraphModel getCurrentParagraphModel() throws WmiNoReadAccessException {
        WmiPositionedView view;
        WmiParagraphModel paragraph = null;
        if (this.marker != null && (view = this.marker.getView()) != null) {
            WmiModel markerModel = view.getModel();
            if (!(markerModel instanceof WmiParagraphModel)) {
                markerModel = WmiModelUtil.findAncestorOfTag(markerModel, WmiModelTag.PARAGRAPH);
            }
            if (markerModel instanceof WmiParagraphModel) {
                paragraph = (WmiParagraphModel)markerModel;
            }
        }
        return paragraph;
    }

    public void resetSelectionOnUpdate() throws WmiNoReadAccessException {
        this.pendingSelectionReset = true;
        this.pendingModelPath = null;
        if (this.currentSelection != null) {
            WmiModel[] modelBounds = new WmiModel[2];
            int[] offsetBounds = new int[2];
            this.currentSelection.getModelInterval(modelBounds, offsetBounds);
            WmiModel boundModel = modelBounds[0];
            if (boundModel != null) {
                this.pendingModelPath = new WmiModelPath(boundModel);
                this.pendingModelPath.push(offsetBounds[0]);
                this.pendingPositionHandler = null;
            }
        }
    }

    public void setPendingPositionUpdateHandler(WmiPositionUpdateHandler handler) {
        this.pendingPositionHandler = handler;
    }

    public void setPendingPosition(WmiModelPosition position) {
        WmiDefaultPositionUpdateHandler posHandler = new WmiDefaultPositionUpdateHandler(this, position);
        this.setPendingPositionUpdateHandler(posHandler);
    }

    public void setPendingPosition(WmiModel model, int position) {
        this.setPendingPosition(new WmiModelPosition(model, position));
    }

    public void addPositionUpdateHandler(WmiPositionUpdateHandler handler) {
        if (!this.positionHandlers.contains(handler)) {
            this.positionHandlers.add(handler);
        }
    }

    public void removePositionUpdateHandler(WmiPositionUpdateHandler handler) {
        this.positionHandlers.remove(handler);
    }

    private void dispatchPositionUpdate() {
        int i = this.positionHandlers.size() - 1;
        while (i >= 0) {
            block10: {
                WmiPositionUpdateHandler positionHandler = (WmiPositionUpdateHandler)this.positionHandlers.get(i);
                WmiMathDocumentModel docModel = (WmiMathDocumentModel)this.getModel();
                boolean hasWriteLock = WmiModelLock.ownsWriteLock(docModel);
                if (hasWriteLock || WmiModelLock.readLock(docModel, true)) {
                    try {
                        try {
                            positionHandler.updatePosition();
                        }
                        catch (WmiNoReadAccessException e) {
                            WmiErrorLog.log(e);
                            if (!hasWriteLock) {
                                WmiModelLock.readUnlock(docModel);
                            }
                            break block10;
                        }
                    }
                    catch (Throwable throwable) {
                        if (!hasWriteLock) {
                            WmiModelLock.readUnlock(docModel);
                        }
                        throw throwable;
                    }
                    if (!hasWriteLock) {
                        WmiModelLock.readUnlock(docModel);
                    }
                }
            }
            --i;
        }
    }

    public void updateNotify() {
        block13: {
            boolean locked = false;
            WmiMathDocumentModel myModel = (WmiMathDocumentModel)this.getModel();
            if (!WmiModelLock.ownsWriteLock(myModel)) {
                locked = WmiModelLock.readLock(myModel, true);
            }
            try {
                try {
                    if (this.pendingPositionHandler != null) {
                        this.pendingPositionHandler.updatePosition();
                    } else if (this.pendingSelectionReset) {
                        if (this.pendingModelPath != null) {
                            this.pendingModelPath = this.adjustModelPath(this.pendingModelPath);
                            this.updatePosition(this.pendingModelPath, 0);
                        }
                        this.setSelection(null);
                    }
                }
                catch (WmiNoReadAccessException e) {
                    WmiErrorLog.log(e);
                    if (locked) {
                        WmiModelLock.readUnlock(myModel);
                    }
                    break block13;
                }
            }
            catch (Throwable throwable) {
                if (locked) {
                    WmiModelLock.readUnlock(myModel);
                }
                throw throwable;
            }
            if (locked) {
                WmiModelLock.readUnlock(myModel);
            }
        }
        this.pendingSelectionReset = false;
        this.pendingModelPath = null;
        this.pendingPositionHandler = null;
    }

    public void notifyPopupRequest(WmiView view, MouseEvent e) {
        if (view instanceof WmiPositionedView && !this.isInHighlight(e, (WmiPositionedView)view) && (this.getSelection() != null || this.marker == null || this.marker.getView() != view)) {
            WmiMathDocumentMouseListener.snapToNearestView(e, view);
            WmiMathDocumentMouseListener.updateSelection(e);
        }
    }

    protected void calculatePendingBreakWidth() {
        Container parent = this.getParent();
        if (parent instanceof JViewport) {
            Rectangle r = ((JViewport)parent).getViewRect();
            this.pendingBreakWidth = r.width - 10;
        }
        if (this.pendingBreakWidth <= 0) {
            this.pendingBreakWidth = 400;
        }
    }

    protected WmiRowView createRootView(WmiModel docModel, String name) {
        return new WmiRowView(docModel, this, name);
    }

    private void registerTestKeys() {
        this.registerKeyboardAction(new DebugPrintAction(this, false, true), "Debug-Print-Light-Views", KeyStroke.getKeyStroke(112, 9, false), 2);
        this.registerKeyboardAction(new DebugPrintAction(this, true, true), "Debug-Print-Verbose-Views", KeyStroke.getKeyStroke(113, 9, false), 2);
        this.registerKeyboardAction(new DebugPrintAction(this, false, false), "Debug-Print-Light", KeyStroke.getKeyStroke(112, 8, false), 2);
        this.registerKeyboardAction(new DebugPrintAction(this, true, false), "Debug-Print-Verbose", KeyStroke.getKeyStroke(113, 8, false), 2);
    }

    protected void createListeners() {
        this.documentMouseListener = new WmiMathDocumentMouseListener(this);
        this.addMouseListener(this.documentMouseListener);
        this.addMouseMotionListener(this.documentMouseListener);
        this.addMouseWheelListener(this.documentMouseListener);
        this.addFocusListener(this);
        this.documentKeyListener = new WmiMathDocumentKeyListener(this);
        this.addKeyListener(this.documentKeyListener);
        if (RuntimePlatform.isWindows() || RuntimePlatform.isMac()) {
            this.inputHandler = new WmiInputMethodRequestHandler(this);
        }
        this.addInputMethodListener(this.inputHandler);
    }

    public void setFocusedView(WmiView view) {
        this.focusView = view;
        if (view != null) {
            boolean grabRootFocus;
            boolean bl = grabRootFocus = !this.hasFocus();
            if (view instanceof WmiPositionedView) {
                WmiPositionedView posView = (WmiPositionedView)view;
                Point pt = WmiViewUtil.getAbsoluteOffset(posView);
                pt.x += posView.getWidth() / 2;
                pt.y += posView.getHeight() / 2;
                Component child = this.getComponentAt(pt);
                if (child != null && child != this) {
                    grabRootFocus = false;
                }
            }
            if (grabRootFocus && WmiMathDocumentView.getActiveDocumentView() == this) {
                this.requestFocus();
            }
        }
        if (this.documentKeyListener != null) {
            this.documentKeyListener.setFocus(view);
        }
    }

    public WmiView getFocusedView() {
        return this.focusView;
    }

    public void notifyMarkerPositionChanged() {
        if (this.contextManager != null) {
            this.contextManager.positionChangeNotification(this);
        }
        this.dispatchPositionUpdate();
    }

    public Point getLastMousePoint() {
        return this.documentMouseListener.getLastMousePoint();
    }

    public WmiView getDragSourceView() {
        return this.documentMouseListener.getDragSourceView();
    }

    public WmiView getDropTargetView() {
        return this.documentMouseListener.getDropTargetView();
    }

    public void notifyDragAndDropComplete(WmiModel changeModel, Point mouseLocInView) {
        this.documentMouseListener.notifyDragAndDropComplete(changeModel, mouseLocInView);
    }

    public void notifyViewLostFocus(WmiView view) {
    }

    public WmiMathDocumentMouseListener getMouseListener() {
        return this.documentMouseListener;
    }

    public WmiMathDocumentKeyListener getKeyListener() {
        return this.documentKeyListener;
    }

    public WmiViewFactory getViewFactory() {
        return this.factory;
    }

    public WmiCaret getCaret() {
        return this.marker instanceof WmiCaret ? (WmiCaret)this.marker : null;
    }

    public WmiPositionMarker getPositionMarker() {
        return this.marker;
    }

    public boolean isMarkerInSubcontainer() {
        WmiPositionedView markerView;
        boolean isInSubcontainer = false;
        if (this.marker != null && (markerView = this.marker.getView()) != null) {
            isInSubcontainer = WmiViewUtil.isInSubcontainer(markerView);
        }
        return isInSubcontainer;
    }

    public void setPositionMarker(WmiPositionMarker newMarker) {
        if (this.marker != null) {
            this.marker.hide();
        }
        this.marker = newMarker;
        if (this.marker != null) {
            this.marker.show();
        }
        this.notifyMarkerPositionChanged();
    }

    protected WmiModelPath adjustModelPath(WmiModelPath path) throws WmiNoReadAccessException {
        WmiModelPath newPath = path;
        WmiCompositeModel adjustModel = (WmiCompositeModel)this.getModel();
        int depth = path.depth();
        int[] adjustedPath = new int[depth];
        int i = 0;
        while (i < depth) {
            int index = path.peek(i);
            if (index < adjustModel.getChildCount()) {
                adjustedPath[i] = index;
                WmiModel child = adjustModel.getChild(index);
                if (!(child instanceof WmiCompositeModel)) break;
                adjustModel = (WmiCompositeModel)child;
            } else {
                int n;
                block8: {
                    WmiModel child;
                    n = i;
                    if (adjustModel.getChildCount() == 0) {
                        adjustModel = adjustModel.getParent();
                        --n;
                    }
                    while (true) {
                        if (n + 1 >= depth) {
                            int[] expandedPath = new int[2 * depth];
                            System.arraycopy(adjustedPath, 0, expandedPath, 0, depth);
                            adjustedPath = expandedPath;
                            depth *= 2;
                        }
                        if ((index = adjustModel.getChildCount()) <= 0) break block8;
                        adjustedPath[n++] = index - 1;
                        child = adjustModel.getChild(index - 1);
                        if (!(child instanceof WmiCompositeModel)) break;
                        adjustModel = (WmiCompositeModel)child;
                    }
                    if (child instanceof WmiTextModel) {
                        adjustedPath[n++] = ((WmiTextModel)child).getLength();
                    }
                }
                newPath = new WmiModelPath();
                int j = 0;
                while (j < n) {
                    newPath.push(adjustedPath[j]);
                    ++j;
                }
                break;
            }
            ++i;
        }
        return newPath;
    }

    public void updatePosition(WmiModelPath path, int scroll) throws WmiNoReadAccessException {
        this.updatePosition(path.getModelPosition((WmiMathDocumentModel)this.getModel()), scroll);
    }

    /*
     * Unable to fully structure code
     */
    public void updatePosition(WmiModelPosition position, int scroll) throws WmiNoReadAccessException {
        block24: {
            block25: {
                resolved = false;
                if (position == null) break block24;
                posModel = position.getModel();
                offset = position.getOffset();
                if (posModel instanceof WmiMathSpaceModel && WmiViewUtil.modelToView(this, posModel, 0) == null) {
                    parent = posModel.getParent();
                    v0 = index = parent != null ? parent.indexOf(posModel) : -1;
                    if (index >= 0) {
                        position = new WmiModelPosition(parent, index + 1);
                        this.updatePosition(position, scroll);
                        return;
                    }
                }
                if (!(posModel instanceof WmiCompositeModel)) break block25;
                view = WmiViewUtil.modelToView(this, posModel, 0);
                if (view == null && posModel instanceof WmiMathFencedModel) {
                    fence = (WmiMathFencedModel)posModel;
                    if (offset == 0) {
                        left = fence.getModelForLeft();
                        if (left != null) {
                            posModel = left;
                            offset = 0;
                            view = WmiViewUtil.modelToView(this, posModel, 0);
                        }
                    } else if (offset == -1 && (right = fence.getModelForRight()) != null) {
                        posModel = right;
                        offset = -1;
                        view = WmiViewUtil.modelToView(this, posModel, 0);
                    }
                }
                if (!WmiViewUtil.isTraversableView(view)) ** GOTO lbl55
                ((WmiPositionedView)view).setPositionMarker(offset);
                resolved = true;
                break block25;
lbl-1000:
                // 1 sources

                {
                    tag = posModel.getTag();
                    if (posModel instanceof WmiMathModel && tag != WmiModelTag.MATH && tag != WmiModelTag.MATH_ROW && tag != WmiModelTag.MATH_TABLE_CELL && tag != WmiModelTag.MATH_TABLE_ROW && tag != WmiModelTag.MATH_TABLE_LABELED_ROW) break;
                    comp = (WmiCompositeModel)posModel;
                    size = comp.getChildCount();
                    if (size > 0 && offset < size) {
                        if (offset >= 0) {
                            posModel = comp.getChild(offset);
                            offset = 0;
                            continue;
                        }
                        posModel = comp.getChild(size - 1);
                        offset = -1;
                        continue;
                    }
                    sibling = null;
                    while (sibling == null && comp != null) {
                        cParent = comp.getParent();
                        if (cParent == null) break;
                        index = cParent.indexOf(comp);
                        if (index < cParent.getChildCount() - 1) {
                            sibling = cParent.getChild(index + 1);
                            continue;
                        }
                        comp = cParent;
                    }
                    posModel = sibling;
                    offset = 0;
lbl55:
                    // 4 sources

                    ** while (posModel instanceof WmiCompositeModel)
                }
            }
            if (posModel instanceof WmiMathModel && !resolved) {
                currentCaret = this.getCaret();
                if (!(currentCaret instanceof WmiMathCaret)) {
                    currentCaret = new WmiMathCaret(this);
                    this.setPositionMarker(currentCaret);
                }
                currentCaret.updateMarkerPosition(posModel, offset);
                resolved = true;
            } else if (posModel instanceof WmiTextModel && !resolved) {
                currentCaret = this.getCaret();
                if (currentCaret == null || currentCaret instanceof WmiMathCaret) {
                    currentCaret = new WmiCaret(this);
                    this.setPositionMarker(currentCaret);
                }
                currentCaret.updateMarkerPosition(posModel, offset);
                resolved = true;
            } else if (posModel != null && !resolved && (view = WmiViewUtil.modelToView(this, posModel, 0)) instanceof WmiPositionedView) {
                ((WmiPositionedView)view).setPositionMarker(offset);
                resolved = true;
            }
        }
        if (!resolved) {
            this.setPositionMarker(null);
        }
        if (this.marker != null) {
            if (scroll == 1) {
                this.marker.scrollVisible();
            } else if (scroll == 2) {
                this.marker.scrollToTop();
            }
        }
    }

    public WmiSelection getSelection() {
        return this.currentSelection;
    }

    public void setSelection(WmiSelection selection) {
        WmiHighlightPainter oldPainter = null;
        WmiHighlightPainter newPainter = null;
        if (this.currentSelection != null) {
            oldPainter = this.currentSelection.getSelectionHighlighter();
        }
        if (selection != null) {
            newPainter = selection.getSelectionHighlighter();
        }
        if (newPainter == null && oldPainter instanceof WmiSelectionHighlighter) {
            ((WmiSelectionHighlighter)oldPainter).computeDirtyRegions(null);
            ((WmiSelectionHighlighter)oldPainter).repaintDirtyRegions();
        } else if (newPainter instanceof WmiSelectionHighlighter) {
            ((WmiSelectionHighlighter)newPainter).computeDirtyRegions(oldPainter);
        }
        this.currentSelection = selection;
        this.fireSelectionChangeNotification(this.currentSelection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireSelectionChangeNotification(WmiSelection selection) {
        ArrayList arrayList = this.selectionChangeListeners;
        synchronized (arrayList) {
            for (WmiSelectionChangeListener listener : this.selectionChangeListeners) {
                listener.notifySelectionChange(selection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSelectionChangeListener(WmiSelectionChangeListener listener) {
        ArrayList arrayList = this.selectionChangeListeners;
        synchronized (arrayList) {
            if (!this.selectionChangeListeners.contains(listener)) {
                this.selectionChangeListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSelectionChangeListener(WmiSelectionChangeListener listener) {
        ArrayList arrayList = this.selectionChangeListeners;
        synchronized (arrayList) {
            if (this.selectionChangeListeners.contains(listener)) {
                this.selectionChangeListeners.remove(listener);
            }
        }
    }

    protected void removeLayoutDecorator() {
        if (this.layoutDecorator != null) {
            this.layoutDecorator.release();
        }
        this.layoutDecorator = null;
    }

    public WmiLayoutDecorator getLayoutDecorator() {
        return this.layoutDecorator;
    }

    public void setLayoutDecorator(WmiLayoutDecorator decorator) {
        if (decorator == this.layoutDecorator) {
            return;
        }
        this.removeLayoutDecorator();
        this.layoutDecorator = decorator;
        this.invalidate(1);
        final WmiMathDocumentView docView = this;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                docView.layoutView();
            }
        });
    }

    @Override
    public int getZoomFactor() {
        return this.zoom;
    }

    public void setTemporaryZoomFactor(int newZoom) {
        this.zoom = newZoom;
    }

    @Override
    public WmiView copyView() {
        return null;
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        Rectangle bounds;
        if (this.isInLayout) {
            Rectangle clip;
            if (this.renderImage != null) {
                int w = this.renderImage.getWidth();
                int h = this.renderImage.getHeight();
                bounds = this.getVisibleRegion();
                g.translate(bounds.x, bounds.y);
                g.drawImage(this.renderImage, 0, 0, w, h, 0, 0, w, h, Color.WHITE, null);
                g.translate(-bounds.x, -bounds.y);
            }
            if ((clip = g.getClipBounds()) != null) {
                this.repaint(clip);
            } else {
                this.repaint();
            }
        }
        if (this.isRepaintEnabled) {
            this.isPainting = true;
            try {
                Container parent = this.getParent();
                boolean resetScrollMode = parent instanceof JViewport && ((JViewport)parent).getScrollMode() != 1 && !this.isInLayout;
                bounds = this.getVisibleRegion();
                Graphics2D g2 = (Graphics2D)g;
                Object hint = g2.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
                FontRenderContext c = WmiFontMetrics.getScreenContext();
                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, c.isAntiAliased() ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
                this.draw(g, new WmiRenderPath(this), bounds);
                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, hint);
                if (this.getComponentCount() > 0) {
                    this.paintChildren(g);
                }
                if (parent instanceof JViewport) {
                    if (this.pendingScrollPosition != null) {
                        SwingUtilities.invokeLater(new DelayedScroll((JViewport)parent, this.pendingScrollPosition));
                        this.pendingScrollPosition = null;
                    }
                    if (resetScrollMode) {
                        ((JViewport)parent).setScrollMode(1);
                    }
                }
                this.paintMarkerInContext(g);
                this.pendingScrollPosition = null;
            }
            finally {
                this.isPainting = false;
            }
        }
    }

    public void paintMarkerInContext(Graphics context) {
        boolean activeDnD;
        WmiSelection selection = this.getSelection();
        boolean bl = activeDnD = this.clipboardManager != null ? this.clipboardManager.isEnabled() : false;
        if (!(this.marker == null || !activeDnD && selection != null && selection.hideCaret() && this.marker instanceof WmiCaret)) {
            this.marker.paint(context);
        }
    }

    public void paintSelectionHighlightInContext(Graphics context) {
        WmiHighlightPainter highlighter;
        WmiSelection selection = this.getSelection();
        if (selection != null && (highlighter = selection.getSelectionHighlighter()) != null) {
            highlighter.paint(context);
        }
    }

    public boolean selectionIncludesContainer(WmiView container) {
        boolean included = false;
        if (this.currentSelection != null && container != null) {
            included = this.currentSelection.contains(container) == 2;
        }
        return included;
    }

    public int getBreakWidth() {
        return this.breakWidth;
    }

    public Rectangle getVisibleRegion() {
        Rectangle r = null;
        Container parent = this.getParent();
        r = parent instanceof JViewport ? ((JViewport)parent).getViewRect() : this.getBounds();
        return r;
    }

    public void setVisibleRegion(int x, int y) {
        Container parent;
        Point p = new Point(x, y);
        if (p.x < 0) {
            p.x = 0;
        }
        if (p.y < 0) {
            p.y = 0;
        }
        if ((parent = this.getParent()) instanceof JViewport) {
            if (this.isInLayout || this.isPainting) {
                this.pendingScrollPosition = p;
            } else {
                ((JViewport)parent).setViewPosition(p);
            }
        }
    }

    public void setScrollPosition(int x, int y, boolean liveScroll) {
        if (this.isScrolling()) {
            return;
        }
        Container parent = this.getParent();
        if (parent instanceof JViewport) {
            if (x < 0) {
                x = 0;
            }
            if (y < 0) {
                y = 0;
            }
            if (this.isInLayout || this.isPainting) {
                this.pendingScrollPosition = new Point(x, y);
            } else {
                JViewport port = (JViewport)parent;
                if (liveScroll) {
                    Thread t = new Thread(new Scroller(port, x, y));
                    t.setName("live scroller");
                    t.setPriority(10);
                    t.start();
                } else {
                    port.setViewPosition(new Point(x, y));
                }
            }
        }
    }

    @Override
    public void setScrollPosition(int x, int y) {
        this.setScrollPosition(x, y, false);
    }

    public void setScrollPositionToView(WmiPositionedView view) {
        Point p = WmiViewUtil.getAbsoluteOffset(view);
        this.setScrollPosition(0, p.y, true);
    }

    public synchronized boolean isScrolling() {
        return this.isScrolling;
    }

    public boolean isPrintView() {
        return false;
    }

    public Cursor getDefaultCursor() {
        return Cursor.getPredefinedCursor(2);
    }

    protected void revalidateLayout() throws WmiNoReadAccessException {
        this.invalidate(this.rootView, WmiModelTag.PARAGRAPH);
        this.invalidateAdaptiveViews(this.rootView);
    }

    public void invalidate(WmiView view, WmiModelTag target) throws WmiNoReadAccessException {
        WmiModelTag tag;
        WmiModel invalidModel = view != null ? view.getModel() : null;
        WmiModelTag wmiModelTag = tag = invalidModel != null ? invalidModel.getTag() : null;
        if (tag != null && tag.equals(target)) {
            view.invalidate(1);
        } else if (view instanceof WmiCompositeView) {
            WmiCompositeView composite = (WmiCompositeView)view;
            int length = composite.getChildCount();
            int i = 0;
            while (i < length) {
                WmiView child = composite.getChild(i);
                this.invalidate(child, target);
                ++i;
            }
        }
    }

    protected void invalidateAdaptiveViews(WmiView base) {
        if (base instanceof WmiAdaptiveLayoutView) {
            base.invalidate(1);
        }
        if (base instanceof WmiCompositeView) {
            WmiCompositeView composite = (WmiCompositeView)base;
            int length = composite.getChildCount();
            int i = 0;
            while (i < length) {
                WmiView child = composite.getChild(i);
                this.invalidateAdaptiveViews(child);
                ++i;
            }
        }
    }

    public void invalidate(WmiModelTag tag) throws WmiNoReadAccessException {
        this.invalidate(this.rootView, tag);
    }

    @Override
    public boolean isRequestFocusEnabled() {
        return true;
    }

    @Override
    public boolean isFocusCycleRoot() {
        return true;
    }

    @Override
    public InputMethodRequests getInputMethodRequests() {
        return this.inputHandler;
    }

    public Color getColor(int index) {
        Color c = null;
        if (index >= 0 && index < 5) {
            c = this.colorTable[index];
        }
        return c;
    }

    public void setColor(Color c, int index) {
        if (index >= 0 && index < 5) {
            this.colorTable[index] = c;
        }
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
        this.setColor(c, 0);
    }

    @Override
    public Color getBackground() {
        return this.getColor(0);
    }

    @Override
    public void updateUI() {
        this.initializeColorTable();
    }

    private void initializeColorTable() {
        String prefix = RESOURCE_PREFIX;
        this.colorTable = new Color[5];
        this.colorTable[0] = UIManager.getColor(String.valueOf(prefix) + ".background");
        this.colorTable[1] = UIManager.getColor(String.valueOf(prefix) + ".foreground");
        this.colorTable[2] = UIManager.getColor(String.valueOf(prefix) + ".caretForeground");
        this.colorTable[4] = UIManager.getColor(String.valueOf(prefix) + ".selectionBackground");
        this.colorTable[3] = UIManager.getColor(String.valueOf(prefix) + ".selectionForeground");
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        int block = 0;
        if (orientation == 0) {
            block = (int)visibleRect.getWidth();
        } else if (orientation == 1) {
            block = (int)visibleRect.getHeight();
        }
        return block;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle arg0, int orientation, int direction) {
        return 15;
    }

    public static WmiMathDocumentView getActiveDocumentView() {
        return activeDocumentView;
    }

    public static void setActiveDocumentView(WmiMathDocumentView view) {
        activeDocumentView = view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WmiScrollableContainerView activeContainer() {
        WmiScrollableContainerView container = null;
        Object object = this.activeContainerAccessLock;
        synchronized (object) {
            container = this.activeContainerView;
        }
        return container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActiveContainer(WmiScrollableContainerView view) {
        Object object = this.activeContainerAccessLock;
        synchronized (object) {
            this.activeContainerView = view;
        }
    }

    @Override
    public WmiPositionedView getNextView(int direction) {
        return null;
    }

    @Override
    public void setNextView(WmiPositionedView next, int direction) {
        if (this.rootView != null) {
            this.rootView.setNextView(next, direction);
        }
    }

    @Override
    public void addNavigationLinks() {
        if (this.rootView != null) {
            this.rootView.addNavigationLinks();
        }
    }

    @Override
    public boolean isNavagableView() {
        return true;
    }

    public boolean isInHighlight(MouseEvent e) {
        boolean enabled = false;
        WmiHighlightPainter highlighter = this.currentSelection != null ? this.currentSelection.getSelectionHighlighter() : null;
        WmiPositionInView pinv = WmiViewUtil.getPositionInView(e);
        Point origin = WmiViewUtil.getAbsoluteOffset(pinv.getView());
        origin.translate(pinv.getPosition().x, pinv.getPosition().y);
        if (highlighter != null) {
            enabled = highlighter.isInsideHighlight(origin);
        }
        return enabled;
    }

    public boolean isInHighlight(WmiPositionedView view) {
        boolean enabled = false;
        WmiHighlightPainter highlighter = this.currentSelection != null ? this.currentSelection.getSelectionHighlighter() : null;
        Point origin = WmiViewUtil.getAbsoluteOffset(view);
        if (highlighter != null && highlighter.isInsideHighlight(origin)) {
            enabled = true;
        }
        return enabled;
    }

    public boolean isInHighlight(MouseEvent e, WmiPositionedView view) {
        boolean inside = false;
        WmiSelection selection = this.getSelection();
        try {
            inside = this.isInHighlight(e);
        }
        catch (NullPointerException npe) {
            inside = this.isInHighlight(view);
        }
        return inside;
    }

    public int getLastHorizontalPosition() {
        return this.lastHorizontalPosition;
    }

    public void saveLastHorizontalPosition() {
        WmiPositionMarker marker = this.getPositionMarker();
        if (marker != null) {
            this.lastHorizontalPosition = marker instanceof WmiMathCaret ? ((WmiMathCaret)marker).getUprightPosition() : marker.getBounds().x;
        }
    }

    @Override
    public void insertView(WmiView view, int offset) {
    }

    @Override
    public WmiView splitView(int offset, int consume) {
        return null;
    }

    @Override
    public int doExplicitLinebreak(WmiParagraphView paragraph) {
        return 0;
    }

    @Override
    public int doImplicitLinebreak(WmiParagraphView paragraph, int horizontalOffset, int breakWidth, int thresholdCost) {
        return 0;
    }

    @Override
    public int doForcedLinebreak(WmiParagraphView paragraph, int horizontalOffset, int breakWidth) {
        return 0;
    }

    @Override
    public boolean hasGoodBreakpoint(int horizontalOffset, int breakWidth, int thresholdCost) throws WmiNoReadAccessException {
        return false;
    }

    @Override
    public int getWidthConstraint(boolean ignoreTopLevelView) {
        return ignoreTopLevelView ? -1 : this.getBreakWidth();
    }

    @Override
    public int getHeightConstraint() {
        return -1;
    }

    public boolean getSkipAutoexecWarning() {
        return this.skipAutoexecWarning;
    }

    public void setSkipAutoexecWarning(boolean b) {
        this.skipAutoexecWarning = b;
    }

    private static class DebugPrintAction
    implements ActionListener {
        private boolean isVerbose = false;
        private boolean views = false;
        private WmiMathDocumentView view;

        private DebugPrintAction(WmiMathDocumentView view, boolean verbose, boolean withViews) {
            this.view = view;
            this.isVerbose = verbose;
            this.views = withViews;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            WmiMathDocumentModel doc = (WmiMathDocumentModel)this.view.getModel();
            if (WmiModelLock.readLock(doc, true)) {
                try {
                    try {
                        WmiModelPathInterval span = null;
                        WmiSelection selection = this.view.getSelection();
                        if (selection != null) {
                            WmiViewPath beginPath = selection.getSelectionStartPath();
                            WmiViewPath endPath = selection.getSelectionEndPath();
                            WmiModelPath begin = new WmiModelPath(beginPath.createModelPosition(this.view));
                            WmiModelPath end = new WmiModelPath(endPath.createModelPosition(this.view));
                            span = new WmiModelPathInterval(begin, end);
                        }
                        if (this.isVerbose) {
                            doc.debugPrintVerbose(span);
                        } else {
                            doc.debugPrintLight(span);
                        }
                        if (this.views) {
                            System.out.println(this.view.debugPrint(0));
                        }
                    }
                    catch (WmiInvalidModelInitializationException wmiInvalidModelInitializationException) {
                        WmiModelLock.readUnlock(doc);
                    }
                    catch (WmiNoReadAccessException wmiNoReadAccessException) {
                        WmiModelLock.readUnlock(doc);
                    }
                }
                finally {
                    WmiModelLock.readUnlock(doc);
                }
            }
        }
    }

    private class DelayedScroll
    implements Runnable {
        JViewport port;
        Point pt;

        private DelayedScroll(JViewport port, Point pt) {
            this.port = port;
            this.pt = pt;
        }

        @Override
        public void run() {
            if (WmiMathDocumentView.this.isPainting || WmiMathDocumentView.this.isInLayout) {
                SwingUtilities.invokeLater(this);
            } else {
                WmiMathDocumentView.this.repaint();
                this.port.setViewPosition(this.pt);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        WmiMathDocumentView.this.repaint();
                    }
                });
            }
        }
    }

    private class Scroller
    implements Runnable {
        public static final int DEFAULT_SCROLL_TIME = 300;
        public static final int DEFAULT_SCROLL_STEPS = 20;
        private static final int MINIMUM_SCROLL_WAIT_TIME = 20;
        private int scrollTime = -1;
        private int scrollSteps = -1;
        private long scrollStartTime = -1L;
        private JViewport viewport = null;
        private int scrollEndX = -1;
        private int scrollEndY = -1;

        private Scroller(JViewport viewport, int scrollTime, int scrollSteps, int scrollEndX, int scrollEndY) {
            this.viewport = viewport;
            this.scrollTime = scrollTime;
            this.scrollSteps = scrollSteps;
            this.scrollEndX = scrollEndX;
            this.scrollEndY = scrollEndY;
        }

        private Scroller(JViewport viewport, int scrollEndX, int scrollEndY) {
            this(viewport, 300, 20, scrollEndX, scrollEndY);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block26: {
                this.scrollStartTime = System.currentTimeMillis();
                Point p = this.viewport.getViewPosition();
                int waitTime = Math.max(20, this.scrollTime / this.scrollSteps);
                int scrollXIncrement = (this.scrollEndX - p.x) / this.scrollSteps;
                int scrollYIncrement = (this.scrollEndY - p.y) / this.scrollSteps;
                try {
                    try {
                        WmiMathDocumentView wmiMathDocumentView = WmiMathDocumentView.this;
                        synchronized (wmiMathDocumentView) {
                            WmiMathDocumentView.this.isScrolling = true;
                        }
                        int i = 1;
                        while (i <= this.scrollSteps) {
                            int newY;
                            int newX;
                            int shouldBeAtStep = (int)(System.currentTimeMillis() - this.scrollStartTime) * this.scrollSteps;
                            shouldBeAtStep /= this.scrollTime;
                            if (++shouldBeAtStep > i) {
                                i = shouldBeAtStep;
                            }
                            boolean xAtBounds = false;
                            boolean yAtBounds = false;
                            int n = newX = scrollXIncrement < 0 ? Math.max(this.scrollEndX, p.x + (i + 1) * scrollXIncrement) : Math.min(this.scrollEndX, p.x + (i + 1) * scrollXIncrement);
                            if (newX + this.viewport.getWidth() > WmiMathDocumentView.this.getWidth()) {
                                newX = WmiMathDocumentView.this.getWidth() - this.viewport.getWidth();
                                xAtBounds = true;
                            }
                            if (newX < 0) {
                                newX = 0;
                                xAtBounds = true;
                            }
                            int n2 = newY = scrollYIncrement < 0 ? Math.max(this.scrollEndY, p.y + (i + 1) * scrollYIncrement) : Math.min(this.scrollEndY, p.y + (i + 1) * scrollYIncrement);
                            if (newY + this.viewport.getHeight() > WmiMathDocumentView.this.getHeight()) {
                                newY = WmiMathDocumentView.this.getHeight() - this.viewport.getHeight();
                                yAtBounds = true;
                            }
                            if (newY < 0) {
                                newY = 0;
                                yAtBounds = true;
                            }
                            SwingUtilities.invokeLater(new DelayedScroll(this.viewport, new Point(newX, newY)));
                            if (!(newX != this.scrollEndX && !xAtBounds || newY != this.scrollEndY && !yAtBounds)) break;
                            WmiMathDocumentView wmiMathDocumentView2 = WmiMathDocumentView.this;
                            synchronized (wmiMathDocumentView2) {
                                WmiMathDocumentView.this.wait(waitTime);
                            }
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        WmiErrorLog.log(e);
                        WmiMathDocumentView wmiMathDocumentView = WmiMathDocumentView.this;
                        synchronized (wmiMathDocumentView) {
                            WmiMathDocumentView.this.isScrolling = false;
                            break block26;
                        }
                    }
                }
                catch (Throwable throwable) {
                    WmiMathDocumentView wmiMathDocumentView = WmiMathDocumentView.this;
                    synchronized (wmiMathDocumentView) {
                        WmiMathDocumentView.this.isScrolling = false;
                    }
                    throw throwable;
                }
                WmiMathDocumentView wmiMathDocumentView = WmiMathDocumentView.this;
                synchronized (wmiMathDocumentView) {
                    WmiMathDocumentView.this.isScrolling = false;
                }
            }
        }
    }
}

