/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiParagraphView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiView;

public class WmiMathExportParagraphView
extends WmiParagraphView {
    public static final int DOTS_PER_INCH = 72;
    public static final int LEFT_INDENT_SIZE = 3;
    private static final int PADDING_ABOVE = 3;
    private static final int PADDING_BELOW = 3;
    private static final int PADDING_RIGHT = 5;
    private static final int PADDING_LEFT = 5;
    private int m_lineBreakWidth;

    public WmiMathExportParagraphView(WmiModel model, WmiMathDocumentView docView, int breakWidth) {
        super(model, docView);
        this.m_lineBreakWidth = breakWidth;
        try {
            if (docView != null) {
                this.setParentView(docView);
                this.updateView();
                this.forceRepaint();
            }
            this.layoutView();
        }
        catch (WmiNoReadAccessException e) {
            WmiErrorLog.log(e);
        }
    }

    public WmiMathExportParagraphView(WmiModel model, WmiMathDocumentView docView) {
        super(model, docView);
        this.m_lineBreakWidth = docView.getBreakWidth();
    }

    @Override
    public int getLinebreakWidth() {
        return this.m_lineBreakWidth;
    }

    @Override
    public int getWidth() {
        int w = 0;
        int size = this.getChildCount();
        int i = 0;
        while (i < size) {
            WmiView childView = this.getChild(i);
            if (childView instanceof WmiPositionedView) {
                w = Math.max(w, ((WmiPositionedView)childView).getWidth());
            }
            ++i;
        }
        return w;
    }

    @Override
    public int getLeftIndent() {
        return 3;
    }

    @Override
    public int getSpaceAbove() {
        return 3;
    }

    @Override
    public int getSpaceBelow() {
        return 3;
    }

    @Override
    public int getLeftMargin() {
        return 5;
    }

    @Override
    public int getRightMargin() {
        return 5;
    }
}

