/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view;

import com.maplesoft.mathdoc.controller.WmiClipboardManager;
import com.maplesoft.mathdoc.controller.WmiInputMethodRequestHandler;
import com.maplesoft.mathdoc.controller.WmiMathDocumentKeyListener;
import com.maplesoft.mathdoc.controller.WmiMathDocumentMouseListener;
import com.maplesoft.mathdoc.controller.WmiMathMLClipboardManager;
import com.maplesoft.mathdoc.controller.WmiMathMLKeyListener;
import com.maplesoft.mathdoc.controller.WmiViewFactory;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiMathMLDocumentModel;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.util.RuntimePlatform;
import java.awt.Container;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import javax.swing.JViewport;

public class WmiMathMLDocumentView
extends WmiMathDocumentView {
    private boolean useBreakWidth = false;

    public WmiMathMLDocumentView(WmiMathDocumentModel _model, WmiViewFactory _factory) {
        super(_model, _factory);
        this.createListeners();
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        kfm.addKeyEventDispatcher(new MathMLKeyEventDispatcher());
    }

    public WmiMathMLDocumentView() {
        this(new WmiMathMLDocumentModel(), null);
    }

    @Override
    protected void createListeners() {
        this.documentMouseListener = new WmiMathDocumentMouseListener(this);
        this.addMouseListener(this.documentMouseListener);
        this.addMouseMotionListener(this.documentMouseListener);
        this.addFocusListener(this);
        this.documentKeyListener = new WmiMathMLKeyListener(this);
        this.addKeyListener(this.documentKeyListener);
        if (RuntimePlatform.isWindows() || RuntimePlatform.isMac()) {
            this.inputHandler = new WmiInputMethodRequestHandler(this);
        }
        this.addInputMethodListener(this.inputHandler);
    }

    @Override
    public Rectangle getVisibleRegion() {
        Rectangle r = null;
        Container parent = this.getParent();
        if (parent instanceof JViewport) {
            r = ((JViewport)parent).getViewRect();
        } else if (parent != null) {
            r = parent.getBounds();
        }
        return r;
    }

    @Override
    protected void calculatePendingBreakWidth() {
        Container parent = this.getParent();
        if (this.useBreakWidth) {
            this.pendingBreakWidth = this.breakWidth;
        } else if (parent instanceof JViewport) {
            Rectangle r = ((JViewport)parent).getViewRect();
            this.pendingBreakWidth = r.width - 10;
        } else {
            this.pendingBreakWidth = parent != null ? parent.getWidth() : 0;
        }
        if (this.pendingBreakWidth <= 0) {
            this.pendingBreakWidth = 400;
        }
    }

    public void setBreakWidth(int width) {
        this.useBreakWidth = true;
        this.breakWidth = width;
    }

    @Override
    public WmiClipboardManager getClipboardManager() {
        if (this.clipboardManager == null) {
            this.clipboardManager = new WmiMathMLClipboardManager(this);
        }
        return this.clipboardManager;
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e.isTemporary()) {
            this.setSelection(null);
        }
        super.focusLost(e);
    }

    private class MathMLKeyEventDispatcher
    implements KeyEventDispatcher {
        private MathMLKeyEventDispatcher() {
        }

        @Override
        public boolean dispatchKeyEvent(KeyEvent e) {
            if (e.getKeyChar() == '\t') {
                WmiMathDocumentKeyListener listener = WmiMathMLDocumentView.this.getKeyListener();
                if (e.getID() == 401) {
                    listener.keyPressed(e);
                } else if (e.getID() == 402) {
                    listener.keyReleased(e);
                } else if (e.getID() == 400) {
                    listener.keyTyped(e);
                }
                return true;
            }
            return false;
        }
    }
}

