/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view;

import com.maplesoft.mathdoc.controller.WmiViewFactory;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.font.WmiFontMetrics;
import com.maplesoft.mathdoc.font.WmiFontResolver;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelObserver;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiInlineView;
import com.maplesoft.mathdoc.view.WmiLinebrokenView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiTextFragmentView;
import com.maplesoft.mathdoc.view.WmiTextView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.math.WmiFencedView;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.util.ArrayList;

public class WmiParagraphView
extends WmiLinebrokenView
implements InputMethodListener {
    private static final String DEBUG_ROW_NAME = "Row";
    private static final int COST_LIMIT = 3;
    public static final int GOOD_BREAK = 0;
    public static final int MID_BREAK = 1;
    public static final int BAD_BREAK = 2;
    private static final float INDENT_SCALE_FACTOR = 0.2f;
    private Insets insets = null;
    private int firstLineIndent = 0;
    private boolean computeBreakWidth = true;
    private int spaceWidth = 0;

    public WmiParagraphView(WmiModel model, WmiMathDocumentView docView) {
        super(model, docView);
        this.setParentModel(model);
    }

    @Override
    public void inputMethodTextChanged(InputMethodEvent event) {
    }

    @Override
    public void caretPositionChanged(InputMethodEvent event) {
    }

    @Override
    public void layoutView() throws WmiNoReadAccessException {
        if (!this.isLayoutValid()) {
            if (this.requiresUpdateOnLayout()) {
                this.deferredUpdateView();
            }
            int zoom = this.getZoomFactor();
            this.spaceWidth = (int)((float)zoom * 0.2f);
            this.setInsets();
            this.firstLineIndent = this.getIntAttribute("firstindent");
            this.breakWidth = this.getLinebreakWidth();
            this.setBreakWidth(this.breakWidth);
            boolean explicitLinebreaking = false;
            Object breaktype = this.getAttribute("linebreak");
            if ("newline".equals(breaktype)) {
                explicitLinebreaking = true;
            }
            this.linebreak(explicitLinebreaking);
            super.layoutView();
            this.adjustVerticalAlignment();
            this.adjustAlignment(this.breakWidth);
            this.baseline = this.computeBaseline();
            if (this.height == 0) {
                WmiFontAttributeSet defaultFont = WmiFontAttributeSet.DEFAULT_FONT_ATTRIBUTES;
                int zoomFactor = this.getZoomFactor();
                boolean forPrint = this.getDocumentView().isPrintView();
                Font font = WmiFontResolver.getFont(defaultFont, zoomFactor, forPrint);
                WmiFontMetrics metrics = WmiFontResolver.getFontMetrics(font);
                this.baseline = metrics.getFontProperty(3, forPrint) + metrics.getFontProperty(0, forPrint);
                this.height = this.baseline + metrics.getFontProperty(4, forPrint);
            }
        }
    }

    private int computeBaseline() {
        WmiView child;
        int base = 0;
        if (this.getChildCount() > 0 && (child = this.getChild(0)) instanceof WmiPositionedView) {
            base = ((WmiPositionedView)child).getBaseline() + ((WmiPositionedView)child).getVerticalOffset();
        }
        return base;
    }

    private void setInsets() throws WmiNoReadAccessException {
        this.insets = new Insets(this.getSpaceAbove(), this.getLeftMargin(), this.getSpaceBelow(), this.getRightMargin());
    }

    @Override
    public void updateView() {
        this.invalidate(1);
    }

    public void deferredUpdateView() throws WmiNoReadAccessException {
        int j;
        WmiView[] oldViews = this.extractViews();
        WmiModel[] models = this.extractModels();
        int size = models.length;
        WmiView[] views = new WmiView[size];
        int oldLength = oldViews != null ? oldViews.length : 0;
        int[] viewIndex = new int[oldLength];
        int viewOffset = 0;
        WmiViewFactory factory = this.getViewFactory();
        int i = 0;
        while (i < oldLength) {
            viewIndex[i] = i;
            ++i;
        }
        i = 0;
        while (i < size) {
            WmiModel child = models[i];
            if (child != null) {
                j = viewOffset;
                while (j < oldLength) {
                    int index = viewIndex[j];
                    WmiView view = oldViews[index];
                    if (view != null && view.getModel() == child && WmiParagraphView.hasUniqueViewObserver(child, this.getDocumentView())) {
                        views[i] = view;
                        if (j != viewOffset) {
                            viewIndex[j] = viewIndex[viewOffset];
                            viewIndex[viewOffset] = index;
                        }
                        ++viewOffset;
                        break;
                    }
                    ++j;
                }
                if (child.isVisible()) {
                    if (views[i] == null && factory != null) {
                        WmiParagraphView.releaseViewObservers(child, this.getDocumentView());
                        views[i] = factory.createView(child, this);
                    }
                } else if (views[i] != null) {
                    views[i].release();
                    views[i] = null;
                }
            }
            ++i;
        }
        j = viewOffset;
        while (j < oldLength) {
            WmiView view = oldViews[viewIndex[j]];
            if (view != null) {
                view.release();
            }
            ++j;
        }
        this.length = views.length;
        this.children = new WmiView[this.length];
        System.arraycopy(views, 0, this.children, 0, this.length);
    }

    private static void releaseViewObservers(WmiModel model, WmiMathDocumentView docView) {
        WmiModelObserver observer = model.getObserver();
        while (observer != null) {
            WmiView view;
            if (observer instanceof WmiView && (view = (WmiView)((Object)observer)).getDocumentView() == docView) {
                model.releaseObserver(observer);
            }
            observer = observer.getNextObserver();
        }
    }

    protected WmiModel[] extractModels() throws WmiNoReadAccessException {
        ArrayList models = new ArrayList();
        WmiCompositeModel model = (WmiCompositeModel)this.getModel();
        this.extractModels(model, models);
        WmiModel[] modelArray = new WmiModel[models.size()];
        models.toArray(modelArray);
        return modelArray;
    }

    protected void extractModels(WmiCompositeModel model, ArrayList models) throws WmiNoReadAccessException {
        if (model != null) {
            int count = model.getChildCount();
            int i = 0;
            while (i < count) {
                WmiModel child = model.getChild(i);
                if (child.isVisible()) {
                    models.add(child);
                }
                ++i;
            }
        }
    }

    protected WmiView[] extractViews() {
        ArrayList views = new ArrayList();
        WmiParagraphView.extractViews(this, views);
        WmiView[] viewArray = new WmiView[views.size()];
        views.toArray(viewArray);
        return viewArray;
    }

    public static void extractViews(WmiCompositeView composite, ArrayList views) {
        WmiMathDocumentView docView = composite.getDocumentView();
        int size = composite.getChildCount();
        int i = 0;
        while (i < size) {
            WmiView child = composite.getChild(i);
            if (child instanceof WmiParagraphInlineView) {
                WmiParagraphView.extractViews((WmiCompositeView)child, views);
            } else if (WmiParagraphView.hasUniqueViewObserver(child.getModel(), docView) && !(child instanceof WmiTextView)) {
                views.add(child);
            }
            ++i;
        }
    }

    private void adjustVerticalAlignment() throws WmiNoReadAccessException {
        int size = this.getChildCount();
        int offset = this.insets != null ? this.insets.top : 0;
        int linespace = this.computeLineSpacing();
        int i = 0;
        while (i < size) {
            WmiInlineView child = (WmiInlineView)this.getChild(i);
            if (offset > 0) {
                child.setVerticalOffset(child.getVerticalOffset() + offset);
            }
            offset += linespace;
            ++i;
        }
        if ((offset += this.insets != null ? this.insets.bottom : 0) > 0) {
            this.height += offset;
        }
    }

    private int computeLineSpacing() throws WmiNoReadAccessException {
        int spacing = 0;
        Object obj = this.getAttribute("linespacing");
        float scaleFactor = 0.0f;
        if (obj instanceof Float) {
            scaleFactor = ((Float)obj).floatValue();
        } else if (obj != null) {
            scaleFactor = Float.parseFloat(obj.toString());
        }
        if (scaleFactor > 0.0f) {
            WmiFontAttributeSet set = WmiFontAttributeSet.DEFAULT_FONT_ATTRIBUTES;
            int zoomFactor = this.getZoomFactor();
            boolean forPrint = this.getDocumentView().isPrintView();
            Font font = WmiFontResolver.getFont(set, zoomFactor, forPrint);
            WmiFontMetrics metrics = WmiFontResolver.getFontMetrics(font);
            spacing = metrics.getFontProperty(3, forPrint) + metrics.getFontProperty(0, forPrint) + metrics.getFontProperty(4, forPrint);
            spacing = (int)(scaleFactor * (float)spacing);
        }
        return spacing;
    }

    protected void adjustAlignment(int breakWidth) throws WmiNoReadAccessException {
        int leftIndent = this.getLeftIndent();
        int rightIndent = this.getRightIndent();
        Object alignment = this.getAttribute("alignment");
        if ("right".equals(alignment)) {
            this.rightAlign(breakWidth, leftIndent, rightIndent);
        } else if ("centred".equals(alignment)) {
            this.centerAlign(breakWidth, leftIndent, rightIndent);
        } else {
            this.leftAlign(breakWidth, leftIndent, rightIndent);
        }
    }

    protected void rightAlign(int breakWidth, int leftIndent, int rightIndent) {
        WmiInlineView child;
        int size = this.getChildCount();
        this.width = 0;
        int i = 0;
        while (i < size) {
            child = (WmiInlineView)this.getChild(i);
            int childWidth = child.getWidth();
            if (childWidth > this.width) {
                this.width = childWidth;
            }
            ++i;
        }
        if (this.width < breakWidth) {
            this.width = breakWidth;
        }
        this.width += leftIndent;
        this.width += rightIndent;
        i = 0;
        while (i < size) {
            child = (WmiInlineView)this.getChild(i);
            child.x = this.width - child.width - rightIndent;
            ++i;
        }
    }

    protected void centerAlign(int breakWidth, int leftIndent, int rightIndent) {
        WmiInlineView child;
        int size = this.getChildCount();
        this.width = 0;
        int i = 0;
        while (i < size) {
            child = (WmiInlineView)this.getChild(i);
            int childWidth = child.getWidth();
            if (childWidth > breakWidth) {
                childWidth = childWidth - child.getPadding(1) <= breakWidth ? breakWidth : (childWidth -= child.getPadding(1));
            }
            if (childWidth > this.width) {
                this.width = childWidth;
            }
            ++i;
        }
        if (this.width < breakWidth) {
            this.width = breakWidth;
        }
        this.width += leftIndent;
        this.width += rightIndent;
        i = 0;
        while (i < size) {
            child = (WmiInlineView)this.getChild(i);
            child.x = (breakWidth - child.getWidth()) / 2 + leftIndent;
            if (child.x < leftIndent) {
                child.x = leftIndent;
            }
            ++i;
        }
    }

    protected void leftAlign(int breakWidth, int leftIndent, int rightIndent) {
        int size = this.getChildCount();
        this.width = 0;
        int i = 0;
        while (i < size) {
            int childWidth;
            WmiInlineView child = (WmiInlineView)this.getChild(i);
            child.x = leftIndent;
            if (i == 0) {
                child.x += this.firstLineIndent;
            }
            if ((childWidth = child.getWidth()) > breakWidth) {
                childWidth = childWidth - child.getPadding(1) <= breakWidth ? breakWidth : (childWidth -= child.getPadding(1));
            }
            if (childWidth > this.width) {
                this.width = childWidth;
            }
            ++i;
        }
        if (this.width < breakWidth) {
            this.width = breakWidth;
        }
        this.width += leftIndent;
        this.width += rightIndent;
    }

    protected boolean requiresUpdateOnLayout() {
        return true;
    }

    @Override
    public int getLeftIndent() {
        return this.insets != null ? this.insets.left : 0;
    }

    @Override
    public int getRightIndent() {
        return this.insets != null ? this.insets.right : 0;
    }

    public int getFirstLineIndent() {
        return this.firstLineIndent;
    }

    public int getLinebreakWidth() {
        int breakWidth = Integer.MAX_VALUE;
        breakWidth = this.computeBreakWidth ? this.getWidthConstraint(false) : this.breakWidth;
        return breakWidth;
    }

    public void setLinebreakWidth(int newWidth) {
        this.setBreakWidth(newWidth);
        this.breakWidth = newWidth;
        this.computeBreakWidth = false;
    }

    private void linebreak(boolean explicitBreaksOnly) throws WmiNoReadAccessException {
        int limit = this.getChildCount();
        WmiInlineView inline = this.createRow(this.getModel(), this.breakWidth);
        int i = 0;
        while (i < limit) {
            WmiView child = this.getChild(i);
            if (child != null) {
                inline.appendView(child);
            }
            ++i;
        }
        this.children = new WmiView[1];
        this.children[0] = inline;
        inline.setParentView(this);
        this.length = 1;
        inline.layoutView();
        WmiParagraphView.recursiveResetObservers(this);
        this.doExplicitLinebreaks();
        if (!explicitBreaksOnly) {
            this.doImplicitLinebreaks();
        }
        WmiParagraphView.recursiveResetObservers(this);
        this.adjustVerticalPadding(this);
        this.pruneEmptyRows();
        WmiParagraphView.recursiveRegisterObservers(this);
        WmiParagraphView.recursiveAdjustInlines(this);
        this.resetNavigationLinks(this);
    }

    private void doExplicitLinebreaks() throws WmiNoReadAccessException {
        int index = 0;
        while (index < this.getChildCount()) {
            WmiPositionedView child = (WmiPositionedView)this.getChild(index++);
            child.doExplicitLinebreak(this);
        }
    }

    private void doImplicitLinebreaks() throws WmiNoReadAccessException {
        int index = 0;
        int indent = this.firstLineIndent;
        while (index < this.getChildCount()) {
            int childWidth;
            WmiParagraphInlineView inline;
            int mathIndent;
            WmiPositionedView child = (WmiPositionedView)this.getChild(index);
            if (child instanceof WmiParagraphInlineView && (mathIndent = (inline = (WmiParagraphInlineView)child).getIndentLevel()) > 0) {
                indent += this.spaceWidth * mathIndent;
            }
            child.layoutView();
            int found = 0;
            int n = childWidth = child instanceof WmiParagraphInlineView ? ((WmiParagraphInlineView)child).getUnadjustedWidth() : this.getWidth();
            if (child != null && childWidth + indent > this.breakWidth) {
                int cost = 0;
                while (cost < 3) {
                    found = child.doImplicitLinebreak(this, indent, this.breakWidth, cost);
                    if (found != 0) break;
                    ++cost;
                }
                if (found == 0) {
                    found = child.doForcedLinebreak(this, indent, this.breakWidth);
                }
            }
            if (found == true) continue;
            ++index;
            indent = 0;
        }
    }

    public WmiView split(WmiView view, int offset, int consume) throws WmiNoReadAccessException {
        WmiPositionedView fragment = null;
        while (view != this) {
            int index;
            fragment = null;
            WmiCompositeView parent = view.getParentView();
            int n = index = parent != null ? parent.indexOf(view) : -1;
            if (view instanceof WmiTextView) {
                WmiTextView text = (WmiTextView)view;
                WmiTextView[] fragments = WmiTextFragmentView.splitTextView(text, offset, consume);
                if (fragments != null && index >= 0) {
                    parent.replaceChild(fragments[0], index);
                    text.release();
                    fragments[0].setParentView(parent);
                    fragment = fragments[1];
                    parent.markInvalid(1);
                }
            } else if (view instanceof WmiCompositeView) {
                WmiCompositeView comp = (WmiCompositeView)view;
                fragment = (WmiPositionedView)comp.splitView(offset, consume);
                if (index >= 0 && fragment != null) {
                    WmiView rightView = parent.getChild(index);
                    parent.replaceChild(fragment, index);
                    fragment = (WmiPositionedView)rightView;
                }
            }
            if (fragment != null && index >= 0) {
                parent.insertView(fragment, index + 1);
                parent.markInvalid(1);
            }
            if (parent != this) {
                ((WmiPositionedView)((Object)parent)).layoutView();
            }
            offset = index + 1;
            view = parent;
            consume = 0;
        }
        return fragment;
    }

    private void pruneEmptyRows() {
        int index = 0;
        while (index < this.getChildCount()) {
            WmiView child = this.getChild(index);
            if (child instanceof WmiInlineView && this.isEmpty((WmiCompositeView)child)) {
                this.removeChild(index);
                continue;
            }
            ++index;
        }
    }

    private boolean isEmpty(WmiCompositeView comp) {
        WmiFencedView fence;
        boolean empty = true;
        int size = comp.getChildCount();
        int i = 0;
        while (i < size) {
            WmiView child = comp.getChild(i);
            if (child instanceof WmiInlineView) {
                if (!this.isEmpty((WmiCompositeView)child)) {
                    empty = false;
                    break;
                }
            } else if (child != null) {
                empty = false;
                break;
            }
            ++i;
        }
        if (empty && comp instanceof WmiFencedView && ((fence = (WmiFencedView)comp).getLeftBracket() != null || fence.getRightBracket() != null)) {
            empty = false;
        }
        return empty;
    }

    private void adjustVerticalPadding(WmiCompositeView view) throws WmiNoReadAccessException {
        int size = view.getChildCount();
        int i = 0;
        while (i < size) {
            WmiView child = view.getChild(i);
            if (!(child instanceof WmiFencedView) && child instanceof WmiCompositeView) {
                this.adjustVerticalPadding((WmiCompositeView)child);
            }
            ++i;
        }
        if (!(view instanceof WmiFencedView) && view instanceof WmiInlineView) {
            WmiInlineView inline = (WmiInlineView)view;
            inline.adjustVerticalLayout();
        }
    }

    private void resetNavigationLinks(WmiCompositeView view) {
        if (view instanceof WmiPositionedView) {
            int size = this.getChildCount();
            int i = 0;
            while (i < size) {
                WmiView child = view.getChild(i);
                if (child instanceof WmiPositionedView) {
                    WmiPositionedView posView = (WmiPositionedView)child;
                    posView.setNextView(null, 1);
                    posView.setNextView(null, 0);
                    posView.setNextView(null, 2);
                    posView.setNextView(null, 3);
                    posView.setNextView(null, -2);
                    posView.setNextView(null, -1);
                    posView.setNextView(null, -4);
                    posView.setNextView(null, -3);
                }
                if (child instanceof WmiCompositeView) {
                    this.resetNavigationLinks((WmiCompositeView)child);
                }
                ++i;
            }
            ((WmiPositionedView)((Object)view)).addNavigationLinks();
        }
    }

    private static void recursiveResetObservers(WmiView view) {
        WmiModel model = view.getModel();
        if (model != null) {
            WmiModelObserver obs = model.getObserver();
            while (obs != null) {
                WmiModelObserver next = obs.getNextObserver();
                if (obs instanceof WmiView && ((WmiView)((Object)obs)).getDocumentView() == view.getDocumentView()) {
                    model.releaseObserver(obs);
                }
                obs = next;
            }
        }
        if (view instanceof WmiCompositeView) {
            WmiCompositeView comp = (WmiCompositeView)view;
            int size = comp.getChildCount();
            int i = 0;
            while (i < size) {
                WmiView child = comp.getChild(i);
                if (child instanceof WmiModelObserver) {
                    WmiParagraphView.recursiveResetObservers(child);
                }
                ++i;
            }
        }
    }

    private static void recursiveRegisterObservers(WmiView view) {
        WmiModel model = view.getModel();
        if (model == null || model.getTag() != WmiModelTag.MATH_PHANTOM) {
            if (model != null && view instanceof WmiModelObserver) {
                ((WmiModelObserver)((Object)view)).registerObserver();
            }
            if (view instanceof WmiCompositeView) {
                WmiCompositeView comp = (WmiCompositeView)view;
                int size = comp.getChildCount();
                int i = 0;
                while (i < size) {
                    WmiView child = comp.getChild(i);
                    if (child instanceof WmiModelObserver) {
                        WmiParagraphView.recursiveRegisterObservers(child);
                    }
                    ++i;
                }
            }
        }
    }

    private static void recursiveAdjustInlines(WmiView view) {
        if (view instanceof WmiCompositeView) {
            WmiCompositeView comp = (WmiCompositeView)view;
            int size = comp.getChildCount();
            if (view instanceof WmiInlineView) {
                ((WmiInlineView)view).removeChildShift();
            }
            int i = 0;
            while (i < size) {
                WmiView child = comp.getChild(i);
                WmiParagraphView.recursiveAdjustInlines(child);
                ++i;
            }
        }
    }

    public boolean isStartOfLine(WmiView view) {
        boolean start = true;
        WmiCompositeView parent = view.getParentView();
        while (parent != this) {
            WmiView candidate = ((WmiPositionedView)((Object)parent)).getNextView(-4);
            if (candidate == null) {
                candidate = parent.getChild(0);
            }
            if (candidate != view) {
                start = false;
                break;
            }
            view = parent;
            parent = view.getParentView();
        }
        return start;
    }

    public int getSpaceAbove() throws WmiNoReadAccessException {
        return this.getIntAttribute("spaceabove");
    }

    public int getSpaceBelow() throws WmiNoReadAccessException {
        return this.getIntAttribute("spacebelow");
    }

    public int getLeftMargin() throws WmiNoReadAccessException {
        return this.getIntAttribute("leftmargin");
    }

    public int getRightMargin() throws WmiNoReadAccessException {
        return this.getIntAttribute("rightmargin");
    }

    public int getIntAttribute(Object key) throws WmiNoReadAccessException {
        int ivalue = 0;
        Object value = this.getAttribute(key);
        if (value instanceof Integer) {
            ivalue = (Integer)value;
        } else if (value != null) {
            ivalue = Integer.parseInt(value.toString());
        }
        return ivalue;
    }

    public Object getAttribute(Object key) throws WmiNoReadAccessException {
        WmiModel model = this.getModel();
        WmiAttributeSet set = model != null ? model.getAttributesForRead() : null;
        return set != null ? set.getAttribute(key) : null;
    }

    @Override
    public WmiInlineView createRow(WmiModel model, int width) {
        return new WmiParagraphInlineView(model, this.getDocumentView());
    }

    public static final class WmiBreakInfo {
        public WmiPositionedView view;
        public String activeText = null;
        public int breakPoint;
        public int nextStart;
        public int width;
        public int nextWidth;
        public int breakWidth;
        public boolean explicitBreaksOnly;
        public boolean forcedBreak;
        public boolean longBreak;

        public WmiBreakInfo(boolean explicitBreaksOnly) {
            this.update(null, 0, -1, 0, 0, false, false);
            this.breakWidth = 0;
            this.explicitBreaksOnly = explicitBreaksOnly;
        }

        public void update(WmiPositionedView view, int breakPoint, int nextStart, int width, int nextWidth, boolean forced, boolean longBreak) {
            this.view = view;
            this.breakPoint = breakPoint;
            this.nextStart = nextStart;
            this.width = width;
            this.nextWidth = nextWidth;
            this.forcedBreak = forced;
            this.longBreak = longBreak;
        }
    }

    public class WmiParagraphInlineView
    extends WmiInlineView {
        boolean mathMode;
        int mathIndentLevel;
        int unadjustedWidth;

        private WmiParagraphInlineView(WmiModel model, WmiMathDocumentView docView) {
            super(model, docView);
            this.unadjustedWidth = -1;
            this.mathMode = false;
            this.mathIndentLevel = 0;
        }

        @Override
        public String getDebugName() {
            return WmiParagraphView.DEBUG_ROW_NAME;
        }

        @Override
        public void registerObserver() {
        }

        public void setMathMode() {
            this.mathMode = true;
            this.mathIndentLevel = 0;
        }

        public void setTextMode() {
            this.mathMode = false;
            this.mathIndentLevel = 0;
        }

        public void incrementIndentLevel() {
            ++this.mathIndentLevel;
        }

        public void decrementIndentLevel() {
            if (this.mathIndentLevel > 0) {
                --this.mathIndentLevel;
            }
        }

        @Override
        public WmiView splitView(int offset, int consume) {
            WmiView fragment = super.splitView(offset, consume);
            if (this.isMathMode()) {
                boolean foundMath = false;
                WmiView view = this;
                while (view instanceof WmiCompositeView) {
                    WmiModel firstModel;
                    int size = ((WmiCompositeView)view).getChildCount();
                    if (size <= 0) break;
                    WmiView firstView = ((WmiCompositeView)view).getChild(0);
                    WmiModel wmiModel = firstModel = firstView != null ? firstView.getModel() : null;
                    if (firstModel.getTag() == WmiModelTag.MATH) {
                        foundMath = true;
                    }
                    view = firstView;
                }
                if (foundMath) {
                    if (this.mathIndentLevel == 0) {
                        this.incrementIndentLevel();
                    }
                } else {
                    this.setTextMode();
                }
            }
            return fragment;
        }

        public int getIndentLevel() {
            return this.mathMode ? this.mathIndentLevel : 0;
        }

        public boolean isMathMode() {
            return this.mathMode;
        }

        @Override
        public void layoutView() throws WmiNoReadAccessException {
            if (!this.isLayoutValid()) {
                super.layoutView();
                if (this.mathMode && this.getChildCount() > 0 && this.width < WmiParagraphView.this.breakWidth) {
                    this.unadjustedWidth = this.width;
                    this.width = WmiParagraphView.this.breakWidth;
                }
            }
        }

        @Override
        public void updateLayout(boolean rightFragment) {
            if (!this.isLayoutValid()) {
                super.updateLayout(rightFragment);
                if (rightFragment && this.mathIndentLevel == 0) {
                    this.mathIndentLevel = 1;
                }
                if (this.mathMode && this.getChildCount() > 0 && this.width < WmiParagraphView.this.breakWidth) {
                    this.unadjustedWidth = this.width;
                    this.width = WmiParagraphView.this.breakWidth;
                }
            }
        }

        @Override
        protected int getChildShiftAdjustment() {
            return this.mathMode ? WmiParagraphView.this.spaceWidth * this.mathIndentLevel : 0;
        }

        protected int getUnadjustedWidth() {
            return this.unadjustedWidth >= 0 ? this.unadjustedWidth : this.width;
        }
    }
}

