/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewBuilder;
import com.maplesoft.util.WmiStartup;
import java.lang.reflect.Constructor;

public class WmiReflectingViewBuilder
implements WmiViewBuilder {
    String fullyQualifiedClassname;
    Constructor construct;
    Object[] args = new Object[2];
    Class[] pTypes = new Class[]{WmiModel.class, WmiMathDocumentView.class};
    static boolean checkAll;
    static boolean checkChosen;

    public WmiReflectingViewBuilder(String packagename, String classname) {
        this(String.valueOf(packagename) + "." + classname);
    }

    public WmiReflectingViewBuilder(String fullyQualifiedClassname) {
        this.fullyQualifiedClassname = fullyQualifiedClassname;
        if (checkAll) {
            if (!checkAll) {
                int v = (int)(System.currentTimeMillis() % 50L);
                boolean bl = checkAll = v == 1;
            }
            if (checkAll) {
                if (!checkChosen) {
                    WmiStartup.progress("* * * NOTE * * * extra check in  WmiReflectingViewBuilder; do not use this timing");
                }
                this.loadClass();
            }
            checkChosen = true;
        }
    }

    private void loadClass() {
        try {
            Class<?> c = Class.forName(this.fullyQualifiedClassname);
            this.construct = c.getConstructor(this.pTypes);
        }
        catch (ClassNotFoundException e) {
            WmiErrorLog.log(e);
        }
        catch (NoSuchMethodException e) {
            WmiErrorLog.log(e);
        }
        catch (IllegalArgumentException e) {
            WmiErrorLog.log(e);
        }
    }

    @Override
    public WmiView createView(WmiModel model, WmiMathDocumentView docView) {
        if (this.construct == null) {
            this.loadClass();
        }
        this.args[0] = model;
        this.args[1] = docView;
        try {
            return (WmiView)this.construct.newInstance(this.args);
        }
        catch (Exception e) {
            WmiErrorLog.log(e);
            return null;
        }
    }
}

