/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view;

import com.maplesoft.mathdoc.view.WmiHighlightPainter;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiScrollableContainerView;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiSelectionHighlighter;
import com.maplesoft.mathdoc.view.WmiViewPath;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import java.awt.Point;
import java.awt.Rectangle;

public class WmiRenderPath {
    private static final int DEFAULT_ARRAY_SIZE = 10;
    private WmiSelection selection = null;
    private WmiViewPath activePath = new WmiViewPath();
    private int[] xOffset = new int[10];
    private int[] yOffset = new int[10];
    private int xShift = 0;
    private int yShift = 0;
    private int depth = 1;
    private boolean drawStringsWithGlyphVectors = true;
    private boolean cloneGCForClip = false;
    private boolean isDrawingToScreen = true;
    private WmiScrollableContainerView container = null;
    private Point containerOffset = new Point(0, 0);

    public WmiRenderPath(WmiMathDocumentView docView) {
        this.xOffset[0] = 0;
        this.yOffset[0] = 0;
        if (docView != null) {
            this.selection = docView.getSelection();
        }
    }

    public void push(int deltaX, int deltaY) {
        this.activePath.push(0);
        this.xOffset = this.ensureCapacity(this.xOffset, this.depth + 1);
        this.yOffset = this.ensureCapacity(this.yOffset, this.depth + 1);
        this.xOffset[this.depth] = this.xOffset[this.depth - 1] + deltaX;
        this.yOffset[this.depth] = this.yOffset[this.depth - 1] + deltaY;
        ++this.depth;
    }

    public void pop() {
        this.activePath.pop();
        --this.depth;
    }

    public void next() {
        this.activePath.next();
    }

    public void applyShift(int deltaX, int deltaY) {
        this.xShift += deltaX;
        this.yShift += deltaY;
    }

    public int getHorizontalShift() {
        return this.xShift;
    }

    public int getVerticalShift() {
        return this.yShift;
    }

    public void translateOrigin(int deltaX, int deltaY) {
        int n = this.depth - 1;
        this.xOffset[n] = this.xOffset[n] + deltaX;
        int n2 = this.depth - 1;
        this.yOffset[n2] = this.yOffset[n2] + deltaY;
    }

    public boolean isSelected(int x, int width) {
        boolean selected = false;
        int selectionStart = this.getLeftSelectionBoundary();
        if (selectionStart >= 0) {
            int selectionEnd;
            int limits = 0;
            if (selectionStart <= x) {
                ++limits;
            }
            if ((selectionEnd = this.getRightSelectionBoundary()) >= x + width) {
                ++limits;
            }
            selected = limits == 2;
        }
        return selected;
    }

    public void setSelection(WmiSelection selection) {
        this.selection = selection;
    }

    public WmiSelection getSelection() {
        return this.selection;
    }

    public WmiViewPath getActivePath() {
        return this.activePath;
    }

    public int getHorizontalOffset() {
        return this.xOffset[this.depth - 1] + this.containerOffset.x;
    }

    public int getVerticalOffset() {
        return this.yOffset[this.depth - 1] + this.containerOffset.y;
    }

    private int[] ensureCapacity(int[] data, int size) {
        if (data == null) {
            data = new int[size];
        } else if (data.length < size) {
            int newSize = 2 * data.length;
            if (newSize < size) {
                newSize = size;
            }
            int[] newPath = new int[newSize];
            System.arraycopy(data, 0, newPath, 0, data.length);
            data = newPath;
        }
        return data;
    }

    public String toString() {
        return "pos:(" + Integer.toString(this.xOffset[this.depth - 1]) + ", " + Integer.toString(this.yOffset[this.depth - 1]) + ")  " + this.activePath + " (" + this.selection + ")";
    }

    public int getLeftSelectionBoundary() {
        return this.getLeftSelectionBoundary(0);
    }

    public int getLeftSelectionBoundary(int offsetAdjust) {
        WmiHighlightPainter highlighter;
        int start = -1;
        WmiHighlightPainter wmiHighlightPainter = highlighter = this.selection != null ? this.selection.getSelectionHighlighter() : null;
        if (highlighter != null) {
            start = highlighter.getLeftBoundary(this.yOffset[this.depth - 1] + offsetAdjust);
        }
        return start;
    }

    public int getRightSelectionBoundary() {
        return this.getRightSelectionBoundary(0);
    }

    public int getRightSelectionBoundary(int offsetAdjust) {
        WmiHighlightPainter highlighter;
        int end = -1;
        WmiHighlightPainter wmiHighlightPainter = highlighter = this.selection != null ? this.selection.getSelectionHighlighter() : null;
        if (highlighter != null) {
            end = highlighter.getRightBoundary(this.yOffset[this.depth - 1] + offsetAdjust);
        }
        return end;
    }

    public boolean isMidpointSelected(WmiPositionedView view) {
        int midpoint;
        int offsetAdjustment = view.getHeight() / 2;
        int selectionStart = this.getLeftSelectionBoundary(offsetAdjustment);
        int selectionEnd = this.getRightSelectionBoundary(offsetAdjustment);
        return selectionEnd > (midpoint = view.getHorizontalOffset() + this.getHorizontalOffset() + view.getWidth() / 2) && selectionStart < midpoint;
    }

    public boolean isPointInSelection(int x, int y) {
        WmiHighlightPainter highlighter;
        boolean contains = false;
        WmiHighlightPainter wmiHighlightPainter = highlighter = this.selection != null ? this.selection.getSelectionHighlighter() : null;
        if (highlighter != null) {
            highlighter.isInsideHighlight(new Point(x, y));
        }
        return contains;
    }

    public Rectangle getSelectionBoundary() {
        WmiHighlightPainter highlighter;
        Rectangle bounds = null;
        WmiHighlightPainter wmiHighlightPainter = highlighter = this.selection != null ? this.selection.getSelectionHighlighter() : null;
        if (highlighter != null) {
            bounds = highlighter.getBounds();
        }
        return bounds;
    }

    public Rectangle getLeftMarginBoundary() {
        WmiHighlightPainter highlighter;
        Rectangle bounds = null;
        WmiHighlightPainter wmiHighlightPainter = highlighter = this.selection != null ? this.selection.getSelectionHighlighter() : null;
        if (highlighter instanceof WmiSelectionHighlighter) {
            bounds = ((WmiSelectionHighlighter)highlighter).computeLeftMarginBounds();
        }
        return bounds;
    }

    public boolean drawStringsWithGlyphVectors() {
        return this.drawStringsWithGlyphVectors;
    }

    public void drawStringsWithGlyphVectors(boolean useGlyphVectors) {
        this.drawStringsWithGlyphVectors = useGlyphVectors;
    }

    public void setScreenDraw(boolean isScreen) {
        this.isDrawingToScreen = isScreen;
    }

    public boolean isScreenDraw() {
        return this.isDrawingToScreen;
    }

    public void setCloneGCForClip(boolean cloneGC) {
        this.cloneGCForClip = cloneGC;
    }

    public boolean cloneGCForClip() {
        return this.cloneGCForClip;
    }

    public WmiScrollableContainerView getContainer() {
        return this.container;
    }

    public void setContainer(WmiScrollableContainerView container) {
        this.container = container;
        if (container != null && !container.isDocumentView()) {
            this.containerOffset = WmiViewUtil.getAbsoluteOffset(container);
        }
    }

    public void copyDrawingFlags(WmiRenderPath from) {
        if (from != null) {
            this.cloneGCForClip = from.cloneGCForClip;
            this.drawStringsWithGlyphVectors = from.drawStringsWithGlyphVectors;
            this.isDrawingToScreen = from.isDrawingToScreen;
        }
    }
}

