/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.view.WmiBoundsMarker;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiParagraphView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiResizableContainerView;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public abstract class WmiResizeDecorator
extends WmiBoundsMarker {
    protected static final int HOTSPOT_NONE = 0;
    protected static final int HOTSPOT_NW = 1;
    protected static final int HOTSPOT_N = 2;
    protected static final int HOTSPOT_NE = 3;
    protected static final int HOTSPOT_W = 4;
    protected static final int HOTSPOT_E = 5;
    protected static final int HOTSPOT_SW = 6;
    protected static final int HOTSPOT_S = 7;
    protected static final int HOTSPOT_SE = 8;
    private static final int MINIMUM_DIMENSION = 20;
    private Rectangle startBounds = null;
    private Point startPoint = null;
    private Object parentAlignment = null;
    private boolean moveUp = false;
    private boolean moveDown = false;
    private boolean moveLeft = false;
    private boolean moveRight = false;

    protected WmiResizeDecorator(WmiMathDocumentView doc) {
        super(doc);
    }

    public Dimension onMouseDragged(MouseEvent e) {
        WmiPositionedView view = this.getView();
        Point p = WmiViewUtil.getAbsoluteOffset(view);
        int x = p.x + e.getX();
        int y = p.y + e.getY();
        Rectangle bounds = this.startBounds != null ? this.startBounds : this.getBounds();
        int newWidth = bounds.width;
        int newHeight = bounds.height;
        if (this.startBounds != null) {
            int deltaX = x - this.startPoint.x;
            int deltaY = y - this.startPoint.y;
            if (this.moveUp) {
                newHeight -= deltaY;
            } else if (this.moveDown) {
                newHeight += deltaY;
            }
            if (this.moveLeft || this.moveRight) {
                if ("centred".equals(this.parentAlignment)) {
                    deltaX *= 2;
                }
                if (this.moveLeft) {
                    newWidth -= deltaX;
                } else if (this.moveRight) {
                    newWidth += deltaX;
                }
            }
            newWidth = Math.max(newWidth, 20);
            newHeight = Math.max(newHeight, 20);
            if (e.isShiftDown()) {
                Dimension d = WmiResizeDecorator.constrainResize(this.startBounds, newWidth, newHeight, this.moveLeft || this.moveRight);
                newWidth = d.width;
                newHeight = d.height;
            }
        }
        return new Dimension(newWidth, newHeight);
    }

    public Cursor onMouseMoved(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        return this.getCursorForPoint(x, y);
    }

    public Cursor getCursorForPoint(int x, int y) {
        int cursorIdx = 0;
        Rectangle bounds = this.getBounds();
        int hotspot = this.selectedHotspot(x, y, bounds);
        switch (hotspot) {
            case 1: {
                cursorIdx = 6;
                break;
            }
            case 2: 
            case 7: {
                cursorIdx = 8;
                break;
            }
            case 3: {
                cursorIdx = 7;
                break;
            }
            case 4: 
            case 5: {
                cursorIdx = 11;
                break;
            }
            case 6: {
                cursorIdx = 4;
                break;
            }
            case 8: {
                cursorIdx = 5;
            }
        }
        if (cursorIdx == 0) {
            return null;
        }
        return Cursor.getPredefinedCursor(cursorIdx);
    }

    public boolean onMousePressed(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        boolean mouseHold = false;
        Rectangle bounds = this.getBounds();
        int hotspot = this.selectedHotspot(x, y, bounds);
        if (hotspot > 0) {
            this.moveLeft = hotspot == 1 || hotspot == 4 || hotspot == 6;
            this.moveRight = hotspot == 3 || hotspot == 5 || hotspot == 8;
            this.moveUp = hotspot == 1 || hotspot == 2 || hotspot == 3;
            this.moveDown = hotspot == 6 || hotspot == 7 || hotspot == 8;
            WmiPositionedView view = this.getView();
            Point p = WmiViewUtil.getAbsoluteOffset(view);
            this.startBounds = new Rectangle(p.x, p.y, bounds.width, bounds.height);
            this.startPoint = new Point(p.x + x, p.y + y);
            this.parentAlignment = this.getAlignment();
            mouseHold = true;
        }
        return mouseHold;
    }

    public void onMouseReleased(MouseEvent e) {
        this.startBounds = null;
        this.startPoint = null;
        this.parentAlignment = null;
    }

    @Override
    public void hide() {
        WmiPositionedView view = this.getView();
        if (view instanceof WmiResizableContainerView) {
            ((WmiResizableContainerView)view).setMarker(null);
        }
        super.hide();
    }

    @Override
    public void show() {
        super.show();
        WmiPositionedView view = this.getView();
        if (view instanceof WmiResizableContainerView) {
            ((WmiResizableContainerView)view).setMarker(this);
        }
    }

    protected abstract int selectedHotspot(int var1, int var2, Rectangle var3);

    private Object getAlignment() {
        WmiModel model;
        WmiParagraphView paragraphView = (WmiParagraphView)WmiViewUtil.findAncestorOfClass(this.getView(), WmiParagraphView.class);
        Object result = null;
        if (paragraphView != null && WmiModelLock.readLock(model = this.getView().getModel(), true)) {
            try {
                try {
                    result = paragraphView.getAttribute("alignment");
                }
                catch (WmiNoReadAccessException nrae) {
                    WmiErrorLog.log(nrae);
                    WmiModelLock.readUnlock(model);
                }
            }
            finally {
                WmiModelLock.readUnlock(model);
            }
        }
        return result;
    }

    private static Dimension constrainResize(Rectangle startBounds, int newWidth, int newHeight, boolean canMoveHorizontally) {
        float ratio = (float)startBounds.width / (float)startBounds.height;
        if (canMoveHorizontally) {
            newHeight = (int)((float)newWidth / ratio);
        } else {
            newWidth = (int)((float)newHeight * ratio);
        }
        return new Dimension(newWidth, newHeight);
    }
}

