/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view;

import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.WmiTableCellAttributeSet;
import com.maplesoft.mathdoc.model.WmiTableCellModel;
import com.maplesoft.mathdoc.view.WmiCellView;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiHighlightPainter;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiRenderPath;
import com.maplesoft.mathdoc.view.WmiResizableContainerView;
import com.maplesoft.mathdoc.view.WmiRowView;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiTableRowView;
import com.maplesoft.mathdoc.view.WmiTableView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;

public class WmiTableCellView
extends WmiRowView
implements WmiCellView {
    public static final int CELL_BORDER = 5;
    private static final String DEBUG_NAME = "Cell";
    public static final int MINIMUM_CELL_WIDTH = 11;
    private int row = -1;
    private int column = -1;
    private int rowSpan = 1;
    private int columnSpan = 1;
    private int borders = 0;
    private boolean columnSeparator = false;

    public WmiTableCellView(WmiModel model, WmiMathDocumentView docView) {
        super(model, docView, DEBUG_NAME);
    }

    @Override
    public void draw(Graphics g, WmiRenderPath path, Rectangle bounds) {
        Shape saveClip = ((Graphics2D)g).getClip();
        int left = path.getHorizontalOffset() + this.x;
        int top = path.getVerticalOffset() + this.y;
        ((Graphics2D)g).clipRect(left, top, this.width, this.height);
        super.draw(g, path, bounds);
        ((Graphics2D)g).setClip(saveClip);
        this.drawStub(g, path, bounds);
    }

    @Override
    public void drawStub(Graphics g, WmiRenderPath path, Rectangle bounds) {
        WmiTableView tableView = (WmiTableView)WmiViewUtil.findAncestorOfTag(this, WmiModelTag.TABLE);
        if (tableView != null) {
            WmiTableRowView tableRow;
            int flag;
            Graphics2D g2d = (Graphics2D)g;
            Stroke saveStroke = g2d.getStroke();
            Color saveColor = g.getColor();
            g2d.setStroke(WmiTableView.BORDER_STROKE);
            WmiSelection selection = path.getSelection();
            WmiHighlightPainter highlighter = selection != null ? selection.getSelectionHighlighter() : null;
            Color highlightColor = highlighter != null ? this.getDocumentView().getColor(3) : null;
            int left = path.getHorizontalOffset() + this.x;
            int top = path.getVerticalOffset();
            int right = left + this.width;
            int bottom = top + this.getCellHeight();
            boolean focus = tableView.hasFocus();
            if (this.row > 0) {
                flag = 2;
                if ((this.borders & 0x10) != 0 && (tableRow = (WmiTableRowView)this.getParentView()) != null && !tableRow.drawSeparator()) {
                    flag = 0;
                }
                WmiTableView.drawBorder(g, this.borders, flag, focus, left, top, right, top, highlighter, highlightColor);
            }
            if ((this.borders & 0x10) != 0) {
                flag = 0;
                tableRow = (WmiTableRowView)this.getParentView();
                int rowIndex = tableView.indexOf(tableRow);
                if (rowIndex >= 0) {
                    rowIndex += this.rowSpan;
                }
                if (rowIndex > 0 && rowIndex < tableView.getChildCount()) {
                    tableRow = (WmiTableRowView)tableView.getChild(rowIndex);
                    if (tableRow != null && tableRow.drawSeparator()) {
                        flag = 8;
                    }
                    WmiTableView.drawBorder(g, this.borders, flag, focus, left, bottom, right, bottom, highlighter, highlightColor);
                }
            }
            if (this.column == 0) {
                flag = 1;
                if ((tableView.getBorderStyleIndex() & flag) == 0) {
                    flag = 0;
                }
                WmiTableView.drawBorder(g, this.borders, flag, focus, left, top, left, bottom, highlighter, highlightColor);
            } else {
                WmiView columnView;
                flag = 1;
                if ((this.borders & 0x10) != 0 && (columnView = tableView.getChild(this.column)) != null) {
                    flag = this.columnSeparator ? 1 : 0;
                }
                WmiTableView.drawBorder(g, this.borders, flag, focus, left, top, left, bottom, highlighter, highlightColor);
            }
            if (this.column + this.columnSpan == tableView.getColumnCount()) {
                flag = 4;
                if ((tableView.getBorderStyleIndex() & flag) == 0) {
                    flag = 0;
                }
                WmiTableView.drawBorder(g, this.borders, flag, focus, right, top, right, bottom, highlighter, highlightColor);
            }
            g.setColor(saveColor);
            g2d.setStroke(saveStroke);
        }
    }

    public void setColumn(int column) throws WmiNoReadAccessException {
        if (column != this.column) {
            this.column = column;
            this.getDocumentView().invalidateAll(this);
        }
    }

    public void setRow(int row) {
        if (row != this.row) {
            this.row = row;
            this.markInvalid(1);
        }
    }

    @Override
    public void layoutView() throws WmiNoReadAccessException {
        if (this.getChildCount() == 1 && this.getChild(0) != null && this.getChild(0) instanceof WmiResizableContainerView) {
            ((WmiResizableContainerView)this.getChild(0)).setUserResizable(false);
        }
        if (!this.isLayoutValid()) {
            WmiTableCellModel model = (WmiTableCellModel)this.getModel();
            if (model != null) {
                WmiTableCellAttributeSet attributes = (WmiTableCellAttributeSet)model.getAttributesForRead();
                int oldColumnSpan = this.columnSpan;
                if (attributes != null) {
                    this.rowSpan = attributes.getRowSpan();
                    this.columnSpan = attributes.getColumnSpan();
                }
                if (this.rowSpan < 1) {
                    this.rowSpan = 1;
                }
                if (this.columnSpan < 1) {
                    this.columnSpan = 1;
                }
                if (this.columnSpan != oldColumnSpan && oldColumnSpan != -1) {
                    int i = 0;
                    while (i < this.length) {
                        WmiView child = this.getChild(i);
                        this.getDocumentView().invalidateAll(child);
                        ++i;
                    }
                }
            }
            this.extractBorderStyle();
            this.validateChildren();
            super.layoutView();
            this.width = this.getBreakWidth() + 10;
            this.height += 5;
            this.extractColumnSeparator();
        }
    }

    public void extractBorderStyle() throws WmiNoReadAccessException {
        Object value;
        WmiCompositeModel tableModel = WmiModelUtil.findAncestorOfTag(this.getModel(), WmiModelTag.TABLE);
        WmiAttributeSet attributes = tableModel.getAttributesForRead();
        Object object = value = attributes != null ? attributes.getAttribute("interior") : null;
        if (value != null) {
            String strValue = value.toString();
            if (strValue.equals("all")) {
                this.borders = 15;
            } else if (strValue.equals("none")) {
                WmiTableView tableView = (WmiTableView)WmiViewUtil.findAncestorOfTag(this, WmiModelTag.TABLE);
                this.borders = 0;
                if (this.column == 0 && (tableView.getBorderStyleIndex() & 1) != 0) {
                    this.borders |= 1;
                }
                if (this.column + this.columnSpan == tableView.getColumnCount() && (tableView.getBorderStyleIndex() & 4) != 0) {
                    this.borders |= 4;
                }
            } else if (strValue.equals("group")) {
                this.borders = 31;
            }
        }
    }

    private void extractColumnSeparator() throws WmiNoReadAccessException {
        this.columnSeparator = false;
        WmiTableView tableView = (WmiTableView)WmiViewUtil.findAncestorOfTag(this, WmiModelTag.TABLE);
        WmiView columnView = tableView.getChild(this.column);
        if (columnView != null) {
            Object value;
            WmiModel model = columnView.getModel();
            WmiAttributeSet attributes = model != null ? model.getAttributesForRead() : null;
            Object object = value = attributes != null ? attributes.getAttribute("separator") : null;
            if (value instanceof Boolean) {
                this.columnSeparator = ((Boolean)value).equals(Boolean.TRUE);
            } else if (value != null) {
                this.columnSeparator = value.toString().compareToIgnoreCase("true") == 0;
            }
        }
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public int getLeftIndent() {
        return 5;
    }

    @Override
    public int getTopMargin() {
        return 5;
    }

    @Override
    public int getBreakWidth() {
        int cellWidth = 0;
        WmiTableView table = (WmiTableView)WmiViewUtil.findAncestorOfTag(this, WmiModelTag.TABLE);
        if (table != null) {
            int i = 0;
            while (i < this.columnSpan) {
                cellWidth += table.getColumnWidth(this.column + i);
                ++i;
            }
            cellWidth -= 10;
        }
        if (cellWidth <= 0) {
            cellWidth = 400;
        }
        return cellWidth;
    }

    protected int computeColumnIndex() {
        int childPos;
        int index = -1;
        WmiCompositeView parent = this.getParentView();
        if (parent instanceof WmiTableRowView && (childPos = parent.indexOf(this)) >= 0) {
            index = 0;
            int i = 0;
            while (i < childPos) {
                WmiModelTag tag;
                WmiView child = parent.getChild(i);
                WmiModel model = child != null ? child.getModel() : null;
                WmiModelTag wmiModelTag = tag = model != null ? model.getTag() : null;
                if (tag == WmiModelTag.TABLE_CELL) {
                    ++index;
                }
                ++i;
            }
        }
        return index;
    }

    public int getCellHeight() {
        int cellHeight = 0;
        WmiTableView table = (WmiTableView)WmiViewUtil.findAncestorOfTag(this, WmiModelTag.TABLE);
        if (table != null) {
            int i = 0;
            while (i < this.rowSpan) {
                cellHeight += table.getRowHeight(this.row + i);
                ++i;
            }
        }
        return cellHeight;
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.getCellHeight());
    }

    @Override
    public void updateView() throws WmiNoReadAccessException {
        super.updateView();
    }

    public int getRowIndex() {
        return this.row;
    }

    public int getColumnIndex() {
        return this.column;
    }

    public int getRowSpan() {
        return this.rowSpan;
    }

    public int getColumnSpan() {
        return this.columnSpan;
    }

    @Override
    public int getWidthConstraint(boolean ignoreTopLevelView) {
        return this.getBreakWidth();
    }
}

