/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view;

import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiTableRowAttributeSet;
import com.maplesoft.mathdoc.view.WmiArrayCompositeView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiTableCellView;
import com.maplesoft.mathdoc.view.WmiTableView;
import java.awt.Point;

public class WmiTableRowView
extends WmiArrayCompositeView {
    private int row = -1;
    private boolean separator = true;

    public WmiTableRowView(WmiModel model, WmiMathDocumentView docView) {
        super(model, docView);
    }

    @Override
    public void layoutView() throws WmiNoReadAccessException {
        if (!this.isLayoutValid()) {
            Object sepValue;
            int size = this.getChildCount();
            this.width = 0;
            this.height = 0;
            WmiTableView table = (WmiTableView)this.getParentView();
            WmiModel model = this.getModel();
            WmiAttributeSet attributes = model != null ? model.getAttributesForRead() : null;
            Object alignment = attributes != null ? attributes.getAttribute("align") : null;
            int alignIndex = this.getAlignmentIndex(alignment);
            Object object = sepValue = attributes != null ? attributes.getAttribute("separator") : null;
            if (sepValue instanceof Boolean) {
                this.separator = sepValue.equals(Boolean.TRUE);
            } else if (sepValue != null) {
                this.separator = sepValue.toString().compareToIgnoreCase("true") == 0;
            }
            int maxAscent = 0;
            int maxDescent = 0;
            int n = 0;
            int i = 0;
            while (i < size) {
                WmiTableCellView pending = table.getActiveCell(n);
                while (pending != null && pending.getRowIndex() + pending.getRowSpan() > this.row) {
                    this.width += pending.getWidth();
                    pending = table.getActiveCell(n += pending.getColumnSpan());
                }
                WmiTableCellView cell = (WmiTableCellView)this.getChild(i);
                cell.setColumn(n);
                cell.setRow(this.row);
                cell.layoutView();
                if (cell.getRowSpan() > 1) {
                    table.setActiveCell(n, cell);
                } else {
                    table.setActiveCell(n, null);
                }
                n += cell.getColumnSpan();
                cell.setHorizontalOffset(this.width);
                this.width += cell.getWidth();
                if (cell.getRowSpan() == 1) {
                    if (cell.getHeight() > this.height) {
                        this.height = cell.getHeight();
                    }
                    if (cell.getBaseline() > maxAscent) {
                        maxAscent = cell.getBaseline();
                    }
                    if (cell.getHeight() - cell.getBaseline() > maxDescent) {
                        maxDescent = cell.getHeight() - cell.getBaseline();
                    }
                }
                ++i;
            }
            switch (alignIndex) {
                case 0: {
                    this.alignTop();
                    break;
                }
                case 1: {
                    this.alignCenter();
                    break;
                }
                case 2: {
                    this.alignBottom();
                    break;
                }
                default: {
                    this.alignBaseline(maxAscent, maxDescent);
                }
            }
            this.addNavigationLinks();
            super.layoutView();
        } else {
            this.updatePendingRows();
        }
    }

    private void updatePendingRows() {
        int size = this.getChildCount();
        WmiTableView table = (WmiTableView)this.getParentView();
        int n = 0;
        int i = 0;
        while (i < size) {
            WmiTableCellView pending = table.getActiveCell(n);
            while (pending != null && pending.getRowIndex() + pending.getRowSpan() > this.row) {
                this.width += pending.getWidth();
                pending = table.getActiveCell(n += pending.getColumnSpan());
            }
            WmiTableCellView cell = (WmiTableCellView)this.getChild(i);
            if (cell.getRowSpan() > 1) {
                table.setActiveCell(n, cell);
            } else {
                table.setActiveCell(n, null);
            }
            n += cell.getColumnSpan();
            ++i;
        }
    }

    private void alignTop() {
        int size = this.getChildCount();
        int i = 0;
        while (i < size) {
            WmiTableCellView cell = (WmiTableCellView)this.getChild(i);
            cell.setVerticalOffset(0);
            ++i;
        }
    }

    private void alignCenter() {
        int size = this.getChildCount();
        int i = 0;
        while (i < size) {
            WmiTableCellView cell = (WmiTableCellView)this.getChild(i);
            cell.setVerticalOffset((this.height - cell.getHeight()) / 2);
            ++i;
        }
    }

    private void alignBottom() {
        int size = this.getChildCount();
        int i = 0;
        while (i < size) {
            WmiTableCellView cell = (WmiTableCellView)this.getChild(i);
            cell.setVerticalOffset(this.height - cell.getHeight());
            ++i;
        }
    }

    private void alignBaseline(int maxAscent, int maxDescent) {
        int size = this.getChildCount();
        int i = 0;
        while (i < size) {
            WmiTableCellView cell = (WmiTableCellView)this.getChild(i);
            int offset = maxAscent - cell.getBaseline();
            int cellHeight = cell.getHeight() - cell.getBaseline() + maxAscent;
            cell.setVerticalOffset(offset);
            if (cellHeight > this.height) {
                this.height = cellHeight;
            }
            ++i;
        }
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
    }

    public void setRow(int row) {
        if (row != this.row) {
            this.row = row;
            this.markInvalid(1);
        }
    }

    @Override
    public void addNavigationLinks() {
        int i = 0;
        while (i < this.length - 1) {
            WmiPositionedView base = (WmiPositionedView)this.getChild(i);
            WmiPositionedView next = (WmiPositionedView)this.getChild(i + 1);
            if (base != null) {
                base.setNextView(next, 3);
            }
            if (next != null) {
                next.setNextView(base, 2);
            }
            ++i;
        }
    }

    @Override
    public WmiPositionedView getNearestChildView(Point pt) {
        return this.getNearestChildView(pt, 2);
    }

    public int getRow() {
        return this.row;
    }

    protected int getAlignmentIndex(Object alignment) {
        int index = 0;
        if (alignment != null) {
            String strValue = alignment.toString();
            int i = 0;
            while (i < 4) {
                if (strValue.equals(WmiTableRowAttributeSet.ALIGNMENT_VALUES[i])) {
                    index = i;
                    break;
                }
                ++i;
            }
        }
        return index;
    }

    public boolean drawSeparator() {
        return this.separator;
    }
}

