/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.font.WmiFontMetrics;
import com.maplesoft.mathdoc.font.WmiFontResolver;
import com.maplesoft.mathdoc.font.WmiTextLayout;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiModelObserver;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.math.WmiAbstractMathTokenModel;
import com.maplesoft.mathdoc.util.WmiResourcePackage;
import com.maplesoft.mathdoc.view.WmiAccessibleContext;
import com.maplesoft.mathdoc.view.WmiAdjustableTextBounds;
import com.maplesoft.mathdoc.view.WmiCaret;
import com.maplesoft.mathdoc.view.WmiGenericView;
import com.maplesoft.mathdoc.view.WmiHighlightPainter;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiParagraphView;
import com.maplesoft.mathdoc.view.WmiRenderPath;
import com.maplesoft.mathdoc.view.WmiScrollableContainerView;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiTextFragmentView;
import com.maplesoft.mathdoc.view.WmiTraversableView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewPath;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import com.maplesoft.mathdoc.view.math.WmiMathCaret;
import com.maplesoft.util.StringTools;
import com.maplesoft.util.WmiUnicodeMapper;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.MissingResourceException;
import javax.accessibility.AccessibleContext;

public class WmiTextView
extends WmiGenericView
implements WmiTraversableView,
WmiAdjustableTextBounds {
    private static final int LOW_ASCII_LIMIT = 128;
    private static final float ITALIC_ADJUST = 0.194f;
    public static final int UNDERLINE_OFFSET = 1;
    private static final float[] COMPOSED_DASH = new float[]{3.0f, 4.0f};
    public static final BasicStroke COMPOSED_STROKE = new BasicStroke(2.0f, 2, 2, 1.0f, COMPOSED_DASH, 0.0f);
    public static final BasicStroke CONVERTED_STROKE = new BasicStroke(3.0f);
    public static final float SUPERSCRIPT_SCALE_FACTOR = 0.8f;
    public static final float SUPERSCRIPT_RAISE_FACTOR = 0.5f;
    public static final float SUBSCRIPT_LOWER_FACTOR = 0.35f;
    private static final char[] JAPANESE_NO_STARTS = new char[]{'\uff64', '\uff61', '\uff63', '\uff71', '\uff72', '\uff73', '\uff74', '\uff75', '\uff82', '\uff94', '\uff95', '\uff96', '\uff9c', '\uff76', '\uff79', '\uff70', '\uff9e', '\uff9f', '\uff1b', '\uff1a', '\uff0e', '\u3001', '\u3002', '\uff0c', '\uff1f', '\uff01', '\uff09', '\uff3d', '\u300d', '\uff5d', '\u3042', '\u3044', '\u3046', '\u3048', '\u304a', '\u3064', '\u3084', '\u3086', '\u3088', '\u308f', ',', '.', ':', ';', '?', '!', ')', ']', '}'};
    private static final char[] JAPANESE_NO_ENDS = new char[]{'\uff08', '\uff3b', '\u300c', '\u3012', '\uff04', '\uff20', '\uffe5', '\uff03', '\u2018', '\u201c', '\u3014', '\u3008', '\u300a', '\u300e', '\u3010', '\uffe0', '\uffe1', '\u00a7', '(', '[', '{', '\u00a2', '\\', '$', '@', '#'};
    private static WmiUnicodeMapper noStarts = new WmiUnicodeMapper();
    private static WmiUnicodeMapper noEnds = new WmiUnicodeMapper();
    private static String undoInsertText = null;
    private static String undoDeleteText = null;
    protected WmiTextLayout layout = null;
    protected WmiFontAttributeSet attributes = null;
    protected int baselineAdjust = 0;
    private static int[] caretBounds;

    static {
        int i = 0;
        while (i < JAPANESE_NO_STARTS.length) {
            noStarts.put(JAPANESE_NO_STARTS[i], Boolean.TRUE);
            ++i;
        }
        i = 0;
        while (i < JAPANESE_NO_ENDS.length) {
            noEnds.put(JAPANESE_NO_ENDS[i], Boolean.TRUE);
            ++i;
        }
        try {
            WmiResourcePackage rb = WmiResourcePackage.getResourcePackage("com.maplesoft.mathdoc.view.resources.View");
            undoInsertText = rb.getStringForKey("InsertText.undo");
            undoDeleteText = rb.getStringForKey("DeleteText.undo");
        }
        catch (MissingResourceException e) {
            WmiErrorLog.log(e);
        }
        caretBounds = new int[4];
    }

    public WmiTextView(WmiModel model, WmiMathDocumentView docView) {
        super(model, docView);
    }

    public static String getUndoInsertTextName() {
        return undoInsertText;
    }

    @Override
    public String debugPrint(int indent) throws WmiNoReadAccessException {
        return String.valueOf(System.getProperty("line.separator")) + this.createIndent(indent) + "<Text x = " + this.x + " y = " + this.y + " width = " + this.width + " height = " + this.height + ">" + this.getText() + "</Text>";
    }

    @Override
    public boolean isRepeatable() {
        return false;
    }

    @Override
    public int getTraversalType() {
        return 1;
    }

    @Override
    public void layoutView() throws WmiNoReadAccessException {
        if (!this.isLayoutValid()) {
            boolean forPrint;
            String str = this.getText();
            int glyphCount = 0;
            WmiModel model = this.getModel();
            WmiMathDocumentView docView = this.getDocumentView();
            boolean bl = forPrint = docView != null ? docView.isPrintView() : false;
            if (model == null) {
                WmiErrorLog.log(new Exception("null model: might be pointing to a dead view"));
            }
            this.attributes = (WmiFontAttributeSet)model.getAttributesForRead();
            int zoom = this.getCorrectedZoomFactor();
            Font font = WmiFontResolver.getFont(this.attributes, zoom, forPrint);
            boolean superscript = this.attributes.isSuperscript();
            boolean subscript = this.attributes.isSubscript();
            if (model instanceof WmiAbstractMathTokenModel) {
                glyphCount = ((WmiAbstractMathTokenModel)model).getGlyphCount();
            }
            if (glyphCount > 0) {
                WmiAbstractMathTokenModel token = (WmiAbstractMathTokenModel)model;
                boolean isMath = WmiModelUtil.findAncestorOfTag(model, WmiModelTag.MATH) != null;
                this.layout = WmiTextLayout.createTextLayout(token, font, this.getDocumentView(), isMath);
                this.width = this.layout.getWidth();
                this.baseline = this.layout.getBaseline();
                this.height = this.layout.getHeight();
            } else if (str != null && str.length() > 0) {
                boolean isMath = WmiModelUtil.findAncestorOfTag(model, WmiModelTag.MATH) != null;
                this.layout = WmiTextLayout.createTextLayout(str, font, this.getDocumentView(), isMath);
                this.width = this.layout.getWidth();
                this.baseline = this.layout.getBaseline();
                this.height = this.layout.getHeight();
            } else {
                this.layout = null;
                this.width = this.getEmptyTextWidth();
                WmiFontMetrics metrics = WmiFontResolver.getFontMetrics(font);
                this.baseline = metrics.getFontProperty(0, forPrint) + metrics.getFontProperty(3, forPrint);
                this.height = this.baseline + metrics.getFontProperty(4, forPrint);
            }
            this.baselineAdjust = 0;
            if (superscript) {
                this.baselineAdjust -= Math.round((float)this.height * 0.5f);
                this.height -= this.baselineAdjust;
                this.baseline -= this.baselineAdjust;
            } else if (subscript) {
                this.baselineAdjust += Math.round((float)this.height * 0.35f);
                this.height += this.baselineAdjust;
            }
            super.layoutView();
        }
    }

    public int getCorrectedZoomFactor() throws WmiNoReadAccessException {
        int zoom = this.getZoomFactor();
        WmiModel model = this.getModel();
        this.attributes = (WmiFontAttributeSet)model.getAttributesForRead();
        boolean superscript = this.attributes.isSuperscript();
        boolean subscript = this.attributes.isSubscript();
        if (superscript || subscript) {
            zoom = Math.round((float)zoom * 0.8f);
        }
        return zoom;
    }

    public WmiTextLayout getLayout() {
        return this.layout;
    }

    public Color getForegroundColor() {
        return this.attributes != null ? new Color(this.attributes.getForeground()) : null;
    }

    public void applyKerningAdjustment(boolean pre, boolean post) {
        if (this.layout != null && this.enableKernAdjust()) {
            this.layout.applyKerningAdjustment(pre, post);
            this.width = this.layout.getWidth() + this.getLeftPadding() + this.getRightPadding();
        }
    }

    @Override
    public int computePreKernAdjustment() {
        return this.layout != null ? (int)this.layout.computePreKernAdjustment() : 0;
    }

    @Override
    public int computePostKernAdjustment() {
        return this.layout != null ? (int)this.layout.computePostKernAdjustment() : 0;
    }

    @Override
    public int computeSpaceAbove() {
        return this.layout != null ? this.layout.computeSpaceAbove() : this.getHeight();
    }

    @Override
    public int computeSpaceBelow() {
        return this.layout != null ? this.layout.computeSpaceBelow() : this.getHeight();
    }

    protected void setLayout(WmiTextLayout layout, WmiFontAttributeSet attributes, int baselineAdjust) {
        this.layout = layout;
        this.width = layout.getWidth();
        this.baseline = layout.getBaseline();
        this.height = layout.getHeight();
        this.attributes = attributes;
        this.baselineAdjust = baselineAdjust;
    }

    public boolean extractNextBreakpoint(WmiParagraphView.WmiBreakInfo info, boolean forceBreak) throws WmiNoReadAccessException {
        int start = info.nextStart;
        info.nextStart = -1;
        String str = info.activeText;
        if (info.view != this || start < 0) {
            info.view = this;
            str = null;
            start = 0;
        }
        if (str == null) {
            try {
                str = this.getText();
            }
            catch (WmiNoReadAccessException e) {
                WmiErrorLog.log(e);
            }
            info.activeText = str;
        }
        int absoluteWidthToStart = info.width;
        int relativeWidthToStart = 0;
        boolean foundBreakpoint = false;
        if (str != null && str.length() > 0 && this.layout != null) {
            int limit;
            Point pt;
            int offset;
            int length = str.length();
            int widthToBreak = 0;
            char lastChar = '\u0000';
            boolean isJapanese = StringTools.isJapaneseText(str);
            relativeWidthToStart = this.layout.getCaretPosition(start, true);
            int i = start;
            while (i < length) {
                boolean breakpoint = false;
                char ch = '\u0000';
                try {
                    ch = str.charAt(i);
                }
                catch (Exception e) {
                    WmiErrorLog.log(e);
                }
                if (Character.isWhitespace(ch) || lastChar == '.' && !Character.isDigit(ch) || lastChar == '-' && !Character.isDigit(ch) && ch != '.' && ch != '>' || lastChar == '+' && !Character.isDigit(ch) && ch != '.' || lastChar == '*' || lastChar == '!' || lastChar == '?' || lastChar == ')' || lastChar == ']' || lastChar == '=' || lastChar == ',' || lastChar == ';' || lastChar == '}' || ch == '(' || ch == '[' || ch == '{' || ch == '-' && Character.isDigit(lastChar) || Character.isWhitespace(lastChar)) {
                    breakpoint = true;
                } else if (isJapanese) {
                    breakpoint = this.isValidJapaneseBreakpoint(ch, lastChar);
                }
                if (breakpoint) {
                    widthToBreak = absoluteWidthToStart - relativeWidthToStart + this.layout.getCaretPosition(i, true);
                    if (widthToBreak > info.breakWidth) {
                        if (!foundBreakpoint) break;
                        info.forcedBreak = true;
                        break;
                    }
                    if (ch == '\n' || ch == '\r') {
                        char skipChar;
                        int nextWidth = widthToBreak;
                        int nextStart = i + 1;
                        char c = skipChar = ch == '\n' ? (char)'\r' : '\n';
                        if (i < length - 1 && (ch = str.charAt(i + 1)) == skipChar) {
                            ++nextStart;
                        }
                        foundBreakpoint = true;
                        info.update(this, i, nextStart, nextWidth, nextWidth, true, false);
                        break;
                    }
                    if (!info.explicitBreaksOnly) {
                        int nextStart = i;
                        if (Character.isWhitespace(ch)) {
                            ++nextStart;
                        }
                        int widthAfterBreak = absoluteWidthToStart - relativeWidthToStart + this.layout.getCaretPosition(nextStart, true);
                        info.update(this, i, nextStart, widthToBreak, widthAfterBreak, false, false);
                        foundBreakpoint = true;
                    }
                }
                lastChar = ch;
                ++i;
            }
            if (!info.explicitBreaksOnly && !foundBreakpoint && forceBreak && (offset = this.getOffset(pt = new Point(limit = info.breakWidth - (absoluteWidthToStart - relativeWidthToStart), 0))) > start) {
                widthToBreak = absoluteWidthToStart - relativeWidthToStart + this.layout.getCaretPosition(offset, true);
                int nextStart = offset != this.getLength() ? offset : -1;
                info.update(this, offset, nextStart, widthToBreak, widthToBreak, true, true);
                foundBreakpoint = true;
            }
        }
        return foundBreakpoint || this.getWidth() - relativeWidthToStart == 0;
    }

    private boolean isValidJapaneseBreakpoint(char ch, char lastCh) {
        boolean isValid = false;
        if (ch < '\u0080') {
            if (lastCh >= '\u0080' && noEnds.get(lastCh) == null) {
                isValid = true;
            }
        } else if (noStarts.get(ch) == null && noEnds.get(lastCh) == null) {
            isValid = true;
        }
        return isValid;
    }

    public WmiView createViewFragment(int startIndex, int endIndex) throws WmiNoReadAccessException {
        return new WmiTextFragmentView(this.getModel(), this.getDocumentView(), startIndex, endIndex);
    }

    public WmiView createViewFragment(int startIndex) throws WmiNoReadAccessException {
        return this.createViewFragment(startIndex, this.getTraversableCount());
    }

    public String getText() throws WmiNoReadAccessException {
        String str = null;
        if (this.getModel() instanceof WmiTextModel) {
            WmiTextModel model = (WmiTextModel)this.getModel();
            str = model.getText();
        }
        return str;
    }

    public int getLength() throws WmiNoReadAccessException {
        WmiTextModel m = (WmiTextModel)this.getModel();
        return m.getLength();
    }

    @Override
    public int getOffset(Point pt) {
        int offset = 0;
        if (this.layout != null) {
            offset = this.layout.getIndex(pt);
        }
        return offset;
    }

    public int getHorizontalOffset(int index) {
        int offset = 0;
        if (this.layout != null) {
            offset = this.layout.getCaretPosition(index, true);
        }
        return offset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setPositionMarker(int offset) {
        WmiModel model = this.getModel();
        if (!WmiModelLock.readLock(model, true)) return;
        try {
            try {
                WmiMathDocumentView docView;
                if (offset == -1) {
                    offset = this.getTraversableCount();
                }
                if ((docView = this.getDocumentView()) != null) {
                    WmiCaret caret = docView.getCaret();
                    boolean setMarker = false;
                    if (caret == null || caret instanceof WmiMathCaret) {
                        caret = new WmiCaret(docView);
                        setMarker = true;
                    }
                    Object object = docView.getTreeLock();
                    synchronized (object) {
                        int[] nArray = caretBounds;
                        synchronized (caretBounds) {
                            WmiScrollableContainerView container = WmiViewUtil.findEnclosingContainer(this);
                            this.getCaretBounds(container, offset, caretBounds);
                            caret.updateCaretBounds(container, caretBounds[0], caretBounds[1], caretBounds[2], caretBounds[3]);
                            // ** MonitorExit[var7_8] (shouldn't be in output)
                        }
                    }
                    {
                        caret.updateView(this, offset);
                        if (setMarker) {
                            docView.setPositionMarker(caret);
                        }
                        caret.show();
                        return;
                    }
                }
                WmiErrorLog.log(new Exception("unable to find document view"));
                return;
            }
            catch (WmiNoReadAccessException e) {
                WmiErrorLog.log(e);
                WmiModelLock.readUnlock(model);
            }
            return;
        }
        finally {
            WmiModelLock.readUnlock(model);
        }
    }

    protected int[] getCaretBounds(WmiScrollableContainerView container, int offset) throws WmiNoReadAccessException {
        return this.getCaretBounds(container, offset, null);
    }

    private int[] getCaretBounds(WmiScrollableContainerView container, int offset, int[] bounds) throws WmiNoReadAccessException {
        int[] res = bounds != null ? bounds : new int[4];
        int length = this.getLength();
        WmiTextModel model = (WmiTextModel)this.getModel();
        WmiFontAttributeSet set = (WmiFontAttributeSet)model.getAttributesForRead();
        Font font = WmiFontResolver.getFont(set, this.getZoomFactor(), this.getDocumentView().isPrintView());
        int horizontalOffset = 0;
        if (length > 0) {
            int index = offset < length ? offset : length - 1;
            horizontalOffset = this.getCaretPosition(index, offset < length);
        }
        WmiFontMetrics metrics = WmiFontResolver.getFontMetrics(font);
        boolean isPrinting = this.getDocumentView().isPrintView();
        int ascent = metrics.getFontProperty(3, isPrinting);
        int descent = metrics.getFontProperty(4, isPrinting);
        int caretHeight = ascent + descent;
        WmiMathDocumentView docView = this.getDocumentView();
        Point pt = WmiViewUtil.getAbsoluteOffset(this);
        if (container != null && container != docView) {
            Point origin = WmiViewUtil.getAbsoluteOffset(container);
            pt.x -= origin.x;
            pt.y -= origin.y;
        }
        if (docView != null) {
            int left;
            int right = left = pt.x + horizontalOffset + this.getLeftPadding();
            int top = pt.y + this.baseline - ascent;
            int bottom = top + caretHeight;
            if (font.isItalic()) {
                right += (int)(0.194f * (float)this.getBaseline());
                bottom -= (int)(0.194f * (float)(this.getHeight() - this.getBaseline()));
            }
            if (this.baselineAdjust != 0) {
                bottom += this.baselineAdjust;
                if ((top += this.baselineAdjust) < pt.y) {
                    top = pt.y;
                }
                if (bottom > pt.y + this.getHeight()) {
                    bottom = pt.y + this.getHeight();
                }
            }
            res[0] = left;
            res[1] = top;
            res[2] = right;
            res[3] = bottom;
        } else {
            WmiErrorLog.log(new Exception("unable to find document view"));
        }
        return res;
    }

    protected int getCaretPosition(int index, boolean before) {
        return this.layout != null ? this.layout.getCaretPosition(index, before) : 0;
    }

    public int[] getCharacterBounds(int offset) throws WmiNoReadAccessException {
        WmiScrollableContainerView container = WmiViewUtil.findEnclosingContainer(this);
        int[] bounds = new int[4];
        int[] b1 = this.getCaretBounds(container, offset);
        int[] b2 = this.getCaretBounds(container, offset + 1);
        bounds[0] = b1[0];
        bounds[1] = b1[1];
        bounds[2] = b2[2] - b1[0];
        bounds[3] = b2[3] - b1[1];
        return bounds;
    }

    public WmiFontAttributeSet getFontAttributes() {
        return this.attributes;
    }

    @Override
    public void updateView() {
        WmiMathDocumentView docView = this.getDocumentView();
        WmiModel targetModel = this.getModel();
        WmiModelObserver observer = targetModel != null ? targetModel.getObserver() : null;
        while (observer != null) {
            WmiView view;
            WmiModelObserver next = observer.getNextObserver();
            if (observer != this && observer instanceof WmiTextFragmentView && (view = (WmiView)((Object)observer)).getDocumentView() == docView) {
                view.invalidate(1);
                view.release();
            }
            observer = next;
        }
        this.invalidate(1);
    }

    @Override
    public void draw(Graphics g, WmiRenderPath path, Rectangle bounds) {
        Font oldFont = g.getFont();
        Color oldColor = g.getColor();
        if (this.layout != null && this.attributes != null) {
            int xOffset = path.getHorizontalOffset();
            int yOffset = path.getVerticalOffset();
            WmiSelection selection = path.getSelection();
            WmiHighlightPainter highlighter = selection != null ? selection.getSelectionHighlighter() : null;
            Rectangle[] selectionBounds = null;
            if (highlighter != null) {
                short shift = this.layout != null ? this.layout.computePreKernAdjustment() : (short)0;
                int widthAdjust = this.layout != null ? this.layout.computePostKernAdjustment() + shift : 0;
                selectionBounds = highlighter.intersect(this.x + xOffset - shift + path.getHorizontalShift(), this.y + yOffset + this.baselineAdjust + path.getVerticalShift(), this.width + widthAdjust, this.height);
            }
            if (this.attributes.isOpaque()) {
                g.setColor(new Color(this.attributes.getBackground()));
                g.fillRect(xOffset + this.x, yOffset + this.y + this.baselineAdjust, this.width, this.height);
                if (selectionBounds != null) {
                    g.setColor(this.getDocumentView().getColor(4));
                    int i = 0;
                    while (i < selectionBounds.length) {
                        g.fillRect(selectionBounds[i].x - path.getHorizontalShift(), selectionBounds[i].y - path.getVerticalShift(), selectionBounds[i].width, selectionBounds[i].height);
                        ++i;
                    }
                }
            }
            Color foreground = new Color(this.attributes.getForeground());
            g.setColor(foreground);
            this.drawText(g, path, this.x + xOffset + this.getLeftPadding(), this.y + yOffset);
            WmiMathDocumentView docView = this.getDocumentView();
            if (selectionBounds != null && docView != null) {
                g.setColor(docView.getColor(3));
                int i = 0;
                while (i < selectionBounds.length) {
                    Rectangle saveClip = g.getClipBounds();
                    g.clipRect(selectionBounds[i].x - path.getHorizontalShift(), selectionBounds[i].y - path.getVerticalShift(), selectionBounds[i].width, selectionBounds[i].height);
                    this.drawText(g, path, this.x + xOffset + this.getLeftPadding(), this.y + yOffset);
                    g.setClip(saveClip);
                    ++i;
                }
            }
        }
        g.setFont(oldFont);
        g.setColor(oldColor);
    }

    private void drawText(Graphics g, WmiRenderPath renderPath, int xPos, int yPos) {
        boolean drawUnderline;
        if (this.layout != null) {
            if (renderPath.drawStringsWithGlyphVectors()) {
                this.layout.draw(g, xPos, yPos + this.baseline + this.baselineAdjust);
            } else {
                this.layout.drawAsString(g, xPos, yPos + this.baseline + this.baselineAdjust);
            }
        }
        boolean bl = drawUnderline = this.attributes.isUnderlined() || this.attributes.isComposed();
        if (drawUnderline |= this.attributes.isConverted()) {
            Graphics2D g2 = (Graphics2D)g;
            Stroke saveStroke = g2.getStroke();
            Color saveColor = g2.getColor();
            if (this.attributes.isComposed() || this.attributes.isConverted() && !this.attributes.isInputMethodSelected()) {
                g2.setStroke(COMPOSED_STROKE);
                g.setColor(Color.DARK_GRAY);
            } else if (this.attributes.isConverted() && this.attributes.isInputMethodSelected()) {
                g2.setStroke(CONVERTED_STROKE);
                g.setColor(Color.BLACK);
            }
            if (this.attributes.isUnderlined()) {
                g.drawLine(xPos + this.getUnderlineHorizontalOffset(), yPos + this.baseline + this.getUnderlineVerticalOffset(), xPos + this.getUnderlineHorizontalOffset() + this.width + this.getUnderlineHorizontalEndOffset(), yPos + this.baseline + this.getUnderlineVerticalOffset());
            } else {
                g.drawLine(xPos + this.getUnderlineHorizontalOffset() + 2, yPos + this.baseline + this.getUnderlineVerticalOffset(), xPos + this.getUnderlineHorizontalOffset() + this.width + this.getUnderlineHorizontalEndOffset() - 2, yPos + this.baseline + this.getUnderlineVerticalOffset());
            }
            g2.setStroke(saveStroke);
            g2.setColor(saveColor);
        }
    }

    public int getUnderlineHorizontalOffset() {
        return 0;
    }

    public int getUnderlineHorizontalEndOffset() {
        return 0;
    }

    public int getUnderlineVerticalOffset() {
        return Math.round((float)(1 * this.getZoomFactor()) / 133.0f);
    }

    public Font getFont() {
        return this.layout != null ? this.layout.getFont() : null;
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public int getTraversableCount() {
        int len = 0;
        if (this.layout != null) {
            len = this.layout.getTextLength();
        }
        return len;
    }

    public int getAdjustedBaseline() {
        return this.baseline + this.baselineAdjust;
    }

    public void insertChar(char ch, int offset) {
        this.insertString(Character.toString(ch), offset);
    }

    /*
     * Exception decompiling
     */
    public void insertString(String str, int offset) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Loose catch block
     */
    public void delete(int offset, int length) {
        block8: {
            WmiTextModel model = null;
            try {
                model = (WmiTextModel)this.getModel();
                WmiModelLock.writeLock(model, true);
                WmiMathDocumentModel doc = model.getDocument();
                WmiMathDocumentView docView = this.getDocumentView();
                model.deleteText(offset, length);
                docView.setPendingPosition(new WmiModelPosition(model, offset));
                doc.update(undoDeleteText);
            }
            catch (WmiNoWriteAccessException e) {
                WmiErrorLog.log(e);
                WmiModelLock.writeUnlock(model);
                break block8;
            }
            catch (WmiModelIndexOutOfBoundsException e) {
                WmiErrorLog.log(e);
                WmiModelLock.writeUnlock(model);
                break block8;
            }
            catch (WmiNoUpdateAccessException e) {
                WmiErrorLog.log(e);
                {
                    catch (Throwable throwable) {
                        WmiModelLock.writeUnlock(model);
                        throw throwable;
                    }
                }
                WmiModelLock.writeUnlock(model);
                break block8;
            }
            WmiModelLock.writeUnlock(model);
        }
    }

    public int getStartOffset() {
        return 0;
    }

    public int getEndOffset() throws WmiNoReadAccessException {
        return this.getLength();
    }

    public int getLeftPadding() {
        return 0;
    }

    public int getRightPadding() {
        return 0;
    }

    public boolean enableKernAdjust() {
        return true;
    }

    public void addTraversableLinks() {
    }

    public WmiViewPath createViewPath(int offset) {
        WmiViewPath path = new WmiViewPath(this);
        path.push(offset);
        return path;
    }

    @Override
    protected AccessibleContext createAccessibleContext() {
        return new WmiAccessibleContext();
    }

    protected int getEmptyTextWidth() throws WmiNoReadAccessException {
        return 0;
    }

    @Override
    public int doExplicitLinebreak(WmiParagraphView paragraph) throws WmiNoReadAccessException {
        boolean found = false;
        String text = this.getText();
        if (text != null) {
            int bp1 = text.indexOf(10);
            int bp2 = text.indexOf(13);
            int breakpoint = -1;
            int consume = 1;
            if (bp1 >= 0 && bp2 >= 0) {
                int n = breakpoint = bp1 < bp2 ? bp1 : bp2;
                if (Math.abs(bp2 - bp1) == 1) {
                    ++consume;
                }
            } else if (bp1 >= 0 || bp2 >= 0) {
                int n = breakpoint = bp1 >= 0 ? bp1 : bp2;
            }
            if (breakpoint >= 0) {
                paragraph.split(this, breakpoint, consume);
                found = true;
            }
        }
        return found ? 2 : 0;
    }

    @Override
    public int doForcedLinebreak(WmiParagraphView paragraph, int horizontalOffset, int breakWidth) throws WmiNoReadAccessException {
        boolean found = false;
        int limit = breakWidth - horizontalOffset;
        Point pt = new Point(limit, 0);
        int textOffset = this.getOffset(pt);
        if (textOffset > 0) {
            found = true;
            paragraph.split(this, textOffset, 0);
        }
        return found ? 2 : 0;
    }

    @Override
    public int doImplicitLinebreak(WmiParagraphView paragraph, int horizontalOffset, int breakWidth, int thresholdCost) throws WmiNoReadAccessException {
        boolean found = false;
        WmiParagraphView.WmiBreakInfo info = new WmiParagraphView.WmiBreakInfo(false);
        info.breakWidth = breakWidth - horizontalOffset;
        this.extractNextBreakpoint(info, false);
        if (info.breakPoint > 0) {
            int consume = 0;
            if (info.nextStart > info.breakPoint) {
                consume = info.nextStart - info.breakPoint;
            }
            paragraph.split(this, info.breakPoint, consume);
            found = true;
        }
        return found ? 2 : 0;
    }
}

