/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view;

import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiResizeDecorator;
import java.awt.Graphics;
import java.awt.Rectangle;

public class WmiThickResizer
extends WmiResizeDecorator {
    public static final int BORDER_THICKNESS = 8;

    public WmiThickResizer(WmiMathDocumentView view) {
        super(view);
    }

    @Override
    protected int selectedHotspot(int x, int y, Rectangle bounds) {
        int hotspot = 0;
        int curWidth = bounds.width;
        int curHeight = bounds.height;
        if (x > 0 && y > 0 && x < curWidth && y < curHeight) {
            if (y < 8) {
                if (x < 8) {
                    hotspot = 1;
                } else if (x > curWidth - 8) {
                    hotspot = 3;
                } else if (x > curWidth / 2 - 4 && x < curWidth / 2 + 4) {
                    hotspot = 2;
                }
            } else if (y > curHeight - 8) {
                if (x < 8) {
                    hotspot = 6;
                } else if (x > curWidth - 8) {
                    hotspot = 8;
                } else if (x > curWidth / 2 - 4 && x < curWidth / 2 + 4) {
                    hotspot = 7;
                }
            } else if (y > curHeight / 2 - 4 && y < curHeight / 2 + 4) {
                if (x < 8) {
                    hotspot = 4;
                } else if (x > curWidth - 8) {
                    hotspot = 5;
                }
            }
        }
        return hotspot;
    }

    @Override
    public void drawBounds(Graphics g, int xPos, int yPos, int xSize, int ySize) {
        super.drawBounds(g, xPos, yPos, xSize, ySize);
        g.translate(xPos - 1, yPos - 1);
        int size = 7;
        g.drawRect(1, 1, 7, 7);
        g.drawRect(xSize / 2 - 3, 1, 7, 7);
        g.drawRect(xSize - 7, 1, 7, 7);
        g.drawRect(1, ySize / 2 - 3, 7, 7);
        g.drawRect(xSize - 7, ySize / 2 - 3, 7, 7);
        g.drawRect(1, ySize - 7, 7, 7);
        g.drawRect(xSize / 2 - 3, ySize - 7, 7, 7);
        g.drawRect(xSize - 7, ySize - 7, 7, 7);
        g.translate(-xPos + 1, -yPos + 1);
    }
}

