/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view;

import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import com.maplesoft.mathdoc.util.WmiAncestorPath;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiRowView;
import com.maplesoft.mathdoc.view.WmiSwitchableCompositeView;
import com.maplesoft.mathdoc.view.WmiTextView;
import com.maplesoft.mathdoc.view.WmiView;

public class WmiViewPath
extends WmiAncestorPath {
    public WmiViewPath() {
    }

    public WmiViewPath(WmiViewPath reference) {
        super(reference);
    }

    public WmiViewPath(WmiView reference) {
        WmiCompositeView parent = null;
        if (reference != null) {
            parent = reference.getParentView();
        }
        while (parent != null && !(parent instanceof WmiMathDocumentView)) {
            int index = parent.indexOf(reference);
            if (index >= 0) {
                this.push(index);
            }
            reference = parent;
            parent = reference.getParentView();
        }
        int i = 0;
        int j = this.length - 1;
        int temp = -1;
        while (i < j) {
            temp = this.path[i];
            this.path[i] = this.path[j];
            this.path[j] = temp;
            ++i;
            --j;
        }
    }

    public static WmiViewPath commonParent(WmiViewPath firstPath, WmiViewPath secondPath) {
        WmiViewPath parent = new WmiViewPath();
        if (firstPath != null && secondPath != null) {
            WmiViewPath first = (WmiViewPath)firstPath.clone();
            WmiViewPath second = (WmiViewPath)secondPath.clone();
            while (first.depth() > second.depth()) {
                first.pop();
            }
            while (second.depth() > first.depth()) {
                second.pop();
            }
            int idx = 0;
            while (idx < first.depth()) {
                if (first.peek(idx) != second.peek(idx)) break;
                parent.push(first.peek(idx));
                ++idx;
            }
        }
        return parent;
    }

    public WmiModelPosition createModelPosition(WmiMathDocumentView docView) throws WmiInvalidModelInitializationException {
        WmiModel model;
        int offset = 0;
        WmiView view = docView;
        int size = this.depth();
        int i = 0;
        while (i < size) {
            WmiCompositeView comp;
            WmiSwitchableCompositeView par;
            WmiRowView broken;
            int index = this.peek(i);
            if (view instanceof WmiSwitchableCompositeView && (broken = (par = (WmiSwitchableCompositeView)view).getRootPhysicalView()) != null) {
                view = broken;
            }
            if (view instanceof WmiCompositeView) {
                if (index < 0) {
                    offset = index;
                    break;
                }
                comp = view;
                int limit = comp.getChildCount();
                if (index >= limit) {
                    offset = -1;
                    break;
                }
            } else {
                if (i >= size) break;
                offset = index;
                break;
            }
            view = comp.getChild(index);
            ++i;
        }
        WmiModel wmiModel = model = view != null ? view.getModel() : null;
        if (view instanceof WmiTextView) {
            if (offset < 0) {
                offset = ((WmiTextView)view).getTraversableCount();
            }
            offset += ((WmiTextView)view).getStartOffset();
        }
        return new WmiModelPosition(model, offset);
    }

    public WmiView extractView(WmiMathDocumentView docView) {
        return this.extractView(docView, null);
    }

    public WmiView extractView(WmiMathDocumentView docView, int[] offsetArray) {
        WmiView view = docView;
        int size = this.depth();
        int i = 0;
        while (i < size) {
            WmiRowView physical;
            int index = this.peek(i);
            if (index < 0) {
                if (offsetArray == null) break;
                offsetArray[0] = index;
                break;
            }
            if (view instanceof WmiSwitchableCompositeView && (physical = ((WmiSwitchableCompositeView)view).getRootPhysicalView()) != null) {
                view = physical;
            }
            if (view instanceof WmiCompositeView) {
                if (index >= ((WmiCompositeView)view).getChildCount()) {
                    if (offsetArray == null) break;
                    offsetArray[0] = -1;
                    break;
                }
            } else {
                if (offsetArray == null || offsetArray.length <= 0) break;
                offsetArray[0] = index;
                break;
            }
            view = ((WmiCompositeView)view).getChild(index);
            ++i;
        }
        return view;
    }

    public Object clone() {
        return new WmiViewPath(this);
    }
}

