/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAttributeComparator;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiDeleteHandler;
import com.maplesoft.mathdoc.model.WmiDeleteManager;
import com.maplesoft.mathdoc.model.WmiDeletePlaceholderModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentHierarchyValidator;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiModelPath;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.WmiParagraphModel;
import com.maplesoft.mathdoc.model.WmiTaskWrapperModel;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.math.WmiFractionModel;
import com.maplesoft.mathdoc.model.math.WmiMathFencedModel;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiRootModel;
import com.maplesoft.mathdoc.util.WmiAncestorPath;
import com.maplesoft.mathdoc.util.WmiResourcePackage;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiDefaultPositionUpdateHandler;
import com.maplesoft.mathdoc.view.WmiGenericView;
import com.maplesoft.mathdoc.view.WmiHighlightPainter;
import com.maplesoft.mathdoc.view.WmiMapleTACompositeView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiResizableContainerView;
import com.maplesoft.mathdoc.view.WmiScrollableContainerView;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiSelectionHighlighter;
import com.maplesoft.mathdoc.view.WmiTextView;
import com.maplesoft.mathdoc.view.WmiTraversableView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewPath;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import java.awt.Toolkit;
import java.util.MissingResourceException;
import java.util.Stack;

public class WmiViewPathInterval
implements WmiSelection {
    private static final int SELECTION_START_MODE = 0;
    private static final int SELECTION_END_MODE = 1;
    public static final int SELECTION_START_INDEX = 0;
    public static final int SELECTION_END_INDEX = 1;
    public static final int SELECTION_BOUNDS = 2;
    private static String undoDeleteSelectionText;
    public static String undoReplaceSelectionText;
    protected WmiMathDocumentView docView;
    protected WmiViewPath lowerBound;
    protected WmiViewPath upperBound;
    private WmiViewPath anchor;
    private WmiSelectionHighlighter highlighter;
    private WmiModel startModel;
    private int startOffset;
    private WmiModel endModel;
    private int endOffset;
    private static int ONBOUNDERY;
    private static int OUTSIDEBOUNDRY;
    private static int INSIDEBOUNDRY;
    private static int ONBOUNDERYPARTIALLY;
    private static int ONBOUNDERYFULLY;

    static {
        try {
            WmiResourcePackage rb = WmiResourcePackage.getResourcePackage("com.maplesoft.mathdoc.view.resources.View");
            undoDeleteSelectionText = rb.getStringForKey("DeleteSelection.undo");
            undoReplaceSelectionText = rb.getStringForKey("ReplaceSelection.undo");
        }
        catch (MissingResourceException e) {
            WmiErrorLog.log(e);
        }
        ONBOUNDERY = 0;
        OUTSIDEBOUNDRY = 1;
        INSIDEBOUNDRY = 2;
        ONBOUNDERYPARTIALLY = 3;
        ONBOUNDERYFULLY = 4;
    }

    public WmiViewPathInterval(WmiMathDocumentView docView) {
        this.docView = docView;
        this.anchor = null;
        this.upperBound = null;
        this.lowerBound = null;
        this.endModel = null;
        this.startModel = null;
    }

    public WmiViewPathInterval(WmiMathDocumentView docView, WmiViewPath first, WmiViewPath second) {
        int[] offset;
        WmiView view;
        this.docView = docView;
        this.anchor = (WmiViewPath)first.clone();
        boolean lowAnchor = true;
        if (second.greaterThan(this.anchor)) {
            this.lowerBound = (WmiViewPath)first.clone();
            this.upperBound = (WmiViewPath)second.clone();
        } else {
            this.lowerBound = (WmiViewPath)second.clone();
            this.upperBound = (WmiViewPath)first.clone();
            lowAnchor = false;
        }
        this.validateSelectionInterval();
        WmiViewPath caretPath = null;
        if (lowAnchor) {
            this.anchor = (WmiViewPath)this.lowerBound.clone();
            caretPath = (WmiViewPath)this.upperBound.clone();
        } else {
            this.anchor = (WmiViewPath)this.upperBound.clone();
            caretPath = (WmiViewPath)this.lowerBound.clone();
        }
        if (caretPath != null && (view = caretPath.extractView(docView, offset = new int[1])) instanceof WmiPositionedView) {
            ((WmiPositionedView)view).setPositionMarker(offset[0]);
        }
        if (docView != null) {
            this.computeModelBounds();
            this.highlighter = new WmiSelectionHighlighter(docView, this, null);
        }
    }

    public void updateModelSelection(WmiModel newStartModel, int newStartOffset, WmiModel newEndModel, int newEndOffset) {
        this.startModel = newStartModel;
        this.startOffset = newStartOffset;
        this.endModel = newEndModel;
        this.endOffset = newEndOffset;
    }

    @Override
    public void updateSelection(WmiViewPath path) {
        if (this.anchor == null) {
            if (this.lowerBound != null && this.upperBound != null) {
                this.anchor = path.greaterThan(this.lowerBound) ? (WmiViewPath)this.lowerBound.clone() : (WmiViewPath)this.upperBound.clone();
            } else if (this.lowerBound != null) {
                this.anchor = (WmiViewPath)this.lowerBound.clone();
            } else if (this.upperBound != null) {
                this.anchor = (WmiViewPath)this.upperBound.clone();
            }
        }
        if (this.anchor != null) {
            int[] offset;
            WmiView view;
            WmiViewPath caretPath;
            if (path.greaterThan(this.anchor)) {
                caretPath = this.upperBound = (WmiViewPath)path.clone();
                this.lowerBound = (WmiViewPath)this.anchor.clone();
            } else {
                caretPath = this.lowerBound = (WmiViewPath)path.clone();
                this.upperBound = (WmiViewPath)this.anchor.clone();
            }
            this.validateSelectionInterval();
            if (caretPath != null && (view = caretPath.extractView(this.docView, offset = new int[1])) instanceof WmiPositionedView && !(view instanceof WmiResizableContainerView)) {
                ((WmiPositionedView)view).setPositionMarker(offset[0]);
            }
            if (this.docView != null) {
                this.computeModelBounds();
                this.highlighter = new WmiSelectionHighlighter(this.docView, this, this.highlighter);
            }
        }
    }

    public void updateSelection(WmiModel newStartModel, int newStartOffset, WmiModel newEndModel, int newEndOffset) throws WmiNoReadAccessException {
        this.updateModelSelection(newStartModel, newStartOffset, newEndModel, newEndOffset);
        boolean validate = false;
        if (this.startModel != null && this.startModel.getParent() == null || this.endModel != null && this.endModel.getParent() == null) {
            validate = false;
        }
        this.lowerBound = this.modelToPath(this.startModel, this.startOffset, 0);
        this.upperBound = this.modelToPath(this.endModel, this.endOffset, 1);
        if (this.docView != null && validate && this.lowerBound != null && this.upperBound != null) {
            this.validateSelectionInterval();
        }
        if (this.docView != null && this.lowerBound != null && this.upperBound != null) {
            this.computeModelBounds();
            this.highlighter = new WmiSelectionHighlighter(this.docView, this, this.highlighter);
        }
    }

    public void getModelInterval(WmiModelPosition[] modelPositions) {
        modelPositions[0] = new WmiModelPosition(this.startModel, this.startOffset);
        modelPositions[1] = new WmiModelPosition(this.endModel, this.endOffset);
    }

    @Override
    public boolean getModelInterval(WmiModel[] models, int[] offsets) {
        models[0] = this.startModel;
        models[1] = this.endModel;
        offsets[0] = this.startOffset;
        offsets[1] = this.endOffset;
        return true;
    }

    protected void computeModelBounds() {
        if (this.docView != null) {
            WmiModelPosition pos = this.pathToModel(this.lowerBound);
            this.startModel = pos.getModel();
            this.startOffset = pos.getOffset();
            pos = this.pathToModel(this.upperBound);
            this.endModel = pos.getModel();
            this.endOffset = pos.getOffset();
        }
    }

    protected void validateSelectionInterval() {
        WmiView lowerView;
        WmiView upperView = this.upperBound != null ? this.upperBound.extractView(this.docView) : null;
        WmiView wmiView = lowerView = this.lowerBound != null ? this.lowerBound.extractView(this.docView) : null;
        if (lowerView != null && upperView != null) {
            WmiViewPath commonPath;
            WmiView commonParent;
            WmiScrollableContainerView endContainer;
            WmiScrollableContainerView startContainer = lowerView == null ? null : WmiViewUtil.findEnclosingContainer(lowerView);
            WmiScrollableContainerView wmiScrollableContainerView = endContainer = upperView == null ? null : WmiViewUtil.findEnclosingContainer(upperView);
            if (startContainer != endContainer) {
                if (startContainer != null && !startContainer.isDocumentView()) {
                    this.lowerBound = new WmiViewPath(startContainer);
                }
                if (endContainer != null && !endContainer.isDocumentView()) {
                    this.upperBound = new WmiViewPath(endContainer);
                }
            }
            WmiModel parentModel = (commonParent = (commonPath = WmiViewPath.commonParent(this.lowerBound, this.upperBound)).extractView(this.docView)) != null ? commonParent.getModel() : null;
            WmiModel lowerModel = lowerView.getModel();
            WmiModel upperModel = upperView.getModel();
            boolean locked = WmiModelLock.readLock(lowerModel, false);
            try {
                try {
                    WmiCompositeModel lowerTableRowParent = WmiModelUtil.findAncestorOfTag(lowerModel, WmiModelTag.MATH_TABLE_ROW);
                    WmiCompositeModel upperTableRowParent = WmiModelUtil.findAncestorOfTag(upperModel, WmiModelTag.MATH_TABLE_ROW);
                    if (lowerTableRowParent != null && upperTableRowParent != null && lowerTableRowParent != upperTableRowParent) {
                        commonParent = WmiViewUtil.findAncestorOfTag(lowerView, WmiModelTag.MATH_TABLE);
                        if (commonParent != null) {
                            this.lowerBound = new WmiViewPath(commonParent);
                            this.lowerBound.push(0);
                            this.upperBound = new WmiViewPath(commonParent);
                            this.upperBound.push(-1);
                        }
                    } else if (parentModel != null && lowerModel != upperModel && !parentModel.isSubselectable()) {
                        this.lowerBound = new WmiViewPath(commonParent);
                        this.lowerBound.push(0);
                        this.upperBound = new WmiViewPath(commonParent);
                        this.upperBound.push(-1);
                    } else if (commonParent != null) {
                        this.applyViewBoundaryConstraints();
                        if (!this.applyModelConstraints()) {
                            this.lowerBound = this.adjustPath(this.lowerBound, commonParent, 0);
                            this.upperBound = this.adjustPath(this.upperBound, commonParent, -1);
                        }
                    }
                }
                catch (WmiNoReadAccessException nrae) {
                    WmiErrorLog.log(nrae);
                    if (locked) {
                        WmiModelLock.readUnlock(lowerModel);
                    }
                }
            }
            finally {
                if (locked) {
                    WmiModelLock.readUnlock(lowerModel);
                }
            }
        }
    }

    private void applyViewBoundaryConstraints() throws WmiNoReadAccessException {
        WmiView anchorView = this.anchor.extractView(this.docView);
        while (anchorView != null) {
            WmiTraversableView traverse;
            int type;
            if (anchorView instanceof WmiTraversableView && ((type = (traverse = (WmiTraversableView)anchorView).getTraversalType()) & 0x10) != 0) {
                WmiView lowView = this.lowerBound.extractView(this.docView);
                WmiView highView = this.upperBound.extractView(this.docView);
                boolean anchorLow = true;
                while (lowView != null) {
                    if (lowView == anchorView) {
                        anchorLow = false;
                        break;
                    }
                    lowView = lowView.getParentView();
                }
                boolean anchorHigh = true;
                while (highView != null) {
                    if (highView == anchorView) {
                        anchorHigh = false;
                        break;
                    }
                    highView = highView.getParentView();
                }
                if (anchorLow) {
                    this.lowerBound = new WmiViewPath(anchorView);
                    this.lowerBound.push(0);
                }
                if (!anchorHigh) break;
                this.upperBound = new WmiViewPath(anchorView);
                this.upperBound.push(-1);
                break;
            }
            anchorView = anchorView.getParentView();
        }
    }

    private boolean applyModelConstraints() throws WmiNoReadAccessException {
        boolean success = false;
        this.computeModelBounds();
        WmiModelPath startModelPath = new WmiModelPath(this.startModel);
        WmiModelPath endModelPath = new WmiModelPath(this.endModel);
        WmiModelPath commonPath = (WmiModelPath)WmiAncestorPath.commonPath(startModelPath, endModelPath);
        if (commonPath != null) {
            success = true;
            WmiModelPosition pos = commonPath.getModelPosition((WmiMathDocumentModel)this.docView.getModel());
            WmiModel ancestor = pos.getModel();
            WmiModel candidate = this.startModel;
            boolean update = false;
            while (candidate != ancestor) {
                if (candidate instanceof WmiCompositeModel && !candidate.isCrossBoundarySubselectable()) {
                    this.startModel = candidate;
                    this.startOffset = 0;
                    update = true;
                }
                candidate = candidate.getParent();
            }
            candidate = this.endModel;
            while (candidate != ancestor) {
                if (candidate instanceof WmiCompositeModel && !candidate.isCrossBoundarySubselectable()) {
                    this.endModel = candidate;
                    this.endOffset = -1;
                    update = true;
                }
                candidate = candidate.getParent();
            }
            if (update) {
                this.updateSelection(this.startModel, this.startOffset, this.endModel, this.endOffset);
            }
        }
        return success;
    }

    private WmiViewPath adjustPath(WmiViewPath boundary, WmiView parentView, int offset) {
        int tail;
        WmiViewPath adjustment = boundary;
        WmiView boundaryView = boundary.extractView(this.docView);
        Object newBoundary = null;
        WmiView currentBoundary = boundaryView;
        while (boundaryView != null && boundaryView != parentView) {
            WmiModel boundaryModel = boundaryView.getModel();
            if (boundaryModel != null && !boundaryModel.isCrossBoundarySubselectable()) {
                newBoundary = boundaryView;
            }
            boundaryView = boundaryView.getParentView();
        }
        if (newBoundary != null && !newBoundary.equals(currentBoundary)) {
            adjustment = new WmiViewPath((WmiView)newBoundary);
            adjustment.push(offset);
        }
        if ((tail = adjustment.peek(adjustment.depth() - 1)) != offset) {
            adjustment = new WmiViewPath(adjustment);
            adjustment.push(offset);
        }
        return adjustment;
    }

    @Override
    public void resync() throws WmiNoReadAccessException {
        if (this.docView != null) {
            WmiViewPath upper;
            WmiViewPath lower;
            if (this.startModel != null && (lower = this.modelToPath(this.startModel, this.startOffset, 0)) != null) {
                this.lowerBound = lower;
            }
            if (this.endModel != null && (upper = this.modelToPath(this.endModel, this.endOffset, 1)) != null) {
                this.upperBound = upper;
            }
            this.highlighter = new WmiSelectionHighlighter(this.docView, this, this.highlighter);
            this.highlighter.repaintDirtyRegions();
        }
    }

    public void scrollVisible() {
        if (this.highlighter != null) {
            this.highlighter.scrollVisible();
        }
    }

    public WmiViewPath getAnchor() {
        return this.anchor;
    }

    @Override
    public int contains(WmiViewPath path) {
        int size = path.depth();
        int fromDepth = this.lowerBound.depth();
        int toDepth = this.upperBound.depth();
        boolean lowInside = true;
        int depth = Math.max(size, fromDepth);
        int i = 0;
        while (i < depth) {
            int index = i < size ? path.peek(i) : 0;
            if (i >= fromDepth) {
                lowInside = true;
                break;
            }
            if (i < size) {
                if (index < this.lowerBound.peek(i)) {
                    lowInside = false;
                    break;
                }
                if (index > this.lowerBound.peek(i)) {
                    lowInside = true;
                    break;
                }
                if (i == depth - 1) {
                    lowInside = true;
                }
            }
            ++i;
        }
        boolean highInside = false;
        depth = size;
        i = 0;
        while (i < depth) {
            int index = path.peek(i);
            if (i >= toDepth) {
                highInside = true;
                break;
            }
            if (index > this.upperBound.peek(i)) {
                highInside = false;
                break;
            }
            if (index < this.upperBound.peek(i)) {
                highInside = true;
                break;
            }
            if (i == size - 1) {
                if (toDepth > size) {
                    highInside = false;
                    break;
                }
                highInside = true;
                break;
            }
            ++i;
        }
        if (!lowInside && !highInside) {
            return 0;
        }
        if (lowInside && highInside) {
            return 2;
        }
        return 1;
    }

    @Override
    public int contains(WmiView view) {
        int result = 2;
        WmiViewPath viewPath = new WmiViewPath(view);
        WmiMathDocumentView docView = view.getDocumentView();
        int lowerViewPathLimit = this.startOffset == -1 ? this.lowerBound.depth() : this.lowerBound.depth() - 1;
        int upperViewPathLimit = this.endOffset == -1 ? this.upperBound.depth() : this.upperBound.depth() - 1;
        int lowerBoundStatus = ONBOUNDERY;
        int upperBoundStatus = ONBOUNDERY;
        int i = 0;
        while (i < viewPath.depth()) {
            if (lowerBoundStatus == ONBOUNDERY && i < lowerViewPathLimit) {
                if (viewPath.peek(i) < this.lowerBound.peek(i)) {
                    lowerBoundStatus = OUTSIDEBOUNDRY;
                } else if (viewPath.peek(i) > this.lowerBound.peek(i)) {
                    lowerBoundStatus = INSIDEBOUNDRY;
                }
            }
            if (lowerBoundStatus == ONBOUNDERY && i == lowerViewPathLimit) {
                lowerBoundStatus = viewPath.peek(i) >= this.startOffset ? INSIDEBOUNDRY : OUTSIDEBOUNDRY;
            }
            if (upperBoundStatus == ONBOUNDERY && i < upperViewPathLimit) {
                if (viewPath.peek(i) < this.upperBound.peek(i)) {
                    upperBoundStatus = INSIDEBOUNDRY;
                } else if (viewPath.peek(i) > this.upperBound.peek(i)) {
                    upperBoundStatus = OUTSIDEBOUNDRY;
                }
            }
            if (upperBoundStatus == ONBOUNDERY && i == upperViewPathLimit) {
                upperBoundStatus = viewPath.peek(i) <= this.endOffset || this.endOffset == -1 ? INSIDEBOUNDRY : OUTSIDEBOUNDRY;
            }
            ++i;
        }
        if (lowerBoundStatus == ONBOUNDERY) {
            WmiView currentLowerView = this.lowerBound.extractView(docView);
            boolean currentLeftFullySelected = true;
            if (this.startOffset != 0) {
                currentLeftFullySelected = false;
            }
            int currentIndex = lowerViewPathLimit - 1;
            while (currentLowerView != view && currentLeftFullySelected) {
                currentLeftFullySelected = currentLeftFullySelected && this.lowerBound.peek(currentIndex) == 0;
                currentLowerView = currentLowerView.getParentView();
            }
            lowerBoundStatus = currentLeftFullySelected ? ONBOUNDERYFULLY : ONBOUNDERYPARTIALLY;
        }
        if (upperBoundStatus == ONBOUNDERY) {
            WmiView currentUpperView = this.upperBound.extractView(docView);
            boolean currentRightFullySelected = true;
            if (this.endOffset != -1) {
                currentRightFullySelected = false;
            }
            while (currentUpperView != null && currentUpperView != view && currentRightFullySelected) {
                WmiCompositeView parentView = currentUpperView.getParentView();
                if (parentView != null) {
                    currentRightFullySelected = currentRightFullySelected && parentView.indexOf(currentUpperView) == parentView.getChildCount() - 1;
                }
                currentUpperView = parentView;
            }
            upperBoundStatus = currentRightFullySelected ? ONBOUNDERYFULLY : ONBOUNDERYPARTIALLY;
        }
        if (lowerBoundStatus == INSIDEBOUNDRY || lowerBoundStatus == ONBOUNDERYFULLY) {
            if (upperBoundStatus == INSIDEBOUNDRY || upperBoundStatus == ONBOUNDERYFULLY) {
                result = 2;
            } else if (upperBoundStatus == ONBOUNDERYPARTIALLY) {
                result = 1;
            }
        }
        if (upperBoundStatus == OUTSIDEBOUNDRY) {
            result = 0;
        }
        if (lowerBoundStatus == ONBOUNDERYPARTIALLY) {
            result = 1;
        }
        if (lowerBoundStatus == OUTSIDEBOUNDRY) {
            result = 0;
        }
        return result;
    }

    @Override
    public boolean contains(WmiView view, int offset) {
        boolean isContained;
        WmiViewPath vp = new WmiViewPath(view);
        boolean bl = isContained = this.contains(vp) != 0;
        if (isContained) {
            WmiModelPosition pos = this.pathToModel(vp);
            WmiModel model = pos.getModel();
            if (view instanceof WmiTextView) {
                offset += ((WmiTextView)view).getStartOffset();
            }
            if (this.startModel == this.endModel) {
                if (offset < this.startOffset || offset > this.endOffset) {
                    isContained = false;
                }
            } else if (model == this.startModel && offset < this.startOffset) {
                isContained = false;
            } else if (model == this.endModel && offset > this.endOffset) {
                isContained = false;
            }
        }
        return isContained;
    }

    @Override
    public boolean hideCaret() {
        return true;
    }

    @Override
    public WmiViewPath getSelectionStartPath() {
        return this.lowerBound;
    }

    @Override
    public WmiViewPath getSelectionEndPath() {
        return this.upperBound;
    }

    @Override
    public boolean isCompoundSelection() {
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.lowerBound.toString());
        sb.append(" ---> ");
        sb.append(this.upperBound.toString());
        if (this.anchor != null) {
            sb.append(" anchor = ");
            sb.append(this.anchor.toString());
        }
        return sb.toString();
    }

    @Override
    public void deleteSelection() {
        this.deleteSelection(true);
    }

    /*
     * Exception decompiling
     */
    public void deleteSelection(boolean autoUpdate) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean handlePlaceholder(String content) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiCompositeModel parent;
        int position;
        boolean handled = false;
        WmiAttributeSet attrs = this.startModel.getAttributesForRead();
        if (attrs != null && "true".equals(attrs.getAttribute("placeholder")) && (position = (parent = this.startModel.getParent()).indexOf(this.startModel)) != 0) {
            WmiModel previousChild = parent.getChild(position - 1);
            if (parent.getChildCount() > position + 1) {
                WmiModel nextChild = parent.getChild(position + 1);
                if (previousChild instanceof WmiTextModel) {
                    int prevLength = ((WmiTextModel)previousChild).getLength();
                    if (nextChild instanceof WmiTextModel) {
                        WmiAttributeSet next = nextChild.getAttributes();
                        WmiAttributeSet prev = previousChild.getAttributes();
                        if (next != null && prev != null && WmiAttributeComparator.isEqual(next, prev)) {
                            WmiModelPosition modPos = new WmiModelPosition(previousChild, prevLength + content.length());
                            this.docView.setPendingPosition(modPos);
                            String nextString = ((WmiTextModel)nextChild).getText();
                            try {
                                ((WmiTextModel)previousChild).appendText(String.valueOf(content) + nextString);
                                parent.removeChild(position);
                                parent.removeChild(position);
                                handled = true;
                            }
                            catch (WmiModelIndexOutOfBoundsException boundE) {
                                WmiErrorLog.log(boundE);
                            }
                        }
                    }
                }
            }
        }
        return handled;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void replaceSelection(String content) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void repaintDirtyRegions() {
        if (this.highlighter != null) {
            this.highlighter.repaintDirtyRegions();
        }
    }

    public WmiModelPosition pathToModel(WmiViewPath path) {
        WmiModelPosition pos = new WmiModelPosition(null, 0);
        try {
            pos = path.createModelPosition(this.docView);
        }
        catch (WmiInvalidModelInitializationException wmiInvalidModelInitializationException) {
            // empty catch block
        }
        return pos;
    }

    public WmiViewPath modelToPath(WmiModel model, int offset, int mode) throws WmiNoReadAccessException {
        WmiView view;
        if (model instanceof WmiTaskWrapperModel) {
            if (mode == 0) {
                model = WmiModelUtil.findFirstDescendantLeaf((WmiCompositeModel)model);
            } else if (mode == 1) {
                model = WmiModelUtil.findLastDescendantLeaf((WmiCompositeModel)model);
            }
        }
        WmiViewPath path = null;
        boolean updateModel = false;
        if (model instanceof WmiTextModel) {
            int limit = ((WmiTextModel)model).getLength();
            if (offset == -1) {
                offset = limit;
            }
            while (offset > limit) {
                int index;
                updateModel = true;
                WmiCompositeModel parent = model.getParent();
                int n = index = parent != null ? parent.indexOf(model) : -1;
                if (index >= 0 && index < parent.getChildCount() - 1) {
                    WmiModel sibling = parent.getChild(index + 1);
                    if (sibling instanceof WmiTextModel) {
                        offset -= limit;
                        model = sibling;
                        limit = ((WmiTextModel)model).getLength();
                        continue;
                    }
                    offset = limit;
                    continue;
                }
                offset = limit;
            }
        }
        if (updateModel) {
            if (mode == 0) {
                this.startModel = model;
                this.startOffset = offset;
            } else {
                this.endModel = model;
                this.endOffset = offset;
            }
        }
        if ((view = WmiViewUtil.modelToView(this.docView, model, offset)) == null) {
            view = this.findNearestVisibleView(model);
        }
        if (view != null) {
            path = new WmiViewPath(view);
        }
        if (view == null) {
            WmiErrorLog.log(new Exception("couldn't find view"));
        }
        if (view instanceof WmiTraversableView) {
            if (offset < 0) {
                path.push(offset);
            } else if (view instanceof WmiTextView) {
                path.push(offset -= ((WmiTextView)view).getStartOffset());
            }
        } else if (offset < 0) {
            path.push(offset);
        }
        return path;
    }

    private WmiView findNearestVisibleView(WmiModel model) throws WmiNoReadAccessException {
        WmiView view = null;
        WmiCompositeModel parent = model != null ? model.getParent() : null;
        while (view == null && parent != null) {
            view = WmiViewUtil.modelToView(this.docView, parent, 0);
            if (view != null) continue;
            model = parent;
            parent = model.getParent();
        }
        return view;
    }

    @Override
    public boolean isReadOnly() throws WmiNoReadAccessException {
        boolean readonly = false;
        if (this.startModel != null) {
            WmiMathDocumentModel docModel = this.startModel.getDocument();
            boolean bl = readonly = !docModel.isMutableModel(this.startModel);
            if (readonly) {
                readonly = !docModel.isMutableModel(this.endModel);
            }
        }
        return readonly;
    }

    @Override
    public WmiMathDocumentView getSourceDocument() {
        return this.docView;
    }

    @Override
    public WmiHighlightPainter getSelectionHighlighter() {
        return this.highlighter;
    }

    @Override
    public boolean isValid() {
        return this.lowerBound != null && this.upperBound != null && !this.lowerBound.equals(this.upperBound);
    }

    protected static class WmiPathDeletionHandler {
        protected WmiModel startModel;
        protected WmiModel endModel;
        protected WmiModel parentModel;
        protected WmiModel deleteLimit;
        protected int startOffset;
        protected int endOffset;
        private Stack startStack;
        private Stack endStack;
        private WmiDeleteManager manager;
        private WmiMathDocumentView docView;

        protected WmiPathDeletionHandler(WmiModelPosition start, WmiModelPosition end, WmiMathDocumentView docView) {
            this.docView = docView;
            this.manager = new WmiDeleteManager();
            this.startModel = start.getModel();
            this.startOffset = start.getOffset();
            this.endModel = end.getModel();
            this.endOffset = end.getOffset();
            WmiMathDocumentModel docModel = (WmiMathDocumentModel)docView.getModel();
            boolean selectAll = this.startModel == docModel && this.endModel == docModel && this.startOffset == -1 && this.endOffset == -1;
            this.startStack = this.createStack(this.startModel, this.startOffset, 0);
            this.endStack = this.createStack(this.endModel, this.endOffset, 1);
            boolean locked = WmiModelLock.readLock(this.startModel, true);
            try {
                try {
                    int startLength = this.startStack.size();
                    int endLength = this.endStack.size();
                    while (startLength != endLength && startLength * endLength != 0) {
                        WmiCompositeModel parent;
                        if (startLength > endLength) {
                            parent = this.startModel.getParent();
                            if (parent.indexOf(this.startModel) != 0) break;
                            this.startModel = parent;
                            this.startStack.remove(0);
                            --startLength;
                            continue;
                        }
                        parent = this.endModel.getParent();
                        if (parent.indexOf(this.endModel) != parent.getChildCount() - 1) break;
                        this.endModel = parent;
                        this.endStack.remove(0);
                        --endLength;
                    }
                    if (selectAll) {
                        this.parentModel = docModel;
                        this.startStack.pop();
                        this.endStack.pop();
                    } else {
                        this.parentModel = this.trimStacks(this.startStack, this.endStack);
                    }
                    this.deleteLimit = null;
                    if (this.startModel != null) {
                        WmiModel wmiModel = this.deleteLimit = this.startModel != this.endModel ? this.parentModel : this.startModel.getParent();
                        if (this.deleteLimit != null) {
                            this.deleteLimit = docView.getDeleteBoundary((WmiCompositeModel)this.deleteLimit);
                        }
                    }
                }
                catch (WmiNoReadAccessException e) {
                    WmiErrorLog.log(e);
                    if (locked) {
                        WmiModelLock.readUnlock(this.startModel);
                    }
                }
            }
            finally {
                if (locked) {
                    WmiModelLock.readUnlock(this.startModel);
                }
            }
        }

        private boolean canDeleteParent(WmiCompositeModel parent, int index) throws WmiNoReadAccessException {
            boolean deleteParent = false;
            if (!this.forceDeleteHandling(parent)) {
                if (index == 0 && parent.getChildCount() == 1) {
                    deleteParent = true;
                } else if (WmiModelUtil.getRemainingChildCount(parent) == 1 && index == WmiModelUtil.getFirstNonDeletePlaceHolderPosition(parent)) {
                    deleteParent = true;
                } else {
                    boolean foundVisibleChild = false;
                    int size = parent.getChildCount();
                    int i = 0;
                    while (i < size) {
                        WmiModel child;
                        if (i != index && (child = parent.getChild(i)).isVisible()) {
                            foundVisibleChild = true;
                            break;
                        }
                        ++i;
                    }
                    deleteParent = !foundVisibleChild;
                }
            }
            return deleteParent;
        }

        private Stack createStack(WmiModel model, int offset, int mode) {
            Stack<WmiModel> stack = new Stack<WmiModel>();
            WmiModel docModel = this.docView.getModel();
            try {
                try {
                    WmiModelLock.readLock(docModel, true);
                    WmiModelPath resolved = new WmiModelPath(model);
                    boolean updateOffset = false;
                    int depth = resolved.depth();
                    WmiModel[] path = new WmiModel[depth + 1];
                    WmiCompositeModel composite = (WmiCompositeModel)docModel;
                    path[0] = docModel;
                    int i = 0;
                    while (i < depth) {
                        WmiModel child;
                        path[i + 1] = child = composite.getChild(resolved.peek(i));
                        if (!(child instanceof WmiCompositeModel)) {
                            if (!updateOffset || !(child instanceof WmiTextModel)) break;
                            if (mode == 0) {
                                this.startOffset = 0;
                                break;
                            }
                            this.endOffset = ((WmiTextModel)child).getLength();
                            break;
                        }
                        composite = (WmiCompositeModel)child;
                        ++i;
                    }
                    i = depth;
                    while (i >= 0) {
                        if (path[i] != null) {
                            stack.push(path[i]);
                        }
                        --i;
                    }
                }
                catch (WmiNoReadAccessException e) {
                    WmiErrorLog.log(e);
                    WmiModelLock.readUnlock(docModel);
                }
            }
            finally {
                WmiModelLock.readUnlock(docModel);
            }
            return stack;
        }

        private WmiModel trimStacks(Stack start, Stack end) {
            WmiModel parent = null;
            while (!start.isEmpty() && !end.isEmpty()) {
                if (start.peek() != end.peek()) break;
                parent = (WmiModel)start.peek();
                start.pop();
                end.pop();
            }
            return parent;
        }

        private void deleteSelection() throws WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException, WmiNoReadAccessException {
            this.refreshSemantics(this.parentModel);
            if (this.startModel == this.endModel && !this.startModel.isSubselectable()) {
                this.deleteModel(this.startModel);
            } else if (this.parentModel instanceof WmiCompositeModel) {
                WmiCompositeModel comp = (WmiCompositeModel)this.parentModel;
                if (this.startModel == this.endModel && this.startModel == this.parentModel) {
                    this.deleteModel(this.parentModel);
                } else {
                    int index2;
                    int index1;
                    if (!this.startStack.isEmpty() && !this.endStack.isEmpty() && (index1 = comp.indexOf((WmiModel)this.startStack.peek())) != (index2 = comp.indexOf((WmiModel)this.endStack.peek()))) {
                        boolean deleted = this.pruneHead(this.endStack);
                        if (deleted) {
                            ++index2;
                        }
                        this.pruneIntermediates(comp, index1, index2);
                    }
                    this.pruneTail(this.startStack);
                    this.postDeleteMerge();
                }
            } else if (this.parentModel instanceof WmiTextModel) {
                WmiTextModel textModel = (WmiTextModel)this.parentModel;
                this.deleteText(textModel, this.startOffset, this.endOffset);
            } else if (this.parentModel != null) {
                this.deleteModel(this.parentModel);
            }
            this.manager.update();
            this.overrideCursorPosition();
        }

        private boolean pruneHead(Stack stack) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
            boolean deleted = false;
            WmiModel model = (WmiModel)stack.pop();
            if (model instanceof WmiCompositeModel && !stack.isEmpty()) {
                WmiCompositeModel composite = (WmiCompositeModel)model;
                WmiModel child = (WmiModel)stack.peek();
                if (child != null) {
                    int index = composite.indexOf(child);
                    int limit = composite.getChildCount();
                    boolean childDeleted = this.pruneHead(stack);
                    if (childDeleted) {
                        ++index;
                    }
                    if (index > 0) {
                        this.deleteChildren(composite, 0, index);
                    }
                    deleted = limit <= index;
                }
            } else if (model instanceof WmiTextModel) {
                int limit;
                WmiTextModel textModel = (WmiTextModel)model;
                if (!textModel.isCrossBoundarySubselectable()) {
                    this.endOffset = textModel.getLength();
                }
                if (this.endOffset == (limit = textModel.getLength())) {
                    deleted = true;
                } else if (this.endOffset > 0 || limit == 0) {
                    this.deleteText(textModel, 0, this.endOffset);
                    deleted = false;
                } else {
                    deleted = false;
                }
            } else {
                deleted = true;
            }
            return deleted;
        }

        private void pruneIntermediates(WmiCompositeModel parent, int from, int to) throws WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException, WmiNoReadAccessException {
            if (to > parent.getChildCount()) {
                to = parent.getChildCount();
            }
            if (to - from > 1) {
                this.deleteChildren(parent, from + 1, to - from - 1);
            }
        }

        private void deleteChildren(WmiCompositeModel parent, int first, int length) throws WmiNoWriteAccessException, WmiNoReadAccessException, WmiModelIndexOutOfBoundsException {
            if (parent.getDeleteHandler() == null) {
                int c = first;
                while (c < length) {
                    WmiModel child = parent.getChild(c);
                    if (child instanceof WmiCompositeModel) {
                        this.manager.unMark((WmiCompositeModel)child);
                    }
                    ++c;
                }
                parent.removeChildren(first, length);
            } else {
                int i = 0;
                while (i < length) {
                    this.deleteChild(parent, first + i);
                    ++i;
                }
            }
        }

        private void deleteChild(WmiCompositeModel parent, int index) throws WmiNoWriteAccessException, WmiNoReadAccessException, WmiModelIndexOutOfBoundsException {
            if (parent.getDeleteHandler() == null) {
                parent.removeChild(index);
            } else {
                WmiModel model = parent.getChild(index);
                WmiDeletePlaceholderModel placeholder = new WmiDeletePlaceholderModel(model);
                parent.replaceChild(placeholder, index);
                this.manager.mark(parent);
            }
        }

        private void appendChildForDelete(WmiCompositeModel parent, WmiModel child) throws WmiNoWriteAccessException {
            if (parent.getDeleteHandler() != null) {
                WmiDeletePlaceholderModel placeholder = new WmiDeletePlaceholderModel(child);
                parent.appendChild(placeholder);
                this.manager.mark(parent);
            }
        }

        private void pruneTail(Stack stack) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
            while (!stack.isEmpty()) {
                WmiModel model = (WmiModel)stack.pop();
                if (model instanceof WmiCompositeModel && !stack.isEmpty()) {
                    WmiCompositeModel composite = (WmiCompositeModel)model;
                    WmiModel child = (WmiModel)stack.peek();
                    if (child == null) continue;
                    int index = 0;
                    int length = 0;
                    WmiView view = WmiViewUtil.modelToView(this.docView, composite, 0);
                    if (view instanceof WmiMapleTACompositeView) {
                        WmiGenericView currentView = ((WmiMapleTACompositeView)view).getCurrentView();
                        child = currentView.getModel();
                        length = 0;
                    } else {
                        index = composite.indexOf(child);
                        length = composite.getChildCount() - (index + 1);
                    }
                    if (length <= 0) continue;
                    this.deleteChildren(composite, index + 1, length);
                    continue;
                }
                if (model instanceof WmiTextModel) {
                    int limit = ((WmiTextModel)model).getLength();
                    if (limit <= this.startOffset && this.startOffset != 0) break;
                    this.deleteText((WmiTextModel)model, this.startOffset, limit);
                    break;
                }
                this.deleteModel(model);
            }
        }

        private void deleteText(WmiTextModel model, int start, int end) throws WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException, WmiNoReadAccessException {
            if (start <= 0 && end >= model.getLength()) {
                this.deleteModel(model);
            } else {
                model.deleteText(start, end - start);
            }
        }

        private boolean isDeleteableParagraph(WmiParagraphModel para, WmiModel ignore) throws WmiNoReadAccessException {
            boolean canDelete = false;
            if (para.isEmpty(ignore)) {
                canDelete = true;
            } else {
                boolean bl = canDelete = para != this.parentModel && !WmiModelUtil.isModelAncestorOfModel(para, this.parentModel);
            }
            if (canDelete) {
                WmiCompositeModel ancestor = para.getParent();
                while (ancestor != null && !ancestor.isDeletionBoundary()) {
                    ancestor = ancestor.getParent();
                }
                if (ancestor != null && ancestor.isDeletionBoundary()) {
                    canDelete = WmiModelUtil.findNextModel((WmiModel)ancestor, (WmiModel)para, WmiParagraphModel.class) != null || WmiModelUtil.findPreviousModel((WmiModel)ancestor, (WmiModel)para, WmiParagraphModel.class) != null;
                }
            }
            return canDelete;
        }

        private void deleteModel(WmiModel model) throws WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException, WmiNoReadAccessException {
            if (model == this.endModel) {
                this.endModel = null;
            }
            if (model == this.startModel) {
                this.startModel = null;
            }
            if (model instanceof WmiMathDocumentModel) {
                WmiMathDocumentModel docModel = (WmiMathDocumentModel)model;
                int count = docModel.getChildCount();
                docModel.removeChildren(0, count);
                this.manager.clear();
                this.docView.setPendingPosition(new WmiModelPosition(docModel, 0));
            } else {
                WmiCompositeModel parent = model.getParent();
                if (parent != null) {
                    int index = parent.indexOf(model);
                    if (index < 0) {
                        if (parent instanceof WmiMathFencedModel) {
                            this.appendChildForDelete(parent, model);
                            return;
                        }
                        if (parent instanceof WmiRootModel || parent instanceof WmiFractionModel) {
                            Toolkit.getDefaultToolkit().beep();
                            return;
                        }
                        throw new WmiModelIndexOutOfBoundsException(model, index);
                    }
                    if (this.canDeleteParent(parent, index)) {
                        if (parent instanceof WmiMathDocumentModel) {
                            this.manager.clear();
                            parent.removeChild(0);
                            this.docView.setPendingPosition(new WmiModelPosition(parent, 0));
                        } else if (parent == this.deleteLimit) {
                            this.manager.clear();
                            this.deleteChild(parent, 0);
                            this.docView.setPendingPosition(new WmiModelPosition(parent, 0));
                        } else if (parent instanceof WmiParagraphModel && !this.isDeleteableParagraph((WmiParagraphModel)parent, model)) {
                            this.manager.clear();
                            this.deleteChild(parent, 0);
                            this.docView.setPendingPosition(new WmiModelPosition(parent, 0));
                        } else {
                            this.manager.unMark(parent);
                            this.deleteModel(parent);
                        }
                    } else {
                        this.deleteChild(parent, index);
                    }
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        }

        private void postDeleteMerge() throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
            boolean doCheck = this.endModel != null && this.startModel != null;
            WmiMathDocumentModel docModel = this.startModel != null ? this.startModel.getDocument() : null;
            WmiMathDocumentHierarchyValidator validator = docModel != null ? docModel.getModelHierarchyValidator() : null;
            doCheck &= validator != null & this.startModel != null && validator.hasPostDeletePermission(this.startModel.getTag());
            while (doCheck && this.startModel.getParent() != this.endModel.getParent()) {
                this.startModel = this.startModel.getParent();
                this.endModel = this.endModel.getParent();
                if (this.startModel == null || this.endModel == null) {
                    doCheck = false;
                }
                if (!validator.hasPostDeletePermission(this.startModel.getTag())) {
                    doCheck = false;
                }
                if (validator.hasPostDeletePermission(this.endModel.getTag())) continue;
                doCheck = false;
            }
            if (doCheck) {
                this.postDeleteMerge(this.startModel, this.endModel);
            }
        }

        private void postDeleteMerge(WmiModel startModel, WmiModel endModel) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
            if (startModel.getTag() == endModel.getTag()) {
                if (startModel instanceof WmiCompositeModel) {
                    WmiCompositeModel comp1 = (WmiCompositeModel)startModel;
                    WmiCompositeModel comp2 = (WmiCompositeModel)endModel;
                    if (comp1 != comp2) {
                        int nextIndex = comp1.getChildCount();
                        int size = comp2.getChildCount();
                        int i = 0;
                        while (i < size) {
                            comp1.appendChild(comp2.getChild(i));
                            ++i;
                        }
                        WmiCompositeModel parent = endModel.getParent();
                        int index = parent.indexOf(endModel);
                        if (index >= 0) {
                            parent.removeChild(index);
                        }
                        if (nextIndex > 0 && nextIndex < comp1.getChildCount()) {
                            this.postDeleteMerge(comp1.getChild(nextIndex - 1), comp1.getChild(nextIndex));
                        }
                    }
                } else if (startModel instanceof WmiTextModel) {
                    WmiCompositeModel parent;
                    int index;
                    WmiFontAttributeSet endAttr;
                    WmiTextModel startText = (WmiTextModel)startModel;
                    WmiTextModel endText = (WmiTextModel)endModel;
                    WmiFontAttributeSet startAttr = (WmiFontAttributeSet)startText.getAttributes();
                    if (startAttr.equals(endAttr = (WmiFontAttributeSet)endText.getAttributes()) && (index = (parent = endModel.getParent()).indexOf(endModel)) >= 0) {
                        int caretPos = startText.getLength();
                        this.manager.setModelToReposition(new WmiModelPosition(startText, caretPos));
                        startText.appendText(endText.getText());
                        parent.removeChild(index);
                    }
                }
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("WmiDeletionHandler[");
            sb.append(this.startModel);
            sb.append("@");
            sb.append(System.identityHashCode(this.startModel));
            sb.append(":");
            sb.append(this.startOffset);
            sb.append("-->");
            sb.append(this.endModel);
            sb.append("@");
            sb.append(System.identityHashCode(this.endModel));
            sb.append(":");
            sb.append(this.endOffset);
            sb.append("]");
            return sb.toString();
        }

        private void overrideCursorPosition() {
            WmiModelPosition position = this.manager.getModelToReposition();
            if (position != null && position.getModel() != null) {
                WmiDefaultPositionUpdateHandler posHandler = new WmiDefaultPositionUpdateHandler(this.docView, position);
                this.docView.setPendingPositionUpdateHandler(posHandler);
            }
        }

        private void refreshSemantics(WmiModel baseModel) throws WmiNoReadAccessException {
            WmiCompositeModel editParentForSemantics = baseModel.getParent();
            while (editParentForSemantics instanceof WmiMathModel) {
                ((WmiMathModel)((Object)editParentForSemantics)).setSemantics(null);
                editParentForSemantics = editParentForSemantics.getParent();
            }
        }

        public boolean forceDeleteHandling(WmiCompositeModel parent) throws WmiNoReadAccessException {
            boolean force = false;
            if (this.startModel != null && WmiModelUtil.isModelAncestorOfModel(this.startModel, parent)) {
                force = false;
            } else if (this.endModel != null && WmiModelUtil.isModelAncestorOfModel(this.endModel, parent)) {
                force = false;
            } else {
                WmiDeleteHandler handler = parent.getDeleteHandler();
                if (handler != null) {
                    force = handler.forceDeleteHandling();
                }
            }
            return force;
        }

        static /* synthetic */ void access$0(WmiPathDeletionHandler wmiPathDeletionHandler) throws WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException, WmiNoReadAccessException {
            wmiPathDeletionHandler.deleteSelection();
        }
    }
}

